/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.cas4;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import org.gatein.sso.plugin.RestCallbackCaller;
import org.jasig.cas.authentication.AbstractAuthenticationHandler;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;

public class GateInAuthenticationHandler
extends AbstractAuthenticationHandler {
    private volatile RestCallbackCaller restCallbackCaller;
    private String gateInProtocol;
    private String gateInHost;
    private String gateInPort;
    private String gateInContext;
    private String httpMethod;

    public HandlerResult authenticate(Credential credential) throws GeneralSecurityException, PreventedException {
        UsernamePasswordCredential usernamePasswordCredential = (UsernamePasswordCredential)credential;
        String username = usernamePasswordCredential.getUsername();
        String password = usernamePasswordCredential.getPassword();
        try {
            boolean authenticated = this.getRestCallbackCaller().executeRemoteCall(username, password);
            if (authenticated) {
                return new HandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData((Credential)usernamePasswordCredential), (Principal)new SimplePrincipal(credential.getId()));
            }
            throw new FailedLoginException("Failed to login at GateIn with username " + username);
        }
        catch (Exception e) {
            throw new FailedLoginException("Failed to login at GateIn. Cause: " + e.getMessage());
        }
    }

    public boolean supports(Credential credential) {
        return credential instanceof UsernamePasswordCredential;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RestCallbackCaller getRestCallbackCaller() {
        if (this.restCallbackCaller == null) {
            GateInAuthenticationHandler gateInAuthenticationHandler = this;
            synchronized (gateInAuthenticationHandler) {
                if (this.restCallbackCaller == null) {
                    this.restCallbackCaller = new RestCallbackCaller(this.gateInProtocol, this.gateInHost, this.gateInPort, this.gateInContext, this.httpMethod);
                }
            }
        }
        return this.restCallbackCaller;
    }

    public String getGateInProtocol() {
        return this.gateInProtocol;
    }

    public void setGateInProtocol(String gateInProtocol) {
        this.gateInProtocol = gateInProtocol;
    }

    public String getGateInHost() {
        return this.gateInHost;
    }

    public void setGateInHost(String gateInHost) {
        this.gateInHost = gateInHost;
    }

    public String getGateInPort() {
        return this.gateInPort;
    }

    public void setGateInPort(String gateInPort) {
        this.gateInPort = gateInPort;
    }

    public String getGateInContext() {
        return this.gateInContext;
    }

    public void setGateInContext(String gateInContext) {
        this.gateInContext = gateInContext;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }
}

