/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.integration;

import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.filter.api.SSOInterceptor;
import org.gatein.sso.integration.SSOUtils;

public class SSOFilterIntegratorPlugin
extends BaseComponentPlugin {
    private final SSOInterceptor filter;
    private final boolean enabled;
    private final String filterMapping;
    private static final Logger log = LoggerFactory.getLogger(SSOFilterIntegratorPlugin.class);

    public SSOFilterIntegratorPlugin(InitParams params, ExoContainerContext containerContext) {
        ValueParam filterClass = params.getValueParam("filterClass");
        ValueParam enabled = params.getValueParam("enabled");
        ValueParam filterMapping = params.getValueParam("filterMapping");
        if (filterClass == null || filterMapping == null) {
            throw new IllegalArgumentException("Parameters 'filterClass' and 'filterMapping' need to be provided");
        }
        boolean bl = this.enabled = enabled != null ? Boolean.parseBoolean(enabled.getValue()) : false;
        if (!this.isEnabled()) {
            log.debug((Object)("Filter " + filterClass.getValue() + " disabled"));
            this.filter = null;
            this.filterMapping = null;
            return;
        }
        this.filterMapping = filterMapping.getValue();
        String filterClazz = filterClass.getValue();
        log.debug((Object)("Plugin initialization with parameters filterClass: " + filterClazz + ", filterMapping: " + filterMapping));
        Class<?> ssoInterceptorCl = SSOUtils.loadClass(filterClazz);
        try {
            this.filter = (SSOInterceptor)ssoInterceptorCl.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Can't instantiate " + ssoInterceptorCl, e);
        }
        this.filter.initWithParams(params, containerContext);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SSOInterceptor getFilter() {
        return this.filter;
    }

    public String getFilterMapping() {
        return this.filterMapping;
    }
}

