/*
 * Decompiled with CFR 0.152.
 */
package org.josso.auth;

import java.security.cert.X509Certificate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.auth.SimplePrincipal;

public class CertificatePrincipal
extends SimplePrincipal {
    private static final Log logger = LogFactory.getLog(CertificatePrincipal.class);
    private X509Certificate _certificate;

    public CertificatePrincipal() {
    }

    public CertificatePrincipal(String username) {
        super(username);
    }

    public CertificatePrincipal(String username, X509Certificate certificate) {
        super(username);
        this._certificate = certificate;
    }

    public X509Certificate getCertificate() {
        return this._certificate;
    }

    public boolean equals(Object another) {
        if (!(another instanceof CertificatePrincipal)) {
            return false;
        }
        X509Certificate anotherCertificate = ((CertificatePrincipal)another).getCertificate();
        boolean equals = super.equals(another);
        if (!equals) {
            return false;
        }
        equals = this.getCertificate() == null ? anotherCertificate == null : this.getCertificate().equals(anotherCertificate);
        return equals;
    }

    public int hashCode() {
        return this.getCertificate() == null ? 0 : this.getCertificate().hashCode();
    }

    public String toString() {
        if (this.getCertificate() != null) {
            return this.getCertificate().getSubjectX500Principal().getName() + " / " + this.getCertificate().getIssuerX500Principal().getName();
        }
        return this.getName();
    }
}

