/*
 * Decompiled with CFR 0.152.
 */
package org.josso.spring;

import java.util.Map;
import org.apache.xbean.spring.context.ClassPathXmlApplicationContext;
import org.josso.ComponentKeeper;
import org.josso.gateway.SSOException;
import org.josso.gateway.SSOGateway;
import org.springframework.context.ApplicationContext;

public class SpringComponentKeeperImpl
implements ComponentKeeper {
    private ApplicationContext context;

    public SpringComponentKeeperImpl(String resource) {
        this.context = new ClassPathXmlApplicationContext(resource);
    }

    public SSOGateway fetchSSOGateway() throws Exception {
        Map gwys = this.context.getBeansOfType(SSOGateway.class);
        if (gwys.values().size() < 1) {
            throw new SSOException("No gateways defined. Verify JOSSO Configuration");
        }
        if (gwys.values().size() > 1) {
            throw new SSOException("Multiple gateway definitions are not supported! Found : " + gwys.values().size());
        }
        return (SSOGateway)gwys.values().iterator().next();
    }

    public ApplicationContext getSpringContext() {
        return this.context;
    }
}

