/*
 * Decompiled with CFR 0.152.
 */
package org.josso.util.config;

import java.util.EventObject;
import javax.management.AttributeChangeNotification;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.josso.SSOConfigurationEventListener;
import org.josso.util.config.ConfigurationContext;
import org.josso.util.config.XUpdateConfigurationHandler;

public class SSOConfigurationEventHandler
extends XUpdateConfigurationHandler
implements SSOConfigurationEventListener {
    private static final Log logger = LogFactory.getLog(SSOConfigurationEventHandler.class);
    private Object source;
    private String[] ignoredAttrs;

    public SSOConfigurationEventHandler(ConfigurationContext ctx, String elementsBaseLocation, String newElementsBaseLocation, Object source, String[] ignoredAttrs) {
        super(ctx, elementsBaseLocation, newElementsBaseLocation);
        this.source = source;
        this.ignoredAttrs = ignoredAttrs;
    }

    public void handleEvent(String eventType, EventObject event) {
        if (event instanceof AttributeChangeNotification) {
            AttributeChangeNotification notification = (AttributeChangeNotification)event;
            String attrName = notification.getAttributeName();
            if (this.ignore(attrName)) {
                return;
            }
            String newValue = notification.getNewValue().toString();
            String oldValue = notification.getOldValue() != null ? notification.getOldValue().toString() : null;
            this.saveElement(attrName, oldValue, newValue);
        }
    }

    public boolean isEventEnabled(String eventType, EventObject event) {
        return this.source.equals(event.getSource());
    }

    protected boolean ignore(String attrName) {
        for (int i = 0; i < this.ignoredAttrs.length; ++i) {
            String ignoredAttr = this.ignoredAttrs[i];
            if (!ignoredAttr.equals(attrName)) continue;
            return true;
        }
        return false;
    }
}

