/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.instrument.classloading.weblogic;

import java.lang.instrument.ClassFileTransformer;
import org.springframework.instrument.classloading.LoadTimeWeaver;
import org.springframework.instrument.classloading.weblogic.WebLogicClassLoader;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class WebLogicLoadTimeWeaver
implements LoadTimeWeaver {
    private final WebLogicClassLoader classLoader;

    public WebLogicLoadTimeWeaver() {
        this(ClassUtils.getDefaultClassLoader());
    }

    public WebLogicLoadTimeWeaver(ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null");
        this.classLoader = new WebLogicClassLoader(classLoader);
    }

    public void addTransformer(ClassFileTransformer transformer) {
        this.classLoader.addTransformer(transformer);
    }

    public ClassLoader getInstrumentableClassLoader() {
        return this.classLoader.getInternalClassLoader();
    }

    public ClassLoader getThrowawayClassLoader() {
        return this.classLoader.getThrowawayClassLoader();
    }
}

