/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.sso.agent.filter;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.PropertyManager;
import org.gatein.common.logging.Logger;
import org.gatein.common.logging.LoggerFactory;
import org.gatein.sso.agent.cas.CASAgent;
import org.gatein.sso.agent.filter.api.AbstractSSOInterceptor;
import org.gatein.sso.agent.josso.JOSSOAgent;
import org.gatein.sso.agent.opensso.OpenSSOAgent;
import org.gatein.wci.security.Credentials;

public class InitiateLoginFilter
extends AbstractSSOInterceptor {
    private static Logger log = LoggerFactory.getLogger(InitiateLoginFilter.class);
    private static final int DEFAULT_MAX_NUMBER_OF_LOGIN_ERRORS = 3;
    private String ssoServerUrl;
    private String ssoCookieName;
    private boolean casRenewTicket;
    private String casServiceUrl;
    private String loginUrl;
    private int maxNumberOfLoginErrors;
    private boolean attachUsernamePasswordToLoginURL;
    private CASAgent casAgent;
    private JOSSOAgent jossoAgent;
    private OpenSSOAgent openSSOAgent;

    @Override
    protected void initImpl() {
        String maxNumberOfLoginErrorsConfig;
        String casServiceUrlConfig;
        this.ssoServerUrl = this.getInitParameter("ssoServerUrl");
        this.ssoCookieName = this.getInitParameter("ssoCookieName");
        this.loginUrl = this.getInitParameter("loginUrl");
        String casRenewTicketConfig = this.getInitParameter("casRenewTicket");
        if (casRenewTicketConfig != null) {
            this.casRenewTicket = Boolean.parseBoolean(casRenewTicketConfig);
        }
        if ((casServiceUrlConfig = this.getInitParameter("casServiceUrl")) != null && casServiceUrlConfig.trim().length() > 0) {
            this.casServiceUrl = casServiceUrlConfig;
        }
        this.maxNumberOfLoginErrors = (maxNumberOfLoginErrorsConfig = this.getInitParameter("maxNumberOfLoginErrors")) == null ? 3 : Integer.parseInt(maxNumberOfLoginErrorsConfig);
        String attachUsernamePasswordToLoginURLConfig = this.getInitParameter("attachUsernamePasswordToLoginURL");
        this.attachUsernamePasswordToLoginURL = attachUsernamePasswordToLoginURLConfig == null ? true : Boolean.parseBoolean(attachUsernamePasswordToLoginURLConfig);
        log.info((Object)("InitiateLoginFilter configuration: ssoServerUrl=" + this.ssoServerUrl + ", ssoCookieName=" + this.ssoCookieName + ", loginUrl=" + this.loginUrl + ", casRenewTicket=" + this.casRenewTicket + ", casServiceUrl=" + this.casServiceUrl + ", maxNumberOfLoginErrors=" + this.maxNumberOfLoginErrors + ", attachUsernamePasswordToLoginURL=" + this.attachUsernamePasswordToLoginURL));
    }

    protected CASAgent getCasAgent() {
        if (this.casAgent == null) {
            CASAgent casAgent = (CASAgent)this.getExoContainer().getComponentInstanceOfType(CASAgent.class);
            if (casAgent == null) {
                throw new IllegalStateException("CASAgent component not provided in PortalContainer");
            }
            casAgent.setCasServerUrl(this.ssoServerUrl);
            casAgent.setCasServiceUrl(this.casServiceUrl);
            casAgent.setRenewTicket(this.casRenewTicket);
            this.casAgent = casAgent;
        }
        return this.casAgent;
    }

    protected JOSSOAgent getJOSSOAgent() {
        if (this.jossoAgent == null) {
            JOSSOAgent jossoAgent = (JOSSOAgent)this.getExoContainer().getComponentInstanceOfType(JOSSOAgent.class);
            if (jossoAgent == null) {
                throw new IllegalStateException("JOSSOAgent component not provided in PortalContainer");
            }
            this.jossoAgent = jossoAgent;
        }
        return this.jossoAgent;
    }

    protected OpenSSOAgent getOpenSSOAgent() {
        if (this.openSSOAgent == null) {
            OpenSSOAgent openssoAgent = (OpenSSOAgent)this.getExoContainer().getComponentInstanceOfType(OpenSSOAgent.class);
            if (openssoAgent == null) {
                throw new IllegalStateException("OpenSSOAgent component not provided in PortalContainer");
            }
            openssoAgent.setServerUrl(this.ssoServerUrl);
            openssoAgent.setCookieName(this.ssoCookieName);
            this.openSSOAgent = openssoAgent;
        }
        return this.openSSOAgent;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse resp = (HttpServletResponse)response;
            this.processSSOToken(req, resp);
            if (resp.isCommitted()) {
                return;
            }
            String portalContext = req.getContextPath();
            if (req.getAttribute("abort") != null) {
                String ssoSuffix = PropertyManager.getProperty((String)"gatein.sso.uri.suffix");
                if (StringUtils.isBlank((String)ssoSuffix)) {
                    ssoSuffix = "/sso";
                }
                String ssoRedirect = portalContext + (ssoSuffix.startsWith("/") ? ssoSuffix : "/" + ssoSuffix);
                resp.sendRedirect(ssoRedirect);
                return;
            }
            String loginRedirectURL = this.getLoginRedirectUrl(req);
            if (!StringUtils.isBlank((String)loginRedirectURL)) {
                loginRedirectURL = resp.encodeRedirectURL(loginRedirectURL);
                resp.sendRedirect(loginRedirectURL);
                return;
            }
            log.warn((Object)"Can't redirect to null SSO URL");
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void destroy() {
    }

    protected void processSSOToken(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws Exception {
        String ticket = httpRequest.getParameter("ticket");
        String jossoAssertion = httpRequest.getParameter("josso_assertion_id");
        String logoutRequest = httpRequest.getParameter("logoutRequest");
        if (ticket != null && ticket.trim().length() > 0) {
            this.getCasAgent().validateTicket(httpRequest, ticket);
        } else if (logoutRequest != null && logoutRequest.trim().length() > 0) {
            httpResponse.getWriter().close();
        } else if (jossoAssertion != null && jossoAssertion.trim().length() > 0) {
            this.getJOSSOAgent().validateTicket(httpRequest, httpResponse);
        } else {
            try {
                this.getOpenSSOAgent().validateTicket(httpRequest, httpResponse);
            }
            catch (IllegalStateException ilse) {
                int currentNumberOfErrors = this.getCountOfUnsuccessfulAttempts(httpRequest);
                log.warn((Object)("Count of login errors: " + currentNumberOfErrors));
                if (currentNumberOfErrors >= this.maxNumberOfLoginErrors) {
                    log.warn((Object)"Max. number of login errors reached. Rethrowing exception");
                    throw ilse;
                }
                httpRequest.setAttribute("abort", (Object)Boolean.TRUE);
            }
        }
    }

    private int getCountOfUnsuccessfulAttempts(HttpServletRequest httpRequest) {
        Integer currentNumberOfErrors = (Integer)httpRequest.getSession().getAttribute("InitiateLoginFilter.currentNumberOfErrors");
        if (currentNumberOfErrors == null) {
            currentNumberOfErrors = 0;
        }
        currentNumberOfErrors = currentNumberOfErrors + 1;
        httpRequest.getSession().setAttribute("InitiateLoginFilter.currentNumberOfErrors", (Object)currentNumberOfErrors);
        return currentNumberOfErrors;
    }

    protected String getLoginRedirectUrl(HttpServletRequest req) {
        if (this.loginUrl == null) {
            return null;
        }
        StringBuilder url = new StringBuilder(this.loginUrl);
        if (this.attachUsernamePasswordToLoginURL) {
            String fakePassword = req.getSession().getId() + "_" + String.valueOf(System.currentTimeMillis());
            Credentials creds = (Credentials)req.getSession().getAttribute("authenticatedCredentials");
            String username = creds != null ? creds.getUsername() : fakePassword;
            url.append("?username=").append(username).append("&password=").append(fakePassword);
        }
        return url.toString();
    }
}

