/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement;

import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.EntitlementSubjectImpl;
import com.sun.identity.entitlement.SubjectAttributesManager;
import com.sun.identity.entitlement.SubjectDecision;
import com.sun.identity.idm.IdType;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupSubject
extends EntitlementSubjectImpl {
    public GroupSubject() {
    }

    public GroupSubject(String group) {
        super(group);
    }

    public GroupSubject(String group, String pSubjectName) {
        super(group, pSubjectName);
    }

    @Override
    public SubjectDecision evaluate(String realm, SubjectAttributesManager mgr, Subject subject, String resourceName, Map<String, Set<String>> environment) throws EntitlementException {
        boolean satified = false;
        Set<Object> publicCreds = subject.getPublicCredentials();
        if (publicCreds != null && !publicCreds.isEmpty()) {
            Map attributes = (Map)publicCreds.iterator().next();
            Set values = (Set)attributes.get("membership:" + IdType.GROUP.getName());
            satified = values != null ? values.contains(this.getID()) : false;
        }
        return new SubjectDecision(satified ^= this.isExclusive(), Collections.EMPTY_MAP);
    }

    @Override
    public Map<String, Set<String>> getSearchIndexAttributes() {
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>(4);
        HashSet<String> set = new HashSet<String>();
        set.add(this.getID());
        map.put("membership:" + IdType.GROUP.getName(), set);
        set = new HashSet();
        set.add("all");
        map.put("identity:", set);
        return map;
    }

    @Override
    public Set<String> getRequiredAttributeNames() {
        HashSet<String> set = new HashSet<String>(2);
        set.add("membership:" + IdType.GROUP.getName());
        return set;
    }

    @Override
    public boolean isIdentity() {
        return true;
    }
}

