/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.password.ui.model;

import com.iplanet.am.util.AMSendMail;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.password.ui.model.PWResetAccountLockout;
import com.sun.identity.password.ui.model.PWResetAdminLog;
import com.sun.identity.password.ui.model.PWResetModel;
import com.sun.identity.password.ui.model.PWResetResBundleCacher;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.mail.MessagingException;

public class PWResetModelImpl
implements PWResetModel {
    private static final String PASSWORD_DEBUG_FILENAME = "amPasswordReset";
    private static final String PW_RESET_ENABLED_ATTR = "iplanet-am-password-reset-enabled";
    private static final String PW_RESET_FAILURE_LOCKOUT_MODE = "iplanet-am-password-reset-failure-lockout-mode";
    private static final String PW_RESET_LOCKOUT_EMAIL_ADDRESS = "iplanet-am-password-reset-lockout-email-address";
    private static final String PW_RESET_FAILURE_DURATION = "iplanet-am-password-reset-failure-duration";
    private static final String PW_RESET_LOCKOUT_WARN_USER = "iplanet-am-password-reset-lockout-warn-user";
    private static final String PW_RESET_FAILURE_COUNT = "iplanet-am-password-reset-failure-count";
    private static final String PW_RESET_FAILURE_LOCKOUT_DURATION = "iplanet-am-password-reset-lockout-duration";
    private static final String PW_RESET_FAILURE_LOCKOUT_MULTIPLIER = "sunLockoutDurationMultiplier";
    private static final String LOCALE_STR = "Locale";
    private static final String PW_RESET_LOCKOUT_ATTR_NAME = "iplanet-am-password-reset-lockout-attribute-name";
    private static final String PW_RESET_LOCKOUT_ATTR_VALUE = "iplanet-am-password-reset-lockout-attribute-value";
    public static final String STRING_TRUE = "true";
    public static Debug debug = Debug.getInstance((String)"amPasswordReset");
    protected SSOToken ssoToken;
    protected ResourceBundle resBundle = null;
    protected String userId = null;
    protected String errorMsg = null;
    protected String informationMsg = null;
    protected String passwordResetMsg = null;
    protected PWResetAdminLog logger = null;
    protected ISLocaleContext localeContext = new ISLocaleContext();
    private static int NUM_OF_MILLISECS_IN_MIN = 60000;
    private static int PW_RESET_FAILURE_DURATION_TIME = 300;
    private static int PW_RESET_FAILURE_LOCKOUT_COUNT = 5;
    private static int PW_RESET_LOCKOUT_USER_WARN_COUNT = 4;
    private String rbName = "amPasswordResetModuleMsgs";
    private boolean pwResetEnable = true;
    private boolean pwResetFailureLockoutMode = false;
    private long pwResetFailureLockoutDuration = 0L;
    private int pwResetFailureLockoutMultiplier = 0;
    private long pwResetFailureLockoutTime = PW_RESET_FAILURE_DURATION_TIME * NUM_OF_MILLISECS_IN_MIN;
    private int pwResetFailureLockoutCnt = PW_RESET_FAILURE_LOCKOUT_COUNT;
    private String pwResetLockoutNotification = null;
    private int pwResetLockoutUserWarningCnt = PW_RESET_LOCKOUT_USER_WARN_COUNT;
    public String pwResetLockoutAttrName = null;
    public String pwResetLockoutAttrValue = null;

    public PWResetModelImpl() {
        this.initialize();
    }

    public String getLocalizedString(String key) {
        String i18nString = key;
        try {
            ResourceBundle rb = PWResetResBundleCacher.getBundle("amPasswordResetModuleMsgs", this.localeContext.getLocale());
            i18nString = rb.getString(key);
        }
        catch (MissingResourceException e) {
            debug.warning("PWResetModelImpl.getLocalizedString", (Throwable)e);
        }
        return i18nString;
    }

    public ISLocaleContext getUserLocaleContext() {
        return this.localeContext;
    }

    public void debugError(String message) {
        debug.error(message);
    }

    public void debugError(String message, Exception e) {
        debug.error(message, (Throwable)e);
    }

    public boolean warningEnabled() {
        return debug.warningEnabled();
    }

    public void debugWarning(String message) {
        debug.warning(message);
    }

    public void debugWarning(String message, Exception e) {
        debug.warning(message, (Throwable)e);
    }

    public boolean messageEnabled() {
        return debug.messageEnabled();
    }

    public void debugMessage(String message) {
        debug.message(message);
    }

    public void debugMessage(String message, Exception e) {
        debug.message(message, (Throwable)e);
    }

    public String getHTMLPageTitle() {
        return this.getLocalizedString("pwConsole.title");
    }

    public boolean isPasswordResetEnabled() {
        return this.pwResetEnable;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserDN(String value) {
        this.userId = value;
    }

    public String getErrorTitle() {
        return this.getLocalizedString("error.title");
    }

    public String getErrorMessage() {
        return this.errorMsg;
    }

    public boolean isError() {
        return this.errorMsg != null && this.errorMsg.length() > 0;
    }

    public String getCopyRightText() {
        return this.getLocalizedString("copyright.text");
    }

    public String getPasswordResetMessage() {
        return this.passwordResetMsg;
    }

    public String getErrorString(Exception ex) {
        return ex.getMessage();
    }

    public String getRootSuffix() {
        return SMSEntry.getRootSuffix();
    }

    protected ServiceSchema getPWResetServiceSchema() throws SSOException, SMSException {
        ServiceSchemaManager mgr = new ServiceSchemaManager("iPlanetAMPasswordResetService", this.ssoToken);
        return mgr.getSchema(SchemaType.ORGANIZATION);
    }

    protected String getL10NAttributeName(ServiceSchemaManager mgr, String key) {
        String i18nName = key;
        try {
            String name = mgr.getI18NFileName();
            if (name != null) {
                ResourceBundle rb = PWResetResBundleCacher.getBundle(name, this.localeContext.getLocale());
                i18nName = Locale.getString((ResourceBundle)rb, (String)key, (Debug)debug);
            }
        }
        catch (MissingResourceException e) {
            debug.warning("PWResetModelImpl.getL10NAttributeName", (Throwable)e);
        }
        return i18nName;
    }

    public String getL10NAttributeName(String serviceName, String key) {
        String i18nName = key;
        try {
            ServiceSchemaManager mgr = new ServiceSchemaManager(serviceName, this.ssoToken);
            String name = mgr.getI18NFileName();
            if (name != null) {
                ResourceBundle rb = PWResetResBundleCacher.getBundle(name, this.localeContext.getLocale());
                i18nName = Locale.getString((ResourceBundle)rb, (String)key, (Debug)debug);
            }
        }
        catch (MissingResourceException mre) {
            if (debug.warningEnabled()) {
                debug.warning("PWResetModelImpl.getL10NAttributeName: Could not localized str for " + key + " in service " + serviceName, (Throwable)mre);
            }
        }
        catch (SSOException e) {
            debug.warning("PWResetModelImpl.getL10NAttributeName", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.warning("PWResetModelImpl.getL10NAttributeName", (Throwable)e);
        }
        return i18nName;
    }

    private void initialize() {
        this.ssoToken = this.getSSOToken();
        this.logger = new PWResetAdminLog(this.ssoToken);
        this.resBundle = PWResetResBundleCacher.getBundle(this.rbName, this.localeContext.getLocale());
    }

    public void readPWResetProfile(String realm) {
        String value = null;
        try {
            value = this.getAttributeValue(realm, PW_RESET_ENABLED_ATTR);
        }
        catch (SSOException e) {
            debug.warning("PWResetModelImpl.readPWResetProfile", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("PWResetModelImpl.readPWResetProfile", (Throwable)e);
        }
        if (value == null || !value.equals(STRING_TRUE)) {
            this.pwResetEnable = false;
            this.informationMsg = this.getLocalizedString("pwResetDisabled.message");
        }
    }

    protected boolean isAttributeSet(String realm, String attrName) throws SSOException, SMSException {
        String value = this.getAttributeValue(realm, attrName);
        return value != null && value.equals(STRING_TRUE);
    }

    protected Set getDefaultAttrValues(ServiceSchema schema, String attrName) {
        AttributeSchema as;
        Set defaultValues = Collections.EMPTY_SET;
        if (schema != null && (as = schema.getAttributeSchema(attrName)) != null) {
            defaultValues = as.getDefaultValues();
        }
        return defaultValues;
    }

    protected String getAttributeValue(String realm, String attrName) throws SSOException, SMSException {
        Set set = this.getAttributeValues(realm, attrName);
        return PWResetModelImpl.getFirstElement(set);
    }

    protected Set getAttributeValues(String realm, String attrName) throws SSOException, SMSException {
        OrganizationConfigManager mgr = new OrganizationConfigManager(this.ssoToken, realm);
        Map attributeValues = mgr.getServiceAttributes("iPlanetAMPasswordResetService");
        return (Set)attributeValues.get(attrName);
    }

    public String getInformationMessage() {
        return this.informationMsg;
    }

    public static String getFirstElement(Set set) {
        return set != null && !set.isEmpty() ? (String)set.iterator().next() : "";
    }

    public void writeLog(String msg, String userDN) {
        Object[] obj = new String[]{userDN};
        this.logger.doLog(MessageFormat.format(this.getLocalizedString(msg), obj));
    }

    public boolean isPasswordResetFailureLockoutEnabled() {
        return this.pwResetFailureLockoutMode;
    }

    public long getPasswordResetFailureLockoutDuration() {
        return this.pwResetFailureLockoutDuration;
    }

    public int getPasswordResetFailureLockoutMultiplier() {
        return this.pwResetFailureLockoutMultiplier;
    }

    public long getPasswordResetFailureLockoutTime() {
        return this.pwResetFailureLockoutTime;
    }

    public int getPasswordResetFailureLockoutCount() {
        return this.pwResetFailureLockoutCnt;
    }

    public String getPasswordResetLockoutNotification() {
        return this.pwResetLockoutNotification;
    }

    public int getPasswordResetLockoutUserWarningCount() {
        return this.pwResetLockoutUserWarningCnt;
    }

    public void populateLockoutValues(String orgDN) {
        try {
            String value = this.getAttributeValue(orgDN, PW_RESET_FAILURE_LOCKOUT_MODE);
            if (value != null && value.equals(STRING_TRUE)) {
                this.pwResetFailureLockoutMode = true;
            }
            if ((value = this.getAttributeValue(orgDN, PW_RESET_FAILURE_DURATION)) != null && value.length() > 0) {
                this.pwResetFailureLockoutTime = Long.parseLong(value);
                this.pwResetFailureLockoutTime *= (long)NUM_OF_MILLISECS_IN_MIN;
            }
            this.pwResetLockoutNotification = this.getAttributeValue(orgDN, PW_RESET_LOCKOUT_EMAIL_ADDRESS);
            value = this.getAttributeValue(orgDN, PW_RESET_LOCKOUT_WARN_USER);
            if (value != null && value.length() > 0) {
                this.pwResetLockoutUserWarningCnt = Integer.parseInt(value);
            }
            if ((value = this.getAttributeValue(orgDN, PW_RESET_FAILURE_LOCKOUT_DURATION)) != null && value.length() > 0) {
                this.pwResetFailureLockoutDuration = Long.parseLong(value);
                this.pwResetFailureLockoutDuration *= (long)NUM_OF_MILLISECS_IN_MIN;
            }
            if ((value = this.getAttributeValue(orgDN, PW_RESET_FAILURE_LOCKOUT_MULTIPLIER)) != null && value.length() > 0) {
                this.pwResetFailureLockoutMultiplier = Integer.parseInt(value);
            }
            if ((value = this.getAttributeValue(orgDN, PW_RESET_FAILURE_COUNT)) != null && value.length() > 0) {
                this.pwResetFailureLockoutCnt = Integer.parseInt(value);
            }
            if ((value = this.getAttributeValue(orgDN, PW_RESET_LOCKOUT_ATTR_NAME)) != null && value.trim().length() > 0) {
                this.pwResetLockoutAttrName = value;
            }
            if ((value = this.getAttributeValue(orgDN, PW_RESET_LOCKOUT_ATTR_VALUE)) != null && value.trim().length() > 0) {
                this.pwResetLockoutAttrValue = value;
            }
        }
        catch (NumberFormatException e) {
            debug.error("PWResetModelImpl.populateLockoutValues", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("PWResetModelImpl.populateLockoutValues", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("PWResetModelImpl.populateLockoutValues", (Throwable)e);
        }
    }

    public boolean isUserLockout(String userDN, String orgDN) {
        this.populateLockoutValues(orgDN);
        PWResetAccountLockout pwResetLockout = new PWResetAccountLockout(this);
        return pwResetLockout.isLockout(userDN);
    }

    public void sendEmailToUser(String from, String[] to, String subject, String msg, String charset) {
        AMSendMail sm = new AMSendMail();
        try {
            sm.postMail(to, subject, msg, from, charset);
        }
        catch (MessagingException ex) {
            debug.error("Could not send email to user " + to, (Throwable)ex);
        }
    }

    public String getPasswordResetLockoutAttributeName() {
        return this.pwResetLockoutAttrName;
    }

    public String getPasswordResetLockoutAttributeValue() {
        return this.pwResetLockoutAttrValue;
    }

    public String getSunLogoLabel() {
        return this.getLocalizedString("sunLogo.label");
    }

    public String getProductLabel() {
        return this.getLocalizedString("product.label");
    }

    public String getJavaLogoLabel() {
        return this.getLocalizedString("javaLogo.label");
    }

    protected SSOToken getSSOToken() {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }
}

