/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.disco.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandler;
import com.sun.identity.liberty.ws.disco.plugins.DiscoEntryHandlerImplUtils;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GlobalDiscoEntryHandler
implements DiscoEntryHandler {
    private static final String DYNAMIC_ATTR_NAME = "sunIdentityServerDynamicDiscoEntries";
    private static final String DISCO_SERVICE = "sunIdentityServerDiscoveryService";

    public GlobalDiscoEntryHandler() {
        DiscoUtils.debug.message("in GlobalDiscoEntryHandler.constructor");
    }

    private static synchronized AMIdentity getRealmIdentity() throws DiscoveryException {
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMIdentityRepository idRepo = new AMIdentityRepository(adminToken, "/");
            return idRepo.getRealmIdentity();
        }
        catch (IdRepoException ire) {
            DiscoUtils.debug.error("GlobalDiscoEntryHandler.getRealmIdentity: Initialization failed", (Throwable)ire);
            throw new DiscoveryException(ire.getMessage());
        }
        catch (SSOException se) {
            DiscoUtils.debug.error("GlobalDiscoEntryHandler.getRealmIdentity: SSOException ", (Throwable)se);
            throw new DiscoveryException(se.getMessage());
        }
    }

    private static void registerDiscoveryService() throws DiscoveryException {
        try {
            AMIdentity amId = GlobalDiscoEntryHandler.getRealmIdentity();
            Set assignedServices = amId.getAssignedServices();
            if (assignedServices != null && assignedServices.contains(DISCO_SERVICE)) {
                return;
            }
            amId.assignService(DISCO_SERVICE, null);
        }
        catch (IdRepoException ire) {
            DiscoUtils.debug.error("GlobalDiscoEntryHandler.registerDiscoveryService: Exception", (Throwable)ire);
            throw new DiscoveryException(ire.getMessage());
        }
        catch (SSOException se) {
            DiscoUtils.debug.error("GlobalDiscoEntryHandler.registerDiscoveryService: Exception", (Throwable)se);
            throw new DiscoveryException(se.getMessage());
        }
    }

    public Map getDiscoEntries(String userID, List reqServiceTypes) {
        DiscoUtils.debug.message("in GlobalDiscoEntryHandler.getDiscoEntries");
        Map results = new HashMap();
        try {
            DiscoEntryHandlerImplUtils.getGlobalDiscoEntries(GlobalDiscoEntryHandler.getRealmIdentity(), DYNAMIC_ATTR_NAME, results, userID);
            results = DiscoEntryHandlerImplUtils.getQueryResults(results, reqServiceTypes);
        }
        catch (Exception e) {
            DiscoUtils.debug.error("GlobalDiscoEntryHandler.getDiscoEntries: Exception:", (Throwable)e);
        }
        return results;
    }

    public Map modifyDiscoEntries(String userID, List removes, List inserts) {
        if (DiscoUtils.debug.messageEnabled()) {
            DiscoUtils.debug.message("GlobalDiscoEntryHandler.modifyDiscoEntries: init ");
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("STATUS_CODE", "Failed");
        HashMap discoEntries = new HashMap();
        try {
            GlobalDiscoEntryHandler.registerDiscoveryService();
            AMIdentity amId = GlobalDiscoEntryHandler.getRealmIdentity();
            DiscoEntryHandlerImplUtils.getGlobalDiscoEntries(GlobalDiscoEntryHandler.getRealmIdentity(), DYNAMIC_ATTR_NAME, discoEntries, userID);
            if (removes != null && removes.size() != 0 && !DiscoEntryHandlerImplUtils.handleRemoves(discoEntries, removes)) {
                return result;
            }
            HashSet entries = new HashSet();
            entries.addAll(discoEntries.values());
            List newEntryIDs = null;
            if (inserts != null && inserts.size() != 0) {
                Map insertResults = DiscoEntryHandlerImplUtils.handleInserts(entries, inserts);
                if (!((String)insertResults.get("STATUS_CODE")).equals("OK")) {
                    return result;
                }
                newEntryIDs = (List)insertResults.get("newEntryIDs");
            }
            if (!DiscoEntryHandlerImplUtils.setGlobalDiscoEntries(amId, DYNAMIC_ATTR_NAME, entries)) {
                return result;
            }
            result.put("STATUS_CODE", "OK");
            if (newEntryIDs != null && newEntryIDs.size() != 0) {
                result.put("newEntryIDs", newEntryIDs);
            }
            return result;
        }
        catch (DiscoveryException de) {
            DiscoUtils.debug.error("GlobalDiscoEntryHandler.modifyDiscoEntries: Exception", (Throwable)de);
            return result;
        }
        catch (Exception ex) {
            DiscoUtils.debug.error("GlobalDiscoEntryHandler.modifyDiscoEntries: Exception", (Throwable)ex);
            return result;
        }
    }
}

