/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.cli.realm.RealmUtils;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;

public class CreateRealm
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        if (!realm.startsWith("/")) {
            realm = "/" + realm;
        }
        String parentRealm = RealmUtils.getParentRealm(realm);
        String childRealm = RealmUtils.getChildRealm(realm);
        String[] params = new String[]{realm};
        this.writeLog(0, Level.INFO, "ATTEMPT_CREATE_REALM", params);
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, parentRealm);
            HashMap defaultValues = new HashMap(2);
            HashMap map = new HashMap(2);
            HashSet<String> values = new HashSet<String>(2);
            values.add("Active");
            map.put("sunOrganizationStatus", values);
            defaultValues.put("sunIdentityRepositoryService", map);
            ocm.createSubOrganization(childRealm, defaultValues);
            this.getOutputWriter().printlnMessage(this.getResourceString("create-realm-succeed"));
            this.writeLog(0, Level.INFO, "SUCCEED_CREATE_REALM", params);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, e.getMessage()};
            this.debugError("CreateRealm.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_CREATE_REALM", args);
            throw new CLIException(e, 127);
        }
    }
}

