/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.idm.plugins.ldapv3;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.util.AMURLEncDec;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.ServerEntryNotFoundException;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.common.CaseInsensitiveHashMap;
import com.sun.identity.common.CaseInsensitiveHashSet;
import com.sun.identity.common.LDAPConnectionPool;
import com.sun.identity.common.ShutdownListener;
import com.sun.identity.common.ShutdownManager;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoBundle;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.idm.common.IdRepoUtils;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3Bundle;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3EventService;
import com.sun.identity.idm.plugins.ldapv3.LDAPv3EventServicePolling;
import com.sun.identity.idm.plugins.ldapv3.Request;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPAttributeSet;
import com.sun.identity.shared.ldap.LDAPCache;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPControl;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPModification;
import com.sun.identity.shared.ldap.LDAPModificationSet;
import com.sun.identity.shared.ldap.LDAPObjectClassSchema;
import com.sun.identity.shared.ldap.LDAPRebind;
import com.sun.identity.shared.ldap.LDAPRebindAuth;
import com.sun.identity.shared.ldap.LDAPReferralException;
import com.sun.identity.shared.ldap.LDAPSchema;
import com.sun.identity.shared.ldap.LDAPSearchConstraints;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.LDAPSocketFactory;
import com.sun.identity.shared.ldap.LDAPUrl;
import com.sun.identity.shared.ldap.controls.LDAPPasswordExpiringControl;
import com.sun.identity.shared.ldap.factory.JSSESocketFactory;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.SchemaType;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class LDAPv3Repo
extends IdRepo {
    private Map supportedOps = new HashMap();
    private Map myConfigMap = null;
    private Map myServiceMap = null;
    private boolean hasShutdown = false;
    private IdRepoListener myListener = null;
    private static SOAPClient mySoapClient = new SOAPClient("dummy");
    private String ldapServerName = null;
    private String ldapHost = null;
    private int ldapPort = 389;
    private String firstHostAndPort = "";
    private static final int NO_PASSWORD_CONTROLS = 0;
    private static final int PASSWORD_EXPIRED = -1;
    private static final int activeMask = -3;
    private static final int disableMask = 2;
    private String orgDN = "";
    private static Debug debug;
    private LDAPConnectionPool connPool;
    private boolean sslMode = false;
    private String ldapConnError = "91";
    private int connNumRetry = 3;
    private int connRetryInterval = 1000;
    private int timeLimit = 5000;
    private int defaultMaxResults = 100;
    private int roleSearchScope = 2;
    private int searchScope = 2;
    private String userSearchFilter = null;
    private String groupSearchFilter = null;
    private String roleSearchFilter = "(&(objectclass=ldapsubentry)(objectclass=nsmanagedroledefinition))";
    private String filterroleSearchFilter = "(&(objectclass=ldapsubentry)(objectclass=nsfilteredroledefinition))";
    private String agentSearchFilter = null;
    private String userSearchNamingAttr = null;
    private String agentSearchNamingAttr = null;
    private String groupSearchNamingAttr = null;
    private String roleSearchNamingAttr = null;
    private String filterroleSearchNamingAttr = null;
    private String peopleCtnrNamingAttr = null;
    private String agentCtnrNamingAttr = null;
    private String groupCtnrNamingAttr = null;
    private String peopleCtnrValue = null;
    private String agentCtnrValue = null;
    private String groupCtnrValue = null;
    private String nsRoleAttr = null;
    private String nsRoleDNAttr = null;
    private String nsRoleFilterAttr = null;
    private String memberOfAttr = null;
    private String uniqueMemberAttr = null;
    private String memberURLAttr = null;
    private String defaultGrpMem = null;
    private String isActiveAttrName = null;
    private boolean alwaysActive = false;
    private String inetUserActive = null;
    private String inetUserInactive = null;
    private Set filterroleObjClassSet = null;
    private Set roleObjClassSet = null;
    private Set groupObjClassSet = null;
    private Set userObjClassSet = null;
    private Set agentObjClassSet = null;
    private Map createUserAttrMap = null;
    private CaseInsensitiveHashSet userAtttributesAllowed = null;
    private CaseInsensitiveHashSet groupAtttributesAllowed = null;
    private CaseInsensitiveHashSet agentAtttributesAllowed = null;
    private CaseInsensitiveHashSet roleAtttributesAllowed = null;
    private CaseInsensitiveHashSet filteredroleAtttributesAllowed = null;
    private Set userSpecifiedOpsSet = null;
    private CaseInsensitiveHashSet authenticatableSet = null;
    private boolean cacheEnabled = false;
    private long cacheTTL = 600L;
    private long cacheSize = 10240L;
    private LDAPCache ldapCache = null;
    private final int MIN_CONNECTION_POOL_SIZE = 1;
    private final int MAX_CONNECTION_POOL_SIZE = 10;
    private final int PS_OP = 15;
    protected static Hashtable _eventsMgr;
    protected static Hashtable _numRequest;
    protected static Map listOfPS;
    private boolean hasListener = false;
    private String dsType = "";
    static final String LDAP_OBJECT_CLASS = "objectclass";
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private static final String LDAPv3Config_LDAPV3GENERIC = "sun-idrepo-ldapv3-ldapv3Generic";
    private static final String LDAPv3Config_LDAPV3AMDS = "sun-idrepo-ldapv3-ldapv3AMDS";
    private static final String LDAPv3Config_LDAPV3AD = "sun-idrepo-ldapv3-ldapv3AD";
    private static final String LDAPv3Config_LDAPV3ADAM = "sun-idrepo-ldapv3-ldapv3ADAM";
    private static final String LDAPv3Config_LDAP_SERVER = "sun-idrepo-ldapv3-config-ldap-server";
    private static final String LDAPv3Config_AUTHID = "sun-idrepo-ldapv3-config-authid";
    private static final String LDAPv3Config_AUTHPW = "sun-idrepo-ldapv3-config-authpw";
    private static final String LDAPv3Config_LDAP_SSL_ENABLED = "sun-idrepo-ldapv3-config-ssl-enabled";
    private static final String LDAPv3Config_LDAP_CONNECTION_POOL_MIN_SIZE = "sun-idrepo-ldapv3-config-connection_pool_min_size";
    private static final String LDAPv3Config_LDAP_CONNECTION_POOL_MAX_SIZE = "sun-idrepo-ldapv3-config-connection_pool_max_size";
    private static final String LDAPv3Config_ORGANIZATION_NAME = "sun-idrepo-ldapv3-config-organization_name";
    private static final String LDAPv3Config_LDAP_GROUP_SEARCH_FILTER = "sun-idrepo-ldapv3-config-groups-search-filter";
    private static final String LDAPv3Config_LDAP_USERS_SEARCH_FILTER = "sun-idrepo-ldapv3-config-users-search-filter";
    private static final String LDAPv3Config_LDAP_ROLES_SEARCH_FILTER = "sun-idrepo-ldapv3-config-roles-search-filter";
    private static final String LDAPv3Config_LDAP_FILTERROLES_SEARCH_FILTER = "sun-idrepo-ldapv3-config-filterroles-search-filter";
    private static final String LDAPv3Config_LDAP_AGENT_SEARCH_FILTER = "sun-idrepo-ldapv3-config-agent-search-filter";
    private static final String LDAPv3Config_LDAP_ROLES_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-roles-search-attribute";
    private static final String LDAPv3Config_LDAP_FILTERROLES_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-filterroles-search-attribute";
    private static final String LDAPv3Config_LDAP_GROUPS_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-groups-search-attribute";
    private static final String LDAPv3Config_LDAP_USERS_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-users-search-attribute";
    private static final String LDAPv3Config_LDAP_AGENT_SEARCH_ATTRIBUTE = "sun-idrepo-ldapv3-config-agent-search-attribute";
    private static final String LDAPv3Config_LDAP_ROLES_SEARCH_SCOPE = "sun-idrepo-ldapv3-config-role-search-scope";
    private static final String LDAPv3Config_LDAP_SEARCH_SCOPE = "sun-idrepo-ldapv3-config-search-scope";
    private static final String LDAPv3Config_LDAP_GROUP_CONTAINER_NAME = "sun-idrepo-ldapv3-config-group-container-name";
    private static final String LDAPv3Config_LDAP_AGENT_CONTAINER_NAME = "sun-idrepo-ldapv3-config-agent-container-name";
    private static final String LDAPv3Config_LDAP_PEOPLE_CONTAINER_NAME = "sun-idrepo-ldapv3-config-people-container-name";
    private static final String LDAPv3Config_LDAP_GROUP_CONTAINER_VALUE = "sun-idrepo-ldapv3-config-group-container-value";
    private static final String LDAPv3Config_LDAP_PEOPLE_CONTAINER_VALUE = "sun-idrepo-ldapv3-config-people-container-value";
    private static final String LDAPv3Config_LDAP_AGENT_CONTAINER_VALUE = "sun-idrepo-ldapv3-config-agent-container-value";
    private static final String LDAPv3Config_LDAP_TIME_LIMIT = "sun-idrepo-ldapv3-config-time-limit";
    private static final String LDAPv3Config_LDAP_MAX_RESULT = "sun-idrepo-ldapv3-config-max-result";
    private static final String LDAPv3Config_REFERRALS = "sun-idrepo-ldapv3-config-referrals";
    private static final String LDAPv3Config_ROLE_OBJECT_CLASS = "sun-idrepo-ldapv3-config-role-objectclass";
    private static final String LDAPv3Config_FILTERROLE_OBJECT_CLASS = "sun-idrepo-ldapv3-config-filterrole-objectclass";
    private static final String LDAPv3Config_GROUP_OBJECT_CLASS = "sun-idrepo-ldapv3-config-group-objectclass";
    private static final String LDAPv3Config_USER_OBJECT_CLASS = "sun-idrepo-ldapv3-config-user-objectclass";
    private static final String LDAPv3Config_AGENT_OBJECT_CLASS = "sun-idrepo-ldapv3-config-agent-objectclass";
    private static final String LDAPv3Config_GROUP_ATTR = "sun-idrepo-ldapv3-config-group-attributes";
    private static final String LDAPv3Config_USER_ATTR = "sun-idrepo-ldapv3-config-user-attributes";
    private static final String LDAPv3Config_AGENT_ATTR = "sun-idrepo-ldapv3-config-agent-attributes";
    private static final String LDAPv3Config_ROLE_ATTR = "sun-idrepo-ldapv3-config-role-attributes";
    private static final String LDAPv3Config_FILTERROLE_ATTR = "sun-idrepo-ldapv3-config-filterrole-attributes";
    private static final String LDAPv3Config_NSROLE = "sun-idrepo-ldapv3-config-nsrole";
    private static final String LDAPv3Config_NSROLEDN = "sun-idrepo-ldapv3-config-nsroledn";
    private static final String LDAPv3Config_NSROLEFILTER = "sun-idrepo-ldapv3-config-nsrolefilter";
    private static final String LDAPv3Config_MEMBEROF = "sun-idrepo-ldapv3-config-memberof";
    private static final String LDAPv3Config_UNIQUEMEMBER = "sun-idrepo-ldapv3-config-uniquemember";
    private static final String LDAPv3Config_DEFAULTGROUPMEMBER = "sun-idrepo-ldapv3-config-dftgroupmember";
    private static final String LDAPv3Config_MEMBERURL = "sun-idrepo-ldapv3-config-memberurl";
    private static final String LDAPv3Config_LDAP_IDLETIMEOUT = "sun-idrepo-ldapv3-config-idletimeout";
    private static final String LDAPv3Config_LDAP_PSEARCHBASE = "sun-idrepo-ldapv3-config-psearchbase";
    private static final String LDAPv3Config_LDAP_PSEARCHFILTER = "sun-idrepo-ldapv3-config-psearch-filter";
    private static final String LDAPv3Config_LDAP_PSEARCHSCOPE = "sun-idrepo-ldapv3-config-psearch-scope";
    private static final String LDAPv3Config_LDAP_ISACTIVEATTRNAME = "sun-idrepo-ldapv3-config-isactive";
    private static final String LDAPv3Config_LDAP_INETUSERACTIVE = "sun-idrepo-ldapv3-config-active";
    private static final String LDAPv3Config_LDAP_INETUSERINACTIVE = "sun-idrepo-ldapv3-config-inactive";
    private static final String LDAPv3Config_LDAP_CREATEUSERMAPPING = "sun-idrepo-ldapv3-config-createuser-attr-mapping";
    private static final String LDAPv3Config_LDAP_AUTHENTICATABLE = "sun-idrepo-ldapv3-config-authenticatable-type";
    private static final String LDAPv3Config_LDAP_CACHEENABLED = "sun-idrepo-ldapv3-config-cache-enabled";
    private static final String LDAPv3Config_LDAP_CACHETTL = "sun-idrepo-ldapv3-config-cache-ttl";
    private static final String LDAPv3Config_LDAP_CACHESIZE = "sun-idrepo-ldapv3-config-cache-size";
    private static final String LDAPv3Config_LDAP_NUM_RETRIES = "sun-idrepo-ldapv3-config-numretires";
    private static final String LDAPv3Config_LDAP_RETRY_INTERVAL = "com.iplanet.am.ldap.connection.delay.between.retries";
    private static final String LDAPv3Config_LDAP_ERROR_CODES = "sun-idrepo-ldapv3-config-errorcodes";
    private static final String AUTH_USER;
    private static final String AUTH_AGENT;
    private static final String AUTH_GROUP;
    private static final String defaultStatusAttribute = "inetUserStatus";
    private static final String statusActive = "Active";
    private static final String statusInactive = "Inactive";
    private static final String unicodePwd = "unicodePwd";
    private static final String userPassword = "userPassword";
    private static final String sunIdentityServerDeviceStatus = "sunIdentityServerDeviceStatus";
    private static SSOToken internalToken;
    private static final String SCHEMA_BUG_PROPERTY = "com.sun.identity.shared.ldap.schema.quoting";
    private static final String VAL_STANDARD = "standard";
    private static final String CLASS_NAME = "com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo";
    protected String LDAPv3Repo = "LDAPv3Repo";
    protected String amAuthLDAP = "amAuthLDAP";

    public LDAPv3Repo() {
        if (debug == null) {
            debug = Debug.getInstance((String)this.LDAPv3Repo);
        }
        this.loadSupportedOps();
    }

    private void enableCache(LDAPConnection ld) {
        if (this.cacheEnabled && ld.getCache() != this.ldapCache) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: isExists. ldapcache is null.");
            }
            ld.setCache(this.ldapCache);
        }
    }

    private void getLDAPServerName(Map configParams) {
        block20: {
            String serverID;
            String siteID;
            block19: {
                siteID = "";
                serverID = "";
                try {
                    serverID = WebtopNaming.getAMServerID();
                    siteID = WebtopNaming.getSiteID(serverID);
                }
                catch (ServerEntryNotFoundException senf) {
                    if (!debug.messageEnabled()) break block19;
                    debug.warning("ServerEntryNotFoundException error: siteID=" + siteID + "; serverID=" + serverID);
                }
            }
            HashSet ldapServerSet = new HashSet((Set)configParams.get(LDAPv3Config_LDAP_SERVER));
            String ldapServer = "";
            String endOfList = "";
            for (String curr : ldapServerSet) {
                StringTokenizer tk = new StringTokenizer(curr, "|");
                String hostAndPort = tk.nextToken().trim();
                String hostServerID = "";
                if (tk.hasMoreTokens()) {
                    hostServerID = tk.nextToken();
                    hostServerID = hostServerID.trim();
                }
                String hostSiteID = "";
                if (tk.hasMoreTokens()) {
                    hostSiteID = tk.nextToken();
                    hostSiteID = hostSiteID.trim();
                }
                if (hostSiteID.length() == 0) {
                    hostSiteID = siteID;
                }
                if (hostServerID.length() == 0) {
                    hostServerID = serverID;
                }
                if (siteID.equals(hostSiteID) && serverID.equals(hostServerID)) {
                    if (ldapServer.length() == 0) {
                        ldapServer = hostAndPort;
                        continue;
                    }
                    ldapServer = ldapServer + " " + hostAndPort;
                    continue;
                }
                if (endOfList.length() == 0) {
                    endOfList = hostAndPort;
                    continue;
                }
                endOfList = endOfList + " " + hostAndPort;
            }
            if (ldapServer.length() == 0) {
                ldapServer = endOfList;
            } else if (endOfList.length() != 0) {
                ldapServer = ldapServer + " " + endOfList;
            }
            if (debug.messageEnabled()) {
                debug.message("getLDAPServerName:LDAPv3Config_LDAP_SERVER; ldapServer:" + ldapServer + "; endOfList:" + endOfList + "; siteID:" + siteID + "; serverID:" + serverID + "; ldapServerSet:" + ldapServerSet);
            }
            this.ldapServerName = ldapServer;
            this.ldapHost = ldapServer;
            int index = ldapServer.indexOf(58);
            if (index > -1) {
                this.ldapHost = ldapServer.substring(0, index);
                try {
                    String portSub = ldapServer.substring(index + 1);
                    int portindex = portSub.indexOf(32);
                    if (portindex > -1) {
                        String portStr = portSub.substring(0, portindex);
                        this.ldapPort = Integer.parseInt(portStr);
                    } else {
                        this.ldapPort = Integer.parseInt(portSub);
                    }
                }
                catch (NumberFormatException e) {
                    if (!debug.messageEnabled()) break block20;
                    debug.message("LDAPv3Repo:authenticate use default 389");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initConnectionPool(Map configParams) {
        block24: {
            int resultCode;
            LDAPConnection ldc;
            int maxPoolSize;
            int minPoolSize;
            String referrals;
            String authpw;
            String authid;
            HashMap<String, Object> connOptions;
            block23: {
                connOptions = new HashMap<String, Object>();
                if (debug.messageEnabled()) {
                    debug.message("LDAPv3Repo: initConnectionPool ");
                }
                if (this.ldapServerName == null) {
                    this.getLDAPServerName(configParams);
                }
                authid = this.getPropertyStringValue(configParams, LDAPv3Config_AUTHID);
                authpw = this.getPropertyStringValue(configParams, LDAPv3Config_AUTHPW);
                referrals = this.getPropertyStringValue(configParams, LDAPv3Config_REFERRALS);
                String ssl = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_SSL_ENABLED);
                minPoolSize = this.getPropertyIntValue(configParams, LDAPv3Config_LDAP_CONNECTION_POOL_MIN_SIZE, 1);
                maxPoolSize = this.getPropertyIntValue(configParams, LDAPv3Config_LDAP_CONNECTION_POOL_MAX_SIZE, 10);
                if (minPoolSize < 1) {
                    minPoolSize = 1;
                }
                if (maxPoolSize < 1) {
                    maxPoolSize = 10;
                }
                ldc = null;
                try {
                    if (ssl != null && ssl.equalsIgnoreCase("true")) {
                        ldc = new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null));
                        this.sslMode = true;
                    } else {
                        ldc = new LDAPConnection();
                        this.sslMode = false;
                    }
                }
                catch (Exception e) {
                    if (debug.messageEnabled()) {
                        debug.message("LDAPv3Repo: initConnectionPool LDAPConnection failed", (Throwable)e);
                    }
                    this.connPool = null;
                }
                try {
                    ldc.setOption(17, (Object)new Integer(3));
                    ldc.setOption(8, (Object)Boolean.valueOf(referrals));
                    ldc.setOption(4, (Object)new Integer(this.timeLimit));
                    ldc.setOption(3, (Object)new Integer(this.defaultMaxResults));
                    this.setDefaultReferralCredentials(ldc);
                    LDAPSearchConstraints constraints = ldc.getSearchConstraints();
                    constraints.setMaxResults(this.defaultMaxResults);
                    constraints.setServerTimeLimit(this.timeLimit);
                    ldc.setSearchConstraints(constraints);
                    connOptions.put("searchconstraints", constraints);
                    if (this.cacheEnabled) {
                        this.ldapCache = new LDAPCache(this.cacheTTL, this.cacheSize);
                        ldc.setCache(this.ldapCache);
                        if (debug.messageEnabled()) {
                            debug.message("LDAPv3Repo: cacheTTL=" + this.cacheTTL + "; cacheSize=" + this.cacheSize);
                        }
                    }
                }
                catch (LDAPException lde) {
                    resultCode = lde.getLDAPResultCode();
                    if (!debug.messageEnabled()) break block23;
                    debug.message("LDAPv3Repo: initConnectionPool setOption failed: " + resultCode);
                }
            }
            try {
                int tosec = this.timeLimit / 1000;
                if (tosec > 0) {
                    ldc.setConnectTimeout(this.timeLimit / 1000);
                } else {
                    ldc.setConnectTimeout(3);
                }
                ldc.connect(this.ldapServerName, this.ldapPort, authid, authpw);
                connOptions.put("referrals", new Boolean(referrals));
                ShutdownManager shutdownMan = ShutdownManager.getInstance();
                if (!shutdownMan.acquireValidLock()) break block24;
                try {
                    this.connPool = new LDAPConnectionPool("LDAPv3Repo", minPoolSize, maxPoolSize, this.ldapServerName, this.ldapPort, ldc.getAuthenticationDN(), ldc.getAuthenticationPassword(), ldc, connOptions);
                    shutdownMan.addShutdownListener(new ShutdownListener(){

                        public void shutdown() {
                            LDAPv3Repo.this.hasShutdown = true;
                            if (LDAPv3Repo.this.connPool != null) {
                                LDAPv3Repo.this.connPool.destroy();
                            }
                        }
                    });
                }
                finally {
                    shutdownMan.releaseLockAndNotify();
                }
            }
            catch (LDAPException lde) {
                resultCode = lde.getLDAPResultCode();
                this.ldapConnError = Integer.toString(resultCode);
                debug.error("LDAPv3Repo: initConnectionPool ConnectionPool failed: " + resultCode + "; ldapServerName:" + this.ldapServerName);
                this.connPool = null;
                try {
                    ldc.disconnect();
                }
                catch (LDAPException lde1) {
                    debug.message("LDAPv3Repo: ldc.disconnect exception. " + lde1.getLDAPResultCode());
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: exit initConnectionPool ");
        }
    }

    protected void setDefaultReferralCredentials(LDAPConnection conn) {
        final LDAPConnection mConn = conn;
        LDAPRebind reBind = new LDAPRebind(){

            public LDAPRebindAuth getRebindAuthentication(String host, int port) {
                return new LDAPRebindAuth(mConn.getAuthenticationDN(), mConn.getAuthenticationPassword());
            }
        };
        LDAPSearchConstraints cons = conn.getSearchConstraints();
        cons.setRebindProc(reBind);
        conn.setSearchConstraints(cons);
    }

    public void initialize(Map configParams) {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: Initializing configuration()");
        }
        super.initialize(configParams);
        this.myConfigMap = configParams;
        String myServiceStr = this.getPropertyStringValue(configParams, "sun-idrepo-ldapv3-config-service-attributes");
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: initialize: myServiceStr: " + myServiceStr);
        }
        this.myServiceMap = myServiceStr != null && myServiceStr.length() != 0 ? new HashMap(mySoapClient.decodeMap(myServiceStr)) : new HashMap();
        if (debug.messageEnabled()) {
            if (this.myServiceMap != null) {
                debug.message("LDAPv3Repo: initialize: myServiceMap: " + this.myServiceMap);
            } else {
                debug.message("LDAPv3Repo: initialize: myServiceMap = null");
            }
        }
        this.setDSType(configParams);
        this.orgDN = this.getPropertyStringValue(configParams, LDAPv3Config_ORGANIZATION_NAME);
        this.timeLimit = this.getPropertyIntValue(configParams, LDAPv3Config_LDAP_TIME_LIMIT, this.timeLimit) * 1000;
        this.defaultMaxResults = this.getPropertyIntValue(configParams, LDAPv3Config_LDAP_MAX_RESULT, this.defaultMaxResults);
        this.cacheEnabled = this.getPropertyBooleanValue(configParams, LDAPv3Config_LDAP_CACHEENABLED);
        this.cacheTTL = this.getPropertyIntValue(configParams, LDAPv3Config_LDAP_CACHETTL, 600);
        this.cacheSize = this.getPropertyIntValue(configParams, LDAPv3Config_LDAP_CACHESIZE, 10240);
        String scope = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_ROLES_SEARCH_SCOPE);
        this.roleSearchScope = scope != null && scope.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (scope != null && scope.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        String searchScopeStr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_SEARCH_SCOPE, LDAP_SCOPE_SUB);
        this.searchScope = searchScopeStr.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (searchScopeStr.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.roleSearchScope = this.searchScope;
        this.userSearchFilter = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_USERS_SEARCH_FILTER);
        this.groupSearchFilter = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_GROUP_SEARCH_FILTER);
        this.roleSearchFilter = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_ROLES_SEARCH_FILTER, this.roleSearchFilter);
        this.filterroleSearchFilter = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_FILTERROLES_SEARCH_FILTER, this.filterroleSearchFilter);
        this.agentSearchFilter = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_AGENT_SEARCH_FILTER);
        this.userSearchNamingAttr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_USERS_SEARCH_ATTRIBUTE);
        this.agentSearchNamingAttr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_AGENT_SEARCH_ATTRIBUTE);
        this.groupSearchNamingAttr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_GROUPS_SEARCH_ATTRIBUTE);
        this.roleSearchNamingAttr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_ROLES_SEARCH_ATTRIBUTE);
        this.filterroleSearchNamingAttr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_FILTERROLES_SEARCH_ATTRIBUTE, "cn");
        this.peopleCtnrNamingAttr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_PEOPLE_CONTAINER_NAME);
        this.agentCtnrNamingAttr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_AGENT_CONTAINER_NAME);
        this.groupCtnrNamingAttr = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_GROUP_CONTAINER_NAME);
        this.peopleCtnrValue = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_PEOPLE_CONTAINER_VALUE);
        this.agentCtnrValue = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_AGENT_CONTAINER_VALUE);
        this.groupCtnrValue = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_GROUP_CONTAINER_VALUE);
        Set tmpOC = (Set)configParams.get(LDAPv3Config_ROLE_OBJECT_CLASS);
        this.roleObjClassSet = tmpOC == null ? Collections.EMPTY_SET : new HashSet(tmpOC);
        tmpOC = (Set)configParams.get(LDAPv3Config_FILTERROLE_OBJECT_CLASS);
        this.filterroleObjClassSet = tmpOC == null ? Collections.EMPTY_SET : new HashSet(tmpOC);
        tmpOC = (Set)configParams.get(LDAPv3Config_GROUP_OBJECT_CLASS);
        this.groupObjClassSet = tmpOC == null ? Collections.EMPTY_SET : new HashSet(tmpOC);
        tmpOC = (Set)configParams.get(LDAPv3Config_USER_OBJECT_CLASS);
        this.userObjClassSet = tmpOC == null ? Collections.EMPTY_SET : new HashSet(tmpOC);
        tmpOC = (Set)configParams.get(LDAPv3Config_AGENT_OBJECT_CLASS);
        this.agentObjClassSet = tmpOC == null ? Collections.EMPTY_SET : new HashSet(tmpOC);
        this.nsRoleAttr = this.getPropertyStringValue(configParams, LDAPv3Config_NSROLE, "nsrole");
        this.nsRoleDNAttr = this.getPropertyStringValue(configParams, LDAPv3Config_NSROLEDN, "nsRoleDN");
        this.nsRoleFilterAttr = this.getPropertyStringValue(configParams, LDAPv3Config_NSROLEFILTER, "nsRoleFilter");
        this.memberOfAttr = this.getPropertyStringValue(configParams, LDAPv3Config_MEMBEROF);
        this.uniqueMemberAttr = this.getPropertyStringValue(configParams, LDAPv3Config_UNIQUEMEMBER);
        this.defaultGrpMem = this.getPropertyStringValue(configParams, LDAPv3Config_DEFAULTGROUPMEMBER);
        this.memberURLAttr = this.getPropertyStringValue(configParams, LDAPv3Config_MEMBERURL);
        this.userAtttributesAllowed = new CaseInsensitiveHashSet();
        Set allowAttr = (Set)configParams.get(LDAPv3Config_USER_ATTR);
        if (allowAttr != null) {
            this.userAtttributesAllowed.addAll(allowAttr);
        }
        this.groupAtttributesAllowed = new CaseInsensitiveHashSet();
        allowAttr = (Set)configParams.get(LDAPv3Config_GROUP_ATTR);
        if (allowAttr != null) {
            this.groupAtttributesAllowed.addAll(allowAttr);
        }
        this.agentAtttributesAllowed = new CaseInsensitiveHashSet();
        allowAttr = (Set)configParams.get(LDAPv3Config_AGENT_ATTR);
        if (allowAttr != null) {
            this.agentAtttributesAllowed.addAll(allowAttr);
        }
        this.roleAtttributesAllowed = new CaseInsensitiveHashSet();
        allowAttr = (Set)configParams.get(LDAPv3Config_ROLE_ATTR);
        if (allowAttr != null) {
            this.roleAtttributesAllowed.addAll(allowAttr);
        }
        this.filteredroleAtttributesAllowed = new CaseInsensitiveHashSet();
        allowAttr = (Set)configParams.get(LDAPv3Config_FILTERROLE_ATTR);
        if (allowAttr != null) {
            this.filteredroleAtttributesAllowed.addAll(allowAttr);
        }
        this.userSpecifiedOpsSet = new HashSet((Set)configParams.get("sunIdRepoSupportedOperations"));
        this.parsedUserSpecifiedOps(this.userSpecifiedOpsSet);
        this.isActiveAttrName = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_ISACTIVEATTRNAME);
        if (this.isActiveAttrName == null || this.isActiveAttrName.length() == 0) {
            this.alwaysActive = true;
            this.isActiveAttrName = defaultStatusAttribute;
        }
        this.inetUserActive = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_INETUSERACTIVE, statusActive);
        this.inetUserInactive = this.getPropertyStringValue(configParams, LDAPv3Config_LDAP_INETUSERINACTIVE, statusInactive);
        this.createUserAttrMap = this.getCreateUserAttrMapping(configParams);
        this.authenticatableSet = new CaseInsensitiveHashSet();
        Set tmpAuthSet = (Set)configParams.get(LDAPv3Config_LDAP_AUTHENTICATABLE);
        if (tmpAuthSet != null) {
            this.authenticatableSet.addAll(tmpAuthSet);
        }
        this.initConnectionPool(configParams);
        if (debug.messageEnabled()) {
            debug.message("    userObjClassSet: " + this.userObjClassSet);
            debug.message("    agentObjClassSet: " + this.agentObjClassSet);
            debug.message("    groupObjClassSet:" + this.groupObjClassSet);
            debug.message("    roleObjClassSet:" + this.roleObjClassSet);
            debug.message("    filterroleObjClassSet: " + this.filterroleObjClassSet);
            debug.message("    userAtttributesAllowed: " + this.userAtttributesAllowed);
            debug.message("    groupAtttributesAllowed: " + this.groupAtttributesAllowed);
            debug.message("    agentAtttributesAllowed: " + this.agentAtttributesAllowed);
            debug.message("    roleAtttributesAllowed: " + this.roleAtttributesAllowed);
            debug.message("    filteredroleAtttributesAllowed: " + this.filteredroleAtttributesAllowed);
            debug.message("LDAPv3Repo: exit Initializing. timeLimit =" + this.timeLimit + "; maxResults =" + this.defaultMaxResults + "; roleSearchScope=" + this.roleSearchScope + "; orgDN=" + this.orgDN + "; createUserAttrMap=" + this.createUserAttrMap);
        }
    }

    public void shutdown() {
        debug.message("LDAPv3Repo: shutdown");
        this.hasShutdown = true;
        super.shutdown();
        if (this.connPool != null) {
            this.connPool.destroy();
        }
        this.removeListener();
    }

    public Set getSupportedOperations(IdType type) {
        return (Set)this.supportedOps.get(type);
    }

    public Set getSupportedTypes() {
        return this.supportedOps.keySet();
    }

    public boolean isActive(SSOToken token, IdType type, String name) throws IdRepoUnsupportedOpException, SSOException {
        Set attrSet;
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: isActive called: type:" + type + "; name:" + name);
        }
        if (!type.equals(IdType.USER) && !type.equals(IdType.AGENT)) {
            Object[] args = new Object[]{CLASS_NAME, IdOperation.READ.getName(), type.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        if (this.alwaysActive) {
            try {
                boolean found = this.isExists(token, type, name);
                return found;
            }
            catch (IdRepoException ide) {
                return false;
            }
        }
        String tmpActiveAttrName = null;
        String tmpInactiveAttrVal = null;
        if (type.equals(IdType.USER)) {
            tmpActiveAttrName = this.isActiveAttrName;
            tmpInactiveAttrVal = this.inetUserInactive;
        } else {
            tmpActiveAttrName = sunIdentityServerDeviceStatus;
            tmpInactiveAttrVal = statusInactive;
        }
        Map attrMap = null;
        HashSet<String> attrNameSet = new HashSet<String>();
        attrNameSet.add(tmpActiveAttrName);
        try {
            attrMap = this.getAttributes(token, type, name, attrNameSet);
            attrMap = new CaseInsensitiveHashMap(attrMap);
        }
        catch (IdRepoException idrepoerr) {
            if (debug.messageEnabled()) {
                debug.message("  LDAPv3Repo: isActive idrepoerr=" + idrepoerr);
            }
            return false;
        }
        if (debug.messageEnabled()) {
            debug.message("  LDAPv3Repo: isActive attrMap=" + attrMap);
        }
        if ((attrSet = (Set)attrMap.get(tmpActiveAttrName)) != null && attrSet.size() == 1) {
            if (this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD) && type.equals(IdType.USER)) {
                int attrValue = Integer.parseInt((String)attrSet.iterator().next());
                boolean disable = (attrValue & 2) != 0;
                return !disable;
            }
            String attrValue = (String)attrSet.iterator().next();
            return !attrValue.equalsIgnoreCase(tmpInactiveAttrVal);
        }
        return true;
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, boolean active) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: setActiveStatus. name=" + name + "; type=" + type + "; active=" + active);
        }
        if (!type.equals(IdType.USER) && !type.equals(IdType.AGENT)) {
            debug.error("LDAPv3Repo: setActiveStatus for identities other than Users and Agent are not allowed ");
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        String tmpActiveAttrName = null;
        String tmpActiveAttrVal = null;
        String tmpInactiveAttrVal = null;
        if (type.equals(IdType.USER)) {
            tmpActiveAttrName = this.isActiveAttrName;
            tmpActiveAttrVal = this.inetUserActive;
            tmpInactiveAttrVal = this.inetUserInactive;
        } else {
            tmpActiveAttrName = sunIdentityServerDeviceStatus;
            tmpActiveAttrVal = statusActive;
            tmpInactiveAttrVal = statusInactive;
        }
        HashMap attrs = new HashMap();
        HashSet<String> vals = new HashSet<String>();
        if (this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD) && type.equals(IdType.USER)) {
            HashSet<String> attrNameSet = new HashSet<String>();
            attrNameSet.add(tmpActiveAttrName);
            Map attrMap = this.getAttributes(token, type, name, attrNameSet);
            attrMap = new CaseInsensitiveHashMap(attrMap);
            Set attrSet = (Set)attrMap.get(tmpActiveAttrName);
            int userAccountControl = Integer.parseInt((String)attrSet.iterator().next());
            userAccountControl = active ? (userAccountControl &= 0xFFFFFFFD) : (userAccountControl |= 2);
            vals.add(Integer.toString(userAccountControl));
        } else if (active) {
            vals.add(tmpActiveAttrVal);
        } else {
            vals.add(tmpInactiveAttrVal);
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: setActiveStatus value=" + vals);
        }
        attrs.put(tmpActiveAttrName, vals);
        this.setAttributes(token, type, name, attrs, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExists(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        String dn;
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: isExists called " + type + ": " + name);
        }
        this.checkConnPool();
        LDAPEntry foundEntry = null;
        try {
            dn = this.getDN(type, name);
        }
        catch (IdRepoUnsupportedOpException ide) {
            return false;
        }
        catch (IdRepoException idrepoerr) {
            return false;
        }
        LDAPConnection ld = null;
        int resultCode = 0;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            foundEntry = ld.read(dn);
        }
        catch (LDAPException e) {
            switch (e.getLDAPResultCode()) {
                case 32: {
                    if (!debug.messageEnabled()) break;
                    debug.message("LDAPv3Repo: isExists: The specified entry does not exist.");
                    break;
                }
                case 9: {
                    if (!debug.messageEnabled()) break;
                    debug.message("LDAPv3Repo: isExists: Entry served by a different LDAP server.");
                    break;
                }
                case 50: {
                    if (!debug.messageEnabled()) break;
                    debug.message("LDAPv3Repo: isExists: You do not have the access rights to perform this operation.");
                    break;
                }
                default: {
                    if (!debug.messageEnabled()) break;
                    debug.message("LDAPv3Repo: isExists: Error number: " + e.getLDAPResultCode());
                    debug.message("LDAPv3Repo: isExists: Could not read the specified entry.");
                }
            }
            if ((resultCode = e.getLDAPResultCode()) == 80 || resultCode == 81 || resultCode == 82) {
                String ldapError = Integer.toString(resultCode);
                Object[] args = new Object[]{CLASS_NAME, LDAPv3Bundle.getString(ldapError)};
                IdRepoFatalException ide = new IdRepoFatalException("amIdRepo", "311", args);
                ide.setLDAPErrorCode(ldapError);
                throw ide;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isExists(IdType type, String dn) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: isExists called " + type + ": " + dn);
        }
        this.checkConnPool();
        LDAPEntry foundEntry = null;
        LDAPConnection ld = null;
        int resultCode = 0;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            foundEntry = ld.read(dn);
        }
        catch (LDAPException e) {
            switch (e.getLDAPResultCode()) {
                case 32: {
                    if (!debug.messageEnabled()) break;
                    debug.message("LDAPv3Repo: isExists: The specified entry does not exist.");
                    break;
                }
                case 9: {
                    if (!debug.messageEnabled()) break;
                    debug.message("LDAPv3Repo: isExists: Entry served by a different LDAP server.");
                    break;
                }
                case 50: {
                    if (!debug.messageEnabled()) break;
                    debug.message("LDAPv3Repo: isExists: You do not have the access rights to perform this operation.");
                    break;
                }
                default: {
                    if (!debug.messageEnabled()) break;
                    debug.message("LDAPv3Repo: isExists: Error number: " + e.getLDAPResultCode());
                    debug.message("LDAPv3Repo: isExists: Could not read the specified entry.");
                }
            }
            if ((resultCode = e.getLDAPResultCode()) == 80 || resultCode == 81 || resultCode == 82) {
                String ldapError = Integer.toString(resultCode);
                Object[] args = new Object[]{CLASS_NAME, LDAPv3Bundle.getString(ldapError)};
                IdRepoFatalException ide = new IdRepoFatalException("amIdRepo", "311", args);
                ide.setLDAPErrorCode(ldapError);
                throw ide;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener() {
        LDAPv3EventService eventService;
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: removeListener called ");
        }
        HashSet<String> tobeRemoveListener = new HashSet<String>();
        if (this.ldapServerName == null) {
            this.getLDAPServerName(this.myConfigMap);
        }
        if (this.ldapServerName == null) {
            debug.error("LDAPv3Repo: removeListener failed. missing ldap server name.");
        }
        Map map = listOfPS;
        synchronized (map) {
            eventService = (LDAPv3EventService)_eventsMgr.get(this.ldapServerName);
            if (eventService != null) {
                if (this.hasListener) {
                    String psIdKey = this.getPSKey(this.myConfigMap);
                    Map listOfRepo = (Map)listOfPS.get(psIdKey);
                    if (listOfRepo != null) {
                        HashSet listOfDS = (HashSet)listOfRepo.get("listOfDS");
                        listOfDS.remove(this);
                        if (listOfDS.isEmpty()) {
                            listOfPS.remove(psIdKey);
                            tobeRemoveListener.add(psIdKey);
                            Integer requestNum = (Integer)_numRequest.get(this.ldapServerName);
                            if (requestNum != null) {
                                int requestInt = requestNum;
                                if (requestInt <= 1) {
                                    _eventsMgr.remove(this.ldapServerName);
                                    eventService.finalize();
                                    _numRequest.remove(this.ldapServerName);
                                } else {
                                    _numRequest.remove(this.ldapServerName);
                                    _numRequest.put(this.ldapServerName, new Integer(requestInt - 1));
                                }
                                if (debug.messageEnabled()) {
                                    debug.message("LDAPv3Repo: removeListener. requestInt=" + requestInt);
                                }
                            }
                        }
                    }
                } else {
                    Integer requestNum = (Integer)_numRequest.get(this.ldapServerName);
                    if (requestNum == null) {
                        _eventsMgr.remove(this.ldapServerName);
                    }
                }
            }
        }
        for (String psIdKeyToRemove : tobeRemoveListener) {
            eventService.removeListener(psIdKeyToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addListener(SSOToken token, IdRepoListener listener) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: addListener called  LDAPv3Config_LDAP_SERVER=" + this.configMap.get(LDAPv3Config_LDAP_SERVER) + "; LDAPv3Config_LDAP_PSEARCHBASE=" + this.configMap.get(LDAPv3Config_LDAP_PSEARCHBASE) + "; LDAPv3Config_LDAP_PSEARCHFILTER=" + this.configMap.get(LDAPv3Config_LDAP_PSEARCHFILTER) + "; LDAPv3Config_LDAP_IDLETIMEOUT=" + this.configMap.get(LDAPv3Config_LDAP_IDLETIMEOUT));
        }
        if (this.connPool == null) {
            debug.error("LDAPv3Repo: addListener failed. Incorrect ldap server configuration." + this.configMap.get(LDAPv3Config_LDAP_SERVER));
            return 0;
        }
        Map map = listOfPS;
        synchronized (map) {
            String psIdKey;
            HashMap<String, Object> listOfRepo;
            this.checkConnPool();
            this.myListener = listener;
            if (!SystemProperties.isServerMode()) {
                return 0;
            }
            if (this.ldapServerName == null) {
                this.getLDAPServerName(this.myConfigMap);
            }
            if (this.ldapServerName == null) {
                debug.error("LDAPv3Repo: addListener failed. missing ldap server name.");
                return 0;
            }
            String searchBase = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_LDAP_PSEARCHBASE);
            if (searchBase == null) {
                debug.error("LDAPv3Repo: addListener failed. missing persistence search base. Not starting persistent search.");
                return 0;
            }
            LDAPv3EventService eventService = (LDAPv3EventService)_eventsMgr.get(this.ldapServerName);
            if (eventService == null) {
                int idleTimeOut = this.getPropertyIntValue(this.myConfigMap, LDAPv3Config_LDAP_IDLETIMEOUT, 0);
                try {
                    if (debug.messageEnabled()) {
                        debug.message("LDAPv3Repo.addListener: eventService is null. idleTimeOut=" + idleTimeOut);
                    }
                    eventService = idleTimeOut == 0 ? new LDAPv3EventService(this.myConfigMap, this.ldapServerName) : new LDAPv3EventServicePolling(this.myConfigMap, this.ldapServerName);
                    _eventsMgr.put(this.ldapServerName, eventService);
                }
                catch (LDAPException le) {
                    debug.error("LDAPv3Repo: addListener failed. new eventService failed. LDAPException=", (Throwable)le);
                    String ldapError = Integer.toString(le.getLDAPResultCode());
                    Object[] args = new Object[]{CLASS_NAME};
                    IdRepoException ide = new IdRepoException("amIdRepo", "218", args);
                    ide.setLDAPErrorCode(ldapError);
                    throw ide;
                }
            }
            if ((listOfRepo = (HashMap<String, Object>)listOfPS.get(psIdKey = this.getPSKey(this.myConfigMap))) == null) {
                String filter = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_LDAP_PSEARCHFILTER, "(objectclass=*)");
                String psearchScopeStr = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_LDAP_PSEARCHSCOPE, LDAP_SCOPE_SUB);
                int psearchScope = 2;
                psearchScope = psearchScopeStr.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (psearchScopeStr.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
                try {
                    eventService.addListener(token, listener, searchBase, psearchScope, filter, 15, this.myConfigMap, this, this.ldapServerName, psIdKey);
                    Integer numRequest = (Integer)_numRequest.get(this.ldapServerName);
                    int requestNum = numRequest == null ? 1 : numRequest + 1;
                    _numRequest.put(this.ldapServerName, new Integer(requestNum));
                }
                catch (IdRepoException idrepoex) {
                    debug.error("LDAPv3Repo: addListener failed. persistant search not supported");
                }
                catch (LDAPException ldapex) {
                    debug.error("LDAPv3Repo: addListener failed. eventService.addListener.LDAPException", (Throwable)ldapex);
                    Object[] args = new Object[]{CLASS_NAME};
                    IdRepoException ide = new IdRepoException("amIdRepo", "218", args);
                    ide.setLDAPErrorCode(Integer.toString(ldapex.getLDAPResultCode()));
                    throw ide;
                }
                HashSet<LDAPv3Repo> listOfDS = new HashSet<LDAPv3Repo>();
                listOfDS.add(this);
                listOfRepo = new HashMap<String, Object>();
                listOfRepo.put("eventServices", eventService);
                listOfRepo.put("listOfDS", listOfDS);
                listOfPS.put(psIdKey, listOfRepo);
            } else {
                HashSet listOfDS = (HashSet)listOfRepo.get("listOfDS");
                listOfDS.add(this);
            }
            this.hasListener = true;
            return 0;
        }
    }

    private Map getAllowedAttrs(IdType type, Map attrMap) {
        Set predefinedAttr = Collections.EMPTY_SET;
        if (type.equals(IdType.USER)) {
            predefinedAttr = this.userAtttributesAllowed;
        } else if (type.equals(IdType.AGENT)) {
            predefinedAttr = this.agentAtttributesAllowed;
        } else if (type.equals(IdType.GROUP)) {
            predefinedAttr = this.groupAtttributesAllowed;
        } else if (type.equals(IdType.ROLE)) {
            predefinedAttr = this.roleAtttributesAllowed;
        } else if (type.equals(IdType.FILTEREDROLE)) {
            predefinedAttr = this.filteredroleAtttributesAllowed;
        }
        CaseInsensitiveHashMap allowedAttr = new CaseInsensitiveHashMap();
        for (String attrName : predefinedAttr) {
            Set attrNameValue = (Set)attrMap.get(attrName);
            if (attrNameValue == null) continue;
            allowedAttr.put(attrName, attrNameValue);
        }
        return allowedAttr;
    }

    private Map doUserStatusMapping(IdType type, String name, Map attrMap) {
        if (!type.equals(IdType.USER) && !type.equals(IdType.AGENT)) {
            return attrMap;
        }
        HashSet<String> newAttrValue = new HashSet<String>();
        if (attrMap.containsKey(this.isActiveAttrName)) {
            Set previousVal = (Set)attrMap.get(this.isActiveAttrName);
            String previousStatus = previousVal.iterator().hasNext() ? (String)previousVal.iterator().next() : null;
            attrMap.remove(this.isActiveAttrName);
            if (previousStatus != null && previousStatus.equalsIgnoreCase(statusInactive)) {
                newAttrValue.add(this.inetUserInactive);
            } else {
                newAttrValue.add(this.inetUserActive);
            }
            attrMap.put(this.isActiveAttrName, newAttrValue);
        } else {
            newAttrValue.add(this.inetUserActive);
            attrMap.put(this.isActiveAttrName, newAttrValue);
        }
        return attrMap;
    }

    private Map addAttrMapping(IdType type, String name, Map attrMap) {
        String rdn;
        Set rdnValue;
        if (debug.messageEnabled()) {
            debug.message("enter addAttrMapping: createUserAttrMap=" + this.createUserAttrMap + ", attrMap = " + IdRepoUtils.getAttrMapWithoutPasswordAttrs(attrMap, null));
        }
        if (type.equals(IdType.USER) || type.equals(IdType.AGENT)) {
            for (String attrName : this.createUserAttrMap.keySet()) {
                Set<String> mapAttrValue;
                if (attrMap.containsKey(attrName)) continue;
                String mapAttrName = (String)this.createUserAttrMap.get(attrName);
                if (mapAttrName.equalsIgnoreCase(attrName)) {
                    mapAttrValue = new HashSet<String>();
                    mapAttrValue.add(name);
                    attrMap.put(attrName, mapAttrValue);
                    continue;
                }
                mapAttrValue = (Set)attrMap.get(mapAttrName);
                if (mapAttrValue == null) continue;
                attrMap.put(attrName, mapAttrValue);
            }
        }
        if (type.equals(IdType.GROUP) && ((rdnValue = (Set)attrMap.get(rdn = this.getNamingAttr(type))) == null || rdnValue.isEmpty())) {
            HashSet<String> cnAttrValue = new HashSet<String>();
            cnAttrValue.add(name);
            attrMap.put(rdn, cnAttrValue);
        }
        if (debug.messageEnabled()) {
            debug.message("exit addAttrMapping: attrMap = " + IdRepoUtils.getAttrMapWithoutPasswordAttrs(attrMap, null));
        }
        return attrMap;
    }

    private Set convertInetStatus(Set attrValueSet, String attrName) {
        if (debug.messageEnabled()) {
            debug.message("convertInetStatus: attrName=" + attrName + ";  attrValueSet=" + attrValueSet);
        }
        HashSet<String> newAttrVal = new HashSet<String>();
        if (this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD)) {
            int attrValue = Integer.parseInt((String)attrValueSet.iterator().next());
            if ((attrValue & 2) != 0) {
                newAttrVal.add(statusInactive);
            } else {
                newAttrVal.add(statusActive);
            }
        } else {
            String value = (String)attrValueSet.iterator().next();
            if (value.equalsIgnoreCase(this.inetUserInactive)) {
                newAttrVal.add(statusInactive);
            } else {
                newAttrVal.add(statusActive);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("convertInetStatus: newAttrVal=" + newAttrVal);
        }
        return newAttrVal;
    }

    private byte[][] convertInetStatus(LDAPAttribute ldapAttr) {
        if (debug.messageEnabled()) {
            debug.message("convertInetStatus: attrName: " + ldapAttr.getName() + "; values=" + ldapAttr.getStringValues());
        }
        byte[][] newAttrVal = new byte[1][];
        if (this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD)) {
            HashSet<String> attrValueSet = new HashSet<String>();
            Enumeration enumVals = ldapAttr.getStringValues();
            while (enumVals != null && enumVals.hasMoreElements()) {
                String value = (String)enumVals.nextElement();
                attrValueSet.add(value);
            }
            int attrValue = Integer.parseInt((String)attrValueSet.iterator().next());
            newAttrVal[0] = (attrValue & 2) != 0 ? statusInactive.getBytes() : statusActive.getBytes();
        } else {
            String value = (String)ldapAttr.getStringValues().nextElement();
            newAttrVal[0] = value.equalsIgnoreCase(this.inetUserInactive) ? statusInactive.getBytes() : statusActive.getBytes();
        }
        if (debug.messageEnabled()) {
            debug.message("convertInetStatus exit: newAttrVal: " + newAttrVal);
        }
        return newAttrVal;
    }

    private void appendInetUser(SSOToken token, IdType type, String name, Map attributes, boolean isString) throws IdRepoException, SSOException {
        if (attributes.containsKey(defaultStatusAttribute) && !attributes.containsKey(this.isActiveAttrName)) {
            Set attrSet;
            if (this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD)) {
                HashSet<String> attrNameSet = new HashSet<String>();
                attrNameSet.add(this.isActiveAttrName);
                Map attrRead = this.getAttributes(token, type, name, attrNameSet);
                attrRead = new CaseInsensitiveHashMap(attrRead);
                Set userAcctSet = (Set)attrRead.get(this.isActiveAttrName);
                int userAccountControl = Integer.parseInt((String)userAcctSet.iterator().next());
                String userStatus = null;
                if (isString) {
                    Set attrSet2 = (Set)attributes.get(defaultStatusAttribute);
                    userStatus = (String)attrSet2.iterator().next();
                } else {
                    byte[][] attrBytes = (byte[][])attributes.get(defaultStatusAttribute);
                    userStatus = new String(attrBytes[0]);
                }
                userAccountControl = userStatus.equalsIgnoreCase(statusInactive) ? (userAccountControl |= 2) : (userAccountControl &= 0xFFFFFFFD);
                attributes.remove(defaultStatusAttribute);
                if (isString) {
                    HashSet<String> usrCtrlSet = new HashSet<String>();
                    usrCtrlSet.add(Integer.toString(userAccountControl));
                    attributes.put(this.isActiveAttrName, usrCtrlSet);
                } else {
                    byte[][] usrCtlBin = new byte[][]{Integer.toString(userAccountControl).getBytes()};
                    attributes.put(this.isActiveAttrName, usrCtlBin);
                }
            } else if (this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3ADAM) && (attrSet = (Set)attributes.get(defaultStatusAttribute)) != null && !attrSet.isEmpty()) {
                String userStatus = (String)attrSet.iterator().next();
                String attrValue = userStatus.equalsIgnoreCase(statusInactive) ? this.inetUserInactive : this.inetUserActive;
                attributes.remove(defaultStatusAttribute);
                HashSet<String> attrValues = new HashSet<String>();
                attrValues.add(attrValue);
                attributes.put(this.isActiveAttrName, attrValues);
            }
        }
    }

    private byte[] encodeADPwd(String passwd) {
        byte[] encodedPwd;
        block2: {
            encodedPwd = null;
            try {
                encodedPwd = ("\"" + passwd + "\"").getBytes("UTF-16LE");
            }
            catch (UnsupportedEncodingException uex) {
                if (!debug.warningEnabled()) break block2;
                debug.warning("LDAPv3Repo.encodeADPwd:", (Throwable)uex);
            }
        }
        return encodedPwd;
    }

    private byte[] doPasswordEncode(IdType type, String name, Map attrMap, String attrName) {
        Set previousVal;
        if (type.equals(IdType.USER) && (this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD) || this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3ADAM)) && (previousVal = (Set)attrMap.remove(attrName)) != null && !previousVal.isEmpty()) {
            HashSet newAttrValue = new HashSet();
            String previousPass = (String)previousVal.iterator().next();
            if (previousPass != null) {
                return this.encodeADPwd(previousPass);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String create(SSOToken token, IdType type, String name, Map attrMap) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: Create called on " + type + ": " + name + " attrMap = " + IdRepoUtils.getAttrMapWithoutPasswordAttrs(attrMap, null));
        }
        this.checkConnPool();
        if (name.startsWith("#")) {
            name = "\\" + name;
        }
        String eDN = this.getDN(type, name);
        LDAPConnection ld = null;
        int resultCode = 0;
        byte[] encodedPwd = null;
        Map origAttrMap = null;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            Set theOC = null;
            if (type.equals(IdType.USER)) {
                theOC = this.userObjClassSet;
            } else if (type.equals(IdType.AGENT)) {
                theOC = this.agentObjClassSet;
            } else if (type.equals(IdType.GROUP)) {
                theOC = this.groupObjClassSet;
            } else if (type.equals(IdType.ROLE)) {
                theOC = this.roleObjClassSet;
            } else if (type.equals(IdType.FILTEREDROLE)) {
                theOC = this.filterroleObjClassSet;
            } else {
                Object[] args = new Object[]{CLASS_NAME, IdOperation.CREATE.getName(), type.getName()};
                throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
            }
            origAttrMap = attrMap;
            attrMap = new CaseInsensitiveHashMap(attrMap);
            encodedPwd = this.doPasswordEncode(type, name, attrMap, unicodePwd);
            attrMap = this.doUserStatusMapping(type, name, attrMap);
            attrMap = this.addAttrMapping(type, name, attrMap);
            attrMap = this.getAllowedAttrs(type, attrMap);
            LDAPAttributeSet ldapAttrSet = new LDAPAttributeSet();
            if (attrMap != null && !attrMap.isEmpty()) {
                boolean addedOC = false;
                HashMap<String, Set> privAttrMap = new HashMap<String, Set>();
                for (String attrName : attrMap.keySet()) {
                    Set attrNameValue;
                    if (attrName.equalsIgnoreCase(LDAP_OBJECT_CLASS)) {
                        attrNameValue = (Set)attrMap.get(attrName);
                        HashSet newNameValue = new HashSet(attrNameValue);
                        newNameValue.addAll(theOC);
                        privAttrMap.put(attrName, newNameValue);
                        addedOC = true;
                        continue;
                    }
                    attrNameValue = (Set)attrMap.get(attrName);
                    if (attrNameValue == null || attrNameValue.isEmpty()) continue;
                    if (this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD) || this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3ADAM)) {
                        attrNameValue.remove("");
                        if (attrNameValue.isEmpty()) continue;
                    }
                    privAttrMap.put(attrName, attrNameValue);
                }
                if (!addedOC) {
                    privAttrMap.put(LDAP_OBJECT_CLASS, theOC);
                }
                String namingAttr = this.getNamingAttr(type);
                HashSet<String> values = new HashSet<String>();
                values.add(name);
                privAttrMap.put(namingAttr, values);
                for (String attrName : privAttrMap.keySet()) {
                    String[] attrValues;
                    Set set = (Set)privAttrMap.get(attrName);
                    String[] stringArray = attrValues = set == null ? null : set.toArray(new String[set.size()]);
                    if (attrName.equals(namingAttr)) {
                        for (int i = 0; i < attrValues.length; ++i) {
                            String s;
                            if (!attrValues[i].startsWith("#")) continue;
                            attrValues[i] = s = "\\" + attrValues[i];
                        }
                    }
                    if (debug.messageEnabled()) {
                        if (attrName.equalsIgnoreCase("userpassword")) {
                            debug.message("    : attrName= " + attrName);
                        } else {
                            debug.message("    : attrName= " + attrName + " set:" + set);
                        }
                    }
                    ldapAttrSet.add(new LDAPAttribute(attrName, attrValues));
                }
            } else {
                String[] attrValues = theOC == null ? null : theOC.toArray(new String[theOC.size()]);
                ldapAttrSet.add(new LDAPAttribute(LDAP_OBJECT_CLASS, attrValues));
            }
            if (type.equals(IdType.GROUP) && this.defaultGrpMem != null) {
                ldapAttrSet.add(new LDAPAttribute(this.uniqueMemberAttr, this.defaultGrpMem));
            }
            if (debug.messageEnabled()) {
                debug.message("    : before ld.add: eDN=" + eDN);
            }
            if (encodedPwd != null) {
                ldapAttrSet.add(new LDAPAttribute(unicodePwd, encodedPwd));
            }
            try {
                LDAPEntry theEntry = new LDAPEntry(eDN, ldapAttrSet);
                ld.add(theEntry);
            }
            catch (LDAPException lde) {
                resultCode = lde.getLDAPResultCode();
                debug.error("LDAPv3Repo.create failed. errorCode=" + lde.getLDAPResultCode() + "  " + lde.getLDAPErrorMessage());
                if (debug.messageEnabled()) {
                    debug.message("LDAPv3Repo.create failed", (Throwable)lde);
                }
                attrMap = origAttrMap;
                this.handleLDAPException(lde, eDN);
            }
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
        if (type.equals(IdType.GROUP) && this.defaultGrpMem != null && this.memberOfAttr != null) {
            this.checkConnPool();
            try {
                ld = this.connPool.getConnection();
                LDAPAttribute mbrOf = new LDAPAttribute(this.memberOfAttr, eDN);
                LDAPModification modMemberOf = new LDAPModification(0, mbrOf);
                ld.modify(this.defaultGrpMem, modMemberOf);
                if (this.cacheEnabled) {
                    this.ldapCache.flushEntries(this.defaultGrpMem, 0);
                }
            }
            catch (LDAPException lde) {
                resultCode = lde.getLDAPResultCode();
                debug.error("LDAPv3Repo.create failed mod user. errorCode=" + lde.getLDAPResultCode() + "  " + lde.getLDAPErrorMessage());
                if (debug.messageEnabled()) {
                    debug.message("LDAPv3Repo.create failed unable to mod user", (Throwable)lde);
                }
                attrMap = origAttrMap;
                this.handleLDAPException(lde, eDN);
            }
            finally {
                if (ld != null) {
                    this.connPool.close(ld, resultCode);
                }
            }
        }
        attrMap = origAttrMap;
        return eDN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: delete called on " + type + ": " + name);
        }
        this.checkConnPool();
        String eDN = this.getDN(type, name);
        LDAPConnection ld = null;
        int resultCode = 0;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            ld.delete(eDN);
        }
        catch (LDAPException lde) {
            resultCode = lde.getLDAPResultCode();
            String ldeErrMsg = lde.getLDAPErrorMessage();
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: delete, error: " + resultCode + "errmsg=" + ldeErrMsg, (Throwable)lde);
            }
            this.handleLDAPException(lde, eDN);
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getAttributes 1 called : " + type + ": " + name + " ; attrName=" + attrNames);
        }
        Map myMap = this.getAttributes(token, type, name, attrNames, true);
        return myMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAttributes(SSOToken token, IdType type, String name, Set attrNames, boolean isString) throws IdRepoException, SSOException {
        CaseInsensitiveHashSet attrNamesCase;
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getAttributes 2 called: " + type + ": " + name + " ; attrName=" + attrNames);
        }
        HashMap<String, Object> theAttrMap = new HashMap<String, Object>();
        CaseInsensitiveHashSet caseInsensitiveHashSet = attrNamesCase = attrNames == null ? new CaseInsensitiveHashSet((Collection)Collections.EMPTY_SET) : new CaseInsensitiveHashSet((Collection)attrNames);
        if (type.equals(IdType.REALM) && attrNames != null && attrNamesCase.contains(LDAP_OBJECT_CLASS)) {
            return theAttrMap;
        }
        this.checkConnPool();
        String dn = this.getDN(type, name);
        LDAPConnection ld = null;
        int resultCode = 0;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            LDAPSearchConstraints constraints = ld.getSearchConstraints();
            constraints.setMaxResults(this.defaultMaxResults);
            constraints.setServerTimeLimit(this.timeLimit);
            boolean addActiveAttrName = false;
            CaseInsensitiveHashSet predefinedAttr = null;
            if (type.equals(IdType.USER)) {
                if (!this.userAtttributesAllowed.contains("nsrole")) {
                    predefinedAttr = new CaseInsensitiveHashSet();
                    Iterator itr = this.userAtttributesAllowed.iterator();
                    while (itr.hasNext()) {
                        predefinedAttr.add(itr.next());
                    }
                    predefinedAttr.add("nsrole");
                } else {
                    predefinedAttr = this.userAtttributesAllowed;
                }
                if ((this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD) || this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3ADAM)) && attrNamesCase.contains(defaultStatusAttribute) && !attrNamesCase.contains(this.isActiveAttrName)) {
                    addActiveAttrName = true;
                    attrNamesCase.add(this.isActiveAttrName);
                }
            } else if (type.equals(IdType.AGENT)) {
                predefinedAttr = this.agentAtttributesAllowed;
            } else if (type.equals(IdType.GROUP)) {
                predefinedAttr = this.groupAtttributesAllowed;
            } else if (type.equals(IdType.ROLE)) {
                predefinedAttr = this.roleAtttributesAllowed;
            } else if (type.equals(IdType.FILTEREDROLE)) {
                predefinedAttr = this.filteredroleAtttributesAllowed;
            }
            if (debug.messageEnabled()) {
                debug.message("  LDAPv3Repo: predefinedAttr=" + predefinedAttr + "; attrNames=" + attrNames);
            }
            LDAPEntry foundEntry = null;
            if (attrNames == null || attrNames.contains("*")) {
                if (predefinedAttr == null || predefinedAttr.isEmpty()) {
                    foundEntry = ld.read(dn);
                } else {
                    foundEntry = ld.read(dn, (String[])predefinedAttr.toArray(new String[predefinedAttr.size()]));
                    attrNamesCase = predefinedAttr;
                }
            } else {
                if (predefinedAttr != null) {
                    CaseInsensitiveHashSet allowedAttrNames = new CaseInsensitiveHashSet();
                    for (Object attrName : attrNamesCase) {
                        if (!predefinedAttr.contains(attrName)) continue;
                        allowedAttrNames.add(attrName);
                    }
                    attrNamesCase = allowedAttrNames;
                    if (attrNamesCase.isEmpty()) {
                        Object attrName;
                        attrName = theAttrMap;
                        return attrName;
                    }
                }
                if (debug.messageEnabled()) {
                    debug.message("  LDAPv3Repo: before read: attrNames=" + attrNames);
                }
                foundEntry = ld.read(dn, (String[])attrNamesCase.toArray(new String[attrNamesCase.size()]));
            }
            if (foundEntry == null) {
                debug.error("getAttributes: unable to find dn:" + dn + " to retrieve its attributes.");
                Object[] args = new Object[]{CLASS_NAME, dn};
                throw new IdRepoException("amIdRepo", "211", args);
            }
            LDAPAttributeSet ldapAttrSet = foundEntry.getAttributeSet();
            int size = ldapAttrSet.size();
            for (int i = 0; i < size; ++i) {
                LDAPAttribute ldapAttr = ldapAttrSet.elementAt(i);
                if (ldapAttr == null) continue;
                String attrName = ldapAttr.getName();
                if (debug.messageEnabled()) {
                    debug.message("  LDAPv3Repo: after read: attrName=" + attrName);
                }
                if (predefinedAttr != null && !predefinedAttr.contains(attrName.toLowerCase())) continue;
                Set<String> attrValueSet = new HashSet<String>();
                if (isString) {
                    Enumeration enumVals = ldapAttr.getStringValues();
                    while (enumVals != null && enumVals.hasMoreElements()) {
                        String value = (String)enumVals.nextElement();
                        attrValueSet.add(value);
                    }
                    if ((this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD) || this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3ADAM)) && attrName.equalsIgnoreCase(this.isActiveAttrName) && (attrNames == null || attrNamesCase.contains(defaultStatusAttribute))) {
                        if (!addActiveAttrName) {
                            theAttrMap.put(attrName.toLowerCase(), attrValueSet);
                        }
                        attrValueSet = this.convertInetStatus(attrValueSet, attrName);
                        theAttrMap.put(defaultStatusAttribute, attrValueSet);
                        continue;
                    }
                    theAttrMap.put(attrName.toLowerCase(), attrValueSet);
                    continue;
                }
                byte[][] values = ldapAttr.getByteValueArray();
                if ((this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD) || this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3ADAM)) && attrName.equalsIgnoreCase(this.isActiveAttrName) && (attrNames == null || attrNamesCase.contains(defaultStatusAttribute))) {
                    if (!addActiveAttrName) {
                        theAttrMap.put(attrName, values);
                    }
                    values = this.convertInetStatus(ldapAttr);
                    theAttrMap.put(defaultStatusAttribute, values);
                } else {
                    theAttrMap.put(attrName, values);
                }
                if (!debug.messageEnabled()) continue;
                debug.message("   getAttribute binary: values=" + values);
            }
        }
        catch (LDAPException lde) {
            resultCode = lde.getLDAPResultCode();
            String ldeErrMsg = lde.getLDAPErrorMessage();
            if (debug.warningEnabled()) {
                debug.warning("LDAPv3Repo.getAttributes failed. errorCode=" + lde.getLDAPResultCode() + "  " + ldeErrMsg);
            }
            this.handleLDAPException(lde, dn);
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getAttributes returns theAttrMap = " + IdRepoUtils.getAttrMapWithoutPasswordAttrs(theAttrMap, null));
        }
        return theAttrMap;
    }

    public Map getAttributes(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getAttributes 3 called: " + type + ": " + name);
        }
        return this.getAttributes(token, type, name, null);
    }

    public Map getBinaryAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("getBinaryAttributes: ...");
        }
        return this.getAttributes(token, type, name, attrNames, false);
    }

    public void setBinaryAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("setBinaryAttributes: type:" + type + "; name=" + name + "; attributes=" + attributes + "; isAdd:" + isAdd);
        }
        this.setAttributes(token, type, name, attributes, isAdd, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Set findDynamicGroupMembersByUrl(LDAPUrl url) throws IdRepoException {
        this.checkConnPool();
        LDAPConnection ld = null;
        int resultCode = 0;
        HashSet<String> groupMemberDNs = null;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            LDAPSearchConstraints constraints = ld.getSearchConstraints();
            constraints.setMaxResults(this.defaultMaxResults);
            constraints.setServerTimeLimit(this.timeLimit);
            groupMemberDNs = new HashSet<String>();
            if (debug.messageEnabled()) {
                debug.message("search filter in LDAPGroups : " + url.getFilter());
            }
            LDAPSearchResults res = ld.search(url.getDN(), url.getScope(), url.getFilter(), null, false, constraints);
            while (res.hasMoreElements()) {
                try {
                    LDAPEntry entry = res.next();
                    if (entry == null) continue;
                    groupMemberDNs.add(entry.getDN());
                }
                catch (LDAPReferralException lre) {
                }
                catch (LDAPException le) {
                    String ldapError = Integer.toString(le.getLDAPResultCode());
                    Object[] args = new Object[]{CLASS_NAME, LDAPv3Bundle.getString(ldapError)};
                    IdRepoException ide = new IdRepoException("amIdRepo", "311", args);
                    ide.setLDAPErrorCode(ldapError);
                    throw ide;
                    return groupMemberDNs;
                }
            }
        }
        catch (LDAPException lde) {
            resultCode = lde.getLDAPResultCode();
            String ldeErrMsg = lde.getLDAPErrorMessage();
            debug.error("LDAPv3Repo: findDynamicGroupMembersByUrl. ld.search error: " + resultCode);
            if (debug.messageEnabled()) {
                debug.error("LDAPv3Repo: findDynamicGroupMembersByUrl failed", (Throwable)lde);
            }
            this.handleLDAPException(lde, url.getDN());
            return groupMemberDNs;
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getGroupMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        HashSet<String> resultSet;
        block17: {
            LDAPAttribute attribute;
            LDAPEntry groupEntry;
            block16: {
                this.checkConnPool();
                resultSet = new HashSet<String>();
                String dn = null;
                try {
                    dn = this.getDN(type, name);
                }
                catch (IdRepoUnsupportedOpException ide) {
                    return null;
                }
                catch (IdRepoException idrepoerr) {
                    return null;
                }
                groupEntry = null;
                LDAPConnection ld = null;
                int resultCode = 0;
                try {
                    ld = this.connPool.getConnection();
                    this.enableCache(ld);
                    groupEntry = ld.read(dn);
                }
                catch (LDAPException e) {
                    debug.error("LDAPGroups: invalid group name " + name);
                    resultCode = e.getLDAPResultCode();
                    if (debug.messageEnabled()) {
                        debug.message("LDAPGroups: invalid group name " + name, (Throwable)e);
                    }
                    String ldapError = Integer.toString(resultCode);
                    Object[] args = new Object[]{CLASS_NAME, LDAPv3Bundle.getString(ldapError)};
                    if (resultCode == 80 || resultCode == 81 || resultCode == 82) {
                        IdRepoFatalException ide = new IdRepoFatalException("amIdRepo", "311", args);
                        ide.setLDAPErrorCode(ldapError);
                        throw ide;
                    }
                    Set ide = null;
                    return ide;
                }
                finally {
                    if (ld != null) {
                        this.connPool.close(ld, resultCode);
                    }
                }
                attribute = groupEntry.getAttribute(this.uniqueMemberAttr);
                if (attribute == null) break block16;
                Enumeration enumVals = attribute.getStringValues();
                while (enumVals != null && enumVals.hasMoreElements()) {
                    String memberDNStr = (String)enumVals.nextElement();
                    resultSet.add(memberDNStr);
                }
                break block17;
            }
            attribute = groupEntry.getAttribute(this.memberURLAttr);
            if (attribute == null) break block17;
            Enumeration enumVals = attribute.getStringValues();
            while (enumVals != null && enumVals.hasMoreElements()) {
                String memberUrl = (String)enumVals.nextElement();
                try {
                    LDAPUrl ldapUrl = new LDAPUrl(AMURLEncDec.encodeLDAPUrl((String)memberUrl));
                    Set dynMembers = this.findDynamicGroupMembersByUrl(ldapUrl);
                    resultSet.addAll(dynMembers);
                }
                catch (MalformedURLException e) {
                    throw new IdRepoException("MalformedURLException");
                }
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Set getManagedRoleMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        HashSet<String> roleMemberDNs;
        block20: {
            this.checkConnPool();
            LDAPConnection ld = null;
            int resultCode = 0;
            roleMemberDNs = null;
            try {
                ld = this.connPool.getConnection();
                this.enableCache(ld);
                LDAPSearchConstraints constraints = ld.getSearchConstraints();
                constraints.setMaxResults(this.defaultMaxResults);
                constraints.setServerTimeLimit(this.timeLimit);
                roleMemberDNs = new HashSet<String>();
                LDAPSearchResults res = null;
                String filter = "(" + this.nsRoleDNAttr + "=" + this.getDN(type, name) + ")";
                if (debug.messageEnabled()) {
                    debug.message("search filter in getManagedRoleMembers: " + filter + "; roleSearchScope =" + this.roleSearchScope + ";  orgDN=" + this.orgDN);
                }
                String baseDN = this.getBaseDN(membersType);
                res = ld.search(baseDN, this.roleSearchScope, filter, null, false, constraints);
                while (res.hasMoreElements()) {
                    try {
                        LDAPEntry entry = res.next();
                        if (entry == null) continue;
                        roleMemberDNs.add(entry.getDN());
                    }
                    catch (LDAPReferralException lre) {
                    }
                    catch (LDAPException le) {
                        resultCode = le.getLDAPResultCode();
                        if (resultCode == 3 || resultCode == 85 || resultCode == 4) {
                            if (debug.messageEnabled()) {
                                debug.message("LDAPv3Plugin: getManagedRoleMemberssearch iteration size/time limit reached: " + le.getMessage() + "  roleMembersDNs=" + roleMemberDNs);
                            }
                            HashSet<String> hashSet = roleMemberDNs;
                            if (ld != null) {
                                this.connPool.close(ld, resultCode);
                            }
                            return hashSet;
                        }
                        if (debug.messageEnabled()) {
                            debug.message("LDAPv3Plugin: getManagedRoleMembers search iteration exception", (Throwable)le);
                        }
                        this.handleLDAPException(le, name);
                    }
                }
                if (ld != null) {
                    this.connPool.close(ld, resultCode);
                }
                break block20;
                {
                    catch (LDAPException lde) {
                        resultCode = lde.getLDAPResultCode();
                        debug.error("LDAPv3Repo: getManagedRoleMembers, ld.search error" + resultCode);
                        if (debug.messageEnabled()) {
                            debug.error("LDAPv3Repo: getManagedRoleMembers, ld.search error", (Throwable)lde);
                        }
                        this.handleLDAPException(lde, this.getDN(type, name));
                    }
                }
            }
            finally {
                if (ld != null) {
                    this.connPool.close(ld, resultCode);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message(" exit getManagedRoleMembers. roleMembersDNs=" + roleMemberDNs);
        }
        if (this.cacheEnabled && roleMemberDNs.isEmpty()) {
            this.clearCache();
        }
        return roleMemberDNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Set getFilteredRoleMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        HashSet<String> roleMemberDNs;
        block22: {
            this.checkConnPool();
            roleMemberDNs = null;
            LDAPConnection ld = null;
            int resultCode = 0;
            String dn = null;
            try {
                LDAPEntry foundEntry;
                LDAPAttribute ldapAttr;
                ld = this.connPool.getConnection();
                this.enableCache(ld);
                LDAPSearchConstraints constraints = ld.getSearchConstraints();
                constraints.setMaxResults(this.defaultMaxResults);
                constraints.setServerTimeLimit(this.timeLimit);
                String[] getAttrs = new String[]{this.nsRoleFilterAttr};
                roleMemberDNs = new HashSet<String>();
                dn = this.getDN(type, name);
                if (debug.messageEnabled()) {
                    debug.message("getFilteredRoleMembers: name=" + name + "; type=" + type + "; membersType=" + membersType);
                }
                if ((ldapAttr = (foundEntry = ld.read(dn, getAttrs)).getAttribute(this.nsRoleFilterAttr)) != null) {
                    Enumeration enumVals = ldapAttr.getStringValues();
                    while (enumVals != null && enumVals.hasMoreElements()) {
                        String roleFilter = (String)enumVals.nextElement();
                        if (debug.messageEnabled()) {
                            debug.message("    inside while. roleFilter=" + roleFilter);
                        }
                        LDAPSearchResults res = ld.search(this.orgDN, 2, roleFilter, null, false, constraints);
                        while (res.hasMoreElements()) {
                            try {
                                LDAPEntry entry = res.next();
                                if (entry == null) continue;
                                roleMemberDNs.add(entry.getDN());
                            }
                            catch (LDAPReferralException lre) {
                            }
                            catch (LDAPException le) {
                                resultCode = le.getLDAPResultCode();
                                if (resultCode == 3 || resultCode == 85 || resultCode == 4) {
                                    if (debug.messageEnabled()) {
                                        debug.message("LDAPv3Plugin: getFilteredRoleMembers search iteration size/time limit reached: " + le.getMessage() + " ; roleMemberDNs=" + roleMemberDNs);
                                    }
                                    HashSet<String> hashSet = roleMemberDNs;
                                    if (ld != null) {
                                        this.connPool.close(ld, resultCode);
                                    }
                                    return hashSet;
                                }
                                if (debug.messageEnabled()) {
                                    debug.message("LDAPv3Repo: getFilteredRoleMembers iteration exception", (Throwable)le);
                                }
                                this.handleLDAPException(le, dn);
                            }
                        }
                    }
                }
                if (ld != null) {
                    this.connPool.close(ld, resultCode);
                }
                break block22;
                {
                    catch (LDAPException lde) {
                        resultCode = lde.getLDAPResultCode();
                        debug.error("LDAPv3Repo: getFilteredRoleMembers, ld.read" + resultCode);
                        if (debug.messageEnabled()) {
                            debug.message("LDAPv3Repo: getFilteredRoleMembers, ld.read", (Throwable)lde);
                        }
                        this.handleLDAPException(lde, dn);
                    }
                }
            }
            finally {
                if (ld != null) {
                    this.connPool.close(ld, resultCode);
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("exit getFilteredRoleMembers roleMemberDNs=" + roleMemberDNs);
        }
        return roleMemberDNs;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Set getMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getMembers called" + type + ": " + name + ": " + membersType);
        }
        Set results = null;
        if (type.equals(IdType.USER) || type.equals(IdType.AGENT)) {
            debug.error("LDAPv3Repo: Membership operation is not supported  for Users or Agents");
            throw new IdRepoException(IdRepoBundle.getString("203"), "203");
        }
        if (type.equals(IdType.GROUP)) {
            if (!membersType.equals(IdType.USER)) {
                debug.error("LDAPv3Repo: Groups do not supported membership for " + membersType.getName());
                Object[] args = new Object[]{CLASS_NAME, membersType.getName(), type.getName()};
                throw new IdRepoException("amIdRepo", "204", args);
            }
            results = this.getGroupMembers(token, type, name, membersType);
        } else if (type.equals(IdType.ROLE)) {
            if (!membersType.equals(IdType.USER)) {
                Object[] args = new Object[]{CLASS_NAME, membersType.getName(), type.getName()};
                throw new IdRepoException("amIdRepo", "204", args);
            }
            results = this.getManagedRoleMembers(token, type, name, membersType);
        } else {
            if (!type.equals(IdType.FILTEREDROLE)) {
                Object[] args = new Object[]{CLASS_NAME, IdOperation.READ.getName(), type.getName()};
                throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
            }
            if (!membersType.equals(IdType.USER)) {
                Object[] args = new Object[]{CLASS_NAME, membersType.getName(), type.getName()};
                throw new IdRepoException("amIdRepo", "204", args);
            }
            results = this.getFilteredRoleMembers(token, type, name, membersType);
        }
        if (debug.messageEnabled()) {
            debug.message("exit  getMembers results=" + results);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getGroupMemberFromUser(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        this.checkConnPool();
        LDAPConnection ld = null;
        int resultCode = 0;
        String dn = null;
        HashSet<String> groupDNs = null;
        try {
            LDAPEntry foundEntry;
            LDAPAttribute ldapAttr;
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            LDAPSearchConstraints constraints = ld.getSearchConstraints();
            constraints.setMaxResults(this.defaultMaxResults);
            constraints.setServerTimeLimit(this.timeLimit);
            String[] getAttrs = new String[]{this.memberOfAttr};
            groupDNs = new HashSet<String>();
            dn = this.getDN(type, name);
            if (debug.messageEnabled()) {
                debug.message("  getGroupMemberFromUser: dn=" + dn + ";  memberOfAttr=" + this.memberOfAttr);
            }
            if ((ldapAttr = (foundEntry = ld.read(dn, getAttrs)).getAttribute(this.memberOfAttr)) != null) {
                Enumeration enumVals = ldapAttr.getStringValues();
                while (enumVals != null && enumVals.hasMoreElements()) {
                    String groupDN = (String)enumVals.nextElement();
                    groupDNs.add(groupDN);
                }
            }
        }
        catch (LDAPException lde) {
            resultCode = lde.getLDAPResultCode();
            debug.error("LDAPv3Repo: getGroupMemberShips. ld.read error: " + resultCode);
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: getGroupMemberShips. ld.read error", (Throwable)lde);
            }
            this.handleLDAPException(lde, dn);
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
        return groupDNs;
    }

    private Set getGroupMemberSearch(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        this.checkConnPool();
        HashSet<String> groupDNs = null;
        LDAPConnection ld = null;
        int ldapResultCode = 0;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            LDAPSearchConstraints constraints = ld.getSearchConstraints();
            constraints.setMaxResults(this.defaultMaxResults);
            constraints.setServerTimeLimit(this.timeLimit);
            groupDNs = new HashSet<String>();
            String dn = this.getDN(type, name);
            String baseDN = this.getBaseDN(IdType.GROUP);
            String[] attrs = new String[]{"dn"};
            int searchGroupScope = this.searchScope;
            String grpMembershipFilter = "(&" + this.groupSearchFilter + "(" + this.uniqueMemberAttr + "=" + dn + "))";
            if (debug.messageEnabled()) {
                debug.message("getGroupMemberSearch: dn=" + dn + "; basedn=" + baseDN + "; scope=" + searchGroupScope + "\n  grpMembershipFilter=" + grpMembershipFilter);
            }
            LDAPSearchResults results = ld.search(baseDN, searchGroupScope, grpMembershipFilter, attrs, false);
            LDAPEntry entry = null;
            while (results.hasMoreElements()) {
                try {
                    entry = results.next();
                    String groupdn = entry.getDN();
                    groupDNs.add(groupdn);
                    if (!debug.messageEnabled()) continue;
                    debug.message("getGroupMemberSearch: groupdn=" + groupdn + "; entry=" + entry);
                }
                catch (LDAPReferralException refe) {
                    debug.message("LDAPReferral Detected.");
                }
            }
        }
        catch (LDAPException e) {
            ldapResultCode = e.getLDAPResultCode();
            if (debug.messageEnabled()) {
                debug.message("  Search for User error: ", (Throwable)e);
                debug.message("resultCode: " + ldapResultCode);
            }
            String ldapError = Integer.toString(ldapResultCode);
            Object[] args = new Object[]{CLASS_NAME, LDAPv3Bundle.getString(ldapError)};
            IdRepoException ide = new IdRepoException("amIdRepo", "311", args);
            ide.setLDAPErrorCode(ldapError);
            throw ide;
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, ldapResultCode);
            }
        }
        return groupDNs;
    }

    private Set getGroupMemberShips(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo. getGroupMemberShips: type=" + type + ";  name=" + name + ";  membershipType=" + membershipType);
        }
        Set groupDNs = this.memberOfAttr == null ? this.getGroupMemberSearch(token, type, name, membershipType) : this.getGroupMemberFromUser(token, type, name, membershipType);
        return groupDNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getManagedRoleMemberShips(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getManagedRoleMemberShips. type=" + type + " name=" + name + " membershipType=" + membershipType);
        }
        this.checkConnPool();
        HashSet<String> roleDNs = null;
        LDAPConnection ld = null;
        int resultCode = 0;
        String dn = null;
        try {
            LDAPAttribute ldapAttr;
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            LDAPSearchConstraints constraints = ld.getSearchConstraints();
            constraints.setMaxResults(this.defaultMaxResults);
            constraints.setServerTimeLimit(this.timeLimit);
            String[] getAttrs = new String[]{this.nsRoleDNAttr};
            roleDNs = new HashSet<String>();
            dn = this.getDN(type, name);
            LDAPEntry foundEntry = ld.read(dn, getAttrs);
            if (foundEntry != null && (ldapAttr = foundEntry.getAttribute(this.nsRoleDNAttr)) != null) {
                Enumeration enumVals = ldapAttr.getStringValues();
                while (enumVals != null && enumVals.hasMoreElements()) {
                    String roleDN = (String)enumVals.nextElement();
                    roleDNs.add(roleDN);
                }
            }
        }
        catch (LDAPException lde) {
            resultCode = lde.getLDAPResultCode();
            debug.error("LDAPv3Repo: getManagedRoleMemberShips. ld.read error" + resultCode + ";  dn=" + dn);
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: getManagedRoleMemberShips. ld.read error dn=" + dn, (Throwable)lde);
            }
            this.handleLDAPException(lde, dn);
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
        return roleDNs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getFilteredRoleMemberShips(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        this.checkConnPool();
        HashSet<String> allRoleDNs = null;
        LDAPConnection ld = null;
        int resultCode = 0;
        String dn = null;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            LDAPSearchConstraints constraints = ld.getSearchConstraints();
            constraints.setMaxResults(this.defaultMaxResults);
            constraints.setServerTimeLimit(this.timeLimit);
            String[] getAttrs = new String[]{this.nsRoleAttr};
            allRoleDNs = new HashSet<String>();
            dn = this.getDN(type, name);
            LDAPEntry foundEntry = ld.read(dn, getAttrs);
            LDAPAttribute ldapAttr = foundEntry.getAttribute(this.nsRoleAttr);
            if (ldapAttr != null) {
                Enumeration enumVals = ldapAttr.getStringValues();
                while (enumVals != null && enumVals.hasMoreElements()) {
                    String roleDN = (String)enumVals.nextElement();
                    allRoleDNs.add(roleDN);
                }
            }
            Set managedRoleDNs = this.getManagedRoleMemberShips(token, type, name, membershipType);
            if (debug.messageEnabled()) {
                debug.message("    managedRoleDNs=" + managedRoleDNs);
                debug.message("    allRoleDNs=" + allRoleDNs);
            }
            HashSet<String> normManagedRoleDNs = new HashSet<String>();
            Iterator iter = managedRoleDNs.iterator();
            while (iter.hasNext()) {
                normManagedRoleDNs.add(new DN((String)iter.next()).toRFCString().toLowerCase());
            }
            HashSet<String> result = new HashSet<String>();
            for (String nsroleName : allRoleDNs) {
                if (normManagedRoleDNs.contains(new DN(nsroleName).toRFCString().toLowerCase())) continue;
                result.add(nsroleName);
            }
            allRoleDNs = result;
        }
        catch (LDAPException lde) {
            resultCode = lde.getLDAPResultCode();
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: getFilteredRoleMemberShips: ld.read: error", (Throwable)lde);
            }
            this.handleLDAPException(lde, dn);
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
        return allRoleDNs;
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getMemberships called" + type + ": " + name + ": " + membershipType);
        }
        Set result = null;
        if (!type.equals(IdType.USER) && !type.equals(IdType.AGENT)) {
            debug.error("LDAPv3Repo: Membership for identities other than  Users is not allowed ");
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        if (membershipType.equals(IdType.GROUP)) {
            result = this.getGroupMemberShips(token, type, name, membershipType);
        } else if (membershipType.equals(IdType.ROLE)) {
            result = this.getManagedRoleMemberShips(token, type, name, membershipType);
        } else if (membershipType.equals(IdType.FILTEREDROLE)) {
            result = this.getFilteredRoleMemberShips(token, type, name, membershipType);
        } else {
            debug.error("LDAPv3Repo: Membership for other types of entities not supported for Users");
            Object[] args = new Object[]{CLASS_NAME, type.getName(), membershipType.getName()};
            throw new IdRepoException("amIdRepo", "204", args);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyGroupMembership(SSOToken token, IdType type, String name, Set usersSet, IdType membersType, int operation) throws IdRepoException, SSOException {
        this.checkConnPool();
        String groupDN = this.getDN(type, name);
        LDAPConnection ld = null;
        int resultCode = 0;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            for (String userDN : usersSet) {
                LDAPAttribute mbr1 = new LDAPAttribute(this.uniqueMemberAttr, userDN);
                LDAPAttribute mbrOf = null;
                if (this.memberOfAttr != null) {
                    mbrOf = new LDAPAttribute(this.memberOfAttr, groupDN);
                }
                LDAPModification mod = null;
                LDAPModification modMemberOf = null;
                switch (operation) {
                    case 1: {
                        mod = new LDAPModification(0, mbr1);
                        if (mbrOf == null) break;
                        modMemberOf = new LDAPModification(0, mbrOf);
                        break;
                    }
                    case 2: {
                        mod = new LDAPModification(1, mbr1);
                        if (mbrOf == null) break;
                        modMemberOf = new LDAPModification(1, mbrOf);
                    }
                }
                try {
                    if (this.cacheEnabled) {
                        this.ldapCache.flushEntries(userDN, 0);
                        this.ldapCache.flushEntries(groupDN, 0);
                    }
                    if (!this.isExists(IdType.GROUP, groupDN)) {
                        String ldapError = Integer.toString(32);
                        Object[] args = new Object[]{CLASS_NAME, groupDN, ""};
                        IdRepoException ide = new IdRepoException("amIdRepo", "220", args);
                        ide.setLDAPErrorCode(ldapError);
                        throw ide;
                    }
                    ld.modify(groupDN, mod);
                    if (!this.isExists(IdType.USER, userDN)) {
                        String ldapError = Integer.toString(32);
                        Object[] args = new Object[]{CLASS_NAME, userDN, ""};
                        IdRepoException ide = new IdRepoException("amIdRepo", "220", args);
                        ide.setLDAPErrorCode(ldapError);
                        throw ide;
                    }
                    if (mbrOf == null) continue;
                    ld.modify(userDN, modMemberOf);
                }
                catch (LDAPException lde) {
                    resultCode = lde.getLDAPResultCode();
                    debug.error("LDAPv3Repo: modifyGroupMembership ld.modify: " + resultCode + " groupDN = " + groupDN + " userDN= " + userDN);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPv3Repo: modifyGroupMembership ld.modify", (Throwable)lde);
                    }
                    this.handleLDAPException(lde, groupDN);
                }
            }
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyRoleMembership(SSOToken token, IdType type, String name, Set usersSet, IdType membersType, int operation) throws IdRepoException, SSOException {
        this.checkConnPool();
        String roleDN = this.getDN(type, name);
        LDAPConnection ld = null;
        int resultCode = 0;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            Iterator it = usersSet.iterator();
            while (it.hasNext()) {
                LDAPModification mod = null;
                String userDN = (String)it.next();
                LDAPAttribute mbr1 = new LDAPAttribute(this.nsRoleDNAttr, roleDN);
                switch (operation) {
                    case 1: {
                        mod = new LDAPModification(0, mbr1);
                        break;
                    }
                    case 2: {
                        mod = new LDAPModification(1, mbr1);
                    }
                }
                try {
                    ld.modify(userDN, mod);
                    if (!this.cacheEnabled) continue;
                    this.ldapCache.flushEntries(userDN, 0);
                }
                catch (LDAPException lde) {
                    resultCode = lde.getLDAPResultCode();
                    debug.error("LDAPv3Repo: modifyRoleMembership ld.modify: " + resultCode + " userDN= " + userDN + " roleDN= " + roleDN);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPv3Repo: modifyRoleMembership ld.modify: ", (Throwable)lde);
                    }
                    this.handleLDAPException(lde, userDN);
                }
            }
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: modifyMemberShip called " + type + "; name= " + name + "; members= " + members + "; membersType= " + membersType + "; operation= " + operation);
        }
        if (members == null || members.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo.modifyMemberShip: Members set is empty");
            }
            throw new IdRepoException("amIdRepo", "201", null);
        }
        if (type.equals(IdType.USER) || type.equals(IdType.AGENT)) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo.modifyMembership: Memberhsip to users and agents is not supported");
            }
            throw new IdRepoException("amIdRepo", "203", null);
        }
        if (!membersType.equals(IdType.USER)) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo.modifyMembership: A non-user type cannot  be made a member of any identity" + membersType.getName());
            }
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        this.checkConnPool();
        HashSet<String> usersSet = new HashSet<String>();
        for (String curr : members) {
            String dn = this.getDN(membersType, curr);
            usersSet.add(dn);
        }
        if (type.equals(IdType.GROUP)) {
            this.modifyGroupMembership(token, type, name, usersSet, membersType, operation);
        } else if (type.equals(IdType.ROLE)) {
            this.modifyRoleMembership(token, type, name, usersSet, membersType, operation);
        } else {
            debug.error("LDAPv3Repo.modifyMembership: Memberships cannot bemodified for type= " + type.getName());
            Object[] args = new Object[]{CLASS_NAME, type.getName()};
            throw new IdRepoException("amIdRepo", "209", args);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: removeAttributes called " + type + ": " + name + attrNames);
        }
        if (attrNames == null || attrNames.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        CaseInsensitiveHashSet predefinedAttr = null;
        if (type.equals(IdType.USER)) {
            predefinedAttr = this.userAtttributesAllowed;
        } else if (type.equals(IdType.AGENT)) {
            predefinedAttr = this.agentAtttributesAllowed;
        } else if (type.equals(IdType.GROUP)) {
            predefinedAttr = this.groupAtttributesAllowed;
        } else if (type.equals(IdType.ROLE)) {
            predefinedAttr = this.roleAtttributesAllowed;
        } else if (type.equals(IdType.FILTEREDROLE)) {
            predefinedAttr = this.filteredroleAtttributesAllowed;
        }
        String eDN = this.getDN(type, name);
        if (attrNames != null && attrNames.isEmpty()) {
            LDAPModificationSet ldapModSet = new LDAPModificationSet();
            for (String attrName : attrNames) {
                if (predefinedAttr != null && !predefinedAttr.contains(attrName)) continue;
                LDAPAttribute theAttr = new LDAPAttribute(attrName);
                ldapModSet.add(2, theAttr);
            }
            LDAPConnection ld = null;
            int resultCode = 0;
            try {
                ld = this.connPool.getConnection();
                this.enableCache(ld);
                ld.modify(eDN, ldapModSet);
                if (this.cacheEnabled) {
                    this.ldapCache.flushEntries(eDN, 0);
                }
            }
            catch (LDAPException lde) {
                resultCode = lde.getLDAPResultCode();
                debug.error("LDAPv3Repo: setAttributes, ld.modify error: " + resultCode);
                if (debug.messageEnabled()) {
                    debug.message("LDAPv3Repo: setAttributes, ld.modify error", (Throwable)lde);
                }
                this.handleLDAPException(lde, eDN);
            }
            finally {
                if (ld != null) {
                    this.connPool.close(ld, resultCode);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public RepoSearchResults search(SSOToken token, IdType type, String pattern, int maxTime, int maxResults, Set returnAttrs, boolean returnAllAttrs, int filterOp, Map avPairs, boolean recursive) throws IdRepoException, SSOException {
        block50: {
            if (com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.messageEnabled()) {
                com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("LDAPv3Repo: new search called:type:" + type + " ;pattern:" + pattern + " ;avPairs: " + avPairs);
                com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("  cont LDAPv3Repo: search: maxTime:" + maxTime + " ;maxResults:" + maxResults + " ;returnAttrs: " + returnAttrs);
                com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("  cont LDAPv3Repo: search:returnAllAttrs:" + returnAllAttrs + " ;filterOp:" + filterOp + " ;recursive:" + recursive + " ;returnAttrs: " + returnAttrs);
            }
            this.checkConnPool();
            base = this.getBaseDN(type);
            scope = 2;
            if (!recursive) {
                scope = 1;
            }
            attrsOnly = false;
            ld = null;
            ldapErrCode = 0;
            allEntryMap = null;
            allEntries = null;
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            searchConstraints = new LDAPSearchConstraints();
            if (maxResults < 1) {
                searchConstraints.setMaxResults(this.defaultMaxResults);
            } else {
                searchConstraints.setMaxResults(maxResults);
            }
            if (maxTime < 1) {
                searchConstraints.setServerTimeLimit(this.timeLimit);
            } else {
                searchConstraints.setServerTimeLimit(maxTime * 1000);
            }
            namingAttr = this.getNamingAttr(type);
            theAttr = null;
            if (returnAllAttrs || returnAttrs != null && returnAttrs.contains("*")) {
                theAttr = new String[]{"*"};
            } else if (returnAttrs != null && !returnAttrs.isEmpty()) {
                returnAttrs.add(namingAttr);
                theAttr = returnAttrs.toArray(new String[returnAttrs.size()]);
            } else {
                theAttr = new String[]{namingAttr};
            }
            myResults = null;
            objectClassFilter = this.getObjClassFilter(type);
            filterSB = new StringBuffer();
            filterSB.append("(&").append(this.constructFilter(namingAttr, objectClassFilter, pattern));
            if (avPairs != null && avPairs.size() > 0) {
                filterSB.append(this.constructFilter(filterOp, avPairs));
            }
            filterSB.append(")");
            if (com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.messageEnabled()) {
                com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("LDAPv3Repo: before ld.search call:filterSB:" + filterSB + " ; base:" + base);
                if (theAttr != null) {
                    com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("          theAttr[0]: " + theAttr[0]);
                } else {
                    com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("          theAttr[0]:=null");
                }
            }
            try {
                myResults = ld.search(base, this.searchScope, filterSB.toString(), theAttr, attrsOnly, searchConstraints);
            }
            catch (LDAPException lde) {
                resultCode = lde.getLDAPResultCode();
                if (com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.messageEnabled()) {
                    com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("LDAPv3Repo: search, ld.search error: " + resultCode);
                }
                ldapError = Integer.toString(resultCode);
                args = new Object[]{"com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo", LDAPv3Bundle.getString(ldapError)};
                if (resultCode == 80 || resultCode == 81 || resultCode == 82) {
                    ide = new IdRepoFatalException("amIdRepo", "311", args);
                    ide.setLDAPErrorCode(ldapError);
                    throw ide;
                }
                if (resultCode == 32) {
                    ide = new RepoSearchResults(new HashSet<E>(), 0, Collections.EMPTY_MAP, type);
                    if (ld != null) {
                        this.connPool.close(ld, ldapErrCode);
                    }
                    return ide;
                }
                ide = new IdRepoException("amIdRepo", "311", args);
                ide.setLDAPErrorCode(ldapError);
                throw ide;
            }
            errorCode = 0;
            allEntryMap = new HashMap<String, HashMap<K, V>>();
            allEntries = new HashSet<String>();
            try {
                while (myResults.hasMoreElements()) {
                    entry = myResults.next();
                    entryDN = entry.getDN();
                    attrEntryMap = new HashMap<String, HashSet<E>>();
                    if (com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.messageEnabled()) {
                        com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("    in search: entryDN=" + entryDN + "; returnAllAttrs=" + returnAllAttrs + "; allEntries=" + allEntries + "; allEntryMap=" + allEntryMap);
                    }
                    if (returnAllAttrs) {
                        ldapAttrSet = entry.getAttributeSet();
                        size = ldapAttrSet.size();
                        for (i = 0; i < size; ++i) {
                            ldapAttr = ldapAttrSet.elementAt(i);
                            if (ldapAttr == null) continue;
                            attrName = ldapAttr.getName();
                            attrValueSet = new HashSet<String>();
                            enumVals = ldapAttr.getStringValues();
                            while (enumVals != null && enumVals.hasMoreElements()) {
                                value = (String)enumVals.nextElement();
                                attrValueSet.add(value);
                            }
                            attrEntryMap.put(attrName, attrValueSet);
                        }
                        idNameValue = (Set)attrEntryMap.get(namingAttr);
                        idName = entryDN;
                        if (entryDN != null && DN.isDN((String)entryDN) && entryDN.toLowerCase().startsWith(namingAttr.toLowerCase())) {
                            edn = new DN(entryDN);
                            dns = edn.explodeDN(true);
                            idName = dns[0];
                        } else if (idNameValue != null && !idNameValue.isEmpty()) {
                            idName = (String)idNameValue.iterator().next();
                        }
                        allEntries.add(idName);
                        allEntryMap.put(idName, attrEntryMap);
                        if (!com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.messageEnabled()) continue;
                        com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("  search1 idName=" + idName + ";  attrEntryMap=" + attrEntryMap);
                        continue;
                    }
                    if (returnAttrs != null && !returnAttrs.isEmpty()) {
                        for (String attrName : returnAttrs) {
                            ldapAttr = entry.getAttribute(attrName);
                            attrValueSet = new HashSet<String>();
                            if (ldapAttr != null) {
                                enumVals = ldapAttr.getStringValues();
                                while (enumVals != null && enumVals.hasMoreElements()) {
                                    value = (String)enumVals.nextElement();
                                    attrValueSet.add(value);
                                }
                            }
                            attrEntryMap.put(attrName, attrValueSet);
                        }
                        idNameValue = (Set)attrEntryMap.get(namingAttr);
                        idName = entryDN;
                        if (entryDN != null && DN.isDN((String)entryDN) && entryDN.toLowerCase().startsWith(namingAttr.toLowerCase())) {
                            edn = new DN(entryDN);
                            dns = edn.explodeDN(true);
                            idName = dns[0];
                        } else if (idNameValue != null && !idNameValue.isEmpty()) {
                            idName = (String)idNameValue.iterator().next();
                        }
                        allEntries.add(idName);
                        allEntryMap.put(idName, attrEntryMap);
                        if (!com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.messageEnabled()) continue;
                        com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("  search2 idName=" + idName + ";  attrEntryMap=" + attrEntryMap);
                        continue;
                    }
                    idName = entryDN;
                    ldapAttr = entry.getAttribute(namingAttr);
                    if (entryDN != null && DN.isDN((String)entryDN) && entryDN.toLowerCase().startsWith(namingAttr.toLowerCase())) {
                        edn = new DN(entryDN);
                        dns = edn.explodeDN(true);
                        idName = dns[0];
                    } else if (ldapAttr != null && (enumVals = ldapAttr.getStringValues()) != null && enumVals.hasMoreElements()) {
                        idName = (String)enumVals.nextElement();
                    }
                    allEntries.add(idName);
                    if (!com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.messageEnabled()) continue;
                    com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("  search3 idName=" + idName + ";  allEntries=" + allEntries);
                }
            }
            catch (LDAPException e) {
                ldapErrCode = e.getLDAPResultCode();
                switch (errorCode) {
                    case 3: 
                    case 85: {
                        errorCode = 2;
                        ** break;
lbl169:
                        // 1 sources

                    }
                    case 4: {
                        errorCode = 1;
                        ** break;
lbl173:
                        // 1 sources

                    }
                    default: {
                        errorCode = ldapErrCode;
                    }
                }
            }
            break block50;
            finally {
                if (ld != null) {
                    this.connPool.close(ld, ldapErrCode);
                }
            }
        }
        if (com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.messageEnabled()) {
            com.sun.identity.idm.plugins.ldapv3.LDAPv3Repo.debug.message("LDAPv3Repo: exit search allEntryDN:" + allEntries + " ;allEntries:" + allEntryMap);
        }
        return new RepoSearchResults(allEntries, errorCode, allEntryMap, type);
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, Map avPairs, boolean recursive, int maxResults, int maxTime, Set returnAttrs) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: old search called" + type + ": " + pattern + ": " + avPairs);
        }
        return this.search(token, type, pattern, maxTime, maxResults, returnAttrs, true, -1, avPairs, recursive);
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        this.setAttributes(token, type, name, attributes, isAdd, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd, boolean isString, boolean dontChangeOCs) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: setAttributes called: " + type + ": " + name + " attributes = " + IdRepoUtils.getAttrMapWithoutPasswordAttrs(attributes, null));
        }
        if (attributes == null || attributes.isEmpty()) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: setAttributes. Attributes are empty");
            }
            throw new IdRepoException("amIdRepo", "201", null);
        }
        this.checkConnPool();
        String eDN = this.getDN(type, name);
        CaseInsensitiveHashSet predefinedAttr = null;
        if (type.equals(IdType.USER)) {
            predefinedAttr = this.userAtttributesAllowed;
        } else if (type.equals(IdType.AGENT)) {
            predefinedAttr = this.agentAtttributesAllowed;
        } else if (type.equals(IdType.GROUP)) {
            predefinedAttr = this.groupAtttributesAllowed;
        } else if (type.equals(IdType.ROLE)) {
            predefinedAttr = this.roleAtttributesAllowed;
        } else if (type.equals(IdType.FILTEREDROLE)) {
            predefinedAttr = this.filteredroleAtttributesAllowed;
        }
        CaseInsensitiveHashMap attributesCase = new CaseInsensitiveHashMap(attributes);
        byte[] encodedPwd = this.doPasswordEncode(type, name, attributesCase, unicodePwd);
        this.appendInetUser(token, type, name, attributesCase, isString);
        LDAPModificationSet ldapModSet = new LDAPModificationSet();
        if (encodedPwd != null) {
            LDAPAttribute theAttr = new LDAPAttribute(unicodePwd);
            theAttr.addValue(encodedPwd);
            if (isAdd) {
                ldapModSet.add(0, theAttr);
            } else {
                ldapModSet.add(2, theAttr);
            }
        }
        Iterator itr = attributesCase.keySet().iterator();
        while (itr.hasNext()) {
            LDAPAttribute theAttr = null;
            String attrName = (String)itr.next();
            if (predefinedAttr != null && !predefinedAttr.contains(attrName)) {
                if (!debug.messageEnabled()) continue;
                debug.message("    setAttributes: not in predefinedAttr list predefinedAttr=" + predefinedAttr + " attrName=" + attrName);
                continue;
            }
            if (isString) {
                String[] attrValues;
                Set set = (Set)attributesCase.get(attrName);
                String[] stringArray = attrValues = set == null ? null : set.toArray(new String[set.size()]);
                if (set == null || set.isEmpty()) {
                    theAttr = new LDAPAttribute(attrName);
                    ldapModSet.add(2, theAttr);
                    continue;
                }
                theAttr = new LDAPAttribute(attrName, attrValues);
                if (isAdd) {
                    ldapModSet.add(0, theAttr);
                    continue;
                }
                ldapModSet.add(2, theAttr);
                continue;
            }
            byte[][] attrBytes = (byte[][])attributesCase.get(attrName);
            theAttr = new LDAPAttribute(attrName);
            int size = attrBytes.length;
            for (int i = 0; i < size; ++i) {
                if (debug.messageEnabled()) {
                    debug.message("setAttributes binary:" + attrBytes[i]);
                }
                theAttr.addValue(attrBytes[i]);
            }
            if (isAdd) {
                ldapModSet.add(0, theAttr);
            } else {
                ldapModSet.add(2, theAttr);
            }
            if (!debug.messageEnabled()) continue;
            debug.message("setAttribute binary attrBytes:" + attrBytes);
        }
        if (ldapModSet.size() == 0) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: setAttributes. LdapModSet is empty");
            }
            throw new IdRepoException("amIdRepo", "201", null);
        }
        if (type.equals(IdType.USER) && !dontChangeOCs) {
            Set ocValues;
            HashSet ocsToBeAdded = new CaseInsensitiveHashSet();
            HashSet<String> ocAttrName = new HashSet<String>();
            ocAttrName.add(LDAP_OBJECT_CLASS);
            Map attrs = this.getAttributes(token, type, name, ocAttrName);
            if (attrs != null && !attrs.isEmpty() && (ocValues = (Set)attrs.values().iterator().next()) != null && !ocValues.isEmpty()) {
                for (String oc : this.userObjClassSet) {
                    boolean found = false;
                    for (String occ : ocValues) {
                        if (!oc.equalsIgnoreCase(occ)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    ocsToBeAdded.add(oc);
                }
            }
            if (!ocsToBeAdded.isEmpty()) {
                HashSet<String> tmpOCSet;
                block48: {
                    Set ocAdded = (Set)attributesCase.get(LDAP_OBJECT_CLASS);
                    if (ocAdded != null && !ocAdded.isEmpty()) {
                        for (String ocname : ocAdded) {
                            ocsToBeAdded.remove(ocname);
                        }
                    }
                    tmpOCSet = new HashSet<String>(2);
                    try {
                        for (String attrOC : ocsToBeAdded) {
                            HashSet OCAttrs = new HashSet(this.getOCAttributes(attrOC));
                            block13: for (String ocName : OCAttrs) {
                                for (String aName : attributesCase.keySet()) {
                                    if (!aName.startsWith(ocName)) continue;
                                    tmpOCSet.add(attrOC);
                                    continue block13;
                                }
                            }
                        }
                    }
                    catch (LDAPException ldx) {
                        int resCode = ldx.getLDAPResultCode();
                        if (!debug.warningEnabled()) break block48;
                        debug.warning("LDAPv3Repo: setAttributes : " + resCode, (Throwable)ldx);
                    }
                }
                if (!(ocsToBeAdded = tmpOCSet).isEmpty()) {
                    ldapModSet.add(0, new LDAPAttribute(LDAP_OBJECT_CLASS, ocsToBeAdded.toArray(new String[ocsToBeAdded.size()])));
                }
            }
        }
        LDAPConnection ld = null;
        int resultCode = 0;
        try {
            ld = this.connPool.getConnection();
            this.enableCache(ld);
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: setAttributes. Calling ld.modify");
            }
            ld.modify(eDN, ldapModSet);
            if (this.cacheEnabled) {
                this.ldapCache.flushEntries(eDN, 0);
            }
        }
        catch (LDAPException lde) {
            resultCode = lde.getLDAPResultCode();
            if (debug.warningEnabled()) {
                debug.warning("LDAPv3Repo: setAttributes, ld.modify error: " + resultCode, (Throwable)lde);
            }
            this.handleLDAPException(lde, eDN);
        }
        finally {
            if (ld != null) {
                this.connPool.close(ld, resultCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changePassword(SSOToken token, IdType type, String name, String attrName, String oldPassword, String newPassword) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo.changePassword: " + type + ": " + name);
        }
        if (!type.equals(IdType.USER)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "229", args);
        }
        LDAPModificationSet ldapModSet = new LDAPModificationSet();
        LDAPAttribute theAttr = new LDAPAttribute(attrName);
        if (attrName.equals(unicodePwd) && this.dsType.equalsIgnoreCase(LDAPv3Config_LDAPV3AD)) {
            byte[] encodedNewPwd = this.encodeADPwd(newPassword);
            theAttr.addValue(encodedNewPwd);
        } else {
            theAttr.addValue(newPassword);
        }
        String eDN = this.getDN(type, name);
        ldapModSet.add(2, theAttr);
        LDAPConnection ldc = null;
        int resultCode = 0;
        try {
            ldc = this.sslMode ? new LDAPConnection((LDAPSocketFactory)new JSSESocketFactory(null)) : new LDAPConnection();
            ldc.connect(this.ldapServerName, this.ldapPort, eDN, oldPassword);
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo.changePassword: Calling ld.modify");
            }
            ldc.modify(eDN, ldapModSet);
            if (this.cacheEnabled) {
                this.ldapCache.flushEntries(eDN, 0);
            }
        }
        catch (LDAPException lde) {
            resultCode = lde.getLDAPResultCode();
            if (debug.warningEnabled()) {
                debug.warning("LDAPv3Repo.changePassword: ld.modify error: " + resultCode, (Throwable)lde);
            }
            this.handleLDAPException(lde, eDN);
        }
        finally {
            if (ldc != null) {
                try {
                    ldc.disconnect();
                }
                catch (LDAPException lde) {}
            }
        }
    }

    private void setMixAttributes(SSOToken token, IdType type, String name, Map attrMap, boolean isAdd) throws IdRepoException, SSOException {
        HashMap binAttrMap = null;
        HashMap strAttrMap = null;
        boolean foundBin = false;
        for (String tmpAttrName : attrMap.keySet()) {
            if (!(attrMap.get(tmpAttrName) instanceof byte[][])) continue;
            if (!foundBin) {
                strAttrMap = new HashMap(attrMap);
                binAttrMap = new HashMap();
            }
            foundBin = true;
            binAttrMap.put(tmpAttrName, attrMap.get(tmpAttrName));
            strAttrMap.remove(tmpAttrName);
        }
        if (foundBin) {
            this.setAttributes(token, type, name, strAttrMap, false, true, true);
            this.setAttributes(token, type, name, binAttrMap, false, false, true);
        } else {
            this.setAttributes(token, type, name, attrMap, false, true, true);
        }
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: assignService called. IdType=" + type + "; name=" + name + "; serviceName=" + serviceName + "; SchemaType=" + sType + "; attrMap=" + attrMap);
        }
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP) || type.equals(IdType.ROLE) || type.equals(IdType.FILTEREDROLE)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (type.equals(IdType.USER)) {
            Set OCs = (Set)attrMap.get(LDAP_OBJECT_CLASS);
            HashSet<String> attrName = new HashSet<String>(1);
            attrName.add(LDAP_OBJECT_CLASS);
            Map tmpMap = this.getAttributes(token, type, name, attrName);
            Set oldOCs = (Set)tmpMap.get(LDAP_OBJECT_CLASS);
            OCs = AMCommonUtils.combineOCs(OCs, oldOCs);
            attrMap.put(LDAP_OBJECT_CLASS, OCs);
            if (sType.equals(SchemaType.USER)) {
                this.setMixAttributes(token, type, name, attrMap, false);
            } else if (sType.equals(SchemaType.DYNAMIC)) {
                return;
            }
        } else if (type.equals(IdType.REALM)) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: assignService: before myServiceMap:" + this.myServiceMap);
            }
            if (serviceName != null && serviceName.length() > 0 && attrMap != null) {
                HashMap myAttrMap = new HashMap(attrMap);
                this.myServiceMap.put(serviceName, myAttrMap);
            } else {
                debug.message("LDAPv3Repo: assignService: not stored. null or 0");
            }
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: assignService: after myServiceMap:" + this.myServiceMap);
            }
            if (this.myListener != null) {
                this.myListener.setServiceAttributes(serviceName, this.myServiceMap);
            }
        } else {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (debug.messageEnabled()) {
            debug.message("  exit assignService.  myServiceMap:" + this.myServiceMap);
        }
    }

    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: unassignService called. IdType=" + type + "; name=" + name + "; serviceName=" + serviceName + "; attrMap=" + attrMap);
        }
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP) || type.equals(IdType.ROLE) || type.equals(IdType.FILTEREDROLE)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (type.equals(IdType.REALM)) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: unassignService: before myServiceMap:" + this.myServiceMap);
            }
            if (serviceName != null && serviceName.length() > 0) {
                this.myServiceMap.remove(serviceName);
            } else {
                debug.message("LDAPv3Repo: unassignService: serviceName is null or 0");
            }
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: unassignService: after myServiceMap:" + this.myServiceMap);
            }
            if (this.myListener != null) {
                this.myListener.setServiceAttributes(serviceName, this.myServiceMap);
            }
        } else if (type.equals(IdType.USER)) {
            Set removeOCs = (Set)attrMap.get(LDAP_OBJECT_CLASS);
            HashSet<String> attrNameSet = new HashSet<String>();
            attrNameSet.add(LDAP_OBJECT_CLASS);
            Map objectClassesMap = this.getAttributes(token, type, name, attrNameSet);
            Set OCValues = (Set)objectClassesMap.get(LDAP_OBJECT_CLASS);
            removeOCs = AMCommonUtils.updateAndGetRemovableOCs(OCValues, removeOCs);
            CaseInsensitiveHashSet removeAttrs = new CaseInsensitiveHashSet();
            for (String oc : removeOCs) {
                HashSet attrs = null;
                try {
                    attrs = new HashSet(this.getOCAttributes(oc));
                }
                catch (LDAPException lde) {
                    int resultCode = lde.getLDAPResultCode();
                    debug.error("LDAPv3Repo: unassignService. get Object Attributes failed: " + resultCode);
                    if (debug.messageEnabled()) {
                        debug.message("LDAPv3Repo: unassignService.", (Throwable)lde);
                    }
                    this.handleLDAPException(lde, name);
                }
                for (String attrName : attrs) {
                    removeAttrs.add(attrName.toLowerCase());
                }
            }
            Map avPair = this.getAttributes(token, type, name);
            for (String attrName : avPair.keySet()) {
                if (removeAttrs.contains(attrName)) {
                    try {
                        AMHashMap tmpMap = new AMHashMap();
                        tmpMap.put(attrName, Collections.EMPTY_SET);
                        this.setAttributes(token, type, name, tmpMap, false);
                    }
                    catch (Exception ex) {
                        if (!debug.messageEnabled()) continue;
                        debug.message("unassignService failed. error occurred while removing attribute: " + attrName);
                    }
                    continue;
                }
                for (String ocName : removeAttrs) {
                    if (!attrName.startsWith(ocName)) continue;
                    try {
                        AMHashMap tmpMap = new AMHashMap();
                        tmpMap.put(attrName, Collections.EMPTY_SET);
                        this.setAttributes(token, type, name, tmpMap, false);
                    }
                    catch (Exception ex) {
                        if (!debug.messageEnabled()) continue;
                        debug.message("unassignService failed. else part: error occurred while removing attribute: " + attrName);
                    }
                }
            }
            AMHashMap tmpMap = new AMHashMap();
            tmpMap.put(LDAP_OBJECT_CLASS, OCValues);
            this.setAttributes(token, type, name, tmpMap, false, true, true);
        } else {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServiceNamesandOCs) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getAssignedServices. IdType=" + type + "; Name=" + name + "; mapOfServiceNamesandOCs=" + mapOfServiceNamesandOCs);
            debug.message("     getAssignedServices. myServiceMap=" + this.myServiceMap);
        }
        Set<Object> resultsSet = new HashSet();
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP) || type.equals(IdType.ROLE) || type.equals(IdType.FILTEREDROLE)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (type.equals(IdType.USER)) {
            Set OCs = this.readObjectClass(token, type, name);
            OCs = this.convertToLowerCase(OCs);
            for (String sname : mapOfServiceNamesandOCs.keySet()) {
                Set ocSet = (Set)mapOfServiceNamesandOCs.get(sname);
                ocSet = this.convertToLowerCase(ocSet);
                if (OCs == null || !OCs.containsAll(ocSet)) continue;
                resultsSet.add(sname);
            }
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: getAssignedServices returns resultsSet: " + resultsSet);
            }
        } else if (type.equals(IdType.REALM)) {
            resultsSet = this.myServiceMap.keySet();
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: getAssignedServices: resultsSet: " + resultsSet + "; myServiceMap:" + this.myServiceMap);
            }
        } else {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        return resultsSet;
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, true);
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, false);
    }

    private Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, boolean isString) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getServiceAttributes. IdType=" + type + "; Name=" + name + "; serviceName=" + serviceName + "; attrNames=" + attrNames + "; isString=" + isString);
        }
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP) || type.equals(IdType.ROLE) || type.equals(IdType.FILTEREDROLE)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (type.equals(IdType.USER)) {
            Map userAttrs;
            Map map = userAttrs = isString ? this.getAttributes(token, type, name, attrNames) : this.getBinaryAttributes(token, type, name, attrNames);
            if (serviceName == null || serviceName.length() == 0) {
                if (debug.messageEnabled()) {
                    debug.message("LDAPv3Repo: getServiceAttribute. userAttrs=" + userAttrs);
                }
                return userAttrs;
            }
            Map srvCfgAttrMap = (Map)this.myServiceMap.get(serviceName);
            HashMap mySrvAttrMap = new HashMap();
            if (srvCfgAttrMap == null || srvCfgAttrMap.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("LDAPv3Repo: getServiceAttribute: return userAttrs:" + userAttrs);
                }
                return userAttrs;
            }
            CaseInsensitiveHashSet attrNamesCase = new CaseInsensitiveHashSet((Collection)attrNames);
            for (String attrName : srvCfgAttrMap.keySet()) {
                if (!attrNamesCase.contains(attrName)) continue;
                mySrvAttrMap.put(attrName, srvCfgAttrMap.get(attrName));
            }
            if (debug.messageEnabled()) {
                debug.message("    mySrvAttrMap=" + mySrvAttrMap);
                debug.message("    srvCfgAttrMap=" + srvCfgAttrMap);
                debug.message("    userAttrs=" + userAttrs);
            }
            CaseInsensitiveHashSet userAttrsNameSet = new CaseInsensitiveHashSet((Collection)userAttrs.keySet());
            for (String attrName : mySrvAttrMap.keySet()) {
                Object tmpAttrSet;
                if (userAttrsNameSet.contains(attrName) || (tmpAttrSet = mySrvAttrMap.get(attrName)) == null) continue;
                if (!isString && tmpAttrSet instanceof Set) {
                    Iterator keyset = ((Set)tmpAttrSet).iterator();
                    int i = 0;
                    byte[][] resultArr = new byte[((Set)tmpAttrSet).size()][];
                    while (keyset.hasNext()) {
                        String thisAttr = (String)keyset.next();
                        resultArr[i] = thisAttr.getBytes();
                        ++i;
                    }
                    userAttrs.put(attrName, resultArr);
                    continue;
                }
                userAttrs.put(attrName, mySrvAttrMap.get(attrName));
            }
            if (debug.messageEnabled()) {
                debug.message("    on exit: userAttrs= " + userAttrs);
            }
            return userAttrs;
        }
        if (type.equals(IdType.REALM)) {
            Map srvCfgAttrMap = (Map)this.myServiceMap.get(serviceName);
            if (srvCfgAttrMap == null || srvCfgAttrMap.isEmpty()) {
                debug.message("LDAPv3Repo: getServiceAttributes. REALM returns empty");
                return new HashMap();
            }
            if (attrNames == null || attrNames.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("LDAPv3Repo: getServiceAttributes. REALM: attrNames is null or empty. srvCfgAttrMap=" + srvCfgAttrMap);
                }
                return new HashMap(srvCfgAttrMap);
            }
            HashMap resultMap = new HashMap();
            CaseInsensitiveHashSet srvCfgAttrNameSet = new CaseInsensitiveHashSet((Collection)srvCfgAttrMap.keySet());
            for (String attrName : attrNames) {
                if (!srvCfgAttrNameSet.contains(attrName)) continue;
                resultMap.put(attrName, srvCfgAttrMap.get(attrName));
            }
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: getServiceAttributes. REALM resultMap=" + resultMap);
            }
            return resultMap;
        }
        Object[] args = new Object[]{this.getClass().getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: modifyService. IdType=" + type + "; Name=" + name + "; serviceName=" + serviceName + "; SchemaType=" + sType + "; attrMap=" + attrMap);
        }
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP) || type.equals(IdType.ROLE) || type.equals(IdType.FILTEREDROLE)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (type.equals(IdType.REALM)) {
            Map srvCfgAttrMap;
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: modifyService. REALM before. myServiceMap" + this.myServiceMap);
            }
            if ((srvCfgAttrMap = (Map)this.myServiceMap.get(serviceName)) == null || srvCfgAttrMap.isEmpty()) {
                this.myServiceMap.put(serviceName, new HashMap(attrMap));
            } else {
                CaseInsensitiveHashSet myServiceNameSet = new CaseInsensitiveHashSet((Collection)srvCfgAttrMap.keySet());
                for (String attrName : attrMap.keySet()) {
                    if (myServiceNameSet.contains(attrName)) {
                        Set attrNamedSet = (Set)attrMap.get(attrName);
                        Set srvCfgAttrNamedSet = (Set)srvCfgAttrMap.get(attrName);
                        srvCfgAttrNamedSet.clear();
                        srvCfgAttrNamedSet.addAll(attrNamedSet);
                        srvCfgAttrMap.put(attrName, srvCfgAttrNamedSet);
                        continue;
                    }
                    srvCfgAttrMap.put(attrName, attrMap.get(attrName));
                }
                this.myServiceMap.put(serviceName, srvCfgAttrMap);
            }
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: modifyService. REALM after. myServiceMap" + this.myServiceMap);
            }
            if (this.myListener != null) {
                this.myListener.setServiceAttributes(serviceName, this.myServiceMap);
                debug.message("LDAPv3Repo: modifyService calls setServiceAttributes:" + this.myServiceMap);
            }
        } else if (type.equals(IdType.USER)) {
            if (sType.equals(SchemaType.DYNAMIC)) {
                Object[] args = new Object[]{this.getClass().getName(), sType.toString(), type.getName()};
                throw new IdRepoException("amIdRepo", "214", args);
            }
            this.setMixAttributes(token, type, name, attrMap, false);
        } else {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
    }

    public String getFullyQualifiedName(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: getFullyQualifiedName. IdType=" + type + ";  name=" + name);
        }
        if (name == null || name.length() == 0) {
            Object[] args = new Object[]{CLASS_NAME, ""};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        String userDN = this.searchForName(type, name);
        if (userDN == null || userDN.length() == 0) {
            return null;
        }
        if (this.firstHostAndPort.length() == 0) {
            StringTokenizer tk = new StringTokenizer(this.ldapServerName);
            this.firstHostAndPort = tk.nextToken();
        }
        return "ldap://" + this.firstHostAndPort + "/" + userDN;
    }

    private String searchForName(IdType type, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo:searchForName. IdType=" + type + ";  name=" + name);
        }
        String userDN = "";
        String baseDN = this.orgDN;
        int searchNameScope = 2;
        String searchFilter = "";
        String[] attrs = new String[2];
        attrs[0] = "dn";
        String namingAttr = this.getNamingAttr(type);
        String objectClassFilter = this.getObjClassFilter(type);
        searchFilter = this.constructFilter(namingAttr, objectClassFilter, name);
        attrs[1] = namingAttr;
        int userMatches = 0;
        this.checkConnPool();
        LDAPConnection ldc = null;
        int ldapResultCode = 0;
        try {
            ldc = this.connPool.getConnection();
            this.enableCache(ldc);
            if (debug.messageEnabled()) {
                debug.message("Connecting to " + this.firstHostAndPort + ":" + "\nSearching " + baseDN + " for " + searchFilter + "\nscope = " + searchNameScope);
            }
            LDAPSearchResults results = ldc.search(baseDN, searchNameScope, searchFilter, attrs, false);
            LDAPEntry entry = null;
            boolean userNamingValueSet = false;
            while (results.hasMoreElements()) {
                try {
                    entry = results.next();
                    userDN = entry.getDN();
                    ++userMatches;
                    if (!debug.messageEnabled()) continue;
                    debug.message("searchForName: userDN=" + userDN + "; entry=" + entry);
                }
                catch (LDAPReferralException refe) {
                    debug.message("LDAPReferral Detected.");
                }
            }
        }
        catch (LDAPException e) {
            ldapResultCode = e.getLDAPResultCode();
            if (debug.messageEnabled()) {
                debug.message("Search for User error: ", (Throwable)e);
                debug.message("resultCode: " + ldapResultCode);
            }
            String ldapError = Integer.toString(ldapResultCode);
            Object[] args = new Object[]{CLASS_NAME, LDAPv3Bundle.getString(ldapError)};
            IdRepoException ide = new IdRepoException("amIdRepo", "311", args);
            ide.setLDAPErrorCode(ldapError);
            throw ide;
        }
        finally {
            if (ldc != null) {
                this.connPool.close(ldc, ldapResultCode);
            }
        }
        if (userMatches > 1) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: searchForName return  found more than match.");
            }
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "222", args);
        }
        return userDN;
    }

    public boolean supportsAuthentication() {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo:supportsAuthentication. authenticationEnabled=true");
        }
        return true;
    }

    public boolean authenticate(Callback[] credentials) throws IdRepoException, AuthLoginException {
        boolean ssl;
        debug.message("LDAPv3Repo: authenticate. ");
        String username = null;
        String password = null;
        for (int i = 0; i < credentials.length; ++i) {
            if (credentials[i] instanceof NameCallback) {
                username = ((NameCallback)credentials[i]).getName();
                if (!debug.messageEnabled()) continue;
                debug.message("LDPv3Repo:authenticate username: " + username);
                continue;
            }
            if (!(credentials[i] instanceof PasswordCallback)) continue;
            char[] passwd = ((PasswordCallback)credentials[i]).getPassword();
            if (passwd != null) {
                password = new String(passwd);
                debug.message("LDAPv3Repo:authenticate passwd present: XXX");
                continue;
            }
            password = new String();
        }
        if (username == null || password == null) {
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "221", args);
        }
        boolean success = false;
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo:authenticate: username=" + username);
        }
        ResourceBundle bundle = AMResourceBundleCache.getInstance().getResBundle("amAuth", Locale.getDefaultLocale());
        String sslStr = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_LDAP_SSL_ENABLED);
        boolean bl = ssl = sslStr != null && sslStr.equalsIgnoreCase("true");
        if (this.ldapServerName == null) {
            this.getLDAPServerName(this.myConfigMap);
        }
        LDAPAuthUtils ldapAuthUtil = null;
        try {
            ldapAuthUtil = new LDAPAuthUtils(this.ldapServerName, this.ldapPort, ssl, bundle, debug);
        }
        catch (LDAPUtilException ldapUtilEx) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo:authenticate LDAPUtilException: " + ldapUtilEx.getMessage());
            }
            Object[] args = new Object[]{CLASS_NAME, username};
            throw new IdRepoException("amIdRepo", "211", args);
        }
        String authid = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_AUTHID);
        String authpw = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_AUTHPW);
        ldapAuthUtil.setAuthDN(authid);
        ldapAuthUtil.setAuthPassword(authpw);
        ldapAuthUtil.setScope(this.searchScope);
        if (this.authenticatableSet.contains(AUTH_USER) && this.authenticateIt(ldapAuthUtil, IdType.USER, username, password)) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo:authenticate IdType.USER authenticateIt=true");
            }
            return true;
        }
        if (this.authenticatableSet.contains(AUTH_AGENT) && this.authenticateIt(ldapAuthUtil, IdType.AGENT, username, password)) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo:authenticate IdType.AGENT authenticateIt=true");
            }
            return true;
        }
        if (this.authenticatableSet.contains(AUTH_GROUP) && this.authenticateIt(ldapAuthUtil, IdType.GROUP, username, password)) {
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo:authenticate IdType.GROUP authenticateIt=true");
            }
            return true;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: exit authenticate failed for" + username);
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean authenticateIt(LDAPAuthUtils ldapAuthUtil, IdType type, String username, String password) throws IdRepoException, AuthLoginException {
        String userid = username;
        String baseDN = this.getBaseDN(type);
        String namingAttr = this.getNamingAttr(type);
        if (!(type.equals(IdType.USER) || type.equals(IdType.AGENT) || type.equals(IdType.GROUP))) {
            return false;
        }
        try {
            ldapAuthUtil.setUserNamingAttribute(namingAttr);
            HashSet<String> userSearchAttr = new HashSet<String>();
            userSearchAttr.add(namingAttr);
            ldapAuthUtil.setUserSearchAttribute(userSearchAttr);
            ldapAuthUtil.setBase(baseDN);
            ldapAuthUtil.setFilter("");
            String[] attrs = new String[]{"dn", namingAttr};
            ldapAuthUtil.setUserAttrs(attrs);
            if (DN.isDN((String)username)) {
                userid = new DN(username).explodeDN(true)[0];
            }
            ldapAuthUtil.authenticateUser(userid, password);
        }
        catch (LDAPUtilException ldapUtilEx) {
            switch (ldapUtilEx.getLDAPResultCode()) {
                case 32: {
                    if (!debug.messageEnabled()) throw new AuthLoginException(this.amAuthLDAP, "NoUser", null);
                    debug.message("LDAPv3Repo:authenticateIt. The specified user does not exist. username=" + username);
                    throw new AuthLoginException(this.amAuthLDAP, "NoUser", null);
                }
                case 49: {
                    if (debug.messageEnabled()) {
                        debug.message("LDAPv3Repo:authenticateIt. Invalid password. username=" + username);
                    }
                    String failureUserID = ldapAuthUtil.getUserId();
                    throw new InvalidPasswordException(this.amAuthLDAP, "InvalidUP", null, failureUserID, null);
                }
                case 53: {
                    if (!debug.messageEnabled()) throw new AuthLoginException(this.amAuthLDAP, "AcctInactive", null);
                    debug.message("LDAPv3Repo:authenticateIt. Unwilling to perform. Account inactivated. username" + username);
                    throw new AuthLoginException(this.amAuthLDAP, "AcctInactive", null);
                }
                case 48: {
                    if (!debug.messageEnabled()) throw new AuthLoginException(this.amAuthLDAP, "InappAuth", null);
                    debug.message("LDAPv3Repo:authenticateIt. Inappropriate authentication. username=" + username);
                    throw new AuthLoginException(this.amAuthLDAP, "InappAuth", null);
                }
                case 19: {
                    if (!debug.messageEnabled()) throw new AuthLoginException(this.amAuthLDAP, "ExceedRetryLimit", null);
                    debug.message("LDAPv3Repo:authenticateIt. Exceed password retry limit. username" + username);
                    throw new AuthLoginException(this.amAuthLDAP, "ExceedRetryLimit", null);
                }
            }
            if (!debug.messageEnabled()) throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
            debug.message("LDAPv3Repo:authenticateIt. default exception. username=" + username);
            throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
        }
        if (ldapAuthUtil.getState() == 26) return true;
        if (ldapAuthUtil.getState() != 21) return false;
        return true;
    }

    public LDAPCache GetCache() {
        return this.ldapCache;
    }

    public void clearCache() {
        if (debug.messageEnabled()) {
            debug.message("clearCache");
        }
        if (!this.cacheEnabled || this.ldapCache == null) {
            return;
        }
        boolean status = this.ldapCache.flushEntries(null, 2);
        if (debug.messageEnabled()) {
            debug.message("clearCache: flushed return " + status);
        }
    }

    public void objectChanged(String dn, int changeType) {
        if (debug.messageEnabled()) {
            debug.message("objectChanged:  dn=" + dn);
        }
        if (this.hasShutdown || !this.cacheEnabled || this.ldapCache == null) {
            return;
        }
        if (changeType == 1) {
            boolean flushStatus = this.ldapCache.flushEntries(null, 2);
        } else if (changeType == 4) {
            boolean flushStatus = this.ldapCache.flushEntries(null, 2);
        } else if (changeType == 8) {
            boolean flushStatus;
            DN fqdn = new DN(dn);
            DN parentDN = fqdn.getParent();
            String parent = parentDN.toString();
            do {
                flushStatus = this.ldapCache.flushEntries(parent, 1);
                if (!debug.messageEnabled()) continue;
                debug.message("objectChanged LDAPPersistSearchControl.MODDN parent scope_one: flushStatus= " + parent + " " + flushStatus);
            } while (flushStatus);
            do {
                flushStatus = this.ldapCache.flushEntries(parent, 0);
                if (!debug.messageEnabled()) continue;
                debug.message("objectChanged LDAPPersistSearchControl.MODDN parent scope_base: flushStatus= " + parent + " " + flushStatus);
            } while (flushStatus);
        } else {
            boolean flushStatus = this.ldapCache.flushEntries(null, 2);
        }
    }

    protected static void objectChanged(String dn, int changeType, Request request, String psIdKey, boolean allObjChanged, boolean clearCache) {
        HashMap listOfRepo;
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo.objectChanged: dn=" + dn + "; changeType" + changeType + "; psIdKey=" + psIdKey + "; allObjChanged=" + allObjChanged + "; clearCache=" + clearCache);
        }
        if ((listOfRepo = (HashMap)listOfPS.get(psIdKey)) != null) {
            HashMap clonedListOfRepo = (HashMap)listOfRepo.clone();
            HashSet listOfDS = (HashSet)clonedListOfRepo.get("listOfDS");
            for (LDAPv3Repo v3Repo : listOfDS) {
                if (v3Repo.hasShutdown) continue;
                if (allObjChanged) {
                    clearCache = true;
                    v3Repo.myListener.allObjectsChanged();
                } else {
                    v3Repo.objectChanged(dn, changeType);
                    Set supportedTypes = v3Repo.getSupportedTypes();
                    for (IdType idType : supportedTypes) {
                        v3Repo.myListener.objectChanged(dn, idType, changeType, v3Repo.myListener.getConfigMap());
                    }
                }
                if (!clearCache) continue;
                v3Repo.clearCache();
            }
        } else if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo.objectChanged: did not find any datastore for this ps.");
        }
    }

    private int checkControls(LDAPConnection ld) {
        block6: {
            LDAPControl[] controls = ld.getResponseControls();
            boolean status = false;
            if (controls != null && controls.length >= 1) {
                LDAPPasswordExpiringControl expgControl = null;
                for (int i = 0; i < controls.length; ++i) {
                    if (controls[i].getType() == 9) {
                        return -1;
                    }
                    if (controls[i].getType() != 10) continue;
                    expgControl = (LDAPPasswordExpiringControl)controls[i];
                }
                if (expgControl != null) {
                    try {
                        return expgControl.getSecondsToExpiration();
                    }
                    catch (NumberFormatException e) {
                        if (!debug.messageEnabled()) break block6;
                        debug.message("Unexpected message <" + expgControl.getMessage() + "> in password expiring control");
                    }
                }
            }
        }
        return 0;
    }

    private Collection getOCAttributes(String objClassName) throws LDAPException, IdRepoException {
        LDAPSchema dirSchema = this.getLDAPSchema();
        Collection attributes = this.getRequiredAttributes(dirSchema, objClassName);
        attributes.addAll(this.getOptionalAttributes(dirSchema, objClassName));
        return attributes;
    }

    private Collection getRequiredAttributes(LDAPSchema dirSchema, String objClassName) throws LDAPException, IdRepoException {
        ArrayList<String> attributeNames = new ArrayList<String>();
        LDAPObjectClassSchema objClass = dirSchema.getObjectClass(objClassName);
        if (objClass != null) {
            Enumeration en = objClass.getRequiredAttributes();
            while (en.hasMoreElements()) {
                attributeNames.add((String)en.nextElement());
            }
        }
        return attributeNames;
    }

    private Collection getOptionalAttributes(LDAPSchema dirSchema, String objClassName) throws LDAPException, IdRepoException {
        ArrayList<String> attributeNames = new ArrayList<String>();
        LDAPObjectClassSchema objClass = dirSchema.getObjectClass(objClassName);
        if (objClass != null) {
            Enumeration en = objClass.getOptionalAttributes();
            while (en.hasMoreElements()) {
                attributeNames.add((String)en.nextElement());
            }
        }
        return attributeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPSchema getLDAPSchema() throws LDAPException, IdRepoException {
        LDAPSchema dirSchema = new LDAPSchema();
        this.checkConnPool();
        LDAPConnection conn = null;
        try {
            conn = this.connPool.getConnection();
            this.enableCache(conn);
            dirSchema.fetchSchema(conn);
        }
        finally {
            if (conn != null) {
                this.connPool.close(conn);
            }
        }
        return dirSchema;
    }

    private Set readObjectClass(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        HashSet<String> attrNameSet = new HashSet<String>();
        attrNameSet.add(LDAP_OBJECT_CLASS);
        Map objectClassesMap = this.getAttributes(token, type, name, attrNameSet);
        Set OCValues = (Set)objectClassesMap.get(LDAP_OBJECT_CLASS);
        return OCValues;
    }

    private Set convertToLowerCase(Set vals) {
        if (vals == null || vals.isEmpty()) {
            return vals;
        }
        HashSet<String> tSet = new HashSet<String>();
        Iterator it = vals.iterator();
        while (it.hasNext()) {
            tSet.add(((String)it.next()).toLowerCase());
        }
        return tSet;
    }

    private Set parseInputedOps(StringTokenizer st, boolean supportService) {
        HashSet<IdOperation> opsReadSet = new HashSet<IdOperation>();
        while (st.hasMoreTokens()) {
            String idOpToken = st.nextToken();
            if (idOpToken.equalsIgnoreCase("read")) {
                opsReadSet.add(IdOperation.READ);
                continue;
            }
            if (idOpToken.equalsIgnoreCase("edit")) {
                opsReadSet.add(IdOperation.EDIT);
                continue;
            }
            if (idOpToken.equalsIgnoreCase("create")) {
                opsReadSet.add(IdOperation.CREATE);
                continue;
            }
            if (idOpToken.equalsIgnoreCase("delete")) {
                opsReadSet.add(IdOperation.DELETE);
                continue;
            }
            if (!idOpToken.equalsIgnoreCase("service") || !supportService) continue;
            opsReadSet.add(IdOperation.SERVICE);
        }
        if (debug.messageEnabled()) {
            debug.message("parseInputedOps exit: opsReadSet:" + opsReadSet);
        }
        return opsReadSet;
    }

    private void parsedUserSpecifiedOps(Set userSpecifiedOpsSet) {
        if (debug.messageEnabled()) {
            debug.message("parsedUserSpecifiedOps entry: userSpecifiedOpsSet:" + userSpecifiedOpsSet);
        }
        IdType idTypeRead = null;
        Object opsREAD = null;
        HashMap oldSupportedOps = new HashMap(this.supportedOps);
        this.supportedOps.clear();
        Iterator it = userSpecifiedOpsSet.iterator();
        while (it.hasNext()) {
            idTypeRead = null;
            Set opsRead = null;
            String curr = (String)it.next();
            StringTokenizer st = new StringTokenizer(curr, "= ,");
            if (st.hasMoreTokens()) {
                String idtypeToken = st.nextToken();
                if (debug.messageEnabled()) {
                    debug.message("    idtypeToken:" + idtypeToken);
                }
                if (idtypeToken.equalsIgnoreCase("user")) {
                    idTypeRead = IdType.USER;
                    opsRead = this.parseInputedOps(st, true);
                } else if (idtypeToken.equalsIgnoreCase("group")) {
                    idTypeRead = IdType.GROUP;
                    opsRead = this.parseInputedOps(st, false);
                } else if (idtypeToken.equalsIgnoreCase("agent")) {
                    idTypeRead = IdType.AGENT;
                    opsRead = this.parseInputedOps(st, false);
                } else if (idtypeToken.equalsIgnoreCase("role")) {
                    idTypeRead = IdType.ROLE;
                    opsRead = this.parseInputedOps(st, false);
                } else if (idtypeToken.equalsIgnoreCase("filteredrole")) {
                    idTypeRead = IdType.FILTEREDROLE;
                    opsRead = this.parseInputedOps(st, false);
                } else if (idtypeToken.equalsIgnoreCase("realm")) {
                    idTypeRead = IdType.REALM;
                    opsRead = this.parseInputedOps(st, true);
                } else {
                    idTypeRead = null;
                }
            }
            if (idTypeRead == null || opsRead == null || opsRead.isEmpty()) continue;
            this.supportedOps.put(idTypeRead, opsRead);
            if (!debug.messageEnabled()) continue;
            debug.message("parsedUserSpecifiedOps called supportedOps:" + this.supportedOps + "; idTypeRead:" + idTypeRead + "; opsRead:" + opsRead);
        }
        HashSet<IdOperation> realmSrv = (HashSet<IdOperation>)this.supportedOps.get(IdType.REALM);
        if (realmSrv == null) {
            realmSrv = new HashSet<IdOperation>();
        }
        realmSrv.add(IdOperation.SERVICE);
        this.supportedOps.put(IdType.REALM, realmSrv);
    }

    private void loadSupportedOps() {
        HashSet<IdOperation> opSet = new HashSet<IdOperation>();
        opSet.add(IdOperation.CREATE);
        opSet.add(IdOperation.DELETE);
        opSet.add(IdOperation.EDIT);
        opSet.add(IdOperation.READ);
        opSet.add(IdOperation.SERVICE);
        this.supportedOps.put(IdType.USER, Collections.unmodifiableSet(opSet));
        this.supportedOps.put(IdType.REALM, Collections.unmodifiableSet(opSet));
        HashSet op2Set = new HashSet(opSet);
        op2Set.remove(IdOperation.SERVICE);
        this.supportedOps.put(IdType.GROUP, Collections.unmodifiableSet(op2Set));
        this.supportedOps.put(IdType.AGENT, Collections.unmodifiableSet(op2Set));
        this.supportedOps.put(IdType.ROLE, Collections.unmodifiableSet(op2Set));
        this.supportedOps.put(IdType.FILTEREDROLE, Collections.unmodifiableSet(op2Set));
        if (debug.messageEnabled()) {
            debug.message("loadSupportedOps: supportedOps: " + this.supportedOps);
        }
    }

    private String getObjClassFilter(IdType type) {
        String objClassFilter = null;
        objClassFilter = type.equals(IdType.USER) ? this.userSearchFilter : (type.equals(IdType.GROUP) ? this.groupSearchFilter : (type.equals(IdType.ROLE) ? this.roleSearchFilter : (type.equals(IdType.FILTEREDROLE) ? this.filterroleSearchFilter : (type.equals(IdType.AGENT) ? this.agentSearchFilter : this.userSearchFilter))));
        if (debug.messageEnabled()) {
            debug.message("getObjClassFilter returns: objClassFilter=" + objClassFilter);
        }
        return objClassFilter;
    }

    private String getNamingAttr(IdType type) {
        String namingAttr = null;
        namingAttr = type.equals(IdType.USER) ? this.userSearchNamingAttr : (type.equals(IdType.GROUP) ? this.groupSearchNamingAttr : (type.equals(IdType.ROLE) ? this.roleSearchNamingAttr : (type.equals(IdType.FILTEREDROLE) ? this.filterroleSearchNamingAttr : (type.equals(IdType.AGENT) ? this.agentSearchNamingAttr : this.userSearchNamingAttr))));
        return namingAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDN(IdType type, String name) throws IdRepoException {
        String dn;
        String origName = name;
        if (name == null) {
            name = "";
        } else if (name.length() > 0) {
            name = name + ",";
        }
        this.checkConnPool();
        if (type.equals(IdType.USER)) {
            if (this.peopleCtnrValue != null && this.peopleCtnrValue.length() != 0 && this.peopleCtnrNamingAttr != null) {
                if (this.peopleCtnrNamingAttr.length() != 0) return this.userSearchNamingAttr + "=" + name + this.peopleCtnrNamingAttr + "=" + this.peopleCtnrValue + "," + this.orgDN;
            }
            dn = this.userSearchNamingAttr + "=" + name + this.orgDN;
            String filter = this.constructFilter(this.userSearchNamingAttr, this.getObjClassFilter(IdType.USER), origName);
            LDAPConnection ld = null;
            try {
                ld = this.connPool.getConnection();
                if (ld == null) {
                    debug.error("LDAPv3Repo: getDN. ld is null");
                }
                this.enableCache(ld);
                LDAPSearchConstraints searchConstraints = new LDAPSearchConstraints();
                searchConstraints.setMaxResults(2);
                searchConstraints.setServerTimeLimit(this.timeLimit);
                if (debug.messageEnabled()) {
                    debug.message("LDAPv3Repo.getDN. before search. name=" + name + "; filter=" + filter + ";  orgDN=" + this.orgDN);
                }
                LDAPSearchResults results = null;
                if (this.userAtttributesAllowed == null || this.userAtttributesAllowed.isEmpty()) {
                    results = ld.search(this.orgDN, 2, filter, null, false, searchConstraints);
                } else {
                    String[] attrArr = (String[])this.userAtttributesAllowed.toArray(new String[this.userAtttributesAllowed.size()]);
                    results = ld.search(this.orgDN, 2, filter, attrArr, false, searchConstraints);
                }
                if (results != null && results.hasMoreElements()) {
                    LDAPEntry myEntry = results.next();
                    if (myEntry != null) {
                        dn = myEntry.getDN();
                    } else {
                        if (debug.messageEnabled()) {
                            debug.message("LDAPv3Repo: getDN search again.");
                        }
                        this.clearCache();
                        results = ld.search(this.orgDN, 2, filter, null, false, searchConstraints);
                        if (results != null && results.hasMoreElements()) {
                            myEntry = results.next();
                            dn = myEntry.getDN();
                        } else if (debug.messageEnabled()) {
                            debug.message("LDAPv3Repo: 2nd getDN user search null.");
                        }
                    }
                    if (!debug.messageEnabled()) return dn;
                    debug.message("LDAPv3Repo.getDN. search return dn=" + dn);
                    return dn;
                }
                if (!debug.warningEnabled()) return dn;
                debug.message("LDAPv3Repo.getDN. user not found");
                return dn;
            }
            catch (Exception lde) {
                if (!debug.messageEnabled()) return dn;
                debug.message("LDAPv3Repo: getDN user search", (Throwable)lde);
                return dn;
            }
            finally {
                if (ld != null) {
                    this.connPool.close(ld);
                }
            }
        } else {
            if (type.equals(IdType.AGENT)) {
                if (this.agentCtnrValue == null) return this.agentSearchNamingAttr + "=" + name + this.orgDN;
                if (this.agentCtnrValue.length() == 0) return this.agentSearchNamingAttr + "=" + name + this.orgDN;
                if (this.agentCtnrNamingAttr == null) return this.agentSearchNamingAttr + "=" + name + this.orgDN;
                if (this.agentCtnrNamingAttr.length() != 0) return this.agentSearchNamingAttr + "=" + name + this.agentCtnrNamingAttr + "=" + this.agentCtnrValue + "," + this.orgDN;
                return this.agentSearchNamingAttr + "=" + name + this.orgDN;
            }
            if (type.equals(IdType.GROUP)) {
                if (this.groupCtnrValue != null && this.groupCtnrValue.length() != 0 && this.groupCtnrNamingAttr != null) {
                    if (this.groupCtnrNamingAttr.length() != 0) return this.groupSearchNamingAttr + "=" + name + this.groupCtnrNamingAttr + "=" + this.groupCtnrValue + "," + this.orgDN;
                }
                dn = this.groupSearchNamingAttr + "=" + name + this.orgDN;
                String filter = this.constructFilter(this.groupSearchNamingAttr, this.getObjClassFilter(IdType.GROUP), origName);
                LDAPConnection ld = null;
                try {
                    ld = this.connPool.getConnection();
                    this.enableCache(ld);
                    LDAPSearchResults results = ld.search(this.orgDN, 2, filter, null, false);
                    if (results == null) return dn;
                    if (!results.hasMoreElements()) return dn;
                    dn = results.next().getDN();
                    return dn;
                }
                catch (Exception lde) {
                    if (!debug.messageEnabled()) return dn;
                    debug.message("LDAPv3Repo: getDN user search", (Throwable)lde);
                    return dn;
                }
                finally {
                    if (ld != null) {
                        this.connPool.close(ld);
                    }
                }
            } else {
                if (type.equals(IdType.ROLE)) {
                    return this.roleSearchNamingAttr + "=" + name + this.orgDN;
                }
                if (type.equals(IdType.FILTEREDROLE)) {
                    return this.filterroleSearchNamingAttr + "=" + name + this.orgDN;
                }
                Object[] args = new Object[]{CLASS_NAME, IdOperation.READ.getName(), type.getName()};
                throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
            }
        }
    }

    private String getBaseDN(IdType type) {
        String dn = type.equals(IdType.USER) ? (this.peopleCtnrValue == null || this.peopleCtnrValue.length() == 0 || this.peopleCtnrNamingAttr == null || this.peopleCtnrNamingAttr.length() == 0 ? this.orgDN : this.peopleCtnrNamingAttr + "=" + this.peopleCtnrValue + "," + this.orgDN) : (type.equals(IdType.AGENT) ? (this.agentCtnrValue == null || this.agentCtnrValue.length() == 0 || this.agentCtnrNamingAttr == null || this.agentCtnrNamingAttr.length() == 0 ? this.orgDN : this.agentCtnrNamingAttr + "=" + this.agentCtnrValue + "," + this.orgDN) : (type.equals(IdType.GROUP) ? (this.groupCtnrValue == null || this.groupCtnrValue.length() == 0 || this.groupCtnrNamingAttr == null || this.groupCtnrNamingAttr.length() == 0 ? this.orgDN : this.groupCtnrNamingAttr + "=" + this.groupCtnrValue + "," + this.orgDN) : (type.equals(IdType.ROLE) || type.equals(IdType.FILTEREDROLE) ? this.orgDN : this.orgDN)));
        return dn;
    }

    private String constructFilter(int filterModifier, Map avPairs) {
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: constructFilter: avPairs=" + avPairs + "filterModifier=" + filterModifier);
        }
        if (avPairs == null || filterModifier == -1) {
            return null;
        }
        StringBuffer filterSB = new StringBuffer();
        if (filterModifier == 0) {
            filterSB.append("(|");
        } else if (filterModifier == 1) {
            filterSB.append("(&");
        }
        for (String attributeName : avPairs.keySet()) {
            for (String attributeValue : (Set)avPairs.get(attributeName)) {
                filterSB.append("(").append(attributeName).append("=").append(attributeValue).append(")");
            }
        }
        filterSB.append(")");
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: exit constructFilter: filterSB= " + filterSB);
        }
        return filterSB.toString();
    }

    private String constructFilter(String namingAttr, String objectClassFilter, String wildcard) {
        String vPart;
        String uPart;
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: constructFilter: objectClassFilter=" + objectClassFilter + "; wildcard=" + wildcard + "; namingAttr=" + namingAttr);
        }
        StringBuffer filterSB = new StringBuffer();
        int index = objectClassFilter.indexOf("%U");
        int vIndex = objectClassFilter.indexOf("%V");
        if (index == -1 && vIndex == -1) {
            if (namingAttr == null || namingAttr.length() == 0) {
                filterSB.append(objectClassFilter);
            } else {
                filterSB.append("(&(").append(namingAttr).append("=").append(wildcard).append(")").append(objectClassFilter).append(")");
            }
            objectClassFilter = filterSB.toString();
            if (debug.messageEnabled()) {
                debug.message("LDAPv3Repo: exit 1 constructFilter . objectClassFilter=" + objectClassFilter);
            }
            return objectClassFilter;
        }
        int indexat = wildcard.indexOf("@");
        if (indexat == -1) {
            uPart = wildcard;
            vPart = "*";
        } else {
            uPart = wildcard.substring(0, indexat);
            vPart = wildcard.substring(indexat + 1);
        }
        while (index != -1) {
            filterSB.append(objectClassFilter.substring(0, index)).append(wildcard).append(objectClassFilter.substring(index + 2));
            objectClassFilter = filterSB.toString();
            filterSB = new StringBuffer();
            index = objectClassFilter.indexOf("%U");
        }
        while (vIndex != -1) {
            filterSB.append(objectClassFilter.substring(0, vIndex)).append(wildcard).append(objectClassFilter.substring(vIndex + 2));
            objectClassFilter = filterSB.toString();
            filterSB = new StringBuffer();
            vIndex = objectClassFilter.indexOf("%V");
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo: exit constructFilter. objectClassFilter=" + objectClassFilter);
        }
        return objectClassFilter;
    }

    private Map getCreateUserAttrMapping(Map configParams) {
        Map createAttrMap;
        Set createUserAttrMappingSet = (Set)configParams.get(LDAPv3Config_LDAP_CREATEUSERMAPPING);
        if (createUserAttrMappingSet == null || createUserAttrMappingSet.isEmpty()) {
            createAttrMap = Collections.EMPTY_MAP;
        } else {
            if (debug.messageEnabled()) {
                debug.message("in getCreateUserAttrMapping: createUserAttrMappingSet=" + createUserAttrMappingSet);
            }
            int size = createUserAttrMappingSet.size();
            createAttrMap = new CaseInsensitiveHashMap(size);
            for (String mapString : createUserAttrMappingSet) {
                int eqIndex = mapString.indexOf(61);
                if (eqIndex > -1) {
                    String first = mapString.substring(0, eqIndex);
                    String second = mapString.substring(eqIndex + 1);
                    createAttrMap.put(first, second);
                    continue;
                }
                createAttrMap.put(mapString, mapString);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("exit getCreateUserAttrMapping: createAttrMap=" + createAttrMap);
        }
        return createAttrMap;
    }

    private void setDSType(Map configParams) {
        this.dsType = configParams.containsKey(LDAPv3Config_LDAPV3AD) ? LDAPv3Config_LDAPV3AD : (configParams.containsKey(LDAPv3Config_LDAPV3ADAM) ? LDAPv3Config_LDAPV3ADAM : (configParams.containsKey(LDAPv3Config_LDAPV3AMDS) ? LDAPv3Config_LDAPV3AMDS : LDAPv3Config_LDAPV3GENERIC));
    }

    private String getPSKey(Map configParams) {
        String psearchBase = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_LDAP_PSEARCHBASE);
        String pfilter = this.getPropertyStringValue(this.myConfigMap, LDAPv3Config_LDAP_PSEARCHFILTER);
        String psIdKey = this.ldapServerName + this.orgDN + psearchBase + pfilter;
        return psIdKey;
    }

    private String getPropertyRetryErrorCodes(Map configParams, String key) {
        TreeSet codes = new TreeSet();
        Set retryErrorSet = (Set)configParams.get(key);
        Iterator itr = retryErrorSet.iterator();
        while (itr.hasNext()) {
            codes.add(itr.next());
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo.getPropertyRetryErrorCodes: " + key + "retryErrorSet=" + retryErrorSet + " ; codes=" + codes);
        }
        String sortedCodes = "";
        itr = codes.iterator();
        while (itr.hasNext()) {
            if (sortedCodes.length() == 0) {
                sortedCodes = sortedCodes + (String)itr.next();
                continue;
            }
            sortedCodes = sortedCodes + "," + (String)itr.next();
        }
        return sortedCodes;
    }

    private int getPropertyIntValue(Map configParams, String key, int defaultValue) {
        int value = defaultValue;
        try {
            Set valueSet = (Set)configParams.get(key);
            if (valueSet != null && !valueSet.isEmpty()) {
                value = Integer.parseInt((String)valueSet.iterator().next());
            }
        }
        catch (NumberFormatException nfe) {
            value = defaultValue;
        }
        if (debug.messageEnabled()) {
            debug.message("    LDAPv3Repo.getPropertyIntValue(): " + key + " = " + value);
        }
        return value;
    }

    private String getPropertyStringValue(Map configParams, String key, String defaultVal) {
        String value = this.getPropertyStringValue(configParams, key);
        if (value == null) {
            value = defaultVal;
        }
        return value;
    }

    private String getPropertyStringValue(Map configParams, String key) {
        String value = null;
        Set valueSet = (Set)configParams.get(key);
        if (valueSet != null && !valueSet.isEmpty()) {
            value = (String)valueSet.iterator().next();
        } else if (debug.messageEnabled()) {
            debug.message("LDAPv3Repo.getPropertyStringValue failed:" + key);
        }
        if (debug.messageEnabled()) {
            if (!key.equals(LDAPv3Config_AUTHPW)) {
                debug.message("    LDAPv3Repo.getPropertyStringValue(): " + key + " = " + value);
            } else if (value == null || value.length() == 0) {
                debug.message("    LDAPv3Repo.getPropertyStringValue(): " + key + " = NULL or ZERO LENGTH");
            } else {
                debug.message("    LDAPv3Repo.getPropertyStringValue(): " + key + " = has value XXX");
            }
        }
        return value;
    }

    private boolean getPropertyBooleanValue(Map configParams, String key) {
        String value = this.getPropertyStringValue(configParams, key);
        return value != null && value.equalsIgnoreCase("true");
    }

    private void checkConnPool() throws IdRepoException {
        if (this.connPool == null) {
            Object[] args = new Object[]{CLASS_NAME, LDAPv3Bundle.getString(this.ldapConnError)};
            IdRepoException ide = new IdRepoException("amIdRepo", "311", args);
            ide.setLDAPErrorCode(this.ldapConnError);
            throw ide;
        }
    }

    private void handleLDAPException(LDAPException lde, String eDN) throws IdRepoException, IdRepoFatalException {
        int resultCode = lde.getLDAPResultCode();
        String ldapError = Integer.toString(resultCode);
        String errorMessage = lde.getLDAPErrorMessage();
        Object[] args = new Object[]{CLASS_NAME, LDAPv3Bundle.getString(ldapError), ""};
        if (resultCode == 80 || resultCode == 81 || resultCode == 82) {
            IdRepoFatalException ide = new IdRepoFatalException("amIdRepo", "311", args);
            ide.setLDAPErrorCode(ldapError);
            throw ide;
        }
        if (resultCode == 19) {
            args[0] = CLASS_NAME;
            args[1] = ldapError;
            args[2] = errorMessage;
            IdRepoFatalException ide = new IdRepoFatalException("amIdRepo", "313", args);
            ide.setLDAPErrorCode(ldapError);
            throw ide;
        }
        if (errorMessage != null && errorMessage.length() > 0) {
            args[0] = CLASS_NAME;
            args[1] = ldapError;
            args[2] = errorMessage;
            IdRepoException ide = new IdRepoException("amIdRepo", "313", args);
            ide.setLDAPErrorCode(ldapError);
            throw ide;
        }
        if (resultCode == 32) {
            args[0] = CLASS_NAME;
            if (eDN == null) {
                eDN = "";
            }
            args[1] = eDN;
            IdRepoException ide = new IdRepoException("amIdRepo", "220", args);
            ide.setLDAPErrorCode(ldapError);
            throw ide;
        }
        IdRepoException ide = new IdRepoException("amIdRepo", "311", args);
        ide.setLDAPErrorCode(ldapError);
        throw ide;
    }

    static {
        _eventsMgr = new Hashtable();
        _numRequest = new Hashtable();
        listOfPS = Collections.synchronizedMap(new HashMap());
        AUTH_USER = IdType.USER.getName();
        AUTH_AGENT = IdType.AGENT.getName();
        AUTH_GROUP = IdType.GROUP.getName();
        internalToken = null;
    }
}

