/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.realm;

import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.util.logging.Level;

public class DeleteRealm
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        String realm = this.getStringOptionValue("realm");
        boolean recursive = this.isOptionSet("recursive");
        String strRecursive = recursive ? "recursive" : "non recursive";
        String[] params = new String[]{realm, strRecursive};
        this.writeLog(0, Level.INFO, "ATTEMPT_DELETE_REALM", params);
        try {
            OrganizationConfigManager ocm = new OrganizationConfigManager(adminSSOToken, realm);
            ocm.deleteSubOrganization(null, recursive);
            this.getOutputWriter().printlnMessage(this.getResourceString("delete-realm-succeed"));
            this.writeLog(0, Level.INFO, "SUCCEED_DELETE_REALM", params);
        }
        catch (SMSException e) {
            String[] args = new String[]{realm, strRecursive, e.getMessage()};
            this.debugError("DeleteRealm.handleRequest", e);
            this.writeLog(1, Level.INFO, "FAILED_DELETE_REALM", args);
            throw new CLIException(e, 127);
        }
    }
}

