/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.OptionList;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModel;
import com.sun.identity.console.policy.SubjectAddViewBean;
import com.sun.identity.console.policy.model.IdentitySubjectModel;
import com.sun.identity.console.policy.model.IdentitySubjectModelImpl;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.PolicyUtils;
import com.sun.web.ui.view.addremove.CCAddRemove;
import com.sun.web.ui.view.html.CCDropDownMenu;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class IdentitySubjectAddViewBean
extends SubjectAddViewBean {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/IdentitySubjectAdd.jsp";
    private static final String FILTER_TYPE = "tfType";
    private static final String ENTITY_TYPE = "searchEntityType";

    public IdentitySubjectAddViewBean() {
        super("IdentitySubjectAdd", DEFAULT_DISPLAY_URL);
    }

    protected String getPropertyXMLFileName(boolean readonly) {
        return "com/sun/identity/console/propertyPMIdentitySubject.xml";
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        Set defaultValue;
        IdentitySubjectModel model = (IdentitySubjectModel)this.getModel();
        Set values = null;
        if (this.bFilter && (defaultValue = this.getValues()) != null) {
            values = this.getAMIdentity(model, defaultValue);
        }
        super.beginDisplay(event);
        String realmName = (String)this.getPageSessionAttribute("currentRealm");
        CCDropDownMenu menu = (CCDropDownMenu)this.getChild(FILTER_TYPE);
        Map supportedEntityTypes = model.getSupportedEntityTypes(realmName);
        OptionList entityTypes = this.createOptionList(supportedEntityTypes);
        entityTypes.add(0, "policy.subject.select.identity.type", "");
        menu.setOptions(entityTypes);
        menu.setValue((Object)"");
        CCAddRemove child = (CCAddRemove)this.getChild("valuesMultipleChoiceValue");
        child.restoreStateData();
        OptionList selected = this.addRemoveModel.getSelectedOptionList();
        OptionList possible = this.createOptionList(this.getPossibleValues(model, realmName));
        child.resetStateData();
        this.addRemoveModel.setAvailableOptionList(possible);
        List selectedIds = AMAdminUtils.toList(selected);
        this.addRemoveModel.setSelectedOptionList(this.createOptionList(this.getAMIdentity(model, selectedIds)));
    }

    private Set getPossibleValues(IdentitySubjectModel model, String realmName) {
        Set possibleValues = null;
        String entityType = (String)this.getPageSessionAttribute(ENTITY_TYPE);
        if (entityType != null && entityType.length() > 0) {
            String pattern = (String)this.propertySheetModel.getValue("tfFilter");
            try {
                IdSearchResults results = model.getEntityNames(realmName, entityType, pattern);
                int errorCode = results.getErrorCode();
                switch (errorCode) {
                    case 1: {
                        this.setInlineAlertMessage("warning", "message.warning", "message.sizelimit.exceeded");
                        break;
                    }
                    case 2: {
                        this.setInlineAlertMessage("warning", "message.warning", "message.timelimit.exceeded");
                    }
                }
                possibleValues = results.getSearchResults();
                if (possibleValues != null && !possibleValues.isEmpty()) {
                    Set hiddenUsers = model.getSpecialUsers(realmName);
                    possibleValues.removeAll(hiddenUsers);
                    Set selected = IdentitySubjectAddViewBean.getValues(this.addRemoveModel.getSelectedOptionList());
                    if (selected != null && !selected.isEmpty()) {
                        Set amids = this.getAMIdentity(model, selected);
                        possibleValues.removeAll(amids);
                    }
                }
            }
            catch (AMConsoleException e) {
                this.setInlineAlertMessage("error", "message.error", e.getMessage());
            }
        }
        return possibleValues != null ? possibleValues : Collections.EMPTY_SET;
    }

    private Set getAMIdentity(IdentitySubjectModel model, Collection ids) {
        HashSet<AMIdentity> values = new HashSet<AMIdentity>(ids.size() * 2);
        SSOToken token = model.getUserSSOToken();
        for (String id : ids) {
            try {
                AMIdentity amid = IdUtils.getIdentity(token, id);
                values.add(amid);
            }
            catch (IdRepoException e) {
                debug.warning("IdentitySubjectAddViewBean.getAMIdentity", (Throwable)e);
            }
        }
        return values;
    }

    protected Set getValues(String subjectType) throws ModelControlException {
        CCAddRemove child = (CCAddRemove)this.getChild("valuesMultipleChoiceValue");
        child.restoreStateData();
        Set values = IdentitySubjectAddViewBean.getValues(this.addRemoveModel.getSelectedOptionList());
        if (values == null || values.isEmpty()) {
            this.setInlineAlertMessage("error", "message.error", "policy.missing.subject.value");
            values = null;
        }
        return values;
    }

    protected OptionList createOptionList(Set values) {
        OptionList optList = new OptionList();
        if (values != null && !values.isEmpty()) {
            Set amIdentity = values.iterator().next() instanceof String ? this.getAMIdentity((IdentitySubjectModel)this.getModel(), values) : values;
            HashMap<String, String> entries = new HashMap<String, String>(values.size() * 2);
            for (AMIdentity identity : amIdentity) {
                entries.put(IdUtils.getUniversalId(identity), PolicyUtils.getDNDisplayString(identity.getName()));
            }
            optList = this.createOptionList(entries);
        }
        return optList;
    }

    protected AMModel getModelInternal() {
        HttpServletRequest req = this.getRequestContext().getRequest();
        return new IdentitySubjectModelImpl(req, this.getPageSessionAttributes());
    }

    public void handleBtnFilterRequest(RequestInvocationEvent event) {
        CCDropDownMenu menu = (CCDropDownMenu)this.getChild(FILTER_TYPE);
        this.setPageSessionAttribute(ENTITY_TYPE, (Serializable)((Object)((String)menu.getValue())));
        super.handleBtnFilterRequest(event);
    }

    public boolean beginChildDisplay(ChildDisplayEvent event) {
        return true;
    }

    protected Set getValidValues() {
        return Collections.EMPTY_SET;
    }
}

