/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.httpbasic;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationInstance;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.modules.httpbasic.HTTPBasicPrincipal;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.HttpCallback;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.security.AccessController;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public class HTTPBasic
extends AMLoginModule {
    private static final String amAuthHTTPBasic = "amAuthHTTPBasic";
    private static Debug debug = Debug.getInstance((String)"amAuthHTTPBasic");
    private static String MODCONFIG = "iplanet-am-auth-http-basic-module-configured";
    private static String AUTHLEVEL = "iplanet-am-auth-httpbasic-auth-level";
    private Principal userPrincipal = null;
    private ResourceBundle bundle = null;
    private String validatedUserID;
    private String instanceName = null;
    private String userName;
    private String userPassword;
    private Map currentConfig;
    private Map options;
    private AMLoginModule amLoginModule = null;

    public void init(Subject subject, Map sharedState, Map options) {
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthHTTPBasic, locale);
        if (debug.messageEnabled()) {
            debug.message("HttpBasicAuth resbundle locale=" + locale);
        }
        this.options = options;
        this.instanceName = CollectionHelper.getMapAttr((Map)options, (String)MODCONFIG);
        String authLevel = CollectionHelper.getMapAttr((Map)options, (String)AUTHLEVEL);
        if (authLevel != null) {
            try {
                this.setAuthLevel(Integer.parseInt(authLevel));
            }
            catch (Exception e) {
                debug.error("Unable to set auth level " + authLevel, (Throwable)e);
            }
        }
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMAuthenticationManager amAM = new AMAuthenticationManager(adminToken, this.getRequestOrg());
            AMAuthenticationInstance amInstance = amAM.getAuthenticationInstance(this.instanceName);
            this.currentConfig = amInstance.getAttributeValues();
            String moduleType = amInstance.getType();
            String moduleClassName = AuthD.getAuth().getAuthenticatorForName(moduleType);
            Class<?> moduleClass = Class.forName(moduleClassName);
            this.amLoginModule = (AMLoginModule)moduleClass.newInstance();
            CallbackHandler handler = this.getCallbackHandler();
            this.amLoginModule.initialize(subject, handler, sharedState, this.currentConfig);
        }
        catch (Exception exp) {
            debug.error("Could not initialize the module instance" + this.instanceName, (Throwable)exp);
        }
    }

    public int process(Callback[] callbacks, int state) throws LoginException {
        if (this.instanceName == null || this.instanceName.length() == 0) {
            throw new AuthLoginException(amAuthHTTPBasic, "noModule", null);
        }
        boolean status = false;
        HttpServletRequest req = this.getHttpServletRequest();
        HttpServletResponse resp = this.getHttpServletResponse();
        String auth = null;
        if (callbacks != null && callbacks.length != 0) {
            auth = ((HttpCallback)callbacks[0]).getAuthorization();
        }
        if ((req == null || resp == null) && auth == null) {
            debug.message("Servlet Request and Response cannot be null");
            throw new AuthLoginException(amAuthHTTPBasic, "reqRespNull", null);
        }
        try {
            debug.message("Process HTTPBasic Auth started ...");
            if (auth == null || auth.length() == 0) {
                auth = req.getHeader("Authorization");
            }
            if (debug.messageEnabled()) {
                debug.message("AUTH : " + auth);
            }
            int retVal = this.authenticate(auth);
            this.validatedUserID = this.userName;
            return retVal;
        }
        catch (Exception ex) {
            debug.error("login: unknown exception = ", (Throwable)ex);
            this.setFailureID(this.userName);
            if (ex instanceof InvalidPasswordException) {
                throw new InvalidPasswordException(ex);
            }
            throw new AuthLoginException(amAuthHTTPBasic, "sendError", null, ex);
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new HTTPBasicPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.validatedUserID = null;
        this.userPrincipal = null;
    }

    public void nullifyUserdVars() {
        this.bundle = null;
        this.userName = null;
        this.userPassword = null;
        this.currentConfig = null;
        this.options = null;
    }

    private int authenticate(String auth) throws LoginException, IOException {
        if (auth == null || !auth.toUpperCase().startsWith("BASIC")) {
            throw new AuthLoginException(amAuthHTTPBasic, "wrong header", null, null);
        }
        BASE64Decoder decoder = new BASE64Decoder();
        String userPwdEncoded = auth.substring(6);
        String decode = new String(decoder.decodeBuffer(userPwdEncoded));
        int idx = decode.indexOf(58);
        if (idx != -1) {
            this.userPassword = decode.substring(idx + 1);
            this.userName = decode.substring(0, idx);
        }
        this.storeUsernamePasswd(this.userName, this.userPassword);
        return this.authenticateToBackEndModule();
    }

    private int authenticateToBackEndModule() throws LoginException {
        Callback[] callbacks = new Callback[2];
        NameCallback nameCallback = new NameCallback("dummy");
        nameCallback.setName(this.userName);
        callbacks[0] = nameCallback;
        PasswordCallback passwordCallback = new PasswordCallback("dummy", false);
        passwordCallback.setPassword(this.userPassword.toCharArray());
        callbacks[1] = passwordCallback;
        return this.amLoginModule.process(callbacks, 1);
    }
}

