/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.share.AuthXMLUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthXMLRequestParser {
    static Debug debug = Debug.getInstance((String)"amXMLHandler");
    Document xmlDocument = null;
    AuthXMLRequest authXMLRequest = null;
    HttpServletRequest servletReq;

    public AuthXMLRequestParser(String xmlString, HttpServletRequest req) {
        this.servletReq = req;
        try {
            this.xmlDocument = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(xmlString.toString().getBytes("UTF-8")));
            if (debug.messageEnabled()) {
                debug.message("AuthXMLRequestParser: in the constructor");
            }
        }
        catch (Exception e) {
            debug.message("AuthXMLRequest Parser error : ", (Throwable)e);
        }
    }

    public AuthXMLRequest parseXML() throws AuthException {
        try {
            debug.message("entering parseXML");
            if (this.xmlDocument == null) {
                return null;
            }
            this.authXMLRequest = new AuthXMLRequest();
            Element docElem = this.xmlDocument.getDocumentElement();
            if (docElem != null) {
                Node abortNode;
                Node logoutNode;
                Node submitReqNode;
                Node loginNode;
                AuthContextLocal authContext;
                String orgName;
                Node queryInfoNode;
                Node newAuthContextNode;
                Node appSSOTokenNode;
                String temp = docElem.getAttribute("version");
                if (debug.messageEnabled()) {
                    debug.message("Request Version is.. : " + temp);
                }
                if (temp != null) {
                    this.authXMLRequest.setRequestVersion(temp);
                }
                Node requestNode = XMLUtils.getChildNode((Node)docElem, (String)"Request");
                String authIdentifier = null;
                if (requestNode != null) {
                    authIdentifier = this.parseNodeAttributes(requestNode, "authIdentifier");
                    if (debug.messageEnabled()) {
                        debug.message("AuthIdentifier is : " + authIdentifier);
                    }
                    this.authXMLRequest.setAuthIdentifier(authIdentifier);
                }
                if ((appSSOTokenNode = XMLUtils.getChildNode((Node)requestNode, (String)"AppSSOToken")) != null) {
                    debug.message("Got the SSO Token node: ");
                    String appSSOTokenID = XMLUtils.getValueOfValueNode((Node)appSSOTokenNode);
                    if (appSSOTokenID != null) {
                        if (debug.messageEnabled()) {
                            debug.message("Got the Session Id: " + appSSOTokenID);
                        }
                        this.authXMLRequest.setAppSSOTokenID(appSSOTokenID);
                    }
                }
                if ((newAuthContextNode = XMLUtils.getChildNode((Node)requestNode, (String)"NewAuthContext")) != null) {
                    String orgName2 = this.parseNodeAttributes(newAuthContextNode, "orgName");
                    this.authXMLRequest.setOrgName(orgName2);
                    this.authXMLRequest.setRequestType(0);
                    AuthContextLocal authContext2 = AuthUtils.getAuthContext(orgName2, authIdentifier, false, this.servletReq, null, null);
                    this.authXMLRequest.setAuthContext(authContext2);
                }
                if ((queryInfoNode = XMLUtils.getChildNode((Node)requestNode, (String)"QueryInformation")) != null) {
                    String queryType = this.parseNodeAttributes(queryInfoNode, "requestedInformation");
                    this.authXMLRequest.setRequestInformation(queryType);
                    this.authXMLRequest.setRequestType(3);
                    orgName = this.parseNodeAttributes(queryInfoNode, "orgName");
                    authContext = null;
                    authContext = orgName != null ? AuthUtils.getAuthContext(orgName, this.servletReq) : AuthUtils.getAuthContext(null, authIdentifier, false);
                    this.authXMLRequest.setAuthContext(authContext);
                }
                if ((loginNode = XMLUtils.getChildNode((Node)requestNode, (String)"Login")) != null) {
                    String forceAuth;
                    String localeAttr;
                    String hostName;
                    debug.message("found login node !!");
                    orgName = this.parseNodeAttributes(loginNode, "orgName");
                    authContext = null;
                    if (orgName != null) {
                        this.authXMLRequest.setOrgName(orgName);
                    }
                    if ((hostName = this.parseNodeAttributes(loginNode, "hostName")) != null) {
                        this.authXMLRequest.setHostName(hostName);
                    }
                    if ((localeAttr = this.parseNodeAttributes(loginNode, "Locale")) != null) {
                        this.authXMLRequest.setLocale(localeAttr);
                    }
                    if ((forceAuth = this.parseNodeAttributes(loginNode, "forceAuth")) != null) {
                        this.authXMLRequest.setForceAuth(forceAuth);
                        if (debug.messageEnabled()) {
                            debug.message("AuthXMLRequestParser.parseXML: Got the force auth flag: " + forceAuth);
                        }
                    }
                    boolean forceAuthBool = Boolean.parseBoolean(forceAuth);
                    this.authXMLRequest.setRequestType(1);
                    this.parseLoginNodeElements(loginNode, this.authXMLRequest);
                    AuthContext.IndexType indexType = this.authXMLRequest.getIndexType();
                    String indexTypeParam = this.convertIndexType(indexType);
                    authContext = AuthUtils.getAuthContext(orgName, authIdentifier, false, this.servletReq, indexTypeParam, this.authXMLRequest, forceAuthBool);
                    this.authXMLRequest.setAuthContext(authContext);
                    if (localeAttr != null) {
                        LoginState loginState = authContext.getLoginState();
                        loginState.setRemoteLocale(localeAttr);
                    }
                }
                if ((submitReqNode = XMLUtils.getChildNode((Node)requestNode, (String)"SubmitRequirements")) != null) {
                    this.authXMLRequest.setRequestType(2);
                    authContext = AuthUtils.getAuthContext(this.servletReq, authIdentifier);
                    this.authXMLRequest.setAuthContext(authContext);
                    Callback[] callbacks = AuthUtils.getRecdCallback(authContext);
                    this.parseSubmitReqElements(submitReqNode, this.authXMLRequest, callbacks);
                }
                if ((logoutNode = XMLUtils.getChildNode((Node)requestNode, (String)"Logout")) != null) {
                    this.authXMLRequest.setRequestType(4);
                    AuthContextLocal authContext3 = AuthUtils.getAuthContext(null, authIdentifier, true);
                    this.authXMLRequest.setAuthContext(authContext3);
                }
                if ((abortNode = XMLUtils.getChildNode((Node)requestNode, (String)"Abort")) != null) {
                    this.authXMLRequest.setRequestType(5);
                    AuthContextLocal authContext4 = AuthUtils.getAuthContext(null, authIdentifier, true);
                    this.authXMLRequest.setAuthContext(authContext4);
                }
            }
        }
        catch (AuthException e) {
            throw e;
        }
        catch (Exception e) {
            debug.message("Error in parseXML: : ", (Throwable)e);
        }
        return this.authXMLRequest;
    }

    private String convertIndexType(AuthContext.IndexType index) {
        String indexTypeParam = null;
        if (index == AuthContext.IndexType.SERVICE) {
            indexTypeParam = "service";
        } else if (index == AuthContext.IndexType.LEVEL) {
            indexTypeParam = "authlevel";
        } else if (index == AuthContext.IndexType.ROLE) {
            indexTypeParam = "role";
        } else if (index == AuthContext.IndexType.MODULE_INSTANCE) {
            indexTypeParam = "module";
        } else if (index == AuthContext.IndexType.USER) {
            indexTypeParam = "user";
        } else if (index == AuthContext.IndexType.COMPOSITE_ADVICE) {
            indexTypeParam = "sunamcompositeadvice";
        } else if (index == AuthContext.IndexType.RESOURCE) {
            indexTypeParam = "resource";
        }
        return indexTypeParam;
    }

    private String parseNodeAttributes(Node requestNode, String attrName) {
        try {
            if (requestNode == null) {
                return null;
            }
            String attrValue = XMLUtils.getNodeAttributeValue((Node)requestNode, (String)attrName);
            if (debug.messageEnabled()) {
                debug.message("Attr Value is : " + attrValue);
            }
            return attrValue;
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("Error getting " + attrName);
                debug.message("Exception ", (Throwable)e);
            }
            return null;
        }
    }

    private void parseLoginNodeElements(Node loginNode, AuthXMLRequest authXMLRequest) {
        Node envNode;
        Node paramsNode;
        Node localeNode;
        authXMLRequest.setRequestType(1);
        Node indexTypeNamePair = XMLUtils.getChildNode((Node)loginNode, (String)"IndexTypeNamePair");
        if (indexTypeNamePair != null) {
            String indexType = this.parseNodeAttributes(indexTypeNamePair, "indexType");
            if (debug.messageEnabled()) {
                debug.message("indexType is .. : " + indexType);
            }
            authXMLRequest.setIndexType(indexType);
            Node indexNameNode = XMLUtils.getChildNode((Node)indexTypeNamePair, (String)"IndexName");
            if (indexNameNode != null) {
                String indexName = XMLUtils.getValueOfValueNode((Node)indexNameNode);
                if (debug.messageEnabled()) {
                    debug.message("indexName is .. : " + indexName);
                }
                authXMLRequest.setIndexName(indexName);
            }
            authXMLRequest.setRequestType(6);
        }
        if ((localeNode = XMLUtils.getChildNode((Node)loginNode, (String)"Locale")) != null) {
            authXMLRequest.setLocale(XMLUtils.getValueOfValueNode((Node)localeNode));
        }
        if ((paramsNode = XMLUtils.getChildNode((Node)loginNode, (String)"Params")) != null) {
            authXMLRequest.setParams(XMLUtils.getValueOfValueNode((Node)paramsNode));
        }
        if ((envNode = XMLUtils.getChildNode((Node)loginNode, (String)"Environment")) != null) {
            NodeList cList = envNode.getChildNodes();
            ArrayList<String> values = new ArrayList<String>();
            int len = cList.getLength();
            for (int i = 0; i < len; ++i) {
                Node node = cList.item(i);
                if (!node.getNodeName().equals("EnvValue")) continue;
                values.add(XMLUtils.getValueOfValueNode((Node)node));
            }
            if (!values.isEmpty()) {
                authXMLRequest.setEnvironment(values);
            }
        }
    }

    void parseSubmitReqElements(Node submitReqNode, AuthXMLRequest authXMLRequest, Callback[] recdCallbacks) {
        Node callbacksNode = XMLUtils.getChildNode((Node)submitReqNode, (String)"Callbacks");
        Callback[] submittedCallbacks = AuthXMLUtils.getCallbacks(callbacksNode, true, recdCallbacks);
        authXMLRequest.setSubmittedCallbacks(submittedCallbacks);
    }
}

