/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.delegation.model.DelegationConfig;
import com.sun.identity.console.property.MultiServicesPropertyXMLBuilder;
import com.sun.identity.console.property.PropertyXMLBuilderBase;
import com.sun.identity.console.realm.model.RMRealmModel;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import java.security.AccessController;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class RMRealmModelImpl
extends AMModelBase
implements RMRealmModel {
    private static SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    private static final String PROPERTY_SECTION_CREATION_GENERAL = "<section name=\"general\" defaultValue=\"realm.sectionHeader.general\"><property required=\"true\"><label name=\"lblName\" defaultValue=\"authDomain.attribute.label.name\" labelFor=\"tfName\" /><cc name=\"tfName\" tagclass=\"com.sun.web.ui.taglib.html.CCTextFieldTag\" /></property><property required=\"true\"><label name=\"lblParent\" defaultValue=\"realm.parent.label\" labelFor=\"tfParent\" /><cc name=\"tfParent\" tagclass=\"com.sun.web.ui.taglib.html.CCSelectableListTag\" ><attribute name=\"size\" value=\"10\" /></cc></property></section>";

    public RMRealmModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public String getCreateRealmPropertyXML() throws AMConsoleException {
        StringBuffer buff = new StringBuffer(2000);
        buff.append(PropertyXMLBuilderBase.getXMLDefinitionHeader()).append("<propertysheet>\n").append(PROPERTY_SECTION_CREATION_GENERAL);
        this.getPropertyXML(buff, false);
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    public String getRealmProfilePropertyXML(String realmName, String viewbeanClassName) throws AMConsoleException {
        DelegationConfig dConfig = DelegationConfig.getInstance();
        boolean canModify = dConfig.hasPermission(realmName, null, "MODIFY", this, viewbeanClassName);
        StringBuffer buff = new StringBuffer(2000);
        buff.append(PropertyXMLBuilderBase.getXMLDefinitionHeader()).append("<propertysheet>\n");
        this.getPropertyXML(buff, !canModify);
        buff.append("</propertysheet>\n");
        return buff.toString();
    }

    private void getPropertyXML(StringBuffer buff, boolean readonly) throws AMConsoleException {
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(adminSSOToken, "/");
            Set serviceSchemas = orgMgr.getServiceSchemas();
            Iterator iter = serviceSchemas.iterator();
            while (iter.hasNext()) {
                MultiServicesPropertyXMLBuilder xmlBuilder = new MultiServicesPropertyXMLBuilder((ServiceSchema)iter.next(), this);
                xmlBuilder.setAllAttributeReadOnly(readonly);
                buff.append(xmlBuilder.getXML(false));
            }
        }
        catch (SSOException e) {
            debug.error("RMRealmModelImpl.getPropertyXML", (Throwable)((Object)e));
        }
        catch (SMSException e) {
            debug.error("RMRealmModelImpl.getPropertyXML", (Throwable)e);
        }
    }

    public void createSubRealm(String parentRealm, String name, Map attrValues) throws AMConsoleException {
        if (parentRealm == null || parentRealm.length() == 0) {
            parentRealm = "/";
        }
        String[] params = new String[]{parentRealm, name};
        this.logEvent("ATTEMPT_CREATE_REALM", params);
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.getUserSSOToken(), parentRealm);
            Map map = this.mapAttributeValuesToServiceName(attrValues);
            orgMgr.createSubOrganization(name, map);
            this.logEvent("SUCCEED_CREATE_REALM", params);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{parentRealm, name, strError};
            this.logEvent("SMS_EXCEPTION_CREATE_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public void deleteSubRealms(String parentRealm, Collection names) throws AMConsoleException {
        String[] params = new String[2];
        params[0] = parentRealm;
        String currentName = "";
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.getUserSSOToken(), parentRealm);
            List orderedByLength = AMAdminUtils.orderByStringLength(names);
            Iterator iter = orderedByLength.iterator();
            while (iter.hasNext()) {
                String name;
                currentName = name = (String)iter.next();
                params[1] = name;
                this.logEvent("ATTEMPT_DELETE_REALM", params);
                orgMgr.deleteSubOrganization(name, true);
                this.logEvent("SUCCEED_DELETE_REALM", params);
            }
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{parentRealm, currentName, strError};
            this.logEvent("SMS_EXCEPTION_DELETE_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public Map getDefaultValues() {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.getUserSSOToken(), "/");
            Set serviceSchemas = orgMgr.getServiceSchemas();
            for (ServiceSchema ss : serviceSchemas) {
                String serviceName = ss.getServiceName();
                Set attrSchemas = ss.getAttributeSchemas();
                for (AttributeSchema as : attrSchemas) {
                    if (as.getType() != AttributeSchema.Type.SINGLE_CHOICE) continue;
                    map.put(serviceName + "_" + as.getName(), as.getDefaultValues());
                }
            }
        }
        catch (SMSException e) {
            debug.error("RMRealmModelImpl.getDefaultValues", (Throwable)e);
        }
        return map;
    }

    public Map getDataMap() {
        HashMap<String, Set> map = new HashMap<String, Set>();
        try {
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.getUserSSOToken(), "/");
            Set serviceSchemas = orgMgr.getServiceSchemas();
            for (ServiceSchema ss : serviceSchemas) {
                String serviceName = ss.getServiceName();
                Set attrSchemas = ss.getAttributeSchemas();
                for (AttributeSchema as : attrSchemas) {
                    map.put(serviceName + "_" + as.getName(), Collections.EMPTY_SET);
                }
            }
        }
        catch (SMSException e) {
            debug.error("RMRealmModelImpl.getDataMap", (Throwable)e);
        }
        return map;
    }

    public Map getAttributeValues(String name) throws AMConsoleException {
        String[] param = new String[]{name};
        this.logEvent("ATTEMPT_GET_ATTR_VALUES_OF_REALM", param);
        try {
            HashMap<String, Set> map = new HashMap<String, Set>();
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.getUserSSOToken(), name);
            Set serviceSchemas = orgMgr.getServiceSchemas();
            for (ServiceSchema ss : serviceSchemas) {
                String serviceName = ss.getServiceName();
                Map values = orgMgr.getAttributes(serviceName);
                Set attributeSchemas = ss.getAttributeSchemas();
                for (AttributeSchema as : attributeSchemas) {
                    String i18nKey = as.getI18NKey();
                    if (i18nKey == null || i18nKey.trim().length() <= 0) continue;
                    String attrName = as.getName();
                    Set val = (Set)values.get(attrName);
                    if (val == null) {
                        val = Collections.EMPTY_SET;
                    }
                    map.put(serviceName + "_" + attrName, val);
                }
            }
            this.logEvent("SUCCEED_GET_ATTR_VALUES_OF_REALM", param);
            return map;
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("SMS_EXCEPTION_GET_ATTR_VALUES_OF_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    public void setAttributeValues(String name, Map attributeValues) throws AMConsoleException {
        try {
            String[] param = new String[]{name};
            this.logEvent("ATTEMPT_SET_ATTR_VALUES_OF_REALM", param);
            OrganizationConfigManager orgMgr = new OrganizationConfigManager(this.getUserSSOToken(), name);
            Map map = this.mapAttributeValuesToServiceName(attributeValues);
            for (String serviceName : map.keySet()) {
                orgMgr.setAttributes(serviceName, (Map)map.get(serviceName));
            }
            this.logEvent("SUCCEED_SET_ATTR_VALUES_OF_REALM", param);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{name, strError};
            this.logEvent("SMS_EXCEPTION_SET_ATTR_VALUES_OF_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private Map mapAttributeValuesToServiceName(Map attributeValues) {
        HashMap mapServices = null;
        if (attributeValues != null && !attributeValues.isEmpty()) {
            mapServices = new HashMap();
            for (String attrName : attributeValues.keySet()) {
                int idx = attrName.indexOf(95);
                if (idx != -1) {
                    String serviceName = attrName.substring(0, idx);
                    String attributeName = attrName.substring(idx + 1);
                    HashMap map = (HashMap)mapServices.get(serviceName);
                    if (map == null) {
                        map = new HashMap();
                        mapServices.put(serviceName, map);
                    }
                    map.put(attributeName, attributeValues.get(attrName));
                    continue;
                }
                debug.error("RMRealmModelImpl.mapAttributeValuesToServiceName: unknown attribute, " + attrName);
            }
        }
        return mapServices == null ? Collections.EMPTY_MAP : mapServices;
    }
}

