/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSNotificationManager;
import com.sun.identity.sm.SMSObjectDB;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.ldap.EmbeddedSearchResultIterator;
import com.sun.identity.sm.ldap.LDAPEventManager;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ModificationType;
import org.opends.server.types.RawAttribute;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

public class SMSEmbeddedLdapObject
extends SMSObjectDB
implements SMSObjectListener {
    static int entriesPresentCacheSize = 1000;
    static boolean initializedNotification;
    static Set entriesPresent;
    static Set entriesNotPresent;
    static ResourceBundle bundle;
    static boolean initialized;
    static Debug debug;
    static LinkedHashSet OU_ATTR;
    static LinkedHashSet O_ATTR;
    static InternalClientConnection icConn;
    static LinkedHashSet smsAttributes;
    static final String SMS_EMBEDDED_LDAP_OBJECT_SEARCH_LIMIT = "com.sun.identity.sm.sms_embedded_ldap_object_search_limit";

    public SMSEmbeddedLdapObject() throws SMSException {
        this.initialize();
    }

    private synchronized void initialize() throws SMSException {
        if (initialized) {
            return;
        }
        debug = Debug.getInstance((String)"amSMSEmbeddedLdap");
        AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
        bundle = amCache.getResBundle("amSDK", Locale.ENGLISH);
        OU_ATTR = new LinkedHashSet(1);
        OU_ATTR.add(this.getNamingAttribute());
        O_ATTR = new LinkedHashSet(1);
        O_ATTR.add(this.getOrgNamingAttribute());
        icConn = InternalClientConnection.getRootConnection();
        try {
            String serviceDN = "ou=services," + this.getRootSuffix();
            if (!SMSEmbeddedLdapObject.entryExists(serviceDN)) {
                HashMap attrs = new HashMap();
                HashSet<String> attrValues = new HashSet<String>();
                attrValues.add("top");
                attrValues.add("organizationalunit");
                attrs.put("objectclass", attrValues);
                SMSEmbeddedLdapObject.create(serviceDN, attrs);
            }
        }
        catch (Exception e) {
            debug.error("SMSEmbeddedLdapObject.initialize: Unable to initalize(exception):", (Throwable)e);
            throw new SMSException("amSDK", "ums-configmanagererror", null);
        }
        String[] smsAttrs = this.getAttributeNames();
        smsAttributes = new LinkedHashSet(smsAttrs.length);
        for (int i = 0; i < smsAttrs.length; ++i) {
            smsAttributes.add(smsAttrs[i]);
        }
        initialized = true;
    }

    private void initializeNotification() {
        if (!initializedNotification) {
            if (SMSNotificationManager.isCacheEnabled()) {
                SMSNotificationManager.getInstance().registerCallbackHandler(this);
            }
            initializedNotification = true;
        }
    }

    public Map read(SSOToken token, String dn) throws SMSException, SSOException {
        if (dn == null || dn.length() == 0) {
            debug.error("SMSEmbeddedLdapObject.read: Null or Empty DN=" + dn);
            throw new SMSException("", "sms-NO_SUCH_OBJECT");
        }
        if (!DN.isDN((String)dn)) {
            debug.warning("SMSEmbeddedLdapObject: Invalid DN=" + dn);
            Object[] args = new String[]{dn};
            throw new SMSException("amSDK", "sms-INVALID_DN", args);
        }
        if (SMSNotificationManager.isCacheEnabled() && entriesNotPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject:read Entry not present: " + dn + " (checked in cached)");
            }
            return null;
        }
        try {
            InternalSearchOperation iso = icConn.processSearch(dn, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, "(|(objectclass=*)(objectclass=ldapsubentry))", smsAttributes);
            ResultCode resultCode = iso.getResultCode();
            if (resultCode == ResultCode.SUCCESS) {
                LinkedList searchResult = iso.getSearchEntries();
                if (!searchResult.isEmpty()) {
                    SearchResultEntry entry = (SearchResultEntry)searchResult.get(0);
                    List attributes = entry.getAttributes();
                    return EmbeddedSearchResultIterator.convertLDAPAttributeSetToMap(attributes);
                }
                return null;
            }
            if (resultCode == ResultCode.NO_SUCH_OBJECT) {
                this.objectChanged(dn, 1);
                if (debug.messageEnabled()) {
                    debug.message("SMSEmbeddedLdapObject.read: entry not present:" + dn);
                }
                return null;
            }
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject.read: Error in accessing entry DN: " + dn + ", error code = " + resultCode);
            }
            throw new SMSException("", "sms-entry-cannot-access");
        }
        catch (DirectoryException dex) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject.read: Error in accessing entry DN: " + dn, (Throwable)dex);
            }
            throw new SMSException(dex, "sms-entry-cannot-access");
        }
    }

    public void create(SSOToken token, String dn, Map attrs) throws SMSException, SSOException {
        SMSEmbeddedLdapObject.create(dn, attrs);
        this.objectChanged(dn, 0);
    }

    private static void create(String dn, Map attrs) throws SMSException, SSOException {
        List attrList = SMSEmbeddedLdapObject.copyMapToAttrList(attrs);
        AddOperation ao = icConn.processAdd(dn, attrList);
        ResultCode resultCode = ao.getResultCode();
        if (resultCode == ResultCode.SUCCESS) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject.create: Successfully created entry: " + dn);
            }
        } else if (resultCode == ResultCode.ENTRY_ALREADY_EXISTS) {
            debug.warning("SMSEmbeddedLdapObject.create: Entry Already Exists Error for DN" + dn);
        } else {
            debug.error("SMSEmbeddedLdapObject.create: Error creating entry: " + dn + ", error code = " + resultCode);
            throw new SMSException("", "sms-entry-cannot-create");
        }
    }

    public void modify(SSOToken token, String dn, ModificationItem[] mods) throws SMSException, SSOException {
        List modList = SMSEmbeddedLdapObject.copyModItemsToLDAPModList(mods);
        ModifyOperation mo = icConn.processModify(dn, modList);
        ResultCode resultCode = mo.getResultCode();
        if (resultCode == ResultCode.SUCCESS) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject.modify: Successfully modified entry: " + dn);
            }
        } else {
            debug.error("SMSEmbeddedLdapObject.modify: Error modifying entry " + dn + " by Principal: " + token.getPrincipal().getName() + ", error code = " + resultCode);
            throw new SMSException("", "sms-entry-cannot-modify");
        }
    }

    public void delete(SSOToken token, String dn) throws SMSException, SSOException {
        for (String entry : this.subEntries(token, dn, "*", 0, false, false)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject: deleting sub-entry: " + entry);
            }
            this.delete(token, this.getNamingAttribute() + "=" + entry + "," + dn);
        }
        Set subOrgNames = this.searchSubOrgNames(token, dn, "*", 0, false, false, false);
        for (String subOrg : subOrgNames) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject: deleting suborganization: " + subOrg);
            }
            this.delete(token, subOrg);
        }
        DeleteOperation dop = icConn.processDelete(dn);
        ResultCode resultCode = dop.getResultCode();
        if (resultCode != ResultCode.SUCCESS) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject.delete: Unable to delete entry:" + dn);
            }
            throw new SMSException("", "sms-entry-cannot-delete");
        }
        this.objectChanged(dn, 1);
    }

    public Set subEntries(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (filter == null) {
            filter = "*";
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject: SubEntries search: " + dn);
        }
        String sfilter = "(objectClass=*)";
        if (!filter.equals("*")) {
            String[] objs = new String[]{filter};
            sfilter = MessageFormat.format(this.getSearchFilter(), objs);
        }
        Set answer = this.getSubEntries(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder);
        return answer;
    }

    private Set getSubEntries(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        try {
            InternalSearchOperation iso = icConn.processSearch(dn, SearchScope.SINGLE_LEVEL, DereferencePolicy.NEVER_DEREF_ALIASES, numOfEntries, 0, false, filter, OU_ATTR, null, null);
            ResultCode resultCode = iso.getResultCode();
            if (resultCode == ResultCode.NO_SUCH_OBJECT) {
                if (debug.messageEnabled()) {
                    debug.message("SMSEmbeddedLdapObject.getSubEntries(): entry not present:" + dn);
                }
            } else if (resultCode == ResultCode.SIZE_LIMIT_EXCEEDED) {
                if (debug.messageEnabled()) {
                    debug.message("SMSEmbeddedLdapObject.getSubEntries: size limit " + numOfEntries + " exceeded for " + "sub-entries: " + dn);
                }
            } else if (resultCode != ResultCode.SUCCESS) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSEmbeddedLdapObject.getSubEntries: Unable to search for sub-entries: " + dn);
                }
                throw new SMSException("", "sms-entry-cannot-search");
            }
            OrderedSet answer = new OrderedSet();
            LinkedList searchResult = iso.getSearchEntries();
            for (SearchResultEntry entry : searchResult) {
                String edn = entry.getDN().toString();
                if (!edn.toLowerCase().startsWith("ou=")) continue;
                String rdn = entry.getDN().getRDN().getAttributeValue(0).getStringValue();
                answer.add(rdn);
            }
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject.getSubEntries: Successfully obtained sub-entries for : " + dn);
            }
            return answer;
        }
        catch (DirectoryException dex) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject.getSubEntries: Unable to search for sub-entries: " + dn, (Throwable)dex);
            }
            throw new SMSException(dex, "sms-entry-cannot-search");
        }
    }

    public Set schemaSubEntries(SSOToken token, String dn, String filter, String sidFilter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject: schemaSubEntries search: " + dn);
        }
        String[] objs = new String[]{filter, sidFilter};
        String sfilter = MessageFormat.format(this.getServiceIdSearchFilter(), objs);
        Set answer = this.getSubEntries(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder);
        return answer;
    }

    public String toString() {
        return "SMSEmbeddedLdapObject";
    }

    public Iterator search(SSOToken token, String startDN, String filter, Set excludes) throws SSOException, SMSException {
        InternalSearchOperation iso = this.searchObjects(startDN, filter, SearchScope.WHOLE_SUBTREE, 0, false, false);
        ResultCode resultCode = iso.getResultCode();
        if (resultCode != ResultCode.SUCCESS && debug.warningEnabled()) {
            debug.warning("SMSEmbeddedLdapObject.searchEx: Unable to search. startDN = " + startDN + ", filter = " + filter + ", resultCode = " + resultCode);
            throw new SMSException("", "sms-error-in-searching");
        }
        HashMap answer = new HashMap();
        LinkedList searchResult = iso.getSearchEntries();
        return new EmbeddedSearchResultIterator(searchResult, excludes);
    }

    public Set search(SSOToken token, String startDN, String filter) throws SSOException, SMSException {
        InternalSearchOperation iso;
        ResultCode resultCode;
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject.search: startDN = " + startDN + ", filter: " + filter);
        }
        if ((resultCode = (iso = this.searchObjects(startDN, filter, SearchScope.WHOLE_SUBTREE, 0, false, false)).getResultCode()) != ResultCode.SUCCESS) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject.search: Unable to search. startDN = " + startDN + ", filter = " + filter + ", resultCode = " + resultCode);
            }
            throw new SMSException("", "sms-error-in-searching");
        }
        OrderedSet answer = new OrderedSet();
        LinkedList searchResult = iso.getSearchEntries();
        for (SearchResultEntry entry : searchResult) {
            String dn = entry.getDN().toString();
            answer.add(dn);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject.search: returned successfully: " + filter + "\n\tObjects: " + answer);
        }
        return answer;
    }

    private InternalSearchOperation searchObjects(String startDN, String filter, SearchScope scope, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SSOException, SMSException {
        try {
            InternalSearchOperation iso = icConn.processSearch(startDN, scope, DereferencePolicy.NEVER_DEREF_ALIASES, numOfEntries, 0, false, filter, null, null, null);
            return iso;
        }
        catch (DirectoryException dex) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject.searchObjects: Unable to search. startDN = " + startDN + ", filter = " + filter, (Throwable)dex);
            }
            throw new SMSException(dex, "sms-error-in-searching");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(SSOToken token, String dn) {
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject.entryExists: checking if entry exists: " + dn);
        }
        dn = new DN(dn).toRFCString().toLowerCase();
        if (SMSNotificationManager.isCacheEnabled() && entriesPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject.entryExists: entry present in cache: " + dn);
            }
            return true;
        }
        if (SMSNotificationManager.isCacheEnabled() && entriesNotPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject.entryExists: entry present in not-present-cache: " + dn);
            }
            return false;
        }
        boolean entryExists = SMSEmbeddedLdapObject.entryExists(dn);
        if (entryExists && SMSNotificationManager.isCacheEnabled()) {
            this.initializeNotification();
            entriesPresent.add(dn);
            if (entriesPresent.size() > entriesPresentCacheSize) {
                Set set = entriesPresent;
                synchronized (set) {
                    Iterator items = entriesPresent.iterator();
                    if (items.hasNext()) {
                        items.next();
                        items.remove();
                    }
                }
            }
        } else if (SMSNotificationManager.isCacheEnabled()) {
            this.initializeNotification();
            entriesNotPresent.add(dn);
            if (entriesNotPresent.size() > entriesPresentCacheSize) {
                Set set = entriesNotPresent;
                synchronized (set) {
                    Iterator items = entriesNotPresent.iterator();
                    if (items.hasNext()) {
                        items.next();
                        items.remove();
                    }
                }
            }
        }
        return entryExists;
    }

    private static boolean entryExists(String dn) {
        try {
            InternalSearchOperation iso = icConn.processSearch(dn, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, "(|(objectclass=*)(objectclass=ldapsubentry))", null);
            ResultCode resultCode = iso.getResultCode();
            if (resultCode == ResultCode.SUCCESS) {
                return true;
            }
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject:entryExists: " + dn + "does not exist. resultCode = " + resultCode);
            }
            return false;
        }
        catch (DirectoryException dex) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject:entryExists: " + dn + "does not exist.", (Throwable)dex);
            }
            return false;
        }
    }

    public void registerCallbackHandler(SMSObjectListener changeListener) throws SMSException {
        LDAPEventManager.addObjectChangeListener(changeListener);
    }

    public void deregisterCallbackHandler(String id) {
        LDAPEventManager.removeObjectChangeListener();
    }

    private static List copyMapToAttrList(Map attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        ArrayList<LDAPAttribute> attrList = new ArrayList<LDAPAttribute>(attrs.size());
        for (String attrName : attrs.keySet()) {
            Set values = (Set)attrs.get(attrName);
            if (values == null || values.isEmpty()) continue;
            ArrayList valueList = new ArrayList();
            valueList.addAll(values);
            attrList.add(new LDAPAttribute(attrName, valueList));
        }
        return attrList;
    }

    private static List copyModItemsToLDAPModList(ModificationItem[] mods) throws SMSException {
        if (mods == null || mods.length == 0) {
            return null;
        }
        ArrayList<LDAPModification> modList = new ArrayList<LDAPModification>(mods.length);
        try {
            for (int i = 0; i < mods.length; ++i) {
                Attribute dAttr = mods[i].getAttribute();
                String attrName = dAttr.getID();
                ArrayList<String> values = new ArrayList<String>();
                NamingEnumeration<?> ne = dAttr.getAll();
                while (ne.hasMore()) {
                    values.add((String)ne.next());
                }
                ModificationType modType = null;
                switch (mods[i].getModificationOp()) {
                    case 1: {
                        modType = ModificationType.ADD;
                        break;
                    }
                    case 2: {
                        modType = ModificationType.REPLACE;
                        break;
                    }
                    case 3: {
                        modType = ModificationType.DELETE;
                    }
                }
                if (modType == null) continue;
                modList.add(new LDAPModification(modType, (RawAttribute)new LDAPAttribute(attrName, values)));
            }
        }
        catch (NamingException nne) {
            throw new SMSException(nne, "sms-cannot-copy-fromModItemToModSet");
        }
        return modList;
    }

    public void objectChanged(String dn, int type) {
        dn = new DN(dn).toRFCString().toLowerCase();
        if (type == 1) {
            entriesPresent.remove(dn);
        } else if (type == 0) {
            entriesNotPresent.remove(dn);
        }
    }

    public void allObjectsChanged() {
        if (SMSEntry.debug.warningEnabled()) {
            SMSEntry.debug.warning("SMSEmbeddedLDAPObject.allObjectsChanged: got notifications, all objects changed");
        }
        entriesPresent.clear();
        entriesNotPresent.clear();
    }

    public Set searchSubOrgNames(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject.searchSubOrgNames: search: " + dn);
        }
        String[] objs = new String[]{filter};
        String FILTER_PATTERN_ORG = "(&(objectclass=sunRealmService)(o={0}))";
        String sfilter = MessageFormat.format(FILTER_PATTERN_ORG, objs);
        Set answer = this.searchSubOrganizationNames(dn, sfilter, numOfEntries, sortResults, ascendingOrder, recursive);
        return answer;
    }

    private Set searchSubOrganizationNames(String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        SearchScope scope = recursive ? SearchScope.WHOLE_SUBTREE : SearchScope.SINGLE_LEVEL;
        InternalSearchOperation iso = this.searchObjects(dn, filter, scope, numOfEntries, sortResults, ascendingOrder);
        ResultCode resultCode = iso.getResultCode();
        if (resultCode == ResultCode.NO_SUCH_OBJECT) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject.searchSubOrganizationNames: suborg not present:" + dn);
            }
        } else if (resultCode == ResultCode.SIZE_LIMIT_EXCEEDED) {
            if (debug.messageEnabled()) {
                debug.message("SMSEmbeddedLdapObject.searchSubOrganizationNames: size limit exceeded. numOfEntries = " + numOfEntries + ", dn = " + dn);
            }
        } else if (resultCode != ResultCode.SUCCESS) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEmbeddedLdapObject.searchSubOrganizationNames: Unable to search. dn = " + dn + ", filter = " + filter + ", resultCode = " + resultCode);
            }
            throw new SMSException("", "sms-suborg-cannot-search");
        }
        OrderedSet answer = new OrderedSet();
        LinkedList searchResult = iso.getSearchEntries();
        for (SearchResultEntry entry : searchResult) {
            String edn = entry.getDN().toString();
            answer.add(edn);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject.searchSubOrganizationName: Successfully obtained suborganization names for : " + dn);
            debug.message("SMSEmbeddedLdapObject.searchSubOrganizationName: Successfully obtained suborganization names  : " + answer.toString());
        }
        return answer;
    }

    public Set searchOrganizationNames(SSOToken token, String dn, int numOfEntries, boolean sortResults, boolean ascendingOrder, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject.searchOrganizationNames search dn: " + dn);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(&");
        for (String val : values) {
            sb.append("(|(").append("sunxmlKeyValue").append("=").append(serviceName).append("-").append(attrName).append("=").append(val).append(")");
            sb.append("(").append("sunxmlKeyValue").append("=").append(attrName).append("=").append(val).append("))");
        }
        sb.append(")");
        String filter = sb.toString();
        String FILTER_PATTERN_SEARCH_ORG = "{0}";
        String dataStore = SMSEntry.getDataStore(token);
        if (dataStore != null && !dataStore.equals(SMSEntry.DATASTORE_ACTIVE_DIR)) {
            FILTER_PATTERN_SEARCH_ORG = "(|(&(objectclass=sunRealmService){0})(&(objectclass=sunServiceComponent){0}))";
        }
        String[] objs = new String[]{filter};
        String sfilter = MessageFormat.format(FILTER_PATTERN_SEARCH_ORG, objs);
        if (debug.messageEnabled()) {
            debug.message("SMSEmbeddedLdapObject.searchOrganizationNames: orgNames search filter: " + sfilter);
        }
        Set answer = this.searchSubOrganizationNames(dn, sfilter, numOfEntries, sortResults, ascendingOrder, true);
        return answer;
    }

    public void shutdown() {
    }

    static {
        entriesPresent = Collections.synchronizedSet(new LinkedHashSet());
        entriesNotPresent = Collections.synchronizedSet(new LinkedHashSet());
        initialized = false;
    }
}

