/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tools.logdoc;

import com.sun.identity.tools.logdoc.LogHtmlTemplate;
import com.sun.identity.tools.logdoc.LogMessagesFormatter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class LogMessages {
    private String name;
    private String prefix;
    private List<LogMessage> messages = new ArrayList<LogMessage>();

    private LogMessages() {
    }

    LogMessages(String fileName, Element root) throws ParserConfigurationException, SAXException, IOException {
        this.name = this.getDisplayName(fileName);
        this.prefix = root.getAttribute("prefix");
        NodeList children = root.getElementsByTagName("logmessage");
        int sz = children.getLength();
        for (int i = 0; i < sz; ++i) {
            this.messages.add(new LogMessage((Element)children.item(i)));
        }
    }

    String getName() {
        return this.name;
    }

    void generateHTMLFile() throws IOException {
        String page = LogHtmlTemplate.page.replaceAll("@NAME@", this.name);
        page = page.replaceAll("@ID_OPTIONS@", this.getOptions());
        page = page.replaceAll("@messages@", this.getMessagesHtml());
        LogMessagesFormatter.writeToFile(page, this.name + ".html");
    }

    private String getOptions() {
        StringBuffer buff = new StringBuffer();
        for (LogMessage m : this.messages) {
            buff.append(LogHtmlTemplate.option.replaceAll("@id@", this.prefix + "-" + m.getID()));
        }
        return buff.toString();
    }

    private String getMessagesHtml() {
        StringBuffer buff = new StringBuffer();
        for (LogMessage m : this.messages) {
            buff.append(m.getHTML(this.prefix));
        }
        return buff.toString();
    }

    private String getDisplayName(String fileName) {
        int idx = fileName.lastIndexOf(47);
        if (idx != -1) {
            fileName = fileName.substring(idx + 1);
        }
        if ((idx = fileName.indexOf(".xml")) != -1) {
            fileName = fileName.substring(0, idx);
        }
        return fileName;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LogMessage {
        private String name;
        private String id;
        private String description;
        private String level;
        private List<String> datainfos = new ArrayList<String>();
        private List<String> triggers = new ArrayList<String>();
        private List<String> actions = new ArrayList<String>();

        LogMessage(Element elm) {
            this.name = elm.getAttribute("name");
            this.id = elm.getAttribute("id");
            this.description = elm.getAttribute("description");
            this.level = elm.getAttribute("loglevel");
            if (this.level.startsWith("LL_")) {
                this.level = this.level.substring(3);
            }
            this.getItems(elm, "datainfo", this.datainfos);
            this.getItems(elm, "triggers", this.triggers);
            this.getItems(elm, "actions", this.actions);
        }

        String getID() {
            return this.id;
        }

        String getHTML(String prefix) {
            String html = LogHtmlTemplate.logmessage.replaceAll("@id@", prefix + "-" + this.id);
            html = html.replaceAll("@level@", this.level);
            html = html.replaceAll("@description@", this.description);
            html = html.replaceAll("@datainfos@", this.listToString(this.datainfos));
            html = html.replaceAll("@triggers@", this.listToString(this.triggers));
            html = html.replaceAll("@actions@", this.listToString(this.actions));
            return html;
        }

        private String listToString(List<String> list) {
            if (list.isEmpty()) {
                return "&nbsp;";
            }
            StringBuffer buff = new StringBuffer();
            for (String s : list) {
                buff.append(s).append("<br />");
            }
            return buff.toString();
        }

        private void getItems(Element elm, String name, List<String> list) {
            NodeList children = elm.getElementsByTagName(name);
            if (children.getLength() > 0) {
                Element node = (Element)children.item(0);
                NodeList iter = node.getElementsByTagName("item");
                int sz = iter.getLength();
                for (int i = 0; i < sz; ++i) {
                    Element x = (Element)iter.item(i);
                    list.add(x.getFirstChild().getNodeValue());
                }
            }
        }
    }
}

