/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.radius.client;

import com.sun.identity.authentication.modules.radius.client.AccessChallenge;
import com.sun.identity.authentication.modules.radius.client.AccessReject;
import com.sun.identity.authentication.modules.radius.client.AccessRequest;
import com.sun.identity.authentication.modules.radius.client.ChallengeException;
import com.sun.identity.authentication.modules.radius.client.NASIPAddressAttribute;
import com.sun.identity.authentication.modules.radius.client.NASPacket;
import com.sun.identity.authentication.modules.radius.client.NASPortAttribute;
import com.sun.identity.authentication.modules.radius.client.PacketFactory;
import com.sun.identity.authentication.modules.radius.client.RejectException;
import com.sun.identity.authentication.modules.radius.client.RequestAuthenticator;
import com.sun.identity.authentication.modules.radius.client.ServerPacket;
import com.sun.identity.authentication.modules.radius.client.StateAttribute;
import com.sun.identity.authentication.modules.radius.client.UserNameAttribute;
import com.sun.identity.authentication.modules.radius.client.UserPasswordAttribute;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;

public class RadiusConn {
    public static final int MAX_RETRIES = 10;
    public static final int RETRIES = 5;
    public static int OFFICAL_PORT = 1812;
    public static int DEFAULT_PORT = 1645;
    public static int DEFAULT_TIMEOUT = 5;
    public static String OPTION_DEBUG = "OPTION_DEBUG";
    private Properties _options = null;
    private boolean _traceOn = true;
    private String[] _host = new String[2];
    private int[] _port = new int[2];
    private static int _selected = 0;
    private String _secret = null;
    private DatagramSocket _socket = null;
    private short _id = (short)System.currentTimeMillis();
    private SecureRandom _rand = null;

    public RadiusConn(String host1, String host2, int port, String secret, int timeout) throws SocketException {
        this(host1, port, host2, port, secret, timeout, null, null);
    }

    public RadiusConn(String host, int port, String secret, byte[] seed, Properties options) throws SocketException {
        this(host, port, host, port, secret, DEFAULT_TIMEOUT, seed, options);
    }

    public RadiusConn(String host1, int port1, String host2, int port2, String secret, int timeout, byte[] seed, Properties options) throws SocketException {
        this._host[0] = host1;
        this._port[0] = port1;
        this._host[1] = host2;
        this._port[1] = port2;
        this._secret = secret;
        this._options = options;
        this._socket = new DatagramSocket();
        this._socket.setSoTimeout(timeout * 1000);
        this._rand = seed == null ? new SecureRandom() : new SecureRandom(seed);
    }

    public void disconnect() throws IOException {
        this._socket.disconnect();
    }

    public void authenticate(String name, String password) throws IOException, NoSuchAlgorithmException, RejectException, ChallengeException {
        int retries = 0;
        ServerPacket res = null;
        AccessRequest req = this.createAccessRequest();
        req.addAttribute(new UserNameAttribute(name));
        req.addAttribute(new UserPasswordAttribute(req.getAuthenticator(), this._secret, password));
        req.addAttribute(new NASIPAddressAttribute(InetAddress.getLocalHost()));
        req.addAttribute(new NASPortAttribute(this._socket.getLocalPort()));
        do {
            this.send(req, this._host[_selected], this._port[_selected]);
            try {
                ++retries;
                res = this.receive();
                if (res instanceof AccessReject) {
                    throw new RejectException((AccessReject)res);
                }
                if (res instanceof AccessChallenge) {
                    throw new ChallengeException((AccessChallenge)res);
                }
            }
            catch (InterruptedIOException e) {
                if (retries >= 10) {
                    retries = 0;
                    throw e;
                }
                if (retries != 5) continue;
                _selected = _selected == 0 ? 1 : 0;
            }
        } while (res == null);
    }

    public void replyChallenge(String password, ChallengeException ce) throws IOException, NoSuchAlgorithmException, RejectException, ChallengeException {
        this.replyChallenge(null, password, ce);
    }

    public void replyChallenge(String name, String password, ChallengeException ce) throws IOException, NoSuchAlgorithmException, RejectException, ChallengeException {
        StateAttribute state = (StateAttribute)ce.getAttributeSet().getAttributeByType(24);
        if (state == null) {
            throw new IOException("State not found in challenge");
        }
        AccessRequest req = this.createAccessRequest();
        req.addAttribute(state);
        if (name != null) {
            req.addAttribute(new UserNameAttribute(name));
        }
        req.addAttribute(new UserPasswordAttribute(req.getAuthenticator(), this._secret, password));
        req.addAttribute(new NASIPAddressAttribute(InetAddress.getLocalHost()));
        req.addAttribute(new NASPortAttribute(this._socket.getLocalPort()));
        this.send(req, this._host[_selected], this._port[_selected]);
        ServerPacket res = this.receive();
        if (res instanceof AccessReject) {
            throw new RejectException((AccessReject)res);
        }
        if (res instanceof AccessChallenge) {
            throw new ChallengeException((AccessChallenge)res);
        }
    }

    public void replyChallenge(String name, String password, String state) throws IOException, NoSuchAlgorithmException, RejectException, ChallengeException {
        if (state == null) {
            throw new IOException("State not found in challenge");
        }
        AccessRequest req = this.createAccessRequest();
        req.addAttribute(new StateAttribute(state));
        req.addAttribute(new UserNameAttribute(name));
        req.addAttribute(new UserPasswordAttribute(req.getAuthenticator(), this._secret, password));
        req.addAttribute(new NASIPAddressAttribute(InetAddress.getLocalHost()));
        req.addAttribute(new NASPortAttribute(this._socket.getLocalPort()));
        this.send(req, this._host[_selected], this._port[_selected]);
        ServerPacket res = this.receive();
        if (res instanceof AccessReject) {
            throw new RejectException((AccessReject)res);
        }
        if (res instanceof AccessChallenge) {
            throw new ChallengeException((AccessChallenge)res);
        }
    }

    private short getIdentifier() {
        short s = this._id;
        this._id = (short)(s + 1);
        return s;
    }

    private void send(NASPacket packet, String host, int port) throws IOException {
        DatagramPacket dp = new DatagramPacket(new byte[4096], 4096);
        dp.setPort(port);
        dp.setAddress(InetAddress.getByName(host));
        byte[] data = packet.getData();
        dp.setLength(data.length);
        dp.setData(data);
        this._socket.send(dp);
        if (this._traceOn) {
            this.trace("Sent " + packet);
        }
    }

    private ServerPacket receive() throws IOException {
        DatagramPacket dp = new DatagramPacket(new byte[4096], 4096);
        this._socket.receive(dp);
        byte[] data = dp.getData();
        ServerPacket p = PacketFactory.createServerPacket(data);
        if (this._traceOn) {
            this.trace("Received " + p + " size=" + p.getAttributeSet().size());
        }
        return p;
    }

    private AccessRequest createAccessRequest() throws NoSuchAlgorithmException {
        RequestAuthenticator ra = new RequestAuthenticator(this._rand, this._secret);
        AccessRequest req = new AccessRequest(this.getIdentifier(), ra);
        return req;
    }

    private void trace(String msg) {
        System.out.println("TRACE: " + msg);
        System.out.flush();
    }
}

