/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.opensso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.entitlement.EntitlementConfiguration;
import com.sun.identity.entitlement.EntitlementException;
import com.sun.identity.entitlement.IPrivilege;
import com.sun.identity.entitlement.PolicyDataStore;
import com.sun.identity.entitlement.Privilege;
import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.opensso.PrivilegeUtils;
import com.sun.identity.entitlement.opensso.SubjectUtils;
import com.sun.identity.entitlement.xacml3.XACMLPrivilegeUtils;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.security.AdminTokenAction;
import java.security.AccessController;
import java.util.Set;
import javax.security.auth.Subject;

public class PolicyPrivilegeManager
extends PrivilegeManager {
    private static boolean migratedToEntitlementSvc = false;
    private static boolean xacmlEnabled = false;
    private String realm = "/";
    private PolicyManager pm;

    public void initialize(String realm, Subject subject) {
        super.initialize(realm, subject);
        this.realm = realm;
        SSOToken ssoToken = SubjectUtils.getSSOToken(subject);
        if (!migratedToEntitlementSvc) {
            try {
                this.pm = new PolicyManager(ssoToken, realm);
            }
            catch (SSOException e) {
                PrivilegeManager.debug.error("PolicyPrivilegeManager.initialize", (Throwable)((Object)e));
            }
            catch (PolicyException e) {
                PrivilegeManager.debug.error("PolicyPrivilegeManager.initialize", (Throwable)e);
            }
        }
    }

    public Privilege getPrivilege(String privilegeName) throws EntitlementException {
        Privilege privilege = null;
        try {
            Policy policy = null;
            if (!migratedToEntitlementSvc) {
                policy = this.pm.getPolicy(privilegeName);
            } else {
                PolicyDataStore pdb = PolicyDataStore.getInstance();
                policy = (Policy)pdb.getPolicy(this.getAdminSubject(), this.getRealm(), privilegeName);
            }
            Set<IPrivilege> privileges = PrivilegeUtils.policyToPrivileges(policy);
            if (privileges != null && !privileges.isEmpty()) {
                for (IPrivilege p : privileges) {
                    if (!(p instanceof Privilege)) continue;
                    privilege = (Privilege)p;
                }
            }
        }
        catch (PolicyException pe) {
            throw new EntitlementException(102, (Throwable)pe);
        }
        catch (SSOException ssoe) {
            throw new EntitlementException(102, (Throwable)((Object)ssoe));
        }
        return privilege;
    }

    public void addPrivilege(Privilege privilege) throws EntitlementException {
        super.addPrivilege(privilege);
        String name = privilege.getName();
        try {
            Object policyObject = PrivilegeUtils.privilegeToPolicyObject(this.realm, privilege);
            if (!migratedToEntitlementSvc) {
                this.pm.addPolicy((Policy)policyObject);
            } else {
                PolicyDataStore pdb = PolicyDataStore.getInstance();
                pdb.addPolicy(this.getAdminSubject(), this.getRealm(), policyObject);
            }
        }
        catch (PolicyException e) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(202, params, e);
        }
        catch (SSOException e) {
            Object[] params = new Object[]{name};
            throw new EntitlementException(202, params, (Throwable)((Object)e));
        }
    }

    public void removePrivilege(String privilegeName) throws EntitlementException {
        try {
            if (!migratedToEntitlementSvc) {
                this.pm.removePolicy(privilegeName);
            } else {
                PolicyDataStore pdb = PolicyDataStore.getInstance();
                pdb.removePolicy(this.getAdminSubject(), this.getRealm(), privilegeName);
            }
        }
        catch (PolicyException e) {
            Object[] params = new Object[]{privilegeName};
            throw new EntitlementException(205, params, e);
        }
        catch (SSOException e) {
            Object[] params = new Object[]{privilegeName};
            throw new EntitlementException(205, params, (Throwable)((Object)e));
        }
    }

    public void modifyPrivilege(Privilege privilege) throws EntitlementException {
        super.modifyPrivilege(privilege);
        String privilegeName = privilege.getName();
        try {
            if (!migratedToEntitlementSvc) {
                this.pm.removePolicy(privilege.getName());
                this.pm.addPolicy(PrivilegeUtils.privilegeToPolicy(this.realm, privilege));
            } else {
                PolicyDataStore pdb = PolicyDataStore.getInstance();
                pdb.removePolicy(this.getAdminSubject(), this.getRealm(), privilege.getName());
                pdb.addPolicy(this.getAdminSubject(), this.getRealm(), PrivilegeUtils.privilegeToPolicyObject(this.getRealm(), privilege));
            }
        }
        catch (PolicyException e) {
            Object[] params = new Object[]{privilegeName};
            throw new EntitlementException(206, params, e);
        }
        catch (SSOException e) {
            Object[] params = new Object[]{privilegeName};
            throw new EntitlementException(206, params, (Throwable)((Object)e));
        }
    }

    public String getPrivilegeXML(String name) throws EntitlementException {
        String xmlString = "";
        xmlString = XACMLPrivilegeUtils.toXACML(this.getPrivilege(name));
        return xmlString;
    }

    public static boolean xacmlPrivilegeEnabled() {
        return xacmlEnabled;
    }

    static {
        SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
        EntitlementConfiguration ec = EntitlementConfiguration.getInstance(SubjectUtils.createSubject(adminToken), "/");
        migratedToEntitlementSvc = ec.migratedToEntitlementService();
        xacmlEnabled = ec.xacmlPrivilegeEnabled();
    }
}

