/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.sun.identity.policy.ActionSchema;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.PolicyConfig;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.StringComparator;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceType {
    private String serviceTypeName;
    private ServiceSchemaManager schemaManager;
    private ServiceSchema policySchema;
    private Node policySchemaNode;
    private ResourceName resourceNameUtil = null;
    private Set actionNames;
    private Map actionSchemas;
    private static final String resourceClass = "com.sun.identity.policy.plugins.PrefixResourceName";
    private static final String resourceWildcard = "*";
    private static final String resourceOneLevelWildcard = "-*-";
    private static final String resourceDelimiter = "/";
    private static final String resourceCase = "false";

    private ServiceType() {
    }

    protected ServiceType(String serviceName, ServiceSchemaManager ssm, ServiceSchema pschema) {
        this.serviceTypeName = serviceName;
        this.schemaManager = ssm;
        this.policySchema = pschema;
        this.policySchemaNode = this.policySchema.getSchemaNode();
        this.actionNames = Collections.unmodifiableSet(this.getActionNamesInternal());
        this.actionSchemas = new HashMap();
        for (String action : this.actionNames) {
            this.actionSchemas.put(action, this.getActionSchemaInternal(action));
        }
        this.actionSchemas = Collections.unmodifiableMap(this.actionSchemas);
        String className = resourceClass;
        HashMap<String, String> resourceMap = null;
        try {
            resourceMap = PolicyConfig.getResourceCompareConfig(this.serviceTypeName);
            if (resourceMap != null) {
                className = (String)resourceMap.get("class");
            } else {
                resourceMap = new HashMap<String, String>();
                resourceMap.put("delimiter", resourceDelimiter);
                resourceMap.put("wildcard", resourceWildcard);
                resourceMap.put("caseSensitive", resourceCase);
                resourceMap.put("oneLevelWildcard", resourceOneLevelWildcard);
            }
            if (className != null) {
                Class<?> resourceClass = Class.forName(className);
                this.resourceNameUtil = (ResourceName)resourceClass.newInstance();
                this.resourceNameUtil.initialize(resourceMap);
            }
        }
        catch (PolicyException e) {
            PolicyManager.debug.error("Failed to get resource comparator For service: " + serviceName, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            PolicyManager.debug.error("ServiceType: Illegal exception ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            PolicyManager.debug.error("ServiceType: Illegal exception ", (Throwable)e);
        }
        catch (InstantiationException e) {
            PolicyManager.debug.error("ServiceType: InstantiationException  exception ", (Throwable)e);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("class name is : " + className + " service name is: " + serviceName);
        }
    }

    public ResourceName getResourceNameComparator() {
        return this.resourceNameUtil;
    }

    public String getName() {
        return this.serviceTypeName;
    }

    public String getI18NPropertiesFileName() {
        return this.schemaManager.getI18NFileName();
    }

    public String getI18NKey() {
        try {
            return this.schemaManager.getGlobalSchema().getI18NKey();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Set getActionNames() {
        return this.actionNames;
    }

    private Set getActionNamesInternal() {
        if (this.policySchemaNode != null) {
            TreeSet<String> answer = new TreeSet<String>(StringComparator.getInstance());
            NodeList children = this.policySchemaNode.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node node = children.item(i);
                if (!node.getNodeName().equalsIgnoreCase("AttributeSchema")) continue;
                answer.add(XMLUtils.getNodeAttributeValue((Node)node, (String)"name"));
            }
            return answer;
        }
        return Collections.EMPTY_SET;
    }

    public ActionSchema getActionSchema(String actionName) throws InvalidNameException {
        ActionSchema actionSchema = (ActionSchema)this.actionSchemas.get(actionName);
        if (actionSchema == null) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("Action name: " + actionName + " not valid for service: " + this.serviceTypeName);
            }
            Object[] objs = new String[]{this.serviceTypeName, actionName};
            throw new InvalidNameException("amPolicy", "invalid_action_name", objs, actionName, 3);
        }
        return actionSchema;
    }

    private ActionSchema getActionSchemaInternal(String actionName) {
        ActionSchema actionSchema = null;
        Node actionSchemaNode = XMLUtils.getNamedChildNode((Node)this.policySchemaNode, (String)"AttributeSchema", (String)"name", (String)actionName);
        if (actionSchemaNode != null) {
            actionSchema = new ActionSchema(actionSchemaNode);
        }
        return actionSchema;
    }

    public Map getActionSchemas() {
        return this.actionSchemas;
    }

    public boolean validateActionValues(Map actionValues) throws InvalidNameException {
        if (actionValues == null || actionValues.size() == 0) {
            return true;
        }
        Iterator actionNames = actionValues.keySet().iterator();
        while (actionNames.hasNext()) {
            try {
                String actionName = (String)actionNames.next();
                ActionSchema as = this.getActionSchema(actionName);
                HashSet values = null;
                Object o = actionValues.get(actionName);
                if (o instanceof String) {
                    values = new HashSet();
                    values.add(o);
                } else {
                    values = (HashSet)o;
                }
                ActionSchema.validate(as, values);
            }
            catch (ClassCastException cce) {
                PolicyManager.debug.error("In validate action name and values invalid class name: " + cce.getMessage());
                throw new InvalidNameException("amPolicy", "invalid_class_name", null, this.serviceTypeName, 1);
            }
        }
        return true;
    }

    public boolean containsActionName(String actionName) {
        return this.getActionNames().contains(actionName);
    }

    protected ResourceMatch compare(String resource1, String resource2) {
        if (this.resourceNameUtil == null) {
            return ResourceMatch.NO_MATCH;
        }
        return this.resourceNameUtil.compare(resource1, resource2, true);
    }

    protected ResourceMatch compare(String resource1, String resource2, boolean interpretWildCard) {
        if (this.resourceNameUtil == null) {
            return ResourceMatch.NO_MATCH;
        }
        return this.resourceNameUtil.compare(resource1, resource2, interpretWildCard);
    }

    public String append(String superRes, String subRes) {
        if (this.resourceNameUtil == null) {
            PolicyManager.debug.error("Append: Don't have resource comparator");
            return superRes;
        }
        return this.resourceNameUtil.append(superRes, subRes);
    }

    public String getSubResource(String res, String superRes) {
        if (this.resourceNameUtil == null) {
            PolicyManager.debug.error("getSubRes: Don't have resource comparator");
            return res;
        }
        return this.resourceNameUtil.getSubResource(res, superRes);
    }

    public String[] split(String res) {
        if (this.resourceNameUtil == null) {
            PolicyManager.debug.error("split: Don't have resource comparator");
            String[] list = new String[]{res};
            return list;
        }
        return this.resourceNameUtil.split(res);
    }

    protected Set getPoliciesForExactResourceMatch(String resoruceName) {
        return null;
    }

    protected Set getPolicyForResource(String resourceName) {
        return null;
    }

    public boolean hasResourceNames() {
        boolean hasResources = false;
        Collection actionSchemas = this.getActionSchemas().values();
        for (ActionSchema actionSchema : actionSchemas) {
            if (!actionSchema.requiresResourceName()) continue;
            hasResources = true;
            break;
        }
        return hasResources;
    }

    String canonicalize(String resourceName) throws PolicyException {
        if (this.resourceNameUtil == null) {
            return resourceName;
        }
        return this.resourceNameUtil.canonicalize(resourceName);
    }
}

