/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.sso.SSOException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.security.AppSSOTokenProvider;
import com.sun.identity.shared.debug.Debug;
import java.util.HashMap;
import java.util.Map;

public class PolicyEvaluatorFactory {
    static Debug debug = Debug.getInstance((String)"amRemotePolicy");
    private static PolicyEvaluatorFactory factory;
    private Map evaluatorsCache = new HashMap(10);

    private PolicyEvaluatorFactory() {
        if (debug.messageEnabled()) {
            debug.message("PolicyEvaluatorFactory():created singleton instance");
        }
    }

    public static synchronized PolicyEvaluatorFactory getInstance() {
        if (factory == null) {
            factory = new PolicyEvaluatorFactory();
        }
        return factory;
    }

    public PolicyEvaluator getPolicyEvaluator(String serviceName) throws PolicyException, SSOException {
        return this.getPolicyEvaluator(serviceName, null);
    }

    public synchronized PolicyEvaluator getPolicyEvaluator(String serviceName, AppSSOTokenProvider appSSOTokenProvider) throws PolicyException, SSOException {
        PolicyEvaluator pe = null;
        if (serviceName == null) {
            if (debug.warningEnabled()) {
                debug.warning("PolicyEvaluatorFactory.getPolicyEvaluator():serviceName is null");
            }
            return null;
        }
        HashMap<AppSSOTokenProvider, PolicyEvaluator> appTokenEvaluatorsMap = (HashMap<AppSSOTokenProvider, PolicyEvaluator>)this.evaluatorsCache.get(serviceName);
        if (appTokenEvaluatorsMap == null) {
            appTokenEvaluatorsMap = new HashMap<AppSSOTokenProvider, PolicyEvaluator>(5);
            this.evaluatorsCache.put(serviceName, appTokenEvaluatorsMap);
        }
        if ((pe = (PolicyEvaluator)appTokenEvaluatorsMap.get(appSSOTokenProvider)) == null) {
            if (debug.messageEnabled()) {
                debug.message("PolicyEvaluatorFactory.getPolicyEvaluator():serviceName=" + serviceName + ":appSSOTokenProvider=" + appSSOTokenProvider + ":creating new PolicyEvaluator");
            }
            pe = new PolicyEvaluator(serviceName, appSSOTokenProvider);
            appTokenEvaluatorsMap.put(appSSOTokenProvider, pe);
        } else if (debug.messageEnabled()) {
            debug.message("PolicyEvaluatorFactory.getPolicyEvaluator():serviceName=" + serviceName + ":appSSOTokenProvider=" + appSSOTokenProvider + ":returning PolicyEvaluator from cache");
        }
        return pe;
    }
}

