/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.Debugger;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.RequestContext;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;

public class LoadSchema
extends AuthenticatedCommand {
    public void handleRequest(RequestContext rc) throws CLIException {
        super.handleRequest(rc);
        this.ldapLogin();
        SSOToken adminSSOToken = this.getAdminSSOToken();
        boolean continueFlag = this.isOptionSet("continue");
        IOutput outputWriter = this.getOutputWriter();
        List xmlFiles = rc.getOption("xmlfile");
        ServiceManager ssm = null;
        try {
            ssm = new ServiceManager(adminSSOToken);
        }
        catch (SMSException e) {
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            throw new CLIException((Throwable)((Object)e), 127);
        }
        CommandManager mgr = this.getCommandManager();
        boolean bError = false;
        String url = mgr.getWebEnabledURL();
        if (url != null && url.length() > 0) {
            String[] param = new String[]{"web-input"};
            this.writeLog(0, Level.INFO, "ATTEMPT_LOAD_SCHEMA", param);
            this.loadSchemaXML(ssm, (String)xmlFiles.iterator().next());
            outputWriter.printlnMessage(this.getResourceString("schema-added"));
            this.writeLog(0, Level.INFO, "SUCCESS_LOAD_SCHEMA", param);
        } else {
            for (String file : xmlFiles) {
                String[] param = new String[]{file};
                try {
                    this.writeLog(0, Level.INFO, "ATTEMPT_LOAD_SCHEMA", param);
                    this.loadSchema(ssm, file);
                    outputWriter.printlnMessage(this.getResourceString("schema-added"));
                    this.writeLog(0, Level.INFO, "SUCCESS_LOAD_SCHEMA", param);
                }
                catch (CLIException e) {
                    bError = true;
                    if (continueFlag) {
                        outputWriter.printlnError(this.getResourceString("schema-failed") + e.getMessage());
                        if (!this.isVerbose()) continue;
                        outputWriter.printlnError(Debugger.getStackTrace(e));
                        continue;
                    }
                    throw e;
                }
            }
        }
        if (bError) {
            throw new CLIException(this.getResourceString("one-or-more-services-not-added"), 127);
        }
    }

    private void loadSchemaXML(ServiceManager ssm, String xml) throws CLIException {
        ByteArrayInputStream bis = null;
        try {
            bis = new ByteArrayInputStream(xml.getBytes());
            ssm.registerServices(bis);
        }
        catch (SSOException e) {
            String[] args = new String[]{"web-input", e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{"web-input", e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ie) {}
            }
        }
    }

    private void loadSchema(ServiceManager ssm, String fileName) throws CLIException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(fileName);
            ssm.registerServices(fis);
        }
        catch (IOException e) {
            String[] args = new String[]{fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        catch (SSOException e) {
            String[] args = new String[]{fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException((Throwable)((Object)e), 127);
        }
        catch (SMSException e) {
            String[] args = new String[]{fileName, e.getMessage()};
            this.writeLog(0, Level.INFO, "FAILED_LOAD_SCHEMA", args);
            throw new CLIException(e, 127);
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ie) {}
            }
        }
    }
}

