/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.wss;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.modules.wss.WSSUserPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.security.UserNameToken;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;
import javax.servlet.http.HttpServletRequest;

public class WSSAuthModule
extends AMLoginModule {
    protected Principal userPrincipal;
    private String userId = null;
    private String userSearchAttribute = null;
    private String userPasswordAttribute = null;
    private String realm = null;
    private static final String UN_SEARCH_ATTRIBUTE = "sunWebservicesUserSearchAttribute";
    private static final String REALM = "sunWebServicesUserRealm";
    private static final String UN_PASSWORD_ATTRIBUTE = "sunWebservicesUserpasswordAttribute";
    private static Debug debug = Debug.getInstance((String)"WebServicesSecurity");
    private static ResourceBundle bundle = ResourceBundle.getBundle("fmWSSecurity");

    public WSSAuthModule() throws LoginException {
        if (debug.messageEnabled()) {
            debug.message("WSSAuthModule()");
        }
    }

    public void init(Subject subject, Map sharedState, Map options) {
        if (debug.messageEnabled()) {
            debug.message("WSSAuthModule initialization" + options);
        }
        this.userSearchAttribute = CollectionHelper.getMapAttr((Map)options, (String)UN_SEARCH_ATTRIBUTE, (String)"uid");
        this.userPasswordAttribute = CollectionHelper.getMapAttr((Map)options, (String)UN_PASSWORD_ATTRIBUTE, (String)"userPassword");
        this.realm = CollectionHelper.getMapAttr((Map)options, (String)REALM, (String)"/");
        if (debug.messageEnabled()) {
            debug.message("WSSAuthModule.init: User search attribute= " + this.userSearchAttribute + "\n" + " User password attribute=" + this.userPasswordAttribute + "\n" + " Realm = " + this.realm);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        HttpServletRequest request = this.getHttpServletRequest();
        String userName = ((NameCallback)callbacks[0]).getName();
        String digest = null;
        String nonce = null;
        String timestamp = null;
        String passwdCallback = this.charToString(((PasswordCallback)callbacks[1]).getPassword(), callbacks[1]);
        if (passwdCallback == null || passwdCallback.length() == 0) {
            throw new InvalidPasswordException(bundle.getString("invalidPassword"));
        }
        boolean isPasswordDigest = false;
        if (passwdCallback.indexOf(";") != -1) {
            isPasswordDigest = true;
        }
        if (isPasswordDigest) {
            if (debug.messageEnabled()) {
                debug.message("WSSAuthModule.process: In password digest");
            }
            StringTokenizer st = new StringTokenizer(passwdCallback, ";");
            while (st.hasMoreTokens()) {
                String tmp = st.nextToken();
                if (tmp.indexOf("PasswordDigest") != -1) {
                    digest = tmp.substring("PasswordDigest=".length());
                    continue;
                }
                if (tmp.indexOf("Nonce=") != -1) {
                    nonce = tmp.substring("Nonce=".length());
                    continue;
                }
                if (tmp.indexOf("Timestamp=") == -1) continue;
                timestamp = tmp.substring("Timestamp=".length());
            }
            if (debug.messageEnabled()) {
                debug.message("WSSAuthModule: Digest =" + digest + " Nonce = " + nonce + " Timestamp = " + timestamp);
            }
            AMIdentity amIdentity = this.searchUser(this.userSearchAttribute, userName);
            try {
                Set attrValues = amIdentity.getAttribute(this.userPasswordAttribute);
                if (attrValues == null || attrValues.isEmpty()) {
                    throw new AuthLoginException(bundle.getString("nullUserPassword"));
                }
                String configAttrValue = (String)attrValues.iterator().next();
                String calculatedDigest = UserNameToken.getPasswordDigest(configAttrValue, nonce, timestamp);
                if (calculatedDigest.equals(digest)) {
                    this.userId = amIdentity.getUniversalId();
                    if (!debug.messageEnabled()) return -1;
                    debug.message("WSSAuthModule: Login succeeded for " + this.userId);
                    return -1;
                }
                if (!debug.messageEnabled()) throw new InvalidPasswordException(bundle.getString("authenticationFailed"));
                debug.message("WSSAuthModule: Digest does not match Expected digest: " + calculatedDigest + " Digest sent: " + digest);
                throw new InvalidPasswordException(bundle.getString("authenticationFailed"));
            }
            catch (Exception e) {
                debug.error("WSSAuthModule.process: exception", (Throwable)e);
                throw new AuthLoginException(bundle.getString("authenticationFailed"));
            }
        } else {
            AMIdentity amIdentity = this.searchUser(this.userSearchAttribute, userName);
            if (amIdentity == null) throw new InvalidPasswordException(bundle.getString("noUserFound"));
            try {
                Set attrValues = amIdentity.getAttribute(this.userPasswordAttribute);
                if (attrValues == null || attrValues.isEmpty()) {
                    throw new AuthLoginException(bundle.getString("nullUserPassword"));
                }
                String configAttrValue = (String)attrValues.iterator().next();
                if (!passwdCallback.equals(configAttrValue)) throw new InvalidPasswordException(bundle.getString("authenticationFailed"));
                this.userId = amIdentity.getUniversalId();
                if (!debug.messageEnabled()) return -1;
                debug.message("WSSAuthModule. Authentication succeeded for " + this.userId);
                return -1;
            }
            catch (Exception ex) {
                debug.error("WSSAuthModule.process: Idrepo exception", (Throwable)ex);
                throw new AuthLoginException(bundle.getString("authenticationFailed"));
            }
        }
    }

    private String charToString(char[] tmpPassword, Callback cbk) {
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        ((PasswordCallback)cbk).clearPassword();
        return new String(pwd);
    }

    private static SSOToken getAdminToken() {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private AMIdentity searchUser(String attr, String attrValue) throws AuthLoginException {
        try {
            if (debug.messageEnabled()) {
                debug.message("WSSAuthModule. Search attr:" + attr + " Attr value: " + attrValue);
            }
            AMIdentityRepository idRepo = new AMIdentityRepository(WSSAuthModule.getAdminToken(), this.realm);
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            control.setTimeOut(0);
            HashMap kvPairMap = new HashMap();
            HashSet<String> set = new HashSet<String>();
            set.add(attrValue);
            kvPairMap.put(attr, set);
            control.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
            IdSearchResults results = idRepo.searchIdentities(IdType.USER, "*", control);
            Set users = results.getSearchResults();
            if (users == null || users.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("WSSAuthModule. No user found with " + attrValue);
                }
                throw new InvalidPasswordException(bundle.getString("noUsersFound"));
            }
            return (AMIdentity)users.iterator().next();
        }
        catch (Exception ex) {
            debug.error("WSSAuthModule.searchUser: ", (Throwable)ex);
            throw new AuthLoginException(bundle.getString("userSearchFailed"));
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userId != null) {
            this.userPrincipal = new WSSUserPrincipal(this.userId);
            return this.userPrincipal;
        }
        return null;
    }
}

