/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.dpro.session.jdbc;

import com.iplanet.dpro.session.jdbc.JDBCConnectionImpl;
import com.iplanet.dpro.session.service.SessionService;
import javax.sql.ConnectionPoolDataSource;

public class OracleConnectionImpl
extends JDBCConnectionImpl {
    ConnectionPoolDataSource ds = null;
    static final String ORCL_POOL_CLASS_NAME = "oracle.jdbc.pool.OracleConnectionPoolDataSource";
    static final String ERROR_MSG_CLASS_NOT_FOUND = "Please check oracle driver file is in the classpath";
    static final String ERROR_MSG_INIT_ERROR = "Error while initializing OracleConnectionPoolDataSource";

    public void init(String connString, String username, String password) {
        try {
            this.ds = (ConnectionPoolDataSource)Class.forName(ORCL_POOL_CLASS_NAME).newInstance();
            if (SessionService.sessionDebug.messageEnabled()) {
                SessionService.sessionDebug.message("username is :" + username);
                SessionService.sessionDebug.message("URL is :" + connString);
            }
            OracleConnectionImpl.invokeSetMethodCaseInsensitive(this.ds, "url", connString);
            OracleConnectionImpl.invokeSetMethodCaseInsensitive(this.ds, "user", username);
            OracleConnectionImpl.invokeSetMethodCaseInsensitive(this.ds, "password", password);
        }
        catch (ClassNotFoundException e) {
            SessionService.sessionDebug.error(ERROR_MSG_CLASS_NOT_FOUND, (Throwable)e);
        }
        catch (Exception e) {
            SessionService.sessionDebug.error(ERROR_MSG_INIT_ERROR, (Throwable)e);
        }
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.ds;
    }
}

