/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli.schema;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.cli.AuthenticatedCommand;
import com.sun.identity.cli.CLIException;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class SchemaCommand
extends AuthenticatedCommand {
    static final String SCHEMA_TYPE_GLOBAL = "global";
    static final String SCHEMA_TYPE_ORGANIZATION = "organization";
    static final String SCHEMA_TYPE_DYNAMIC = "dynamic";
    static final String SCHEMA_TYPE_USER = "user";
    static final String SCHEMA_TYPE_POLICY = "policy";

    protected ServiceSchemaManager getServiceSchemaManager() throws CLIException {
        String serviceName = this.getStringOptionValue("servicename");
        return this.getServiceSchemaManager(serviceName);
    }

    protected ServiceSchemaManager getServiceSchemaManager(String serviceName) throws CLIException {
        ServiceSchemaManager mgr = null;
        SSOToken adminSSOToken = this.getAdminSSOToken();
        if (serviceName != null) {
            try {
                mgr = new ServiceSchemaManager(serviceName, adminSSOToken);
            }
            catch (SSOException e) {
                this.debugError("SchemaCommand.getServiceSchemaManager", (Throwable)((Object)e));
                throw new CLIException((Throwable)((Object)e), 127);
            }
            catch (SMSException e) {
                this.debugError("SchemaCommand.getServiceSchemaManager", e);
                throw new CLIException(e, 127);
            }
        }
        return mgr;
    }

    protected ServiceSchema getServiceSchema() throws CLIException {
        String serviceName = this.getStringOptionValue("servicename");
        String subSchemaName = this.getStringOptionValue("subschemaname");
        String schemaType = this.getStringOptionValue("schematype");
        return this.getServiceSchema(serviceName, subSchemaName, schemaType);
    }

    protected ServiceSchema getServiceSchema(String serviceName, String subSchemaName, String schemaType) throws CLIException {
        ServiceSchema ss = null;
        ServiceSchemaManager ssm = this.getServiceSchemaManager(serviceName);
        if (ssm != null && schemaType != null) {
            try {
                ss = ssm.getSchema(this.getSchemaType(schemaType));
                if (subSchemaName != null) {
                    boolean done = false;
                    StringTokenizer st = new StringTokenizer(subSchemaName, "/");
                    while (st.hasMoreTokens() && !done) {
                        String str = st.nextToken();
                        if (str != null) {
                            if ((ss = ss.getSubSchema(str)) != null) continue;
                            String[] args = new String[]{subSchemaName};
                            throw new CLIException(MessageFormat.format(this.getResourceString("schema-sub-schema-does-not-exists"), args), 127);
                        }
                        done = true;
                    }
                }
            }
            catch (SMSException e) {
                this.debugError("SchemaCommand.getServiceSchema", e);
                throw new CLIException(e, 127);
            }
        }
        if (ss == null) {
            String[] args = new String[]{subSchemaName};
            throw new CLIException(MessageFormat.format(this.getResourceString("schema-sub-schema-does-not-exists"), args), 127);
        }
        return ss;
    }

    private SchemaType getSchemaType(String schemaTypeName) {
        SchemaType schemaType = null;
        if (schemaTypeName.equalsIgnoreCase(SCHEMA_TYPE_GLOBAL)) {
            schemaType = SchemaType.GLOBAL;
        } else if (schemaTypeName.equalsIgnoreCase(SCHEMA_TYPE_ORGANIZATION)) {
            schemaType = SchemaType.ORGANIZATION;
        } else if (schemaTypeName.equalsIgnoreCase(SCHEMA_TYPE_DYNAMIC)) {
            schemaType = SchemaType.DYNAMIC;
        } else if (schemaTypeName.equalsIgnoreCase(SCHEMA_TYPE_USER)) {
            schemaType = SchemaType.USER;
        } else if (schemaTypeName.equalsIgnoreCase(SCHEMA_TYPE_POLICY)) {
            schemaType = SchemaType.POLICY;
        }
        return schemaType;
    }

    protected void attributeSchemaNoExist(String attributeSchemaName, String logID, String[] logArgs) throws CLIException {
        this.writeLog(1, Level.INFO, logID, logArgs);
        Object[] p = new Object[]{attributeSchemaName};
        String msg = MessageFormat.format(this.getResourceString("attribute-schema-not-exist"), p);
        throw new CLIException(msg, 127);
    }
}

