/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.authentication.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthConfigUtils;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.config.AuthConfigurationEntry;
import com.sun.identity.console.authentication.model.AuthConfigurationModel;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class AuthConfigurationModelImpl
extends AMModelBase
implements AuthConfigurationModel {
    private static final String REQUIRED = "REQUIRED";
    private static final String OPTIONAL = "OPTIONAL";
    private static final String SUFFICIENT = "SUFFICIENT";
    private static final String REQUISITE = "REQUISITE";
    private static final String SUCCESS_URL = "iplanet-am-auth-login-success-url";
    private static final String FAILURE_URL = "iplanet-am-auth-login-failure-url";
    private static final String POST_PROCESS_CLASS = "iplanet-am-auth-post-login-process-class";
    private static final String AUTH_CONFIG_ATTR = "iplanet-am-auth-configuration";
    private static final int DEFAULT_PRIORITY = 0;
    public static final String CONFIG_NAME = "authConfigurationEntryName";
    private String currentRealm = null;
    private Map configData = null;
    private List entryList = null;
    private String xmlValue = null;
    private OrganizationConfigManager ocm = null;

    public AuthConfigurationModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
        this.currentRealm = (String)map.get("currentRealm");
    }

    public Map getValues() throws AMConsoleException {
        return this.configData;
    }

    public static Set getNamedConfigurations(SSOToken ssoToken, String realmName) {
        Set configurations = null;
        String errorMsg = null;
        try {
            configurations = AMAuthConfigUtils.getAllNamedConfig(realmName, ssoToken);
        }
        catch (SMSException e) {
            debug.error("AuthConfigurationModel.getNamedConfigurations", (Throwable)e);
            errorMsg = e.getMessage();
        }
        catch (SSOException e) {
            debug.error("AuthConfigurationModel.getNamedConfigurations", (Throwable)((Object)e));
            errorMsg = e.getMessage();
        }
        if (errorMsg != null) {
            configurations = Collections.EMPTY_SET;
        }
        return configurations;
    }

    public void createAuthConfiguration(String name) throws AMConsoleException {
        if (name == null || name.length() == 0) {
            throw new AMConsoleException(this.getLocalizedString("authentication.config.missing.name"));
        }
        String[] params = new String[]{this.currentRealm, name};
        this.logEvent("ATTEMPT_CREATE_AUTH_CONFIG", params);
        String errorMsg = null;
        try {
            AMAuthConfigUtils.createNamedConfig(name, 0, new HashMap(), this.currentRealm, this.getUserSSOToken());
            this.logEvent("SUCCEED_CREATE_AUTH_CONFIG", params);
        }
        catch (SMSException e) {
            errorMsg = this.getErrorString(e);
            String[] paramsEx = new String[]{this.currentRealm, name, errorMsg};
            this.logEvent("SMS_EXCEPTION_CREATE_AUTH_CONFIG", paramsEx);
            debug.warning("problem creating auth instance", (Throwable)e);
        }
        catch (SSOException e) {
            errorMsg = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, name, errorMsg};
            this.logEvent("SSO_EXCEPTION_CREATE_AUTH_CONFIG", paramsEx);
            debug.warning("problem creating auth instance", (Throwable)((Object)e));
        }
        catch (AMConfigurationException e) {
            errorMsg = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{this.currentRealm, name, errorMsg};
            this.logEvent("AUTH_CONFIGURATION_EXCEPTION_CREATE_AUTH_CONFIG", paramsEx);
            debug.warning("problem creating auth instance", (Throwable)((Object)e));
        }
        if (errorMsg != null) {
            throw new AMConsoleException(errorMsg);
        }
    }

    public void deleteAuthConfiguration(String realm, Set names) throws AMConsoleException {
        StringBuffer errorList = new StringBuffer();
        String message = null;
        for (String config : names) {
            message = null;
            try {
                AMAuthConfigUtils.removeNamedConfig(config, realm, this.getUserSSOToken());
            }
            catch (AMConfigurationException e) {
                debug.warning("failed to delete", (Throwable)((Object)e));
                message = e.getMessage();
                errorList.append(config);
            }
            catch (SMSException e) {
                debug.warning("failed to delete", (Throwable)e);
                message = e.getMessage();
                errorList.append(config);
            }
            catch (SSOException e) {
                debug.warning("failed to delete", (Throwable)((Object)e));
                message = e.getMessage();
                errorList.append(config);
            }
            if (message == null || errorList.length() <= 0) continue;
            errorList.append(", ");
        }
        if (errorList.length() > 0) {
            String[] tmp = new String[]{errorList.toString(), message};
            throw new AMConsoleException(MessageFormat.format(this.getLocalizedString("authentication.config.delete.failed"), tmp));
        }
    }

    private void verifyConfigurationService(String currentRealm) {
        if (this.ocm == null) {
            try {
                this.ocm = new OrganizationConfigManager(this.getUserSSOToken(), currentRealm);
            }
            catch (SMSException sms) {
                debug.error("error getting config manager", (Throwable)sms);
            }
        }
        try {
            this.ocm.getServiceConfig("iPlanetAMAuthConfiguration");
        }
        catch (SMSException sms) {
            try {
                this.ocm.addServiceConfig("iPlanetAMAuthConfiguration", new HashMap());
            }
            catch (SMSException x) {
                debug.message("the service is already registered");
            }
        }
    }

    public void setValues(Map data) {
        if (this.configData != null && !this.configData.isEmpty()) {
            this.configData.putAll(data);
        }
    }

    public String getPostProcessingClass(String realm, String config) {
        Set tmp;
        this.initialize(realm, config);
        String value = null;
        if (this.configData != null && !this.configData.isEmpty() && (tmp = (Set)this.configData.get(POST_PROCESS_CLASS)) != null && !tmp.isEmpty()) {
            value = (String)tmp.iterator().next();
        }
        return value == null ? "" : value;
    }

    public String getModuleFlag(int idx) {
        String flag = null;
        AuthConfigurationEntry entry = (AuthConfigurationEntry)this.entryList.get(idx);
        if (entry != null) {
            flag = entry.getControlFlag();
        }
        return flag;
    }

    public String getModuleOptions(int idx) {
        String options = null;
        AuthConfigurationEntry entry = (AuthConfigurationEntry)this.entryList.get(idx);
        if (entry != null) {
            options = entry.getOptions();
        }
        return options;
    }

    public String getModuleName(int idx) {
        String name = null;
        AuthConfigurationEntry entry = (AuthConfigurationEntry)this.entryList.get(idx);
        if (entry != null) {
            name = entry.getLoginModuleName();
        }
        return name;
    }

    public int getNumberEntries() {
        return this.entryList != null ? this.entryList.size() : 0;
    }

    public String getXMLValue(String realm, String config) {
        if (this.xmlValue == null || this.xmlValue.length() < 1) {
            this.initialize(realm, config);
        }
        return this.xmlValue;
    }

    public void setXMLValue(String value) {
        this.xmlValue = value;
        this.entryList = new ArrayList(AMAuthConfigUtils.xmlToAuthConfigurationEntry(value));
        HashSet<String> s = new HashSet<String>(2);
        s.add(value);
        this.configData.put(AUTH_CONFIG_ATTR, s);
    }

    public void removeAuthEntries(Integer[] entries) {
        ArrayList removeList = new ArrayList(entries.length * 2);
        for (int i = 0; i < entries.length; ++i) {
            removeList.add(this.entryList.get(entries[i]));
        }
        this.entryList.removeAll(removeList);
        this.xmlValue = AMAuthConfigUtils.authConfigurationEntryToXMLString(this.entryList);
    }

    public void setEntries(List entries) {
        if (entries != null && !entries.isEmpty()) {
            this.entryList = entries;
            this.xmlValue = AMAuthConfigUtils.authConfigurationEntryToXMLString(this.entryList);
            HashSet<String> s = new HashSet<String>(2);
            s.add(this.xmlValue);
            this.configData.put(AUTH_CONFIG_ATTR, s);
        }
    }

    public void setPostAuthPropertiesClass(String className) {
        HashSet<String> tmp = new HashSet<String>(2);
        tmp.add(className);
        this.configData.put(POST_PROCESS_CLASS, tmp);
    }

    public void store(String realm, String config) throws AMConsoleException {
        String errorMsg = null;
        String[] params = new String[]{realm, config};
        this.logEvent("ATTEMPT_MODIFY_AUTH_CONFIG_PROFILE", params);
        try {
            AMAuthConfigUtils.replaceNamedConfig(config, 0, this.configData, realm, this.getUserSSOToken());
            this.logEvent("SUCCEED_MODIFY_AUTH_CONFIG_PROFILE", params);
        }
        catch (SSOException e) {
            errorMsg = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realm, config, errorMsg};
            this.logEvent("SSO_EXCEPTION_MODIFY_AUTH_CONFIG_PROFILE", paramsEx);
        }
        catch (SMSException e) {
            errorMsg = this.getErrorString(e);
            String[] paramsEx = new String[]{realm, config, errorMsg};
            this.logEvent("SMS_EXCEPTION_MODIFY_AUTH_CONFIG_PROFILE", paramsEx);
        }
        catch (AMConfigurationException e) {
            errorMsg = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realm, config, errorMsg};
            this.logEvent("AUTH_CONFIGURATION_EXCEPTION_MODIFY_AUTH_CONFIG_PROFILE", paramsEx);
        }
        if (errorMsg != null) {
            throw new AMConsoleException(errorMsg);
        }
    }

    public void reset(String realm, String config) {
        this.configData = null;
        this.xmlValue = null;
        this.initialize(realm, config);
    }

    public void initialize(String realm, String config) {
        Set tmp;
        this.verifyConfigurationService(realm);
        try {
            if (this.configData == null) {
                String[] params = new String[]{realm, config};
                this.logEvent("ATTEMPT_GET_AUTH_CONFIG_PROFILE", params);
                this.configData = AMAuthConfigUtils.getNamedConfig(config, realm, this.getUserSSOToken());
                this.logEvent("SUCCEED_GET_AUTH_CONFIG_PROFILE", params);
            }
        }
        catch (SSOException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realm, config, strError};
            this.logEvent("SSO_EXCEPTION_GET_AUTH_CONFIG_PROFILE", paramsEx);
            debug.warning("AuthConfigurationModelImpl.initialize", (Throwable)((Object)e));
            this.configData = Collections.EMPTY_MAP;
        }
        catch (AMConfigurationException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realm, config, strError};
            this.logEvent("AUTH_CONFIGURATION_EXCEPTION_GET_AUTH_CONFIG_PROFILE", paramsEx);
            debug.error("AuthConfigurationModelImpl.initialize", (Throwable)((Object)e));
            this.configData = Collections.EMPTY_MAP;
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realm, config, strError};
            this.logEvent("SMS_EXCEPTION_GET_AUTH_CONFIG_PROFILE", paramsEx);
            debug.error("AuthConfigurationModelImpl.initialize", (Throwable)e);
            this.configData = Collections.EMPTY_MAP;
        }
        if (this.configData != null && !this.configData.isEmpty() && this.xmlValue == null && (tmp = (Set)this.configData.get(AUTH_CONFIG_ATTR)) != null && !tmp.isEmpty()) {
            this.xmlValue = (String)tmp.iterator().next();
            this.entryList = new ArrayList(AMAuthConfigUtils.xmlToAuthConfigurationEntry(this.xmlValue));
        }
    }

    public Map getCriteriaMap() {
        HashMap<String, String> m = new HashMap<String, String>(8);
        m.put(REQUIRED, this.getLocalizedString("authentication.config.required.label"));
        m.put(OPTIONAL, this.getLocalizedString("authentication.config.optional.label"));
        m.put(SUFFICIENT, this.getLocalizedString("authentication.config.sufficient.label"));
        m.put(REQUISITE, this.getLocalizedString("authentication.config.requisite.label"));
        return m;
    }
}

