/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.sso.SSOException;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
implements Cloneable {
    public static final String EMPTY_RESOURCE_NAME = "";
    public static final String EXCLUDED_RESOURCE_NAMES = "EXCLUDED_resource_NAMES";
    private String ruleName;
    private String serviceTypeName;
    private ServiceType serviceType;
    Set<String> resourceNames = new HashSet<String>();
    Set<String> excludedResourceNames;
    private String applicationName;
    private Map actions;

    protected Rule() {
    }

    public Rule(String serviceName, String resourceName, Map actions) throws NameNotFoundException, InvalidNameException {
        this(null, serviceName, resourceName, actions);
    }

    public Rule(String serviceName, Map actions) throws NameNotFoundException, InvalidNameException {
        this(null, serviceName, null, actions);
    }

    public Rule(String ruleName, String serviceName, String resourceName, Map actions) throws NameNotFoundException, InvalidNameException {
        this.ruleName = ruleName != null ? ruleName : "rule" + ServiceTypeManager.generateRandomName();
        this.resourceNames = new HashSet<String>();
        if (resourceName == null || resourceName.length() == 0) {
            this.resourceNames.add(EMPTY_RESOURCE_NAME);
        } else {
            resourceName = resourceName.trim();
            if (PolicyManager.migratedToEntitlementService) {
                this.resourceNames.add(resourceName);
            } else {
                this.checkAndSetServiceType(serviceName);
                this.serviceTypeName = serviceName;
                this.serviceType.validateActionValues(actions);
                this.actions = new HashMap(actions);
                try {
                    this.resourceNames.add(this.serviceType.canonicalize(resourceName));
                }
                catch (PolicyException pe) {
                    throw new InvalidNameException(pe, resourceName, 2);
                }
            }
        }
        this.checkAndSetServiceType(serviceName);
        this.serviceTypeName = serviceName;
        this.actions = new HashMap(actions);
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName == null ? this.serviceTypeName : this.applicationName;
    }

    protected Rule(Node ruleNode) throws InvalidFormatException, InvalidNameException, NameNotFoundException {
        Node serviceNode;
        if (!ruleNode.getNodeName().equalsIgnoreCase("Rule")) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid rule xml blob given to constructor");
            }
            throw new InvalidFormatException("amPolicy", "invalid_xml_rule_node", null, EMPTY_RESOURCE_NAME, 2);
        }
        this.ruleName = XMLUtils.getNodeAttributeValue((Node)ruleNode, (String)"name");
        if (this.ruleName == null) {
            this.ruleName = "rule" + ServiceTypeManager.generateRandomName();
        }
        if ((serviceNode = XMLUtils.getChildNode((Node)ruleNode, (String)"ServiceName")) == null || (this.serviceTypeName = XMLUtils.getNodeAttributeValue((Node)serviceNode, (String)"name")) == null) {
            if (PolicyManager.debug.warningEnabled()) {
                PolicyManager.debug.warning("invalid service name in rule xml blob in constructor");
            }
            Object[] objs = new String[]{this.serviceTypeName == null ? "null" : this.serviceTypeName};
            throw new InvalidFormatException("amPolicy", "invalid_xml_rule_service_name", objs, this.ruleName, 2);
        }
        this.checkAndSetServiceType(this.serviceTypeName);
        Node applicationNameNode = XMLUtils.getChildNode((Node)ruleNode, (String)"ApplicationName");
        if (applicationNameNode != null) {
            this.applicationName = XMLUtils.getNodeAttributeValue((Node)applicationNameNode, (String)"name");
        }
        this.resourceNames = new HashSet<String>();
        this.resourceNames.addAll(this.getResources(ruleNode, "ResourceName", PolicyManager.migratedToEntitlementService));
        Set<String> excludeResources = this.getResources(ruleNode, "ExcludedResourceName", PolicyManager.migratedToEntitlementService);
        if (excludeResources != null) {
            this.excludedResourceNames = new HashSet<String>();
            this.excludedResourceNames.addAll(excludeResources);
        }
        Set actionNodes = XMLUtils.getChildNodes((Node)ruleNode, (String)"AttributeValuePair");
        this.actions = new HashMap();
        if (actionNodes != null) {
            Iterator items = actionNodes.iterator();
            while (items.hasNext()) {
                String actionName = null;
                Set actionValues = null;
                Node node = (Node)items.next();
                Node attrNode = XMLUtils.getChildNode((Node)node, (String)"Attribute");
                if (attrNode == null || (actionName = XMLUtils.getNodeAttributeValue((Node)attrNode, (String)"name")) == null || (actionValues = XMLUtils.getAttributeValuePair((Node)node)) == null) {
                    Object[] objs = new String[]{actionName == null ? "null" : actionName};
                    throw new InvalidFormatException("amPolicy", "invalid_xml_rule_action_name", objs, this.ruleName, 2);
                }
                this.actions.put(actionName, actionValues);
            }
        }
    }

    private Set<String> getResources(Node ruleNode, String childNodeName, boolean migratedToEntitlementService) throws InvalidNameException {
        HashSet<String> container = null;
        Set children = XMLUtils.getChildNodes((Node)ruleNode, (String)childNodeName);
        if (children != null && !children.isEmpty()) {
            container = new HashSet<String>();
            for (Node resourceNode : children) {
                String resourceName = XMLUtils.getNodeAttributeValue((Node)resourceNode, (String)"name");
                if (resourceName == null) continue;
                resourceName = resourceName.trim();
                if (!migratedToEntitlementService) {
                    try {
                        resourceName = this.serviceType.canonicalize(resourceName);
                    }
                    catch (PolicyException pe) {
                        throw new InvalidNameException(pe, resourceName, 2);
                    }
                }
                container.add(resourceName);
            }
        }
        return container;
    }

    private void checkAndSetServiceType(String serviceTypeName) throws NameNotFoundException {
        ServiceTypeManager stm = null;
        try {
            stm = ServiceTypeManager.getServiceTypeManager();
            this.serviceType = stm.getServiceType(serviceTypeName);
        }
        catch (SSOException ssoe) {
            PolicyManager.debug.error("Unable to get admin SSO token" + (Object)((Object)ssoe));
            throw new NameNotFoundException((Throwable)((Object)ssoe), serviceTypeName, 3);
        }
    }

    public String getName() {
        return this.ruleName;
    }

    public void setName(String ruleName) throws InvalidNameException {
        this.ruleName = ruleName != null ? ruleName : "rule" + ServiceTypeManager.generateRandomName();
    }

    public String getServiceTypeName() {
        return this.serviceTypeName;
    }

    public String getResourceName() {
        return this.resourceNames == null || this.resourceNames.isEmpty() ? EMPTY_RESOURCE_NAME : this.resourceNames.iterator().next();
    }

    public Set<String> getResourceNames() {
        return this.resourceNames;
    }

    public void setResourceNames(Set<String> resourceNames) {
        this.resourceNames = new HashSet<String>();
        if (resourceNames != null) {
            this.resourceNames.addAll(resourceNames);
        }
    }

    public Set<String> getExcludedResourceNames() {
        return this.excludedResourceNames;
    }

    public void setExcludedResourceNames(Set<String> excludedResourceNames) {
        if (excludedResourceNames != null) {
            this.excludedResourceNames = new HashSet<String>();
            this.excludedResourceNames.addAll(excludedResourceNames);
        } else {
            this.excludedResourceNames = null;
        }
    }

    public Set getActionNames() {
        return new HashSet(this.actions.keySet());
    }

    public Set getActionValues(String actionName) throws NameNotFoundException {
        Set answer = (Set)this.actions.get(actionName);
        if (answer != null) {
            answer = (Set)((HashSet)answer).clone();
        }
        return answer;
    }

    public Map getActionValues() {
        return new HashMap(this.actions);
    }

    public void setActionValues(Map actionValues) throws InvalidNameException {
        this.serviceType.validateActionValues(actionValues);
        this.actions = new HashMap(actionValues);
    }

    public boolean equals(Object obj) {
        boolean matched = true;
        if (obj == null || !(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        if (this.excludedResourceNames == null ? other.getExcludedResourceNames() != null : !((Object)this.excludedResourceNames).equals(other.getExcludedResourceNames())) {
            return false;
        }
        if (this.applicationName == null ? other.applicationName != null : !this.applicationName.equals(other.applicationName)) {
            return false;
        }
        if (this.resourceNames == null ? other.resourceNames != null : !((Object)this.resourceNames).equals(other.resourceNames)) {
            return false;
        }
        if (!((Object)this.actions).equals(other.actions)) {
            return false;
        }
        return matched;
    }

    public ResourceMatch isResourceMatch(String serviceName, String resourceName) {
        ResourceMatch rm = null;
        if (!serviceName.equalsIgnoreCase(this.serviceTypeName)) {
            rm = ResourceMatch.NO_MATCH;
        } else {
            String res = this.getResourceNames().iterator().next();
            rm = this.serviceType.compare(resourceName, res);
        }
        return rm;
    }

    public String toXML() {
        StringBuffer answer = new StringBuffer(100);
        answer.append("\n").append("<Rule");
        if (this.ruleName != null) {
            answer.append(" name=\"");
            answer.append(XMLUtils.escapeSpecialCharacters((String)this.ruleName));
            answer.append("\">");
        } else {
            answer.append(">");
        }
        answer.append("\n").append("<ServiceName name=\"");
        answer.append(XMLUtils.escapeSpecialCharacters((String)this.serviceTypeName));
        answer.append("\" />");
        if (this.resourceNames != null) {
            for (String resourceName : this.resourceNames) {
                answer.append("\n").append("<ResourceName name=\"");
                answer.append(XMLUtils.escapeSpecialCharacters((String)resourceName));
                answer.append("\" />");
            }
        }
        if (this.excludedResourceNames != null) {
            for (String r : this.excludedResourceNames) {
                answer.append("\n").append("<ExcludedResourceName name=\"");
                answer.append(XMLUtils.escapeSpecialCharacters((String)r));
                answer.append("\" />");
            }
        }
        if (this.applicationName != null) {
            answer.append("\n").append("<").append("ApplicationName").append(" name=\"").append(XMLUtils.escapeSpecialCharacters((String)this.applicationName)).append("\" />");
        }
        HashSet actionNames = new HashSet();
        actionNames.addAll(this.actions.keySet());
        for (String actionName : actionNames) {
            answer.append("\n").append("<AttributeValuePair>");
            answer.append("\n").append("<Attribute name=\"");
            answer.append(XMLUtils.escapeSpecialCharacters((String)actionName));
            answer.append("\" />");
            Set values = (Set)this.actions.get(actionName);
            if (values.size() > 0) {
                Iterator items = values.iterator();
                while (items.hasNext()) {
                    answer.append("\n").append("<Value>");
                    answer.append(XMLUtils.escapeSpecialCharacters((String)((String)items.next())));
                    answer.append("</Value>");
                }
            }
            answer.append("\n").append("</AttributeValuePair>");
        }
        answer.append("\n").append("</Rule>");
        return answer.toString();
    }

    protected ServiceType getServiceType() {
        return this.serviceType;
    }

    protected String toResourcesXml(String policyName) {
        StringBuffer beginning = new StringBuffer(100);
        beginning.append("<").append("PolicyCrossReferences").append(" ").append("name").append("=\"").append(this.serviceTypeName).append("\" ").append("type").append("=\"").append("Resources").append("\">");
        String normalizedResName = null;
        normalizedResName = this.resourceNames == null || this.resourceNames.isEmpty() ? "---EMPTY---" : this.resourceNames.iterator().next();
        String[] resources = this.serviceType.split(normalizedResName);
        int n = resources.length;
        StringBuffer middle = new StringBuffer(100);
        middle.append("<").append("Reference").append(" ").append("name").append("=\"").append(resources[n - 1]).append("\"><").append("PolicyName").append(" ").append("name").append("=\"").append(policyName).append("\"/></").append("Reference").append(">");
        String tmp = middle.toString();
        for (int i = n - 2; i >= 0; --i) {
            tmp = "<Reference name=\"" + resources[i] + "\">" + tmp + "</" + "Reference" + ">";
        }
        return beginning + tmp + "</" + "PolicyCrossReferences" + ">";
    }

    public String toString() {
        return this.toXML();
    }

    public Object clone() {
        Rule answer = null;
        try {
            answer = (Rule)super.clone();
        }
        catch (CloneNotSupportedException se) {
            answer = new Rule();
        }
        answer.ruleName = this.ruleName;
        answer.serviceTypeName = this.serviceTypeName;
        answer.applicationName = this.applicationName;
        answer.serviceType = this.serviceType;
        answer.resourceNames = new HashSet<String>();
        if (this.resourceNames != null) {
            answer.resourceNames.addAll(this.resourceNames);
        }
        if (this.excludedResourceNames != null) {
            answer.excludedResourceNames = new HashSet<String>();
            answer.excludedResourceNames.addAll(this.excludedResourceNames);
        }
        answer.actions = new HashMap();
        for (Object o : this.actions.keySet()) {
            Set set = (Set)this.actions.get(o);
            HashSet aset = new HashSet();
            aset.addAll(set);
            answer.actions.put(o, aset);
        }
        return answer;
    }

    Map getActionValues(String resourceType, String resourceName, Set actionNames) throws NameNotFoundException {
        ResourceMatch rm;
        HashMap<String, Set> actionValues = null;
        if (this.serviceTypeName.equalsIgnoreCase(resourceType) && actionNames != null && (ResourceMatch.EXACT_MATCH.equals(rm = this.isResourceMatch(resourceType, resourceName)) || ResourceMatch.WILDCARD_MATCH.equals(rm))) {
            actionValues = new HashMap<String, Set>();
            for (String actionName : actionNames) {
                Set values = this.getActionValues(actionName);
                if (values == null) continue;
                actionValues.put(actionName, values);
            }
        }
        return actionValues;
    }
}

