/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.util;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.common.DateUtils;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.DNMapper;
import java.security.AccessController;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class AMAuthUtils {
    private static Debug utilDebug = Debug.getInstance((String)"amAMAuthUtils");

    private AMAuthUtils() {
    }

    public static Set getAuthenticatedRealms(SSOToken token) throws SSOException {
        HashSet<String> returnRealms = new HashSet<String>();
        String ssoRealm = token.getProperty("Organization");
        returnRealms.add(DNMapper.orgNameToRealmName(ssoRealm));
        Set realmsFromScheme = AMAuthUtils.parseData(token.getProperty("AuthType"), true);
        returnRealms.addAll(realmsFromScheme);
        Set realmsFromLevel = AMAuthUtils.parseData(token.getProperty("AuthLevel"), true);
        returnRealms.addAll(realmsFromLevel);
        Set realmsFromService = AMAuthUtils.parseData(token.getProperty("Service"), true);
        returnRealms.addAll(realmsFromService);
        if (utilDebug.messageEnabled()) {
            utilDebug.message("Realms from SSO Org : " + ssoRealm);
            utilDebug.message("Realms from Auth Type : " + realmsFromScheme);
            utilDebug.message("Realms from Auth Level : " + realmsFromLevel);
            utilDebug.message("Realms from Service : " + realmsFromService);
            utilDebug.message("Return getAuthenticatedRealms : " + returnRealms);
        }
        return returnRealms;
    }

    public static Set getAuthenticatedSchemes(SSOToken token) throws SSOException {
        return AMAuthUtils.parseData(token.getProperty("AuthType"), false);
    }

    public static Set getAuthenticatedServices(SSOToken token) throws SSOException {
        return AMAuthUtils.parseData(token.getProperty("Service"), false);
    }

    public static Set getAuthenticatedLevels(SSOToken token) throws SSOException {
        return AMAuthUtils.parseData(token.getProperty("AuthLevel"), false);
    }

    public static Set getRealmQualifiedAuthenticatedSchemes(SSOToken token) throws SSOException {
        return AMAuthUtils.parseRealmData(token.getProperty("AuthType"), token.getProperty("Organization"));
    }

    public static Set getRealmQualifiedAuthenticatedServices(SSOToken token) throws SSOException {
        return AMAuthUtils.parseRealmData(token.getProperty("Service"), token.getProperty("Organization"));
    }

    public static Set getRealmQualifiedAuthenticatedLevels(SSOToken token) throws SSOException {
        return AMAuthUtils.parseRealmData(token.getProperty("AuthLevel"), token.getProperty("Organization"));
    }

    public static String toRealmQualifiedAuthnData(String realm, String data) {
        String realmQualifedData = data;
        if (realm != null && realm.length() != 0) {
            realmQualifedData = realm.trim() + ":" + data.trim();
        }
        return realmQualifedData;
    }

    public static String getRealmFromRealmQualifiedData(String realmQualifedData) {
        int index;
        String realm = null;
        if (realmQualifedData != null && realmQualifedData.length() != 0 && (index = realmQualifedData.indexOf(":")) != -1) {
            realm = realmQualifedData.substring(0, index).trim();
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("realmQualifedData : " + realmQualifedData);
            utilDebug.message("RealmFromRealmQualifiedData : " + realm);
        }
        return realm;
    }

    public static String getDataFromRealmQualifiedData(String realmQualifedData) {
        String data = null;
        if (realmQualifedData != null && realmQualifedData.length() != 0) {
            int index = realmQualifedData.indexOf(":");
            data = index != -1 ? realmQualifedData.substring(index + 1).trim() : realmQualifedData;
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("realmQualifedData : " + realmQualifedData);
            utilDebug.message("DataFromRealmQualifiedData : " + data);
        }
        return data;
    }

    private static Set parseData(String data, boolean realm) {
        HashSet<String> returnData = Collections.EMPTY_SET;
        if (data != null && data.length() != 0) {
            StringTokenizer stz = new StringTokenizer(data, "|");
            returnData = new HashSet<String>();
            while (stz.hasMoreTokens()) {
                String nameValue = stz.nextToken();
                int index = nameValue.indexOf(":");
                if (index == -1 && realm) continue;
                if (index == -1) {
                    returnData.add(nameValue);
                    continue;
                }
                String name = nameValue.substring(0, index).trim();
                String value = nameValue.substring(index + 1).trim();
                if (realm) {
                    returnData.add(name);
                    continue;
                }
                returnData.add(value);
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("parseData:Input data : " + data);
            utilDebug.message("parseData:returnData : " + returnData);
        }
        return returnData;
    }

    private static Set parseRealmData(String data, String orgDN) {
        HashSet<String> returnData = Collections.EMPTY_SET;
        String realm = DNMapper.orgNameToRealmName(orgDN);
        if (data != null && data.length() != 0) {
            StringTokenizer stz = new StringTokenizer(data, "|");
            returnData = new HashSet<String>();
            while (stz.hasMoreTokens()) {
                String realmData = stz.nextToken();
                if (realmData == null || realmData.length() == 0) continue;
                int index = realmData.indexOf(":");
                if (index == -1) {
                    realmData = AMAuthUtils.toRealmQualifiedAuthnData(realm, realmData);
                }
                returnData.add(realmData);
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("parseRealmData:Input data : " + data);
            utilDebug.message("parseRealmData:returnData : " + returnData);
        }
        return returnData;
    }

    public static Map getModuleAuthTimeMap(SSOToken ssoToken) {
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AMAuthUtils.getModuleAuthTimeMap : ssoToken = " + ssoToken.getTokenID());
        }
        String moduleAuthTime = null;
        try {
            moduleAuthTime = ssoToken.getProperty("moduleAuthTime");
        }
        catch (SSOException ssoExp) {
            utilDebug.warning("AMAuthUtils.getModuleAuthTimeMap :Cannot get Module Auth Time from SSO Token");
        }
        HashMap<String, String> moduleTimeMap = new HashMap<String, String>();
        if (moduleAuthTime == null || moduleAuthTime.length() == 0) {
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AMAuthUtils.getModuleAuthTimeMap : MODULE_AUTH_TIME not set in SSO Token ");
            }
            try {
                String authType = ssoToken.getProperty("AuthType");
                String authInstant = ssoToken.getProperty("authInstant");
                StringTokenizer tokenizer = new StringTokenizer(authType, "|");
                while (tokenizer.hasMoreTokens()) {
                    String moduleName = tokenizer.nextToken();
                    moduleTimeMap.put(moduleName, authInstant);
                }
            }
            catch (SSOException ssoExp) {
                utilDebug.error("AMAuthUtils.getModuleAuthTimeMap : Cannot get Auth type/instant from SSO Token", (Throwable)((Object)ssoExp));
            }
        } else {
            StringTokenizer tokenizer = new StringTokenizer(moduleAuthTime, "|");
            while (tokenizer.hasMoreTokens()) {
                StringTokenizer elemToken = new StringTokenizer(tokenizer.nextToken(), "+");
                while (elemToken.hasMoreTokens()) {
                    String moduleName = elemToken.nextToken();
                    String authTime = elemToken.nextToken();
                    moduleTimeMap.put(moduleName, authTime);
                }
            }
        }
        if (utilDebug.messageEnabled()) {
            utilDebug.message("AMAuthUtils.getModuleAuthTimeMap : moduleTimeMap = " + moduleTimeMap);
        }
        return moduleTimeMap;
    }

    public static long getAuthInstant(SSOToken ssoToken, String authType, String authValue) {
        try {
            SSOTokenManager manager = SSOTokenManager.getInstance();
            manager.refreshSession(ssoToken);
        }
        catch (SSOException ssoExp) {
            utilDebug.warning("AMAuthUtils.getAuthInstant : Cannot refresh the SSO Token");
        }
        long retTime = 0L;
        AuthContext.IndexType indexType = AuthUtils.getIndexType(authType);
        if (indexType == AuthContext.IndexType.MODULE_INSTANCE) {
            Map moduleTimeMap = AMAuthUtils.getModuleAuthTimeMap(ssoToken);
            String strDate = (String)moduleTimeMap.get(authValue);
            if (utilDebug.messageEnabled()) {
                utilDebug.message("AMAuthUtils.getAuthInstant : date from getAuthInstant = " + strDate);
            }
            if (strDate != null && strDate.length() != 0) {
                Date dt = null;
                try {
                    dt = DateUtils.stringToDate(strDate);
                }
                catch (ParseException parseExp) {
                    utilDebug.message("AMAuthUtils.getAuthInstant : Cannot parse Date");
                }
                if (dt != null) {
                    retTime = dt.getTime();
                }
            }
        }
        return retTime;
    }

    public static List getModuleInstancesForHttpBasic(String realmName) {
        ArrayList moduleInstances = new ArrayList();
        AMAuthUtils.addModInstanceNames(realmName, "DataStore", moduleInstances);
        AMAuthUtils.addModInstanceNames(realmName, "LDAP", moduleInstances);
        AMAuthUtils.addModInstanceNames(realmName, "AD", moduleInstances);
        AMAuthUtils.addModInstanceNames(realmName, "JDBC", moduleInstances);
        return moduleInstances;
    }

    private static void addModInstanceNames(String realmName, String moduleType, List modInstances) {
        try {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            AMAuthenticationManager amAM = new AMAuthenticationManager(adminToken, realmName);
            Set instanceNames = amAM.getModuleInstanceNames(moduleType);
            modInstances.addAll(instanceNames);
        }
        catch (AMConfigurationException exp) {
            utilDebug.error("AMAuthUtils.addModInstanceNames: Error while trying to get auth module instance names for auth type" + moduleType);
        }
    }
}

