/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import java.util.LinkedList;

public class ReaderWriterLock {
    private int currentReaders;
    private int queuedReaders;
    private int currentWriters;
    private final LinkedList writerLocks = new LinkedList();

    public synchronized void readRequest() {
        if (this.currentWriters == 0 && this.writerLocks.size() == 0) {
            ++this.currentReaders;
        } else {
            ++this.queuedReaders;
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean readRequestImmediate() {
        if (this.currentWriters == 0 && this.writerLocks.size() == 0) {
            ++this.currentReaders;
            return true;
        }
        return false;
    }

    public synchronized void readDone() {
        if (--this.currentReaders == 0) {
            this.notify_writers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRequest() {
        Object lock;
        Object object = lock = new Object();
        synchronized (object) {
            ReaderWriterLock readerWriterLock = this;
            synchronized (readerWriterLock) {
                boolean goAheadWithWrite;
                boolean bl = goAheadWithWrite = this.writerLocks.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0;
                if (goAheadWithWrite) {
                    ++this.currentWriters;
                    return;
                }
                this.writerLocks.addLast(lock);
            }
            try {
                lock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public synchronized boolean writeRequestImmediate() {
        if (this.writerLocks.size() == 0 && this.currentReaders == 0 && this.currentWriters == 0) {
            ++this.currentWriters;
            return true;
        }
        return false;
    }

    public synchronized void writeDone() {
        --this.currentWriters;
        if (this.queuedReaders > 0) {
            this.notify_readers();
        } else {
            this.notify_writers();
        }
    }

    private void notify_readers() {
        this.currentReaders += this.queuedReaders;
        this.queuedReaders = 0;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notify_writers() {
        if (this.writerLocks.size() > 0) {
            Object oldest = this.writerLocks.removeFirst();
            ++this.currentWriters;
            Object e = oldest;
            synchronized (e) {
                oldest.notify();
            }
        }
    }

    public static class Test {
        Resource resource = new Resource();

        public Test() {
            if (!this.resource.read_if_possible()) {
                System.out.println("Immediate read request didn't work");
            }
            if (!this.resource.write_if_possible()) {
                System.out.println("Immediate write request didn't work");
            }
            new Writer("w/0").start();
            new Reader("r/1").start();
            new Writer("w/1").start();
            new Writer("w/2").start();
            new Reader("r/2").start();
            new Reader("r/3").start();
        }

        public static void main(String[] args) {
            new Test();
        }

        class Writer
        extends Thread {
            private String name;

            Writer(String name) {
                this.name = name;
            }

            public void run() {
                System.out.println("Starting " + this.name);
                Test.this.resource.write(this.name);
                System.out.println("Stopping " + this.name);
            }
        }

        class Reader
        extends Thread {
            private String name;

            Reader(String name) {
                this.name = name;
            }

            public void run() {
                System.out.println("Starting " + this.name);
                Test.this.resource.read(this.name);
                System.out.println("Stopping " + this.name);
            }
        }

        static class Resource {
            ReaderWriterLock lock = new ReaderWriterLock();

            Resource() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void read(String reader) {
                try {
                    this.lock.readRequest();
                    System.out.println("\t\t" + reader + " reading");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("\t\t" + reader + " done");
                }
                finally {
                    this.lock.readDone();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void write(String writer) {
                try {
                    this.lock.writeRequest();
                    System.out.println("\t\t" + writer + " writing");
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    System.out.println("\t\t" + writer + " done");
                }
                finally {
                    this.lock.writeDone();
                }
            }

            public boolean read_if_possible() {
                if (this.lock.readRequestImmediate()) {
                    this.lock.readDone();
                    return true;
                }
                return false;
            }

            public boolean write_if_possible() {
                if (this.lock.writeRequestImmediate()) {
                    this.lock.writeDone();
                    return true;
                }
                return false;
            }
        }
    }
}

