/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.ConditionOpViewBeanBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Map;

public class ConditionAddViewBean
extends ConditionOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/ConditionAdd.jsp";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";

    ConditionAddViewBean(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    public ConditionAddViewBean() {
        super("ConditionAdd", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name);
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.back");
        this.ptModel.setValue("button2", (Object)"button.finish");
        this.ptModel.setValue("button3", (Object)"button.cancel");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        boolean wizard = this.getPageSessionAttribute("wizard") != null;
        String ptTitle = "page.title.policy.condition.create";
        if (!wizard) {
            ptTitle = "page.title.policy.condition.create.shortcut";
            this.disableButton("button1", true);
        }
        PolicyModel model = (PolicyModel)this.getModel();
        String i18nName = (String)this.propertySheetModel.getValue("tfConditionTypeName");
        String title = model.getLocalizedString(ptTitle);
        String[] param = new String[]{i18nName};
        this.ptModel.setPageTitleText(MessageFormat.format(title, param));
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.submitCycle = true;
        try {
            Condition condition = this.createCondition();
            if (condition != null) {
                CachedPolicy cachedPolicy = this.getCachedPolicy();
                Policy policy = cachedPolicy.getPolicy();
                String name = (String)this.propertySheetModel.getValue("tfConditionName");
                policy.addCondition(name, condition);
                this.backTrail();
                this.forwardToPolicyViewBean();
            } else {
                this.forwardTo();
            }
        }
        catch (NameAlreadyExistsException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
            this.forwardTo();
        }
        catch (InvalidNameException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
            this.forwardTo();
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
            this.forwardTo();
        }
    }

    protected Map getDefaultValues() {
        return null;
    }

    protected boolean hasValues() {
        return true;
    }

    protected String getBreadCrumbDisplayName() {
        return "breadcrumbs.addCondition";
    }

    protected boolean startPageTrail() {
        return false;
    }
}

