/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.common;

import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ResourceBundle;

public class MessageWriter {
    private final String logName = "amtune-config";
    private PrintWriter logFile = null;
    private String logFilePath = null;
    private static boolean writeToFile = true;
    private static boolean writeToTerm = true;
    private static MessageWriter logObj;
    private ResourceBundle rb;

    private MessageWriter() throws AMTuneException {
        try {
            File logDir = new File(AMTuneUtil.getCurDir() + "../.." + "/" + "logs");
            if (!logDir.isDirectory()) {
                logDir.mkdirs();
            }
            this.logFilePath = logDir.getAbsolutePath() + "/" + this.generateLogFileName("amtune-config");
            this.rb = ResourceBundle.getBundle("amtune");
        }
        catch (Exception ex) {
            throw new AMTuneException(ex.getMessage());
        }
    }

    public static void setWriteToFile(boolean toFile) {
        writeToFile = toFile;
    }

    public static void setWriteToTerm(boolean toTerm) {
        writeToTerm = toTerm;
    }

    public static MessageWriter getInstance() throws AMTuneException {
        if (logObj == null) {
            logObj = new MessageWriter();
        }
        return logObj;
    }

    public void writelnLocaleMsg(String msg) {
        try {
            this.writeln(this.rb.getString(msg).replace("\n", ""));
        }
        catch (Exception ex) {
            this.writeln(msg);
        }
    }

    public void writeLocaleMsg(String msg) {
        try {
            this.write(this.rb.getString(msg).replace("\n", ""));
        }
        catch (Exception ex) {
            this.write(msg);
        }
    }

    public void write(String msg) {
        try {
            if (this.logFile == null) {
                FileOutputStream fos = new FileOutputStream(this.logFilePath, true);
                this.logFile = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8")), true);
            }
            if (writeToFile && writeToTerm) {
                this.logFile.print(msg);
                System.out.print(msg);
            } else if (writeToTerm) {
                System.out.print(msg);
            } else if (writeToFile) {
                this.logFile.print(msg);
            }
            this.logFile.flush();
        }
        catch (IOException e) {
            System.err.println(msg);
        }
    }

    public void writeln(String msg) {
        try {
            if (this.logFile == null) {
                FileOutputStream fos = new FileOutputStream(this.logFilePath, true);
                this.logFile = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)fos, "UTF-8")), true);
            }
            if (writeToFile && writeToTerm) {
                this.logFile.println(msg);
                System.out.println(msg);
            } else if (writeToTerm) {
                System.out.print(msg);
            } else if (writeToFile) {
                this.logFile.println(msg);
            }
            this.logFile.flush();
        }
        catch (IOException e) {
            System.err.println(msg);
        }
    }

    public void close() {
        if (this.logFile == null) {
            return;
        }
        this.logFile.flush();
        this.logFile.close();
        this.logFile = null;
    }

    private String generateLogFileName(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            return "";
        }
        String logFileName = prefix + "." + AMTuneUtil.getRandomStr() + ".log";
        return logFileName;
    }

    public String getConfigurationFilePath() {
        return this.logFilePath;
    }
}

