/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.cli;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.authentication.internal.InvalidAuthContextException;
import com.sun.identity.cli.CLIException;
import com.sun.identity.cli.CommandManager;
import com.sun.identity.cli.IOutput;
import com.sun.identity.cli.LogWriter;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.locale.Locale;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.LoginException;

class Authenticator {
    private static final String LOGIN_STATUS = "iplanet-am-user-login-status";
    private static final String ACCOUNT_LIFE = "iplanet-am-user-account-life";
    private static final String STRING_ACTIVE = "active";
    private static final String DEFINED_AUTH_MODULE = "com.sun.identity.amadmin.authModule";
    private static final String LDAP_AUTH_MODULE = "LDAP";
    private static final String FLATFILE_AUTH_MODULE = "DataStore";
    private static Set ACTIVE_STATE_ATTRIBUTES = new HashSet(4);
    private static Authenticator instance = new Authenticator();

    private Authenticator() {
    }

    public static Authenticator getInstance() {
        return instance;
    }

    public com.sun.identity.authentication.AuthContext sessionBasedLogin(CommandManager mgr, String bindUser, String bindPwd) throws CLIException {
        String[] param = new String[]{bindUser};
        LogWriter.log(mgr, 0, Level.INFO, "ATTEMPT_LOGIN", param, null);
        try {
            com.sun.identity.authentication.AuthContext ac = this.sessionBasedLoginInternal(mgr, bindUser, bindPwd);
            LogWriter.log(mgr, 0, Level.INFO, "SUCCEED_LOGIN", param, null);
            return ac;
        }
        catch (CLIException e) {
            String[] params = new String[]{bindUser, e.getMessage()};
            LogWriter.log(mgr, 1, Level.INFO, "FAILED_LOGIN", params, null);
            throw e;
        }
    }

    private com.sun.identity.authentication.AuthContext sessionBasedLoginInternal(CommandManager mgr, String bindUser, String bindPwd) throws CLIException {
        com.sun.identity.authentication.AuthContext lc = null;
        String authModule = SystemProperties.get(DEFINED_AUTH_MODULE);
        if (authModule != null) {
            lc = this.sessionBasedLoginInternal(mgr, bindUser, bindPwd, authModule);
        } else {
            try {
                lc = this.sessionBasedLoginInternal(mgr, bindUser, bindPwd, LDAP_AUTH_MODULE);
            }
            catch (CLIException e) {
                lc = this.sessionBasedLoginInternal(mgr, bindUser, bindPwd, FLATFILE_AUTH_MODULE);
            }
        }
        return lc;
    }

    private com.sun.identity.authentication.AuthContext sessionBasedLoginInternal(CommandManager mgr, String bindUser, String bindPwd, String authModule) throws CLIException {
        com.sun.identity.authentication.AuthContext lc = this.getAuthContext(mgr, authModule);
        this.processCallback(mgr, lc, bindUser, bindPwd);
        try {
            lc.getSSOToken();
        }
        catch (Exception e) {
            ResourceBundle rb = mgr.getResourceBundle();
            throw new CLIException(rb.getString("exception-session-based-login-failed"), 20);
        }
        return lc;
    }

    SSOToken ldapLogin(CommandManager mgr, String bindUser, String bindPwd) throws CLIException {
        SSOToken ssoToken = null;
        IOutput outputWriter = mgr.getOutputWriter();
        ResourceBundle rb = mgr.getResourceBundle();
        if (mgr.isVerbose()) {
            outputWriter.printlnMessage(rb.getString("verbose-authenticating"));
        }
        String[] param = new String[]{bindUser};
        String installTime = SystemProperties.get("com.sun.identity.security.amadmin", "false");
        if (installTime.equalsIgnoreCase("false")) {
            LogWriter.log(mgr, 0, Level.INFO, "ATTEMPT_LOGIN", param, null);
            try {
                com.sun.identity.authentication.AuthContext lc = this.sessionBasedLoginInternal(mgr, bindUser, bindPwd);
                ssoToken = lc.getSSOToken();
                mgr.registerSSOToken(ssoToken);
            }
            catch (Exception e) {
                ssoToken = this.ldapLoginInternal(mgr, bindUser, bindPwd);
            }
        }
        if (ssoToken == null) {
            ssoToken = this.ldapLoginInternal(mgr, bindUser, bindPwd);
        }
        LogWriter.log(mgr, 0, Level.INFO, "SUCCEED_LOGIN", param, null);
        if (mgr.isVerbose()) {
            outputWriter.printlnMessage(rb.getString("verbose-authenticated"));
        }
        return ssoToken;
    }

    private SSOToken ldapLoginInternal(CommandManager mgr, String bindUser, String bindPwd) throws CLIException {
        SSOToken ssoToken = null;
        ResourceBundle rb = mgr.getResourceBundle();
        try {
            AuthContext ac = this.getLDAPAuthContext(bindUser, bindPwd);
            if (ac.getLoginStatus() != 3) {
                throw new CLIException(rb.getString("exception-LDAP-login-failed"), 19);
            }
            ssoToken = ac.getSSOToken();
            AMIdentity amid = new AMIdentity(ssoToken, ssoToken.getPrincipal().getName(), IdType.USER, "/", null);
            ssoToken.setProperty("sun.am.UniversalIdentifier", amid.getUniversalId());
        }
        catch (LoginException le) {
            String[] params = new String[]{bindUser, le.getMessage()};
            LogWriter.log(mgr, 1, Level.INFO, "FAILED_LOGIN", params, null);
            throw new CLIException(rb.getString("exception-LDAP-login-failed"), 19);
        }
        catch (SSOException e) {
            String[] params = new String[]{bindUser, e.getMessage()};
            LogWriter.log(mgr, 1, Level.INFO, "FAILED_LOGIN", params, null);
            throw new CLIException((Throwable)((Object)e), 19);
        }
        catch (InvalidAuthContextException iace) {
            String[] params = new String[]{bindUser, iace.getMessage()};
            LogWriter.log(mgr, 1, Level.INFO, "FAILED_LOGIN", params, null);
            throw new CLIException(rb.getString("exception-LDAP-login-failed"), 19);
        }
        return ssoToken;
    }

    private AuthContext getLDAPAuthContext(String bindUser, String bindPwd) throws LoginException {
        AuthPrincipal principal = new AuthPrincipal(bindUser);
        AuthContext authContext = new AuthContext(principal, bindPwd.toCharArray());
        return authContext;
    }

    private com.sun.identity.authentication.AuthContext getAuthContext(CommandManager mgr, String moduleName) throws CLIException {
        try {
            com.sun.identity.authentication.AuthContext lc = new com.sun.identity.authentication.AuthContext("/");
            lc.login(AuthContext.IndexType.MODULE_INSTANCE, moduleName);
            return lc;
        }
        catch (LoginException le) {
            ResourceBundle rb = mgr.getResourceBundle();
            throw new CLIException(rb.getString("exception-LDAP-login-failed"), 20);
        }
    }

    private void processCallback(CommandManager mgr, com.sun.identity.authentication.AuthContext lc, String bindUser, String bindPwd) throws CLIException {
        ResourceBundle rb = mgr.getResourceBundle();
        while (lc.hasMoreRequirements()) {
            Callback[] callbacks = lc.getRequirements();
            if (callbacks == null) continue;
            this.setCallbackValues(callbacks, bindUser, bindPwd);
            lc.submitRequirements(callbacks);
        }
        if (lc.getStatus() != AuthContext.Status.SUCCESS) {
            throw new CLIException(rb.getString("exception-LDAP-login-failed"), 20);
        }
    }

    private void setCallbackValues(Callback[] callbacks, String bindUser, String bindPwd) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName(bindUser);
                continue;
            }
            if (!(callbacks[i] instanceof PasswordCallback)) continue;
            PasswordCallback pc = (PasswordCallback)callbacks[i];
            char[] pswd = bindPwd.toCharArray();
            pc.setPassword(pswd);
        }
    }

    private static String getStringValue(Map map, String key) {
        Set set;
        String strValue = null;
        if (map != null && !map.isEmpty() && (set = (Set)map.get(key)) != null && !set.isEmpty()) {
            strValue = (String)set.iterator().next();
        }
        return strValue;
    }

    private static boolean isExpired(String strDate) {
        boolean expired = false;
        if (strDate != null && strDate.trim().length() > 0) {
            Date exprDate = Locale.parseNormalizedDateString((String)strDate);
            expired = exprDate.before(new Date());
        }
        return expired;
    }

    static {
        ACTIVE_STATE_ATTRIBUTES.add(LOGIN_STATUS);
        ACTIVE_STATE_ATTRIBUTES.add(ACCOUNT_LIFE);
    }
}

