/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.common;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class ISResourceBundle
extends ListResourceBundle {
    private static final String LOCALE_SERVICE = "sunIdentityLocaleService";
    private static final String VERSION = "1.0";
    private static final String RB_CONFIG_ID = "ResourceBundleName";
    private static final String LOCALE_CONFIG_ID = "Locale";
    private String[][] rbArray;
    private static Debug debug = Debug.getInstance((String)"amProfile");
    private static final String bundleName = "amCommonUtils";
    public static ResourceBundle _bundle = ResourceBundle.getBundle("amCommonUtils");

    protected ISResourceBundle(Map keyValues) {
        if (keyValues == null) {
            throw new NullPointerException();
        }
        this.rbArray = new String[keyValues.size()][2];
        Iterator it = keyValues.keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            String key = (String)it.next();
            Set values = (Set)keyValues.get(key);
            if (values.size() == 0) continue;
            String value = (String)values.iterator().next();
            this.rbArray[count][0] = this.convertUnicode(key);
            this.rbArray[count][1] = this.convertUnicode(value);
            ++count;
        }
    }

    public static ResourceBundle getResourceBundle(SSOToken token, String rbName, Locale locale) throws SSOException {
        if (locale == null) {
            return ISResourceBundle.getResourceBundle(token, rbName, (String)null);
        }
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String loc = null;
        if (language != null && language.length() > 0) {
            loc = language;
        }
        if (country != null && country.length() > 0 && loc != null) {
            loc = loc + "_" + country;
        }
        return ISResourceBundle.getResourceBundle(token, rbName, loc);
    }

    public static ResourceBundle getResourceBundle(SSOToken token, String rbName, String locale) throws SSOException {
        try {
            return ISResourceBundle.getResourceBundleFromDisk(rbName, locale);
        }
        catch (MissingResourceException me) {
            return ISResourceBundle.getResourceBundleFromDirectory(token, rbName, locale);
        }
    }

    public static void deleteResourceBundle(SSOToken token, String rbName, String locale) throws SMSException, SSOException {
        if (rbName == null) {
            return;
        }
        ServiceConfigManager scm = new ServiceConfigManager(token, LOCALE_SERVICE, VERSION);
        ServiceConfig globalConfig = scm.getGlobalConfig(null);
        if (locale == null) {
            try {
                globalConfig.removeSubConfig(rbName);
            }
            catch (SMSException se) {
                throw new MissingResourceException(_bundle.getString("isResourceBundleMsg1") + rbName + ". " + se.getMessage(), _bundle.getString("isResourceBundleMsg2"), _bundle.getString("isResourceBundleMsg3"));
            }
        } else {
            ServiceConfig rbConfig = globalConfig.getSubConfig(rbName);
            if (rbConfig == null) {
                throw new MissingResourceException(_bundle.getString("isResourceBundleMsg0") + rbName + ". ", _bundle.getString("isResourceBundleMsg2"), _bundle.getString("isResourceBundleMsg3"));
            }
            rbConfig.removeSubConfig(locale);
        }
    }

    public static void storeResourceBundle(SSOToken token, String rbName, String locale, Map attributes) throws SMSException, SSOException {
        if (rbName == null) {
            return;
        }
        ServiceConfigManager scm = new ServiceConfigManager(token, LOCALE_SERVICE, VERSION);
        ServiceConfig globalConfig = scm.getGlobalConfig(null);
        ServiceConfig rbConfig = globalConfig.getSubConfig(rbName);
        if (rbConfig == null) {
            globalConfig.addSubConfig(rbName, RB_CONFIG_ID, 0, new HashMap());
            rbConfig = globalConfig.getSubConfig(rbName);
        }
        if (locale == null) {
            rbConfig.setAttributes(attributes);
        } else {
            ServiceConfig localeConfig = rbConfig.getSubConfig(locale);
            if (localeConfig == null) {
                rbConfig.addSubConfig(locale, LOCALE_CONFIG_ID, 0, attributes);
                localeConfig = rbConfig.getSubConfig(locale);
            } else {
                localeConfig.setAttributes(attributes);
            }
        }
    }

    protected Object[][] getContents() {
        return this.rbArray;
    }

    private static ResourceBundle getResourceBundleFromDisk(String rbName, String locale) {
        if (locale != null && locale.trim().length() > 0) {
            StringTokenizer tzer = new StringTokenizer(locale = locale.trim(), "_");
            int count = tzer.countTokens();
            if (count <= 2 && count > 0) {
                String language = tzer.nextToken();
                if (tzer.hasMoreTokens()) {
                    return ResourceBundle.getBundle(rbName, new Locale(language, tzer.nextToken()));
                }
                return ResourceBundle.getBundle(rbName, new Locale(language, ""));
            }
            return ResourceBundle.getBundle(rbName);
        }
        return ResourceBundle.getBundle(rbName);
    }

    private static ResourceBundle getResourceBundleFromDirectory(SSOToken token, String rbName, String locale) throws SSOException {
        if (debug.messageEnabled()) {
            debug.message("ISResourceBundle.get-> Unable to find RB in local path. looking in the directory: " + rbName);
        }
        String language = null;
        try {
            ServiceConfigManager scm = new ServiceConfigManager(token, LOCALE_SERVICE, VERSION);
            ServiceConfig globalConfig = scm.getGlobalConfig(null);
            if (globalConfig == null) {
                throw new MissingResourceException("Unable to find LocaleService", "com.sun.identity.common.ISResourceBundle", "all");
            }
            ServiceConfig rbConfig = globalConfig.getSubConfig(rbName);
            if (rbConfig == null) {
                throw new MissingResourceException("Unable to find ResourceBundle: " + rbName, "com.sun.identity.common.ISResourceBundle", "all");
            }
            if (locale == null) {
                Map attrs = rbConfig.getAttributes();
                return new ISResourceBundle(attrs);
            }
            StringTokenizer tzer = new StringTokenizer(locale, "_");
            language = tzer.nextToken();
            ServiceConfig localeConfig = rbConfig.getSubConfig(locale);
            if (localeConfig == null) {
                localeConfig = rbConfig.getSubConfig(language);
            }
            if (localeConfig == null) {
                Map attrs = rbConfig.getAttributes();
                return new ISResourceBundle(attrs);
            }
            Map attrs = localeConfig.getAttributes();
            return new ISResourceBundle(attrs);
        }
        catch (SMSException se) {
            throw new MissingResourceException(_bundle.getString("isResourceBundleMsg0") + rbName, _bundle.getString("isResourceBundleMsg2"), _bundle.getString("isResourceBundleMsg3"));
        }
    }

    private String convertUnicode(String inputStr) {
        int len = inputStr.length();
        StringBuffer result = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            int c;
            if ((c = inputStr.charAt(x++)) == 92 && x < len) {
                if ((c = inputStr.charAt(x++)) == 117) {
                    int value = 0;
                    if (x + 4 <= len) {
                        block6: for (int i = 0; i < 4; ++i) {
                            c = inputStr.charAt(x++);
                            switch (c) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    value = (value << 4) + c - 48;
                                    continue block6;
                                }
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    value = (value << 4) + 10 + c - 97;
                                    continue block6;
                                }
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: {
                                    value = (value << 4) + 10 + c - 65;
                                    continue block6;
                                }
                                default: {
                                    throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                }
                            }
                        }
                        result.append((char)value);
                        continue;
                    }
                    throw new IllegalArgumentException("Malformed \\uxxxx encoding.\\u should be followed by atleast four hex digits ");
                }
                if (c == 116) {
                    c = 9;
                } else if (c == 114) {
                    c = 13;
                } else if (c == 110) {
                    c = 10;
                } else if (c == 102) {
                    c = 12;
                } else {
                    result.append('\\');
                }
                result.append((char)c);
                continue;
            }
            result.append((char)c);
        }
        return result.toString();
    }
}

