/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.realm.model;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.config.AMAuthenticationManager;
import com.sun.identity.authentication.config.AMConfigurationException;
import com.sun.identity.console.base.AMViewConfig;
import com.sun.identity.console.base.model.AMAdminUtils;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.base.model.AMModelBase;
import com.sun.identity.console.realm.model.ServicesModel;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.sm.OrganizationConfigManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;

public class ServicesModelImpl
extends AMModelBase
implements ServicesModel {
    private static SSOToken adminSSOToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    private static Set SUPPORTED_SCHEMA_TYPE = new HashSet();

    public ServicesModelImpl(HttpServletRequest req, Map map) {
        super(req, map);
    }

    public Map getAssignedServiceNames(String realmName) throws AMConsoleException {
        String[] param = new String[]{realmName};
        this.logEvent("ATTEMPT_GET_ASSIGNED_SERVICE_OF_REALM", param);
        try {
            OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(this.getUserSSOToken(), realmName);
            HashSet names = orgCfgMgr.getAssignedServices();
            if (names == null || names.isEmpty()) {
                names = new HashSet();
            }
            this.getIdentityServices(realmName, names);
            AMAuthenticationManager mgr = new AMAuthenticationManager(adminSSOToken, realmName);
            AMAdminUtils.removeAllCaseIgnore(names, mgr.getAuthenticationServiceNames());
            this.removeNonDisplayableServices(names, SUPPORTED_SCHEMA_TYPE);
            names.remove("iPlanetAMAuthConfiguration");
            names.remove("iPlanetAMAuthService");
            this.logEvent("SUCCEED_GET_ASSIGNED_SERVICE_OF_REALM", param);
            return this.mapNameToDisplayName(names);
        }
        catch (AMConfigurationException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, strError};
            this.logEvent("CONFIGURATION_EXCEPTION_GET_ASSIGNED_SERVICE_OF_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, strError};
            this.logEvent("SMS_EXCEPTION_GET_ASSIGNED_SERVICE_OF_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private void getIdentityServices(String realmName, Set names) {
        try {
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
            AMIdentity realmIdentity = repo.getRealmIdentity();
            names.addAll(realmIdentity.getAssignedServices());
        }
        catch (SSOException e) {
            debug.warning("ServicesModelImpl.getIdentityServices", (Throwable)((Object)e));
        }
        catch (IdRepoException e) {
            debug.warning("ServicesModelImpl.getIdentityServices", (Throwable)e);
        }
    }

    public Map getAssignableServiceNames(String realmName) throws AMConsoleException {
        String[] param = new String[]{realmName};
        this.logEvent("ATTEMPT_GET_ASSIGNABLE_SERVICE_OF_REALM", param);
        try {
            OrganizationConfigManager orgCfgMgr = new OrganizationConfigManager(this.getUserSSOToken(), realmName);
            Set names = orgCfgMgr.getAssignableServices();
            this.addIdentityUnassignedServices(realmName, names);
            names.removeAll(orgCfgMgr.getAssignedServices());
            AMAuthenticationManager mgr = new AMAuthenticationManager(this.getUserSSOToken(), realmName);
            AMAdminUtils.removeAllCaseIgnore(names, mgr.getAuthenticationServiceNames());
            this.removeNonDisplayableServices(names, SUPPORTED_SCHEMA_TYPE);
            names.remove("iPlanetAMAuthService");
            this.logEvent("SUCCEED_GET_ASSIGNABLE_SERVICE_OF_REALM", param);
            return this.mapNameToDisplayName(names);
        }
        catch (AMConfigurationException e) {
            String strError = this.getErrorString((Throwable)((Object)e));
            String[] paramsEx = new String[]{realmName, strError};
            this.logEvent("CONFIGURATION_EXCEPTION_GET_ASSIGNABLE_SERVICE_OF_REALM", paramsEx);
            if (debug.warningEnabled()) {
                debug.warning("ServicesModel.getAssignableServiceNames " + strError);
            }
            throw new AMConsoleException("no.properties");
        }
        catch (SMSException e) {
            String strError = this.getErrorString(e);
            String[] paramsEx = new String[]{realmName, strError};
            this.logEvent("SMS_EXCEPTION_GET_ASSIGNABLE_SERVICE_OF_REALM", paramsEx);
            throw new AMConsoleException(strError);
        }
    }

    private void addIdentityUnassignedServices(String realmName, Set names) {
        try {
            AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
            AMIdentity realmIdentity = repo.getRealmIdentity();
            names.addAll(realmIdentity.getAssignableServices());
        }
        catch (IdRepoException e) {
            debug.warning("ServicesModelImpl.addIdentityUnassignedServices", (Throwable)e);
        }
        catch (SSOException e) {
            debug.warning("ServicesModelImpl.addIdentityUnassignedServices", (Throwable)((Object)e));
        }
    }

    private Map mapNameToDisplayName(Set names) {
        HashMap<String, String> map = new HashMap<String, String>(names.size() * 2);
        AMViewConfig vConfig = AMViewConfig.getInstance();
        for (String name : names) {
            String displayName;
            if (!vConfig.isServiceVisible(name) || name.equals(displayName = this.getLocalizedServiceName(name))) continue;
            map.put(name, displayName);
        }
        return map;
    }

    public void unassignServices(String realmName, Set names) throws AMConsoleException {
        if (names != null && !names.isEmpty()) {
            if (realmName == null || realmName.trim().length() == 0) {
                realmName = "/";
            }
            String[] params = new String[2];
            params[0] = realmName;
            String curServiceName = "";
            try {
                OrganizationConfigManager scm = new OrganizationConfigManager(this.getUserSSOToken(), realmName);
                AMIdentityRepository repo = new AMIdentityRepository(this.getUserSSOToken(), realmName);
                AMIdentity realmIdentity = repo.getRealmIdentity();
                Set realmServices = realmIdentity.getAssignedServices();
                Iterator iter = names.iterator();
                while (iter.hasNext()) {
                    String name;
                    curServiceName = name = (String)iter.next();
                    params[1] = name;
                    this.logEvent("ATTEMPT_UNASSIGN_SERVICE_FROM_REALM", params);
                    if (realmServices.contains(name)) {
                        realmIdentity.unassignService(name);
                    } else {
                        scm.unassignService(name);
                    }
                    this.logEvent("SUCCEED_UNASSIGN_SERVICE_FROM_REALM", params);
                }
            }
            catch (SMSException e) {
                String strError = this.getErrorString(e);
                String[] paramsEx = new String[]{realmName, curServiceName, strError};
                this.logEvent("SMS_EXCEPTION_UNASSIGN_SERVICE_FROM_REALM", paramsEx);
                throw new AMConsoleException(strError);
            }
            catch (SSOException e) {
                String strError = this.getErrorString((Throwable)((Object)e));
                String[] paramsEx = new String[]{realmName, curServiceName, strError};
                this.logEvent("SSO_EXCEPTION_UNASSIGN_SERVICE_FROM_REALM", paramsEx);
                throw new AMConsoleException(strError);
            }
            catch (IdRepoException e) {
                String strError = this.getErrorString(e);
                String[] paramsEx = new String[]{realmName, curServiceName, strError};
                this.logEvent("IDREPO_EXCEPTION_UNASSIGN_SERVICE_FROM_REALM", paramsEx);
                throw new AMConsoleException(strError);
            }
        }
    }

    private void removeNonDisplayableServices(Set serviceNames, Set schemaTypes) {
        Iterator i = serviceNames.iterator();
        while (i.hasNext()) {
            String svcName = (String)i.next();
            if (this.getServicePropertiesViewBeanURL(svcName) != null) continue;
            boolean hasAttr = false;
            Iterator j = schemaTypes.iterator();
            while (j.hasNext() && !hasAttr) {
                SchemaType type = (SchemaType)j.next();
                Set displayable = AMAdminUtils.getDisplayableAttributeNames(svcName, type);
                hasAttr = !displayable.isEmpty();
            }
            if (hasAttr) continue;
            i.remove();
        }
    }

    static {
        SUPPORTED_SCHEMA_TYPE.add(SchemaType.ORGANIZATION);
        SUPPORTED_SCHEMA_TYPE.add(SchemaType.DYNAMIC);
    }
}

