/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.entitlement.log;

import com.sun.identity.entitlement.PrivilegeManager;
import com.sun.identity.entitlement.log.ILoggerProvider;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class LoggerFactory {
    private static LoggerFactory instance = new LoggerFactory();
    private ILoggerProvider provider;

    private LoggerFactory() {
        String prop = System.getProperty("com.sun.identity.log.loggerprovider");
        if (prop != null && prop.trim().length() > 0) {
            this.provider = this.getLoggerProvider(prop, false);
        }
        if (this.provider == null) {
            this.provider = this.getLoggerProvider("com.sun.identity.entitlement.log.LoggerProvider", true);
        }
    }

    private ILoggerProvider getLoggerProvider(String className, boolean quiet) {
        try {
            className = className.trim();
            Class<?> clazz = Class.forName(className);
            return (ILoggerProvider)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            PrivilegeManager.debug.error("LoggerFactory.<init>", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            PrivilegeManager.debug.error("LoggerFactory.<init>", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            PrivilegeManager.debug.error("LoggerFactory.<init>", (Throwable)ex);
        }
        return null;
    }

    private Logger getLoggEr(String name) {
        return this.provider != null ? this.provider.getLogger(name) : LogManager.getLogManager().getLogger(name);
    }

    public static Logger getLogger(String name) {
        return instance.getLoggEr(name);
    }
}

