/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.monitoring;

import com.sun.identity.monitoring.Agent;
import com.sun.identity.monitoring.SSOServerInfo;
import com.sun.identity.monitoring.SsoServerInstance;
import com.sun.identity.shared.debug.Debug;
import com.sun.management.snmp.agent.SnmpMib;
import java.util.StringTokenizer;
import javax.management.MBeanServer;

public class SsoServerInstanceImpl
extends SsoServerInstance {
    private static Debug debug = null;
    private static String myMibName;

    public SsoServerInstanceImpl(SnmpMib myMib) {
        super(myMib);
        myMibName = myMib.getMibName();
        this.init(myMib, null);
    }

    public SsoServerInstanceImpl(SnmpMib myMib, MBeanServer server) {
        super(myMib, server);
        myMibName = myMib.getMibName();
        this.init(myMib, server);
    }

    private void init(SnmpMib myMib, MBeanServer server) {
        Byte bz;
        if (debug == null) {
            debug = Debug.getInstance((String)"amMonitoring");
        }
        String classMethod = "SsoServerInstanceImpl.init:";
        SSOServerInfo svrinfo = Agent.getAgentSvrInfo();
        this.SsoServerSFOStatus = Agent.getSFOStatus() ? "on" : "off";
        String temp = "embedded";
        if (!svrinfo.isEmbeddedDS) {
            temp = "remote";
        }
        this.SsoServerConfigStoreType = temp;
        this.SsoServerPort = new Integer(svrinfo.serverPort);
        try {
            this.SsoServerMemberOfSite = new Integer(svrinfo.siteID);
        }
        catch (NumberFormatException ex) {
            debug.error(classMethod + " svrinfo.siteID = " + svrinfo.siteID + " is not a number");
        }
        this.SsoServerHostname = svrinfo.serverName;
        this.SsoServerId = svrinfo.serverID;
        String stdt = svrinfo.startDate;
        StringTokenizer st = new StringTokenizer(stdt);
        String sdate = st.nextToken();
        String stime = st.nextToken();
        st = new StringTokenizer(sdate, "-");
        String year = st.nextToken();
        int iyear = 0;
        try {
            iyear = Integer.parseInt(year);
        }
        catch (NumberFormatException ex) {
            debug.error(classMethod + "year = " + year + " not parsable");
        }
        byte yrlow = (byte)(iyear & 0xFF);
        byte yrhigh = (byte)((iyear & 0xFF00) >> 8 & 0xFF);
        String month = st.nextToken();
        String day = st.nextToken();
        st = new StringTokenizer(stime, ":");
        String hour = st.nextToken();
        String min = st.nextToken();
        String sec = st.nextToken();
        Byte byrhi = bz = new Byte(0);
        Byte byrlo = bz;
        Byte bmo = bz;
        Byte bdy = bz;
        Byte bhr = bz;
        Byte bmn = bz;
        Byte bsc = bz;
        try {
            byrhi = new Byte(yrhigh);
            byrlo = new Byte(yrlow);
            bmo = new Byte(month);
            bdy = new Byte(day);
            bhr = new Byte(hour);
            bmn = new Byte(min);
            bsc = new Byte(sec);
        }
        catch (NumberFormatException ex) {
            debug.error(classMethod + "error converting start date/time" + ", date = " + sdate + ", time = " + stime);
        }
        this.SsoServerStartDate = new Byte[8];
        this.SsoServerStartDate[0] = byrhi;
        this.SsoServerStartDate[1] = byrlo;
        this.SsoServerStartDate[2] = bmo;
        this.SsoServerStartDate[3] = bdy;
        this.SsoServerStartDate[4] = bhr;
        this.SsoServerStartDate[5] = bmn;
        this.SsoServerStartDate[6] = bsc;
        this.SsoServerStartDate[7] = bz;
    }
}

