/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AuthenticatedSharedAgents
implements Subject,
ServiceListener {
    private static final String version = "1.0";
    private static final String agentserviceName = "AgentService";
    private static ServiceConfigManager scm = null;
    private static Set sharedAgentsCache = new HashSet();
    private static Map realmCache = new HashMap(2);
    private static ValidValues validValues = new ValidValues(0, Collections.EMPTY_SET);
    static Debug debug = Debug.getInstance((String)"AuthAgents");

    public AuthenticatedSharedAgents() {
        block7: {
            SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            if (debug.messageEnabled()) {
                debug.message(": AuthenticatedSharedAgents adding Listener");
            }
            try {
                if (scm == null) {
                    scm = new ServiceConfigManager(adminToken, agentserviceName, version);
                }
                if (scm != null) {
                    scm.addListener(this);
                }
            }
            catch (SMSException smse) {
                if (debug.warningEnabled()) {
                    debug.warning("AuthenticatedSharedAgents: Unable to init scm due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("AuthenticatedSharedAgents: Unable to init scm due to " + (Object)((Object)ssoe));
            }
        }
    }

    public void initialize(Map configParams) {
    }

    public Syntax getValueSyntax(SSOToken token) {
        return Syntax.CONSTANT;
    }

    public ValidValues getValidValues(SSOToken token) {
        return validValues;
    }

    public ValidValues getValidValues(SSOToken token, String pattern) {
        return validValues;
    }

    public String getDisplayNameForValue(String value, Locale locale) {
        return value;
    }

    public Set getValues() {
        return Collections.EMPTY_SET;
    }

    public void setValues(Set names) {
    }

    public boolean isMember(SSOToken token) throws SSOException {
        boolean ismember = false;
        boolean errCode = false;
        if (token != null && SSOTokenManager.getInstance().isValidToken(token)) {
            try {
                String userDN = null;
                String userDNUnivId = null;
                AMIdentity amId = IdUtils.getIdentity(token);
                IdType idType = amId.getType();
                userDN = amId.getName();
                userDNUnivId = amId.getUniversalId();
                if (debug.messageEnabled()) {
                    debug.message("AuthenticatedSharedAgents:isMember:idType = " + idType + ", userDN = " + userDN);
                }
                if (userDN != null && (idType.equals(IdType.AGENT) || idType.equals(IdType.AGENTONLY))) {
                    String rlmName = amId.getRealm();
                    if (this.isSharedAgent(token, userDN, userDNUnivId, rlmName)) {
                        errCode = true;
                        if (debug.messageEnabled()) {
                            debug.message("AuthenticatedSharedAgents:isMember:YES");
                        }
                    } else if (debug.messageEnabled()) {
                        debug.message("AuthenticatedSharedAgents:isMember:NO");
                    }
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("AuthenticatedSharedAgents.isMember():userDN is null or invalid IdType " + userDN + "IdType :" + idType);
                        debug.message("AuthenticatedSharedAgents.isMember():returning false");
                    }
                    errCode = false;
                }
            }
            catch (IdRepoException ire) {
                debug.error("AuthenticatedSharedAgents:isMember: IdRepoException:msg = " + ire.getMessage());
                errCode = false;
            }
            if (errCode) {
                ismember = true;
            }
        }
        return ismember;
    }

    public Object clone() {
        AuthenticatedSharedAgents theClone = null;
        try {
            theClone = (AuthenticatedSharedAgents)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        return theClone;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected boolean isSharedAgent(SSOToken token, String userName, String userDNUnivId, String rlmName) {
        boolean isSharedAgent;
        block11: {
            isSharedAgent = false;
            try {
                if (debug.messageEnabled()) {
                    debug.message("AuthenticatedSharedAgents:isSharedAgent:userName = " + userName + " Realm Name = " + rlmName);
                }
                if (userName != null) {
                    String agentName = userName;
                    if (DN.isDN((String)userName)) {
                        agentName = LDAPDN.explodeDN((String)userName, (boolean)true)[0];
                    }
                    if (debug.messageEnabled()) {
                        debug.message("AuthenticatedSharedAgents:isSharedAgent:agentName = " + agentName);
                    }
                    if (sharedAgentsCache != null && !sharedAgentsCache.isEmpty() && sharedAgentsCache.contains(userDNUnivId)) {
                        return true;
                    }
                    SSOToken adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
                    ServiceConfig oc = this.getOrgConfig(adminToken, rlmName);
                    ServiceConfig aCfg = oc.getSubConfig(agentName);
                    if (aCfg != null) {
                        String agentType = aCfg.getSchemaID();
                        if (oc.getSubConfigNames().contains(agentName) && agentType.equalsIgnoreCase("SharedAgent")) {
                            isSharedAgent = true;
                            AuthenticatedSharedAgents.updateCache(userDNUnivId);
                        }
                    }
                }
            }
            catch (SSOException ssoe) {
                if (debug.warningEnabled()) {
                    debug.warning("AuthenticatedSharedAgents.isSharedAgent(): SSOException: " + (Object)((Object)ssoe));
                }
            }
            catch (SMSException smse) {
                if (!debug.warningEnabled()) break block11;
                debug.warning("AuthenticatedSharedAgents.isSharedAgent(): SMSException: " + smse);
            }
        }
        return isSharedAgent;
    }

    private ServiceConfig getOrgConfig(SSOToken token, String realmName) {
        ServiceConfig orgConfigCache;
        block7: {
            if (debug.messageEnabled()) {
                debug.message("AuthenticatedSharedAgents.getOrgConfig() called. ");
            }
            orgConfigCache = null;
            try {
                if (realmCache != null && !realmCache.isEmpty() && realmCache.containsKey(realmName) && (orgConfigCache = (ServiceConfig)realmCache.get(realmName)).isValid()) {
                    debug.message("AuthenticatedSharedAgents.getOrgConfig() found in cache.");
                    return orgConfigCache;
                }
                if (scm == null) {
                    scm = new ServiceConfigManager(token, agentserviceName, version);
                }
                orgConfigCache = scm.getOrganizationConfig(realmName, null);
                AuthenticatedSharedAgents.updateRealmCache(realmName, orgConfigCache);
            }
            catch (SMSException smse) {
                if (debug.warningEnabled()) {
                    debug.warning("AuthenticatedSharedAgents.getOrgConfig(): Unable to get organization config due to " + smse);
                }
            }
            catch (SSOException ssoe) {
                if (!debug.warningEnabled()) break block7;
                debug.warning("AuthenticatedSharedAgents.getOrgConfig(): Unable to get organization config due to " + (Object)((Object)ssoe));
            }
        }
        return orgConfigCache;
    }

    private static void updateCache(String userDNUnivId) {
        HashSet<String> nset = new HashSet<String>();
        nset.addAll(sharedAgentsCache);
        nset.add(userDNUnivId);
        sharedAgentsCache = nset;
    }

    static void clearCache() {
        sharedAgentsCache = new HashSet();
        realmCache = new HashMap(2);
    }

    private static void updateRealmCache(String realmName, ServiceConfig orgConfig) {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgents.updateRealmCache: update cache for realm " + realmName);
        }
        HashMap<String, ServiceConfig> rmap = new HashMap<String, ServiceConfig>(2);
        rmap.putAll(realmCache);
        rmap.put(realmName, orgConfig);
        realmCache = rmap;
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgents.globalConfigChanged..");
        }
        AuthenticatedSharedAgents.clearCache();
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgents.organizationConfigChanged..");
        }
        AuthenticatedSharedAgents.clearCache();
    }

    public void schemaChanged(String serviceName, String version) {
        if (debug.messageEnabled()) {
            debug.message("AuthenticatedSharedAgents.schemaChanged..");
        }
        AuthenticatedSharedAgents.clearCache();
    }
}

