/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm.ldap;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.ums.DataLayer;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.AdminDNAction;
import com.sun.identity.shared.datastruct.OrderedSet;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPAttribute;
import com.sun.identity.shared.ldap.LDAPAttributeSet;
import com.sun.identity.shared.ldap.LDAPCompareAttrNames;
import com.sun.identity.shared.ldap.LDAPConnection;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.LDAPEntry;
import com.sun.identity.shared.ldap.LDAPEntryComparator;
import com.sun.identity.shared.ldap.LDAPException;
import com.sun.identity.shared.ldap.LDAPModificationSet;
import com.sun.identity.shared.ldap.LDAPSearchConstraints;
import com.sun.identity.shared.ldap.LDAPSearchResults;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSNotificationManager;
import com.sun.identity.sm.SMSObjectDB;
import com.sun.identity.sm.SMSObjectListener;
import com.sun.identity.sm.ldap.LDAPEventManager;
import com.sun.identity.sm.ldap.SMDataLayer;
import com.sun.identity.sm.ldap.SearchResultIterator;
import java.security.AccessController;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.ModificationItem;

public class SMSLdapObject
extends SMSObjectDB
implements SMSObjectListener {
    static DataLayer dlayer;
    static SMDataLayer smdlayer;
    static int connNumRetry;
    static int connRetryInterval;
    static HashSet retryErrorCodes;
    static int entriesPresentCacheSize;
    static boolean initializedNotification;
    static Set entriesPresent;
    static Set entriesNotPresent;
    static ResourceBundle bundle;
    boolean initialized;
    static Debug debug;
    static String[] OU_ATTR;
    static String[] O_ATTR;
    static boolean enableProxy;
    static Principal adminPrincipal;

    public SMSLdapObject() throws SMSException {
        this.initialize();
    }

    private synchronized void initialize() throws SMSException {
        if (this.initialized) {
            return;
        }
        debug = Debug.getInstance((String)"amSMSLdap");
        AMResourceBundleCache amCache = AMResourceBundleCache.getInstance();
        bundle = amCache.getResBundle("amSDK", Locale.ENGLISH);
        SMSLdapObject.OU_ATTR[0] = this.getNamingAttribute();
        SMSLdapObject.O_ATTR[0] = this.getOrgNamingAttribute();
        String enableP = SystemProperties.get("com.sun.identity.sm.ldap.enableProxy");
        boolean bl = enableProxy = enableP != null && enableP.equalsIgnoreCase("true");
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: proxy enable value: " + enableProxy);
        }
        try {
            if (enableProxy) {
                adminPrincipal = new AuthPrincipal((String)AccessController.doPrivileged(new AdminDNAction()));
                dlayer = DataLayer.getInstance();
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: DataLayer instance obtained.");
                }
            } else {
                smdlayer = SMDataLayer.getInstance();
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject: SMDataLayer instance obtained.");
                }
            }
            if (dlayer == null && smdlayer == null) {
                debug.error("SMSLdapObject: Unable to initialize LDAP");
                throw new SMSException("amSDK", "ums-configmanagererror", null);
            }
            debug.message("SMSLdapObject: LDAP Initialized successfully");
            DataLayer.initConnectionParams();
            connNumRetry = DataLayer.getConnNumRetry();
            connRetryInterval = DataLayer.getConnRetryInterval();
            retryErrorCodes = DataLayer.getRetryErrorCodes();
            String serviceDN = "ou=services," + this.getRootSuffix();
            if (!SMSLdapObject.entryExists(serviceDN)) {
                HashMap attrs = new HashMap();
                HashSet<String> attrValues = new HashSet<String>();
                attrValues.add("top");
                attrValues.add("organizationalunit");
                attrs.put("objectclass", attrValues);
                SMSLdapObject.create(adminPrincipal, serviceDN, attrs);
            }
        }
        catch (Exception e) {
            debug.error("SMSEntry: Unable to initalize(exception):", (Throwable)e);
            throw new SMSException("amSDK", "ums-configmanagererror", null);
        }
        this.initialized = true;
    }

    private void initializeNotification() {
        if (!initializedNotification) {
            if (SMSNotificationManager.isCacheEnabled()) {
                SMSNotificationManager.getInstance().registerCallbackHandler(this);
            }
            initializedNotification = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map read(SSOToken token, String dn) throws SMSException, SSOException {
        if (dn == null || dn.length() == 0) {
            debug.error("SMSLdapObject: read():Null or Empty DN=" + dn);
            throw new SMSException(new LDAPException(bundle.getString("sms-INVALID_DN") + dn, 32), "sms-NO_SUCH_OBJECT");
        }
        if (!DN.isDN((String)dn)) {
            debug.warning("SMSLdapObject: Invalid DN=" + dn);
            Object[] args = new String[]{dn};
            throw new SMSException("amSDK", "sms-INVALID_DN", args);
        }
        if (SMSNotificationManager.isCacheEnabled() && entriesNotPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject:read Entry not present: " + dn + " (checked in cached)");
            }
            return null;
        }
        LDAPEntry ldapEntry = null;
        int retry = 0;
        while (retry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.read() retry: " + retry);
            }
            int errorCode = 0;
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            try {
                ldapEntry = conn.read(this.getNormalizedName(token, dn), this.getAttributeNames());
                break;
            }
            catch (LDAPException e) {
                errorCode = e.getLDAPResultCode();
                if (!retryErrorCodes.contains(Integer.toString(errorCode)) || retry == connNumRetry) {
                    if (errorCode == 32) {
                        this.objectChanged(dn, 1);
                        if (!debug.messageEnabled()) break;
                        debug.message("SMSLdapObject.read: entry not present:" + dn);
                        break;
                    }
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject.read: Error in accessing entry DN: " + dn, (Throwable)e);
                    }
                    throw new SMSException(e, "sms-entry-cannot-access");
                }
                ++retry;
                try {
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                if (conn == null) continue;
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
        if (ldapEntry != null) {
            LDAPAttributeSet attrSet = ldapEntry.getAttributeSet();
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.read(): reading entry: " + dn);
            }
            return SearchResultIterator.convertLDAPAttributeSetToMap(attrSet);
        }
        return null;
    }

    public void create(SSOToken token, String dn, Map attrs) throws SMSException, SSOException {
        SMSLdapObject.create(token.getPrincipal(), this.getNormalizedName(token, dn), attrs);
        this.objectChanged(dn, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void create(Principal p, String dn, Map attrs) throws SMSException, SSOException {
        int retry = 0;
        while (retry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.create() retry: " + retry);
            }
            int errorCode = 0;
            LDAPConnection conn = SMSLdapObject.getConnection(p);
            try {
                LDAPAttributeSet attrSet = SMSLdapObject.copyMapToAttrSet(attrs);
                conn.add(new LDAPEntry(dn, attrSet));
                if (!debug.messageEnabled()) break;
                debug.message("SMSLdapObject.create Successfully created entry: " + dn);
                break;
            }
            catch (LDAPException e) {
                errorCode = e.getLDAPResultCode();
                if (errorCode == 68 && retry > 0) {
                    debug.warning("SMSLdapObject.create() Entry Already Exists Error for DN" + dn);
                    break;
                }
                if (!retryErrorCodes.contains(Integer.toString(errorCode)) || retry >= connNumRetry) {
                    debug.error("SMSLdapObject.create() Error in creating entry: " + dn + "\nBy Principal: " + p.getName(), (Throwable)e);
                    throw new SMSException(e, "sms-entry-cannot-create");
                }
                ++retry;
                try {
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                if (conn == null) continue;
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(SSOToken token, String dn, ModificationItem[] mods) throws SMSException, SSOException {
        int retry = 0;
        while (retry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.modify() retry: " + retry);
            }
            int errorCode = 0;
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            try {
                LDAPModificationSet modSet = SMSLdapObject.copyModItemsToLDAPModSet(mods);
                conn.modify(this.getNormalizedName(token, dn), modSet);
                if (!debug.messageEnabled()) break;
                debug.message("SMSLdapObject.modify(): Successfully modified entry: " + dn);
                break;
            }
            catch (LDAPException e) {
                errorCode = e.getLDAPResultCode();
                if (!retryErrorCodes.contains(Integer.toString(errorCode)) || retry == connNumRetry) {
                    debug.error("SMSLdapObject.modify(): Error in modifying entry: " + dn + "\nBy Principal: " + token.getPrincipal().getName(), (Throwable)e);
                    throw new SMSException(e, "sms-entry-cannot-modify");
                }
                ++retry;
                try {
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                if (conn == null) continue;
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(SSOToken token, String dn) throws SMSException, SSOException {
        for (String entry : this.subEntries(token, dn, "*", 0, false, false)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: deleting sub-entry: " + entry);
            }
            this.delete(token, this.getNamingAttribute() + "=" + entry + "," + dn);
        }
        Set subOrgNames = this.searchSubOrgNames(token, dn, "*", 0, false, false, false);
        for (String subOrg : subOrgNames) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: deleting suborganization: " + subOrg);
            }
            this.delete(token, this.getNormalizedName(token, subOrg));
        }
        LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
        try {
            SMSLdapObject.delete(conn, this.getNormalizedName(token, dn));
        }
        finally {
            SMSLdapObject.releaseConnection(conn);
        }
        this.objectChanged(dn, 1);
    }

    private static void delete(LDAPConnection conn, String dn) throws SMSException {
        try {
            int retry = 0;
            while (retry <= connNumRetry) {
                if (debug.messageEnabled()) {
                    debug.message("SMSLdapObject.delete() retry: " + retry);
                }
                try {
                    conn.delete(dn);
                    break;
                }
                catch (LDAPException e) {
                    if (!retryErrorCodes.contains("" + e.getLDAPResultCode()) || retry == connNumRetry) {
                        throw e;
                    }
                    ++retry;
                    try {
                        Thread.sleep(connRetryInterval);
                    }
                    catch (InterruptedException ex) {}
                }
            }
        }
        catch (LDAPException le) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject:delete() Unable to delete entry:" + dn, (Throwable)le);
            }
            throw new SMSException(le, "sms-entry-cannot-delete");
        }
    }

    public Set subEntries(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (filter == null) {
            filter = "*";
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: SubEntries search: " + dn);
        }
        String sfilter = "(objectClass=*)";
        if (!filter.equals("*")) {
            String[] objs = new String[]{filter};
            sfilter = MessageFormat.format(this.getSearchFilter(), objs);
        }
        Set answer = this.getSubEntries(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getSubEntries(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        LDAPSearchResults results = null;
        int retry = 0;
        while (retry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.subEntries() retry: " + retry);
            }
            int errorCode = 0;
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(numOfEntries);
            constraints.setServerTimeLimit(0);
            try {
                results = conn.search(this.getNormalizedName(token, dn), 1, filter, OU_ATTR, false, constraints);
                if (!sortResults) break;
                LDAPCompareAttrNames comparator = new LDAPCompareAttrNames(this.getNamingAttribute(), ascendingOrder);
                results.sort((LDAPEntryComparator)comparator);
                break;
            }
            catch (LDAPException e) {
                errorCode = e.getLDAPResultCode();
                if (errorCode == 32) {
                    if (!debug.messageEnabled()) break;
                    debug.message("SMSLdapObject.subEntries(): entry not present:" + dn);
                    break;
                }
                if (!retryErrorCodes.contains(Integer.toString(errorCode)) || retry >= connNumRetry) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject.subEntries: Unable to search for sub-entries: " + dn, (Throwable)e);
                    }
                    throw new SMSException(e, "sms-entry-cannot-search");
                }
                ++retry;
                try {
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                if (conn == null) continue;
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
        OrderedSet answer = new OrderedSet();
        if (results != null) {
            while (results.hasMoreElements()) {
                try {
                    LDAPEntry entry = results.next();
                    String edn = entry.getDN();
                    if (!edn.toLowerCase().startsWith("ou=")) continue;
                    String temp = LDAPDN.explodeDN((String)entry.getDN(), (boolean)true)[0];
                    answer.add(this.getDenormalizedName(token, temp));
                }
                catch (LDAPException e) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject.subEntries: Error in obtaining sub-entries: " + dn, (Throwable)e);
                    }
                    throw new SMSException(e, "sms-entry-cannot-obtain");
                }
            }
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.subEntries: Successfully obtained sub-entries for : " + dn);
            }
        }
        return answer;
    }

    public Set schemaSubEntries(SSOToken token, String dn, String filter, String sidFilter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: schemaSubEntries search: " + dn);
        }
        String[] objs = new String[]{filter, sidFilter};
        String sfilter = MessageFormat.format(this.getServiceIdSearchFilter(), objs);
        Set answer = this.getSubEntries(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder);
        return answer;
    }

    public String toString() {
        return "SMSLdapObject";
    }

    private static void releaseConnection(LDAPConnection conn) {
        if (conn != null) {
            if (enableProxy) {
                dlayer.releaseConnection(conn);
            } else {
                smdlayer.releaseConnection(conn);
            }
        }
    }

    private static void releaseConnection(LDAPConnection conn, int errorCode) {
        if (conn != null) {
            if (enableProxy) {
                dlayer.releaseConnection(conn, errorCode);
            } else {
                smdlayer.releaseConnection(conn, errorCode);
            }
        }
    }

    private static LDAPConnection getConnection(Principal p) throws SMSException {
        LDAPConnection conn = null;
        conn = enableProxy ? dlayer.getConnection(p) : smdlayer.getConnection();
        if (conn == null) {
            debug.error("SMSLdapObject: Unable to get connection to LDAP server for the principal: " + p);
            throw new SMSException(new LDAPException(bundle.getString("sms-SERVER_DOWN")), "sms-SERVER_DOWN");
        }
        return conn;
    }

    public Iterator search(SSOToken token, String startDN, String filter, Set excludes) throws SSOException, SMSException {
        LDAPSearchResults results = this.searchObjectsEx(token, startDN, filter);
        return new SearchResultIterator(results, excludes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPSearchResults searchObjectsEx(SSOToken token, String startDN, String filter) throws SSOException, SMSException {
        LDAPSearchResults results = null;
        int retry = 0;
        while (retry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.search() retry: " + retry);
            }
            int errorCode = 0;
            LDAPConnection conn = SMSLdapObject.getConnection(adminPrincipal);
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(0);
            constraints.setServerTimeLimit(0);
            String[] smsAttrs = new String[]{"sunKeyValue", "sunxmlKeyValue"};
            try {
                results = conn.search(this.getNormalizedName(token, startDN), 1, filter, smsAttrs, false, constraints);
                break;
            }
            catch (LDAPException e) {
                errorCode = e.getLDAPResultCode();
                if (!retryErrorCodes.contains(Integer.toString(errorCode)) || retry >= connNumRetry) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject.search(): LDAP exception in search for filter match: " + filter, (Throwable)e);
                    }
                    throw new SMSException(e, "sms-error-in-searching");
                }
                ++retry;
                try {
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                if (conn == null) continue;
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
        return results;
    }

    public Set search(SSOToken token, String startDN, String filter) throws SSOException, SMSException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: search filter: " + filter);
        }
        LDAPSearchResults results = this.searchObjects(token, startDN, filter);
        OrderedSet answer = new OrderedSet();
        while (results != null && results.hasMoreElements()) {
            try {
                LDAPEntry entry = results.next();
                answer.add(entry.getDN());
            }
            catch (LDAPException ldape) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject.search(): Error in searching for filter match: " + filter, (Throwable)ldape);
                }
                throw new SMSException(ldape, "sms-error-in-searching");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject.search() returned successfully: " + filter + "\n\tObjects: " + answer);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LDAPSearchResults searchObjects(SSOToken token, String startDN, String filter) throws SSOException, SMSException {
        LDAPSearchResults results = null;
        int retry = 0;
        while (retry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.search() retry: " + retry);
            }
            int errorCode = 0;
            LDAPConnection conn = SMSLdapObject.getConnection(adminPrincipal);
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(0);
            constraints.setServerTimeLimit(0);
            try {
                results = conn.search(this.getNormalizedName(token, startDN), 2, filter, null, false, constraints);
                break;
            }
            catch (LDAPException e) {
                errorCode = e.getLDAPResultCode();
                if (!retryErrorCodes.contains(Integer.toString(errorCode)) || retry >= connNumRetry) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject.search(): LDAP exception in search for filter match: " + filter, (Throwable)e);
                    }
                    throw new SMSException(e, "sms-error-in-searching");
                }
                ++retry;
                try {
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                if (conn == null) continue;
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean entryExists(SSOToken token, String dn) {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject: checking if entry exists: " + dn);
        }
        dn = new DN(dn).toRFCString().toLowerCase();
        if (SMSNotificationManager.isCacheEnabled() && entriesPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in cache: " + dn);
            }
            return true;
        }
        if (SMSNotificationManager.isCacheEnabled() && entriesNotPresent.contains(dn)) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject: entry present in not-present-cache: " + dn);
            }
            return false;
        }
        boolean entryExists = SMSLdapObject.entryExists(this.getNormalizedName(token, dn));
        if (entryExists && SMSNotificationManager.isCacheEnabled()) {
            this.initializeNotification();
            entriesPresent.add(dn);
            if (entriesPresent.size() > entriesPresentCacheSize) {
                Set set = entriesPresent;
                synchronized (set) {
                    Iterator items = entriesPresent.iterator();
                    if (items.hasNext()) {
                        items.next();
                        items.remove();
                    }
                }
            }
        } else if (SMSNotificationManager.isCacheEnabled()) {
            this.initializeNotification();
            entriesNotPresent.add(dn);
            if (entriesNotPresent.size() > entriesPresentCacheSize) {
                Set set = entriesNotPresent;
                synchronized (set) {
                    Iterator items = entriesNotPresent.iterator();
                    if (items.hasNext()) {
                        items.next();
                        items.remove();
                    }
                }
            }
        }
        return entryExists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean entryExists(String dn) {
        boolean entryExists = false;
        LDAPConnection conn = null;
        try {
            conn = SMSLdapObject.getConnection(adminPrincipal);
            conn.read(dn, OU_ATTR);
            entryExists = true;
        }
        catch (LDAPException e) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject:entryExists: " + dn + "does not exist");
            }
        }
        catch (SMSException ssoe) {
            if (debug.warningEnabled()) {
                debug.warning("SMSLdapObject: SMSException while  checking for entry: " + dn, (Throwable)ssoe);
            }
        }
        finally {
            SMSLdapObject.releaseConnection(conn);
        }
        return entryExists;
    }

    public void registerCallbackHandler(SMSObjectListener changeListener) throws SMSException {
        LDAPEventManager.addObjectChangeListener(changeListener);
    }

    public void deregisterCallbackHandler(String id) {
        LDAPEventManager.removeObjectChangeListener();
    }

    private static LDAPAttributeSet copyMapToAttrSet(Map attrs) {
        LDAPAttribute[] ldapAttrs = new LDAPAttribute[attrs.size()];
        Iterator items = attrs.keySet().iterator();
        int i = 0;
        while (items.hasNext()) {
            String attrName = (String)items.next();
            Set attrValues = (Set)attrs.get(attrName);
            ldapAttrs[i] = new LDAPAttribute(attrName, attrValues.toArray(new String[attrValues.size()]));
            ++i;
        }
        return new LDAPAttributeSet(ldapAttrs);
    }

    private static LDAPModificationSet copyModItemsToLDAPModSet(ModificationItem[] mods) throws SMSException {
        LDAPModificationSet modSet = new LDAPModificationSet();
        try {
            block7: for (int i = 0; i < mods.length; ++i) {
                Attribute attribute = mods[i].getAttribute();
                LDAPAttribute attr = new LDAPAttribute(attribute.getID());
                NamingEnumeration<?> ne = attribute.getAll();
                while (ne.hasMore()) {
                    attr.addValue((String)ne.next());
                }
                switch (mods[i].getModificationOp()) {
                    case 1: {
                        modSet.add(0, attr);
                        continue block7;
                    }
                    case 2: {
                        modSet.add(2, attr);
                        continue block7;
                    }
                    case 3: {
                        modSet.add(1, attr);
                    }
                }
            }
        }
        catch (NamingException nne) {
            throw new SMSException(nne, "sms-cannot-copy-fromModItemToModSet");
        }
        return modSet;
    }

    public void objectChanged(String dn, int type) {
        dn = new DN(dn).toRFCString().toLowerCase();
        if (type == 1) {
            entriesPresent.remove(dn);
        } else if (type == 0) {
            entriesNotPresent.remove(dn);
        }
    }

    public void allObjectsChanged() {
        if (SMSEntry.debug.warningEnabled()) {
            SMSEntry.debug.warning("SMSLDAPObject: got notifications, all objects changed");
        }
        entriesPresent.clear();
        entriesNotPresent.clear();
    }

    public Set searchSubOrgNames(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject.searchSubOrgNames search: " + dn);
        }
        String[] objs = new String[]{filter};
        String FILTER_PATTERN_ORG = "(&(objectclass=sunRealmService)(o={0}))";
        String sfilter = MessageFormat.format(FILTER_PATTERN_ORG, objs);
        Set answer = this.searchSubOrganizationNames(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder, recursive);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set searchSubOrganizationNames(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder, boolean recursive) throws SMSException, SSOException {
        LDAPSearchResults results = null;
        int scope = recursive ? 2 : 1;
        int retry = 0;
        while (retry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.searchSubOrganizationNames() retry: " + retry);
            }
            int errorCode = 0;
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(numOfEntries);
            constraints.setServerTimeLimit(0);
            try {
                results = conn.search(this.getNormalizedName(token, dn), scope, filter, O_ATTR, false, constraints);
                if (!sortResults) break;
                LDAPCompareAttrNames comparator = new LDAPCompareAttrNames(this.getOrgNamingAttribute(), ascendingOrder);
                results.sort((LDAPEntryComparator)comparator);
                break;
            }
            catch (LDAPException e) {
                errorCode = e.getLDAPResultCode();
                if (!retryErrorCodes.contains(Integer.toString(errorCode)) || retry >= connNumRetry) {
                    if (errorCode == 32) {
                        if (!debug.messageEnabled()) break;
                        debug.message("SMSLdapObject.searchSubOrganizationNames(): suborg not present:" + dn);
                        break;
                    }
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject.searchSubOrganizationName(): Unable to search for suborganization names: " + dn, (Throwable)e);
                    }
                    throw new SMSException(e, "sms-suborg-cannot-search");
                }
                ++retry;
                try {
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                if (conn == null) continue;
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
        OrderedSet answer = new OrderedSet();
        while (results != null && results.hasMoreElements()) {
            try {
                LDAPEntry entry = results.next();
                String rdn = entry.getDN().toString();
                answer.add(rdn);
            }
            catch (LDAPException e) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject.searchSubOrganizationName: Error in obtaining suborganization names: " + dn, (Throwable)e);
                }
                throw new SMSException(e, "sms-suborg-cannot-obtain");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject.searchSubOrganizationName: Successfully obtained suborganization names for : " + dn);
            debug.message("SMSLdapObject.searchSubOrganizationName: Successfully obtained suborganization names  : " + answer.toString());
        }
        return answer;
    }

    public Set searchOrganizationNames(SSOToken token, String dn, int numOfEntries, boolean sortResults, boolean ascendingOrder, String serviceName, String attrName, Set values) throws SMSException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject:searchOrganizationNames search dn: " + dn);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(&");
        for (String val : values) {
            sb.append("(|(").append("sunxmlKeyValue").append("=").append(serviceName).append("-").append(attrName).append("=").append(val).append(")");
            sb.append("(").append("sunxmlKeyValue").append("=").append(attrName).append("=").append(val).append("))");
        }
        sb.append(")");
        String filter = sb.toString();
        String FILTER_PATTERN_SEARCH_ORG = "{0}";
        String dataStore = SMSEntry.getDataStore(token);
        if (dataStore != null && !dataStore.equals(SMSEntry.DATASTORE_ACTIVE_DIR)) {
            FILTER_PATTERN_SEARCH_ORG = "(|(&(objectclass=sunRealmService){0})(&(objectclass=sunServiceComponent){0}))";
        }
        String[] objs = new String[]{filter};
        String sfilter = MessageFormat.format(FILTER_PATTERN_SEARCH_ORG, objs);
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject:orgNames search filter: " + sfilter);
        }
        Set answer = this.getOrgNames(token, dn, sfilter, numOfEntries, sortResults, ascendingOrder);
        return answer;
    }

    public void shutdown() {
        if (!enableProxy && smdlayer != null) {
            smdlayer.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getOrgNames(SSOToken token, String dn, String filter, int numOfEntries, boolean sortResults, boolean ascendingOrder) throws SMSException, SSOException {
        LDAPSearchResults results = null;
        int retry = 0;
        while (retry <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("SMSLdapObject.getOrgNames() retry: " + retry);
            }
            int errorCode = 0;
            LDAPConnection conn = SMSLdapObject.getConnection(token.getPrincipal());
            LDAPSearchConstraints constraints = conn.getSearchConstraints();
            constraints.setMaxResults(numOfEntries);
            constraints.setServerTimeLimit(0);
            try {
                results = conn.search(this.getNormalizedName(token, dn), 2, filter, O_ATTR, false, constraints);
                if (!sortResults) break;
                LDAPCompareAttrNames comparator = new LDAPCompareAttrNames(this.getOrgNamingAttribute(), ascendingOrder);
                results.sort((LDAPEntryComparator)comparator);
                break;
            }
            catch (LDAPException e) {
                errorCode = e.getLDAPResultCode();
                if (!retryErrorCodes.contains(Integer.toString(errorCode)) || retry == connNumRetry) {
                    if (errorCode == 32) {
                        if (!debug.messageEnabled()) break;
                        debug.message("SMSLdapObject.getOrgNames(): org not present:" + dn);
                        break;
                    }
                    if (debug.warningEnabled()) {
                        debug.warning("SMSLdapObject.getOrgNames: Unable to search for organization names: " + dn, (Throwable)e);
                    }
                    throw new SMSException(e, "sms-org-cannot-search");
                }
                ++retry;
                try {
                    Thread.sleep(connRetryInterval);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            finally {
                if (conn == null) continue;
                SMSLdapObject.releaseConnection(conn, errorCode);
            }
        }
        OrderedSet answer = new OrderedSet();
        while (results != null && results.hasMoreElements()) {
            try {
                LDAPEntry entry = results.next();
                String rdn = entry.getDN().toString();
                answer.add(rdn);
            }
            catch (LDAPException e) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSLdapObject.getOrgNames: Error in obtaining organization names: " + dn, (Throwable)e);
                }
                throw new SMSException(e, "sms-org-cannot-obtain");
            }
        }
        if (debug.messageEnabled()) {
            debug.message("SMSLdapObject.getOrgNames(): Successfully obtained organization names for : " + dn);
            debug.message("SMSLdapObject.getOrgNames(): Successfully obtained organization names  : " + answer.toString());
        }
        return answer;
    }

    private String getDenormalizedName(SSOToken token, String name) {
        String dataStore;
        if (name.indexOf("^") >= 0 && (dataStore = SMSEntry.getDataStore(token)) != null && dataStore.equals(SMSEntry.DATASTORE_ACTIVE_DIR)) {
            name = name.replaceAll("_", "=");
        }
        return name;
    }

    private String getNormalizedName(SSOToken token, String dn) {
        String dataStore;
        if (dn.indexOf("^") >= 0 && (dataStore = SMSEntry.getDataStore(token)) != null && dataStore.equals(SMSEntry.DATASTORE_ACTIVE_DIR)) {
            String[] dns = LDAPDN.explodeDN((String)dn, (boolean)false);
            StringBuffer buff = new StringBuffer();
            String s = dns[0];
            int idx = s.indexOf(61);
            String naming = s.substring(0, idx + 1);
            String value = s.substring(idx + 1).replaceAll("=", "_");
            buff.append(naming).append(value);
            for (int i = 1; i < dns.length; ++i) {
                s = dns[i];
                idx = s.indexOf(61);
                naming = s.substring(0, idx + 1);
                value = s.substring(idx + 1).replaceAll("=", "_");
                buff.append(",").append(naming).append(value);
            }
            dn = buff.toString();
        }
        return dn;
    }

    static {
        connNumRetry = 3;
        connRetryInterval = 1000;
        retryErrorCodes = new HashSet();
        entriesPresentCacheSize = 1000;
        entriesPresent = Collections.synchronizedSet(new LinkedHashSet());
        entriesNotPresent = Collections.synchronizedSet(new LinkedHashSet());
        OU_ATTR = new String[1];
        O_ATTR = new String[1];
    }
}

