/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.tune.impl;

import com.sun.identity.tune.base.AMTuneDSBase;
import com.sun.identity.tune.common.AMTuneException;
import com.sun.identity.tune.common.FileHandler;
import com.sun.identity.tune.config.AMTuneConfigInfo;
import com.sun.identity.tune.util.AMTuneUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;

public class TuneDS6Impl
extends AMTuneDSBase {
    private String dsAdmPath;
    private String dbBackupDir;

    public void initialize(AMTuneConfigInfo configInfo) throws AMTuneException {
        super.initialize(configInfo);
        this.dsAdmPath = AMTuneUtil.isWindows() ? this.dsConfInfo.getDSToolsBinDir() + "/" + "dsadm.exe " : this.dsConfInfo.getDSToolsBinDir() + "/" + "dsadm ";
        this.validateDSADMPath();
        this.dbBackupDir = "amtune-" + AMTuneUtil.getRandomStr();
        this.checkDSRealVersion();
    }

    private void validateDSADMPath() throws AMTuneException {
        File dsadm = new File(this.dsAdmPath.trim());
        if (!dsadm.exists()) {
            AMTuneUtil.printErrorMsg("DS_TOOLS_DIR");
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ds-tool-not-found"));
        }
    }

    private void checkDSRealVersion() throws AMTuneException {
        StringBuffer rBuff;
        String verCmd = this.dsAdmPath + " --version";
        int extVal = AMTuneUtil.executeCommand(verCmd, rBuff = new StringBuffer());
        if (extVal == -1) {
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-ds-version-fail-msg"));
        }
        if (rBuff.indexOf("6.2") != -1) {
            throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-ds-unsupported-msg"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTuning() throws AMTuneException {
        try {
            this.pLogger.log(Level.FINE, "startTuning", "Start tuning.");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-fam-ds6-tuning");
            this.mWriter.writeln("#####################################################################");
            this.mWriter.writelnLocaleMsg("pt-init");
            this.mWriter.writeln("---------------------------------------------------------------------");
            this.computeTuneValues();
            this.mWriter.writeln("=====================================================================");
            this.modifyLDAP();
            if (!AMTuneUtil.isWindows()) {
                this.tuneUsingDSE();
            }
            this.tuneFuture();
            this.mWriter.writelnLocaleMsg("pt-ds-um-mutliple-msg");
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "startTuning", "Error Tuning DSEE6.0");
            this.mWriter.writeln(" ");
            this.mWriter.writelnLocaleMsg("pt-error-tuning-msg");
            this.pLogger.logException("startTuning", ex);
        }
        finally {
            try {
                this.releaseCon();
            }
            catch (Exception exception) {}
            this.deletePasswordFile();
        }
    }

    protected void tuneUsingDSE() throws AMTuneException {
        try {
            super.tuneUsingDSE();
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "");
            if (this.configInfo.isReviewMode()) {
                return;
            }
            this.pLogger.log(Level.FINE, "tuneUsingDSE", "Modify dse.ldif");
            if (this.curDBHomeLocation.equals(this.newDBHomeLocation)) {
                this.pLogger.log(Level.INFO, "tuneUsingDSE", "Current DB Location is same as recommended value.");
                return;
            }
            this.stopDS();
            this.backUpDS();
            FileHandler dseH = new FileHandler(this.dseLdifPath);
            int reqLineNo = dseH.lineContains("nsslapd-db-home-directory:");
            dseH.replaceLine(reqLineNo, "nsslapd-db-home-directory: " + this.newDBHomeLocation);
            dseH.close();
            this.startDS();
        }
        catch (FileNotFoundException fex) {
            throw new AMTuneException(fex.getMessage());
        }
        catch (IOException ioe) {
            throw new AMTuneException(ioe.getMessage());
        }
    }

    private void modifyLDAP() throws AMTuneException {
        this.pLogger.log(Level.FINE, "modifyLDAP", "Modify LDAP attributes.");
        boolean applyRec = false;
        boolean remAci = false;
        this.ldapTuningRecommendations();
        if (this.configInfo.isReviewMode()) {
            return;
        }
        this.stopDS();
        this.backUpDS();
        this.startDS();
        applyRec = this.applyRecommendations();
        if (applyRec || remAci) {
            this.stopDS();
            this.startDS();
        }
    }

    protected void backUpDS() throws AMTuneException {
        try {
            String dbBackUpSuccessFile = this.instanceDir + "/" + "bak" + "/" + this.dbBackupDir + "/" + "SUCCESS.dontdelete";
            File successFile = new File(dbBackUpSuccessFile);
            if (successFile.isFile()) {
                this.pLogger.log(Level.INFO, "backUpDS", "Backup exists");
                return;
            }
            File bakDir = new File(this.dsConfInfo.getDsInstanceDir() + "/" + "bak");
            if (!bakDir.isDirectory()) {
                bakDir.mkdir();
            }
            StringBuffer resultBuffer = new StringBuffer();
            String db2BakCmd = this.dsAdmPath + "backup " + this.instanceDir + " " + bakDir.getAbsolutePath() + "/" + this.dbBackupDir;
            this.pLogger.log(Level.FINE, "backUpDS", "Backing up DS instance." + this.instanceDir);
            int retVal = AMTuneUtil.executeCommand(db2BakCmd, resultBuffer);
            if (retVal == -1) {
                this.mWriter.writelnLocaleMsg("pt-cannot-backup-db");
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ds-db-backup-failed"));
            }
            this.pLogger.log(Level.FINE, "backUpDS", "Backing up Done...");
            try {
                File dseLdif = new File(this.dseLdifPath);
                this.pLogger.log(Level.FINE, "backUpDS", "Backing " + this.dseLdifPath);
                File bakDseFile = new File(this.instanceDir + "/" + "bak" + "/" + this.dbBackupDir + "/" + "dse.ldif");
                AMTuneUtil.CopyFile(dseLdif, bakDseFile);
                this.pLogger.log(Level.FINE, "backUpDS", "Backing Done..");
            }
            catch (Exception ex) {
                this.pLogger.log(Level.SEVERE, "backupDS", ex.getMessage());
                throw new AMTuneException(AMTuneUtil.getResourceBundle().getString("pt-error-ds-conf-file-backup"));
            }
            successFile.createNewFile();
        }
        catch (Exception ex) {
            this.pLogger.log(Level.SEVERE, "backUpDS", "Error backing up DS " + ex.getMessage());
            throw new AMTuneException(ex.getMessage());
        }
    }

    protected void stopDS() throws AMTuneException {
        this.pLogger.log(Level.FINE, "stopDS", "Stopping DS6.");
        StringBuffer resultBuffer = new StringBuffer();
        String stopCmd = this.dsAdmPath + "stop " + this.instanceDir;
        int retVal = AMTuneUtil.executeCommand(stopCmd, resultBuffer);
        if (retVal == -1) {
            throw new AMTuneException(resultBuffer.toString());
        }
        this.pLogger.log(Level.FINE, "stopDS", "DS6 Successfully stopped.");
    }

    protected void startDS() throws AMTuneException {
        this.pLogger.log(Level.FINE, "startDS", "Starting DS6.");
        StringBuffer resultBuffer = new StringBuffer();
        String startCmd = this.dsAdmPath + "start " + this.instanceDir;
        int retVal = AMTuneUtil.executeCommand(startCmd, resultBuffer);
        if (retVal == -1) {
            throw new AMTuneException(resultBuffer.toString());
        }
        this.pLogger.log(Level.FINE, "startDS", "DS6 Successfully started.");
    }
}

