/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.security;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SecurityMechanism {
    private static Map map = new HashMap();
    public static final String WSS_NULL_SAML_HK_URI = "urn:sun:wss:security:null:SAMLToken-HK";
    public static final String WSS_TLS_SAML_HK_URI = "urn:sun:wss:security:TLS:SAMLToken-HK";
    public static final String WSS_CLIENT_TLS_SAML_HK_URI = "urn:sun:wss:security:ClientTLS:SAMLToken-HK";
    public static final String WSS_NULL_SAML_SV_URI = "urn:sun:wss:security:null:SAMLToken-SV";
    public static final String WSS_TLS_SAML_SV_URI = "urn:sun:wss:security:TLS:SAMLToken-SV";
    public static final String WSS_CLIENT_TLS_SAML_SV_URI = "urn:sun:wss:security:ClientTLS:SAMLToken-SV";
    public static final String WSS_NULL_X509_TOKEN_URI = "urn:sun:wss:security:null:X509Token";
    public static final String WSS_TLS_X509_TOKEN_URI = "urn:sun:wss:security:TLS:X509Token";
    public static final String WSS_CLIENT_TLS_X509_TOKEN_URI = "urn:sun:wss:security:ClientTLS:X509Token";
    public static final String WSS_NULL_USERNAME_TOKEN_URI = "urn:sun:wss:security:null:UserNameToken";
    public static final String WSS_TLS_USERNAME_TOKEN_URI = "urn:sun:wss:security:TLS:UserNameToken";
    public static final String WSS_CLIENT_TLS_USERNAME_TOKEN_URI = "urn:sun:wss:security:ClientTLS:UserNameToken";
    public static final String WSS_NULL_USERNAME_TOKEN_PLAIN_URI = "urn:sun:wss:security:null:UserNameToken-Plain";
    public static final String WSS_TLS_USERNAME_TOKEN_PLAIN_URI = "urn:sun:wss:security:TLS:UserNameToken-Plain";
    public static final String WSS_CLIENT_TLS_USERNAME_TOKEN_PLAIN_URI = "urn:sun:wss:security:ClientTLS:UserNameToken-Plain";
    public static final String LIBERTY_DS_SECURITY_URI = "urn:sun:liberty:discovery:security";
    public static final String STS_SECURITY_URI = "urn:sun:wss:sts:security";
    public static final String LIB_NULL_X509_TOKEN_URI = "urn:liberty:security:2005-02:null:X509";
    public static final String LIB_NULL_SAML_BEARER_TOKEN_URI = "urn:liberty:security:2005-02:null:Bearer";
    public static final String LIB_NULL_SAML_TOKEN_URI = "urn:liberty:security:2005-02:null:SAML";
    public static final String LIB_TLS_X509_TOKEN_URI = "urn:liberty:security:2005-02:TLS:X509";
    public static final String LIB_TLS_SAML_BEARER_TOKEN_URI = "urn:liberty:security:2005-02:TLS:Bearer";
    public static final String LIB_TLS_SAML_TOKEN_URI = "urn:liberty:security:2005-02:TLS:SAML";
    public static final String LIB_CLIENT_TLS_X509_TOKEN_URI = "urn:liberty:security:2005-02:ClientTLS:X509";
    public static final String LIB_CLIENT_TLS_SAML_BEARER_TOKEN_URI = "urn:liberty:security:2005-02:ClientTLS:Bearer";
    public static final String LIB_CLIENT_TLS_SAML_TOKEN_URI = "urn:liberty:security:2005-02:ClientTLS:SAML";
    public static final String WSS_NULL_SAML2_HK_URI = "urn:sun:wss:security:null:SAML2Token-HK";
    public static final String WSS_TLS_SAML2_HK_URI = "urn:sun:wss:security:TLS:SAML2Token-HK";
    public static final String WSS_CLIENT_TLS_SAML2_HK_URI = "urn:sun:wss:security:ClientTLS:SAML2Token-HK";
    public static final String WSS_NULL_SAML2_SV_URI = "urn:sun:wss:security:null:SAML2Token-SV";
    public static final String WSS_TLS_SAML2_SV_URI = "urn:sun:wss:security:TLS:SAML2Token-SV";
    public static final String WSS_CLIENT_TLS_SAML2_SV_URI = "urn:sun:wss:security:ClientTLS:SAML2Token-SV";
    public static final String WSS_NULL_ANONYMOUS_URI = "urn:sun:wss:security:null:Anonymous";
    public static final String WSS_TLS_ANONYMOUS_URI = "urn:sun:wss:security:TLS:Anonymous";
    public static final String WSS_CLIENT_TLS_ANONYMOUS_URI = "urn:sun:wss:security:ClientTLS:Anonymous";
    public static final String WSS_NULL_KERBEROS_TOKEN_URI = "urn:sun:wss:security:null:KerberosToken";
    public static final String WSS_TLS_KERBEROS_TOKEN_URI = "urn:sun:wss:security:TLS:KerberosToken";
    public static final String WSS_CLIENT_TLS_KERBEROS_TOKEN_URI = "urn:sun:wss:security:ClientTLS:KerberosToken";
    public static final SecurityMechanism WSS_CLIENT_TLS_SAML_HK;
    public static final SecurityMechanism WSS_TLS_SAML_HK;
    public static final SecurityMechanism WSS_NULL_SAML_HK;
    public static final SecurityMechanism WSS_CLIENT_TLS_SAML_SV;
    public static final SecurityMechanism WSS_TLS_SAML_SV;
    public static final SecurityMechanism WSS_NULL_SAML_SV;
    public static final SecurityMechanism WSS_NULL_X509_TOKEN;
    public static final SecurityMechanism WSS_TLS_X509_TOKEN;
    public static final SecurityMechanism WSS_CLIENT_TLS_X509_TOKEN;
    public static final SecurityMechanism WSS_NULL_USERNAME_TOKEN;
    public static final SecurityMechanism WSS_TLS_USERNAME_TOKEN;
    public static final SecurityMechanism WSS_CLIENT_TLS_USERNAME_TOKEN;
    public static final SecurityMechanism WSS_NULL_USERNAME_TOKEN_PLAIN;
    public static final SecurityMechanism WSS_TLS_USERNAME_TOKEN_PLAIN;
    public static final SecurityMechanism WSS_CLIENT_TLS_USERNAME_TOKEN_PLAIN;
    public static final SecurityMechanism LIBERTY_DS_SECURITY;
    public static final SecurityMechanism STS_SECURITY;
    public static final SecurityMechanism LIB_NULL_X509_TOKEN;
    public static final SecurityMechanism LIB_NULL_SAML_BEARER_TOKEN;
    public static final SecurityMechanism LIB_NULL_SAML_TOKEN;
    public static final SecurityMechanism LIB_TLS_X509_TOKEN;
    public static final SecurityMechanism LIB_TLS_SAML_BEARER_TOKEN;
    public static final SecurityMechanism LIB_TLS_SAML_TOKEN;
    public static final SecurityMechanism LIB_CLIENT_TLS_X509_TOKEN;
    public static final SecurityMechanism LIB_CLIENT_TLS_SAML_BEARER_TOKEN;
    public static final SecurityMechanism LIB_CLIENT_TLS_SAML_TOKEN;
    public static final SecurityMechanism WSS_CLIENT_TLS_SAML2_HK;
    public static final SecurityMechanism WSS_TLS_SAML2_HK;
    public static final SecurityMechanism WSS_NULL_SAML2_HK;
    public static final SecurityMechanism WSS_CLIENT_TLS_SAML2_SV;
    public static final SecurityMechanism WSS_TLS_SAML2_SV;
    public static final SecurityMechanism WSS_NULL_SAML2_SV;
    public static final SecurityMechanism WSS_CLIENT_TLS_ANONYMOUS;
    public static final SecurityMechanism WSS_TLS_ANONYMOUS;
    public static final SecurityMechanism WSS_NULL_ANONYMOUS;
    public static final SecurityMechanism WSS_NULL_KERBEROS_TOKEN;
    public static final SecurityMechanism WSS_TLS_KERBEROS_TOKEN;
    public static final SecurityMechanism WSS_CLIENT_TLS_KERBEROS_TOKEN;
    private String sechMech = null;
    private String uri = null;
    private boolean lookupEnabled = false;
    private boolean registerEnabled = false;

    public SecurityMechanism(String name) {
        this.sechMech = name;
        this.uri = (String)map.get(this.sechMech);
    }

    public SecurityMechanism(String name, boolean useTA) {
        this.sechMech = name;
        this.uri = (String)map.get(this.sechMech);
        this.lookupEnabled = useTA;
        this.registerEnabled = useTA;
    }

    public String getName() {
        return this.sechMech;
    }

    public String getURI() {
        return this.uri;
    }

    public boolean isTARegistrationRequired() {
        return this.registerEnabled;
    }

    public boolean isTALookupRequired() {
        return this.lookupEnabled;
    }

    public static SecurityMechanism getSecurityMechanism(String uri) {
        if (uri == null) {
            return null;
        }
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!value.equals(uri)) continue;
            if (uri.equals(LIBERTY_DS_SECURITY_URI) || uri.equals(LIB_NULL_X509_TOKEN_URI) || uri.equals(LIB_TLS_X509_TOKEN_URI) || uri.equals(LIB_CLIENT_TLS_X509_TOKEN_URI) || uri.equals(LIB_NULL_SAML_TOKEN_URI) || uri.equals(LIB_TLS_SAML_TOKEN_URI) || uri.equals(LIB_CLIENT_TLS_SAML_TOKEN_URI) || uri.equals(LIB_NULL_SAML_BEARER_TOKEN_URI) || uri.equals(LIB_TLS_SAML_BEARER_TOKEN_URI) || uri.equals(LIB_CLIENT_TLS_SAML_BEARER_TOKEN_URI) || uri.equals(STS_SECURITY_URI)) {
                return new SecurityMechanism(key, true);
            }
            return new SecurityMechanism(key);
        }
        return null;
    }

    public static List getLibertySecurityMechanismURIs() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(LIB_NULL_X509_TOKEN_URI);
        list.add(LIB_TLS_X509_TOKEN_URI);
        list.add(LIB_CLIENT_TLS_X509_TOKEN_URI);
        list.add(LIB_NULL_SAML_BEARER_TOKEN_URI);
        list.add(LIB_TLS_SAML_BEARER_TOKEN_URI);
        list.add(LIB_CLIENT_TLS_SAML_BEARER_TOKEN_URI);
        list.add(LIB_NULL_SAML_TOKEN_URI);
        list.add(LIB_TLS_SAML_TOKEN_URI);
        list.add(LIB_CLIENT_TLS_SAML_TOKEN_URI);
        return list;
    }

    public static List getAllWSCSecurityMechanisms() {
        ArrayList<SecurityMechanism> list = new ArrayList<SecurityMechanism>();
        list.add(WSS_NULL_ANONYMOUS);
        list.add(WSS_NULL_SAML_SV);
        list.add(WSS_NULL_SAML_HK);
        list.add(WSS_NULL_X509_TOKEN);
        list.add(WSS_NULL_KERBEROS_TOKEN);
        list.add(WSS_NULL_USERNAME_TOKEN);
        list.add(WSS_NULL_USERNAME_TOKEN_PLAIN);
        list.add(WSS_NULL_SAML2_SV);
        list.add(WSS_NULL_SAML2_HK);
        list.add(LIBERTY_DS_SECURITY);
        list.add(STS_SECURITY);
        return list;
    }

    public static List getAllWSPSecurityMechanisms() {
        ArrayList<SecurityMechanism> list = new ArrayList<SecurityMechanism>();
        list.add(WSS_NULL_ANONYMOUS);
        list.add(WSS_NULL_SAML_SV);
        list.add(WSS_NULL_SAML_HK);
        list.add(WSS_NULL_X509_TOKEN);
        list.add(WSS_NULL_KERBEROS_TOKEN);
        list.add(WSS_NULL_USERNAME_TOKEN);
        list.add(WSS_NULL_USERNAME_TOKEN_PLAIN);
        list.add(WSS_NULL_SAML2_SV);
        list.add(WSS_NULL_SAML2_HK);
        list.add(LIB_NULL_X509_TOKEN);
        list.add(LIB_NULL_SAML_BEARER_TOKEN);
        list.add(LIB_NULL_SAML_TOKEN);
        return list;
    }

    static {
        map.put("Anonymous", WSS_NULL_ANONYMOUS_URI);
        map.put("TLS-Anonymous", WSS_TLS_ANONYMOUS_URI);
        map.put("ClientTLS-Anonymous", WSS_CLIENT_TLS_ANONYMOUS_URI);
        map.put("ClientTLS-SAML-HolderOfKey", WSS_CLIENT_TLS_SAML_HK_URI);
        map.put("TLS-SAML-HolderOfKey", WSS_TLS_SAML_HK_URI);
        map.put("SAML-HolderOfKey", WSS_NULL_SAML_HK_URI);
        map.put("ClientTLS-SAML-SenderVouches", WSS_CLIENT_TLS_SAML_SV_URI);
        map.put("TLS-SAML-SenderVouches", WSS_TLS_SAML_SV_URI);
        map.put("SAML-SenderVouches", WSS_NULL_SAML_SV_URI);
        map.put("X509Token", WSS_NULL_X509_TOKEN_URI);
        map.put("TLS-X509Token", WSS_TLS_X509_TOKEN_URI);
        map.put("ClientTLS-X509Token", WSS_CLIENT_TLS_X509_TOKEN_URI);
        map.put("UserNameToken", WSS_NULL_USERNAME_TOKEN_URI);
        map.put("TLS-UserNameToken", WSS_TLS_USERNAME_TOKEN_URI);
        map.put("ClientTLS-UserNameToken", WSS_CLIENT_TLS_USERNAME_TOKEN_URI);
        map.put("UserNameToken-Plain", WSS_NULL_USERNAME_TOKEN_PLAIN_URI);
        map.put("TLS-UserNameToken-Plain", WSS_TLS_USERNAME_TOKEN_PLAIN_URI);
        map.put("ClientTLS-UserNameToken-Plain", WSS_CLIENT_TLS_USERNAME_TOKEN_PLAIN_URI);
        map.put("LibertyDiscoverySecurity", LIBERTY_DS_SECURITY_URI);
        map.put("LibertyX509Token", LIB_NULL_X509_TOKEN_URI);
        map.put("LibertyBearerToken", LIB_NULL_SAML_BEARER_TOKEN_URI);
        map.put("LibertySAMLToken", LIB_NULL_SAML_TOKEN_URI);
        map.put("TLS-LibertyX509Token", LIB_TLS_X509_TOKEN_URI);
        map.put("TLS-LibertyBearerToken", LIB_TLS_SAML_BEARER_TOKEN_URI);
        map.put("TLS-LibertySAMLToken", LIB_TLS_SAML_TOKEN_URI);
        map.put("ClientTLS-LibertyX509Token", LIB_CLIENT_TLS_X509_TOKEN_URI);
        map.put("ClientTLS-LibertyBearerToken", LIB_CLIENT_TLS_SAML_BEARER_TOKEN_URI);
        map.put("ClientTLS-LibertySAMLToken", LIB_CLIENT_TLS_SAML_TOKEN_URI);
        map.put("SAML2-HolderOfKey", WSS_NULL_SAML2_HK_URI);
        map.put("TLS-SAML2-HolderOfKey", WSS_TLS_SAML2_HK_URI);
        map.put("ClientTLS-SAML2-HolderOfKey", WSS_CLIENT_TLS_SAML2_HK_URI);
        map.put("SAML2-SenderVouches", WSS_NULL_SAML2_SV_URI);
        map.put("TLS-SAML2-SenderVouches", WSS_TLS_SAML2_SV_URI);
        map.put("ClientTLS-SAML2-SenderVouches", WSS_CLIENT_TLS_SAML2_SV_URI);
        map.put("STSSecurity", STS_SECURITY_URI);
        map.put("KerberosToken", WSS_NULL_KERBEROS_TOKEN_URI);
        map.put("TLS-KerberosToken", WSS_TLS_KERBEROS_TOKEN_URI);
        map.put("ClientTLS-KerberosToken", WSS_CLIENT_TLS_KERBEROS_TOKEN_URI);
        WSS_CLIENT_TLS_SAML_HK = new SecurityMechanism("ClientTLS-SAML-HolderOfKey");
        WSS_TLS_SAML_HK = new SecurityMechanism("TLS-SAML-HolderOfKey");
        WSS_NULL_SAML_HK = new SecurityMechanism("SAML-HolderOfKey");
        WSS_CLIENT_TLS_SAML_SV = new SecurityMechanism("ClientTLS-SAML-SenderVouches");
        WSS_TLS_SAML_SV = new SecurityMechanism("TLS-SAML-SenderVouches");
        WSS_NULL_SAML_SV = new SecurityMechanism("SAML-SenderVouches");
        WSS_NULL_X509_TOKEN = new SecurityMechanism("X509Token");
        WSS_TLS_X509_TOKEN = new SecurityMechanism("TLS-X509Token");
        WSS_CLIENT_TLS_X509_TOKEN = new SecurityMechanism("ClientTLS-X509Token");
        WSS_NULL_USERNAME_TOKEN = new SecurityMechanism("UserNameToken");
        WSS_TLS_USERNAME_TOKEN = new SecurityMechanism("TLS-UserNameToken");
        WSS_CLIENT_TLS_USERNAME_TOKEN = new SecurityMechanism("ClientTLS-UserNameToken");
        WSS_NULL_USERNAME_TOKEN_PLAIN = new SecurityMechanism("UserNameToken-Plain");
        WSS_TLS_USERNAME_TOKEN_PLAIN = new SecurityMechanism("TLS-UserNameToken-Plain");
        WSS_CLIENT_TLS_USERNAME_TOKEN_PLAIN = new SecurityMechanism("ClientTLS-UserNameToken-Plain");
        LIBERTY_DS_SECURITY = new SecurityMechanism("LibertyDiscoverySecurity", true);
        STS_SECURITY = new SecurityMechanism("STSSecurity", true);
        LIB_NULL_X509_TOKEN = new SecurityMechanism("LibertyX509Token", true);
        LIB_NULL_SAML_BEARER_TOKEN = new SecurityMechanism("LibertyBearerToken", true);
        LIB_NULL_SAML_TOKEN = new SecurityMechanism("LibertySAMLToken", true);
        LIB_TLS_X509_TOKEN = new SecurityMechanism("TLS-LibertyX509Token", true);
        LIB_TLS_SAML_BEARER_TOKEN = new SecurityMechanism("TLS-LibertyBearerToken", true);
        LIB_TLS_SAML_TOKEN = new SecurityMechanism("TLS-LibertySAMLToken", true);
        LIB_CLIENT_TLS_X509_TOKEN = new SecurityMechanism("ClientTLS-LibertyX509Token", true);
        LIB_CLIENT_TLS_SAML_BEARER_TOKEN = new SecurityMechanism("ClientTLS-LibertyBearerToken", true);
        LIB_CLIENT_TLS_SAML_TOKEN = new SecurityMechanism("ClientTLS-LibertySAMLToken", true);
        WSS_CLIENT_TLS_SAML2_HK = new SecurityMechanism("ClientTLS-SAML2-HolderOfKey");
        WSS_TLS_SAML2_HK = new SecurityMechanism("TLS-SAML2-HolderOfKey");
        WSS_NULL_SAML2_HK = new SecurityMechanism("SAML2-HolderOfKey");
        WSS_CLIENT_TLS_SAML2_SV = new SecurityMechanism("ClientTLS-SAML2-SenderVouches");
        WSS_TLS_SAML2_SV = new SecurityMechanism("TLS-SAML2-SenderVouches");
        WSS_NULL_SAML2_SV = new SecurityMechanism("SAML2-SenderVouches");
        WSS_CLIENT_TLS_ANONYMOUS = new SecurityMechanism("ClientTLS-Anonymous");
        WSS_TLS_ANONYMOUS = new SecurityMechanism("TLS-Anonymous");
        WSS_NULL_ANONYMOUS = new SecurityMechanism("Anonymous");
        WSS_NULL_KERBEROS_TOKEN = new SecurityMechanism("KerberosToken");
        WSS_TLS_KERBEROS_TOKEN = new SecurityMechanism("TLS-KerberosToken");
        WSS_CLIENT_TLS_KERBEROS_TOKEN = new SecurityMechanism("ClientTLS-KerberosToken");
    }
}

