/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.config;

import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wss.security.PasswordCredential;
import com.sun.identity.wss.sts.STSUtils;
import com.sun.identity.wss.sts.config.FAMCallbackHandler;
import com.sun.identity.wss.sts.config.FAMTrustSPMetadata;
import com.sun.xml.ws.api.security.trust.config.STSConfiguration;
import com.sun.xml.ws.api.security.trust.config.TrustSPMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.security.auth.callback.CallbackHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FAMSTSConfiguration
implements STSConfiguration,
ConfigurationListener {
    private static Map<String, TrustSPMetadata> spMap = new HashMap<String, TrustSPMetadata>();
    private static String type;
    private static String issuer;
    private static boolean encryptIssuedToken;
    private static boolean encryptIssuedKey;
    private static long issuedTokenTimeout;
    private static String stsEndpoint;
    private static String certAlias;
    private static String clientUserToken;
    private static List secMech;
    private static boolean isResponseSign;
    private static boolean isResponseEncrypt;
    private static boolean isRequestSign;
    private static boolean isRequestEncrypt;
    private static boolean isRequestHeaderEncrypt;
    private static String privateKeyType;
    private static String privateKeyAlias;
    private static String publicKeyAlias;
    private static String kerberosDomainServer;
    private static String kerberosDomain;
    private static String kerberosServicePrincipal;
    private static String kerberosKeyTabFile;
    private static boolean isVerifyKrbSignature;
    private static Set samlAttributes;
    private static boolean includeMemberships;
    private static String nameIDMapper;
    private static String attributeNS;
    private static List usercredentials;
    private static String encryptionAlgorithm;
    private static int encryptionStrength;
    private static String signingRefType;
    private static String authChain;
    private static boolean detectUserTokenReplay;
    private static boolean detectMessageReplay;
    private CallbackHandler callbackHandler;
    private Map<String, Object> otherOptions = new HashMap<String, Object>();
    private static Set trustedIssuers;
    private static Set trustedIPAddresses;
    static final String CONFIG_NAME = "STS_CONFIG";
    static final String SERVICE_NAME = "sunFAMSTSService";
    static final String ISSUER = "stsIssuer";
    static final String END_POINT = "stsEndPoint";
    static final String ENCRYPT_ISSUED_KEY = "stsEncryptIssuedKey";
    static final String ENCRYPT_ISSUED_TOKEN = "stsEncryptIssuedToken";
    static final String LIFE_TIME = "stsLifetime";
    static final String TOKEN_IMPL_CLASS = "stsTokenImplClass";
    static final String CERT_ALIAS = "stsCertAlias";
    private static final String TRUSTED_ISSUERS = "trustedIssuers";
    private static final String TRUSTED_IP_ADDRESSES = "trustedIPAddresses";
    static final String CLIENT_USER_TOKEN = "com.sun.identity.wss.sts.clientusertoken";
    static final String SEC_MECH = "SecurityMech";
    static final String RESPONSE_SIGN = "isResponseSign";
    static final String RESPONSE_ENCRYPT = "isResponseEncrypt";
    static final String REQUEST_SIGN = "isRequestSign";
    static final String REQUEST_ENCRYPT = "isRequestEncrypt";
    static final String REQUEST_HEADER_ENCRYPT = "isRequestHeaderEncrypt";
    static final String PRIVATE_KEY_TYPE = "privateKeyType";
    static final String PRIVATE_KEY_ALIAS = "privateKeyAlias";
    static final String PUBLIC_KEY_ALIAS = "publicKeyAlias";
    static final String USER_NAME = "UserName";
    static final String USER_PASSWORD = "UserPassword";
    static final String USER_CREDENTIAL = "UserCredential";
    static final String KERBEROS_DOMAIN_SERVER = "KerberosDomainServer";
    static final String KERBEROS_DOMAIN = "KerberosDomain";
    static final String KERBEROS_SERVICE_PRINCIPAL = "KerberosServicePrincipal";
    static final String KERBEROS_KEYTAB_FILE = "KerberosKeyTabFile";
    static final String KERBEROS_VERIFY_SIGNATURE = "isVerifyKrbSignature";
    static final String SAML_ATTRIBUTE_MAPPING = "SAMLAttributeMapping";
    static final String INCLUDE_MEMBERSHIPS = "includeMemberships";
    static final String SAML_ATTRIBUTE_NS = "AttributeNamespace";
    static final String NAMEID_MAPPER = "NameIDMapper";
    static final String ENCRYPTION_ALGORITHM = "EncryptionAlgorithm";
    static final String ENCRYPTION_STRENGTH = "EncryptionStrength";
    static final String SIGNING_REF_TYPE = "SigningRefType";
    static final String AUTHENTICATION_CHAIN = "AuthenticationChain";
    static final String USER_TOKEN_DETECT_REPLAY = "DetectUserTokenReplay";
    static final String MESSAGE_REPLAY_DETECTION = "DetectMessageReplay";
    private static Debug debug;
    static ConfigurationInstance ci;

    public void configChanged(ConfigurationActionEvent e) {
        if (debug.messageEnabled()) {
            debug.message("FAMSTSConfiguration: configChanged");
        }
        FAMSTSConfiguration.setValues();
    }

    private static void setValues() {
        String tmp;
        String classMethod = "FAMSTSConfiguration.setValues:";
        Map attrMap = null;
        try {
            attrMap = ci.getConfiguration(null, null);
        }
        catch (ConfigurationException ce) {
            debug.error(classMethod, (Throwable)ce);
            return;
        }
        Set values = (Set)attrMap.get(ISSUER);
        if (values != null && !values.isEmpty()) {
            issuer = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(END_POINT)) != null && !values.isEmpty()) {
            stsEndpoint = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(ENCRYPT_ISSUED_KEY)) != null && !values.isEmpty()) {
            encryptIssuedKey = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(ENCRYPT_ISSUED_TOKEN)) != null && !values.isEmpty()) {
            encryptIssuedToken = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(LIFE_TIME)) != null && !values.isEmpty()) {
            issuedTokenTimeout = Long.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(TOKEN_IMPL_CLASS)) != null && !values.isEmpty()) {
            type = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(CERT_ALIAS)) != null && !values.isEmpty()) {
            certAlias = (String)values.iterator().next();
        }
        trustedIssuers = (Set)attrMap.get(TRUSTED_ISSUERS);
        trustedIPAddresses = (Set)attrMap.get(TRUSTED_IP_ADDRESSES);
        values = (Set)attrMap.get(CLIENT_USER_TOKEN);
        if (values != null && !values.isEmpty()) {
            clientUserToken = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(SEC_MECH)) != null && !values.isEmpty()) {
            if (secMech == null) {
                secMech = new ArrayList();
                secMech.addAll(values);
            } else {
                secMech.clear();
                secMech.addAll(values);
            }
        }
        if ((values = (Set)attrMap.get(RESPONSE_SIGN)) != null && !values.isEmpty()) {
            isResponseSign = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(RESPONSE_ENCRYPT)) != null && !values.isEmpty()) {
            isResponseEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_SIGN)) != null && !values.isEmpty()) {
            isRequestSign = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_ENCRYPT)) != null && !values.isEmpty()) {
            isRequestEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_HEADER_ENCRYPT)) != null && !values.isEmpty()) {
            isRequestHeaderEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(PRIVATE_KEY_TYPE)) != null && !values.isEmpty()) {
            privateKeyType = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(PRIVATE_KEY_ALIAS)) != null && !values.isEmpty()) {
            privateKeyAlias = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(PUBLIC_KEY_ALIAS)) != null && !values.isEmpty()) {
            publicKeyAlias = (String)values.iterator().next();
        }
        String value = null;
        values = (Set)attrMap.get(USER_CREDENTIAL);
        if (values != null && !values.isEmpty()) {
            value = (String)values.iterator().next();
        }
        if (value != null && value.length() != 0) {
            if (usercredentials == null) {
                usercredentials = new ArrayList();
            }
            StringTokenizer stVal = new StringTokenizer(value, ",");
            while (stVal.hasMoreTokens()) {
                StringTokenizer st1;
                String tmpVal = stVal.nextToken();
                int index = tmpVal.indexOf("|");
                if (index == -1) {
                    return;
                }
                String usertmp = tmpVal.substring(0, index);
                String passwordtmp = tmpVal.substring(index + 1, tmpVal.length());
                String user = null;
                String password = null;
                StringTokenizer st = new StringTokenizer(usertmp, ":");
                if (USER_NAME.equals(st.nextToken()) && st.hasMoreTokens()) {
                    user = st.nextToken();
                }
                if (USER_PASSWORD.equals((st1 = new StringTokenizer(passwordtmp, ":")).nextToken()) && st1.hasMoreTokens()) {
                    password = st1.nextToken();
                }
                if (user == null || password == null) continue;
                PasswordCredential credential = new PasswordCredential(user, password);
                usercredentials.add(credential);
            }
        }
        if ((values = (Set)attrMap.get(KERBEROS_DOMAIN_SERVER)) != null && !values.isEmpty()) {
            kerberosDomainServer = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(KERBEROS_DOMAIN)) != null && !values.isEmpty()) {
            kerberosDomain = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(KERBEROS_SERVICE_PRINCIPAL)) != null && !values.isEmpty()) {
            kerberosServicePrincipal = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(KERBEROS_KEYTAB_FILE)) != null && !values.isEmpty()) {
            kerberosKeyTabFile = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(KERBEROS_VERIFY_SIGNATURE)) != null && !values.isEmpty()) {
            isVerifyKrbSignature = Boolean.valueOf((String)values.iterator().next());
        }
        samlAttributes = (Set)attrMap.get(SAML_ATTRIBUTE_MAPPING);
        values = (Set)attrMap.get(SAML_ATTRIBUTE_NS);
        if (values != null && !values.isEmpty()) {
            attributeNS = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(NAMEID_MAPPER)) != null && !values.isEmpty()) {
            nameIDMapper = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(INCLUDE_MEMBERSHIPS)) != null && !values.isEmpty()) {
            includeMemberships = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(ENCRYPTION_ALGORITHM)) != null && !values.isEmpty()) {
            encryptionAlgorithm = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(ENCRYPTION_STRENGTH)) != null && !values.isEmpty()) {
            tmp = (String)values.iterator().next();
            encryptionStrength = Integer.parseInt(tmp);
        }
        if ((values = (Set)attrMap.get(SIGNING_REF_TYPE)) != null && !values.isEmpty()) {
            signingRefType = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(AUTHENTICATION_CHAIN)) != null && !values.isEmpty() && !(tmp = (String)values.iterator().next()).equals("[Empty]")) {
            authChain = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(USER_TOKEN_DETECT_REPLAY)) != null && !values.isEmpty()) {
            detectUserTokenReplay = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(MESSAGE_REPLAY_DETECTION)) != null && !values.isEmpty()) {
            detectMessageReplay = Boolean.valueOf((String)values.iterator().next());
        }
    }

    public void addTrustSPMetadata(TrustSPMetadata data, String spEndpoint) {
        spMap.put(spEndpoint, data);
    }

    public TrustSPMetadata getTrustSPMetadata(String spEndpoint) {
        FAMTrustSPMetadata data = new FAMTrustSPMetadata(spEndpoint);
        spMap.put(spEndpoint, data);
        return spMap.get(spEndpoint);
    }

    public Set getTrustedIssuers() {
        return trustedIssuers;
    }

    public Set getTrustedIPAddresses() {
        return trustedIPAddresses;
    }

    public void setType(String type) {
        FAMSTSConfiguration.type = type;
    }

    public String getType() {
        return type;
    }

    public void setIssuer(String issuer) {
        FAMSTSConfiguration.issuer = issuer;
    }

    public String getIssuer() {
        return issuer;
    }

    public void setEncryptIssuedToken(boolean encryptIssuedToken) {
        FAMSTSConfiguration.encryptIssuedToken = encryptIssuedToken;
    }

    public boolean getEncryptIssuedToken() {
        return encryptIssuedToken;
    }

    public void setEncryptIssuedKey(boolean encryptIssuedKey) {
        FAMSTSConfiguration.encryptIssuedKey = encryptIssuedKey;
    }

    public boolean getEncryptIssuedKey() {
        return encryptIssuedKey;
    }

    public void setIssuedTokenTimeout(long issuedTokenTimeout) {
        FAMSTSConfiguration.issuedTokenTimeout = issuedTokenTimeout;
    }

    public long getIssuedTokenTimeout() {
        return issuedTokenTimeout;
    }

    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
    }

    public CallbackHandler getCallbackHandler() {
        return new FAMCallbackHandler(certAlias);
    }

    public void setClientUserTokenClass(String clientUserTokenClass) {
        clientUserToken = clientUserTokenClass;
    }

    public String getClientUserTokenClass() {
        return clientUserToken;
    }

    public List getSecurityMechanisms() {
        return secMech;
    }

    public void setSecurityMechanisms(List authMech) {
        secMech = authMech;
    }

    public boolean isResponseSignEnabled() {
        return isResponseSign;
    }

    public void setResponseSignEnabled(boolean enable) {
        isResponseSign = enable;
    }

    public boolean isResponseEncryptEnabled() {
        return isResponseEncrypt;
    }

    public void setResponseEncryptEnabled(boolean enable) {
        isResponseEncrypt = enable;
    }

    public boolean isRequestSignEnabled() {
        return isRequestSign;
    }

    public void setRequestSignEnabled(boolean enable) {
        isRequestSign = enable;
    }

    public boolean isRequestEncryptEnabled() {
        return isRequestEncrypt;
    }

    public void setRequestEncryptEnabled(boolean enable) {
        isRequestEncrypt = enable;
    }

    public boolean isRequestHeaderEncryptEnabled() {
        return isRequestHeaderEncrypt;
    }

    public void setRequestHeaderEncryptEnabled(boolean enable) {
        isRequestHeaderEncrypt = enable;
    }

    public String getPrivateKeyType() {
        return privateKeyType;
    }

    public void setPrivateKeyType(String keyType) {
        privateKeyType = keyType;
    }

    public String getPrivateKeyAlias() {
        return privateKeyAlias;
    }

    public void setPrivateKeyAlias(String alias) {
        privateKeyAlias = alias;
    }

    public String getPublicKeyAlias() {
        return publicKeyAlias;
    }

    public void setPublicKeyAlias(String alias) {
        publicKeyAlias = alias;
    }

    public Map<String, Object> getOtherOptions() {
        return this.otherOptions;
    }

    public String getSTSEndpoint() {
        return stsEndpoint;
    }

    public String getKDCDomain() {
        return kerberosDomain;
    }

    public void setKDCDomain(String domain) {
        kerberosDomain = domain;
    }

    public String getKDCServer() {
        return kerberosDomainServer;
    }

    public void setKDCServer(String kdcServer) {
        kerberosDomainServer = kdcServer;
    }

    public String getKeyTabFile() {
        return kerberosKeyTabFile;
    }

    public void setKeyTabFile(String file) {
        kerberosKeyTabFile = file;
    }

    public String getKerberosServicePrincipal() {
        return kerberosServicePrincipal;
    }

    public void setKerberosServicePrincipal(String principal) {
        kerberosServicePrincipal = principal;
    }

    public boolean isValidateKerberosSignature() {
        return isVerifyKrbSignature;
    }

    public void setValidateKerberosSignature(boolean validate) {
        isVerifyKrbSignature = validate;
    }

    public Set getSAMLAttributeMapping() {
        return samlAttributes;
    }

    public void setSAMLAttributeMapping(Set attributeMap) {
        samlAttributes = attributeMap;
    }

    public boolean shouldIncludeMemberships() {
        return includeMemberships;
    }

    public void setIncludeMemberships(boolean include) {
        includeMemberships = include;
    }

    public String getNameIDMapper() {
        return nameIDMapper;
    }

    public void setNameIDMapper(String nameIDMapper) {
        FAMSTSConfiguration.nameIDMapper = nameIDMapper;
    }

    public String getSAMLAttributeNamespace() {
        return attributeNS;
    }

    public void setSAMLAttributeNamespace(String attributeNS) {
        FAMSTSConfiguration.attributeNS = attributeNS;
    }

    public void setUsers(List usercredentials) {
        FAMSTSConfiguration.usercredentials = usercredentials;
    }

    public List getUsers() {
        return usercredentials;
    }

    public String getEncryptionAlgorithm() {
        return encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String algorithm) {
        encryptionAlgorithm = algorithm;
    }

    public int getEncryptionStrength() {
        return encryptionStrength;
    }

    public void setEncryptionStrength(int encryptionStrength) {
        FAMSTSConfiguration.encryptionStrength = encryptionStrength;
    }

    public String getSigningRefType() {
        return signingRefType;
    }

    public void setSigningRefType(String refType) {
        signingRefType = refType;
    }

    public String getAuthenticationChain() {
        return authChain;
    }

    public void setAuthenticationChain(String authChain) {
        FAMSTSConfiguration.authChain = authChain;
    }

    public boolean isUserTokenDetectReplayEnabled() {
        return detectUserTokenReplay;
    }

    public void setDetectUserTokenReplay(boolean enable) {
        detectUserTokenReplay = enable;
    }

    public boolean isMessageReplayDetectionEnabled() {
        return detectMessageReplay;
    }

    public void setMessageReplayDetection(boolean enable) {
        detectMessageReplay = enable;
    }

    static {
        encryptIssuedToken = false;
        encryptIssuedKey = true;
        secMech = null;
        isResponseSign = false;
        isResponseEncrypt = false;
        isRequestSign = false;
        isRequestEncrypt = false;
        isRequestHeaderEncrypt = false;
        isVerifyKrbSignature = false;
        samlAttributes = null;
        includeMemberships = false;
        nameIDMapper = null;
        attributeNS = null;
        usercredentials = null;
        encryptionAlgorithm = null;
        encryptionStrength = 0;
        signingRefType = null;
        authChain = null;
        detectUserTokenReplay = true;
        detectMessageReplay = true;
        trustedIssuers = null;
        trustedIPAddresses = null;
        debug = STSUtils.debug;
        ci = null;
        try {
            ci = ConfigurationManager.getConfigurationInstance((String)CONFIG_NAME);
            ci.addListener((ConfigurationListener)new FAMSTSConfiguration());
            FAMSTSConfiguration.setValues();
        }
        catch (ConfigurationException ce) {
            debug.error("FAMSTSConfiguration.static:", (Throwable)ce);
        }
    }
}

