/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.sts.config;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.identity.wss.security.PasswordCredential;
import com.sun.identity.wss.security.WSSUtils;
import com.sun.identity.wss.sts.STSUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class STSRemoteConfig {
    private String type;
    private String issuer;
    private String stsEndpoint;
    private List secMech = null;
    private boolean isResponseSign = false;
    private boolean isResponseEncrypt = false;
    private boolean isRequestSign = false;
    private boolean isRequestEncrypt = false;
    private boolean isRequestHeaderEncrypt = false;
    private String privateKeyType;
    private String privateKeyAlias;
    private String publicKeyAlias;
    private String kerberosDomainServer;
    private String kerberosDomain;
    private String kerberosServicePrincipal;
    private String kerberosKeyTabFile;
    private boolean isVerifyKrbSignature = false;
    private List usercredentials = null;
    private String encryptionAlgorithm = null;
    private int encryptionStrength = 0;
    private String signingRefType = null;
    private String authChain = null;
    private boolean detectUserTokenReplay = true;
    private static boolean detectMessageReplay = true;
    static final String ISSUER = "stsIssuer";
    static final String SERVICE_NAME = "sunFAMSTSService";
    static final String END_POINT = "stsEndPoint";
    static final String SEC_MECH = "SecurityMech";
    static final String RESPONSE_SIGN = "isResponseSign";
    static final String RESPONSE_ENCRYPT = "isResponseEncrypt";
    static final String REQUEST_SIGN = "isRequestSign";
    static final String REQUEST_ENCRYPT = "isRequestEncrypt";
    static final String REQUEST_HEADER_ENCRYPT = "isRequestHeaderEncrypt";
    static final String PRIVATE_KEY_TYPE = "privateKeyType";
    static final String PRIVATE_KEY_ALIAS = "privateKeyAlias";
    static final String PUBLIC_KEY_ALIAS = "publicKeyAlias";
    static final String USER_NAME = "UserName";
    static final String USER_PASSWORD = "UserPassword";
    static final String USER_CREDENTIAL = "UserCredential";
    static final String KERBEROS_DOMAIN_SERVER = "KerberosDomainServer";
    static final String KERBEROS_DOMAIN = "KerberosDomain";
    static final String KERBEROS_SERVICE_PRINCIPAL = "KerberosServicePrincipal";
    static final String KERBEROS_KEYTAB_FILE = "KerberosKeyTabFile";
    static final String KERBEROS_VERIFY_SIGNATURE = "isVerifyKrbSignature";
    static final String ENCRYPTION_ALGORITHM = "EncryptionAlgorithm";
    static final String ENCRYPTION_STRENGTH = "EncryptionStrength";
    static final String SIGNING_REF_TYPE = "SigningRefType";
    static final String AUTHENTICATION_CHAIN = "AuthenticationChain";
    static final String USER_TOKEN_DETECT_REPLAY = "DetectUserTokenReplay";
    static final String MESSAGE_REPLAY_DETECTION = "DetectMessageReplay";

    public STSRemoteConfig() {
        SSOToken adminToken = WSSUtils.getAdminToken();
        Map attrMap = null;
        try {
            ServiceSchemaManager scm = new ServiceSchemaManager(SERVICE_NAME, adminToken);
            ServiceSchema globalSchema = scm.getGlobalSchema();
            attrMap = globalSchema.getAttributeDefaults();
            this.setValues(attrMap);
        }
        catch (SSOException ssoEx) {
            STSUtils.debug.error("FAMSTSConfiguration.static init failed", (Throwable)ssoEx);
        }
        catch (SMSException smsEx) {
            STSUtils.debug.error("FAMSTSConfiguration.static init failed", (Throwable)smsEx);
        }
    }

    private void setValues(Map attrMap) {
        String tmp;
        Set values;
        if (STSUtils.debug.messageEnabled()) {
            STSUtils.debug.message("STSServiceConfigMap: " + attrMap);
        }
        if ((values = (Set)attrMap.get(END_POINT)) != null && !values.isEmpty()) {
            this.stsEndpoint = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(ISSUER)) != null && !values.isEmpty()) {
            this.issuer = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(SEC_MECH)) != null && !values.isEmpty()) {
            if (this.secMech == null) {
                this.secMech = new ArrayList();
                this.secMech.addAll(values);
            } else {
                this.secMech.clear();
                this.secMech.addAll(values);
            }
        }
        if ((values = (Set)attrMap.get(RESPONSE_SIGN)) != null && !values.isEmpty()) {
            this.isResponseSign = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(RESPONSE_ENCRYPT)) != null && !values.isEmpty()) {
            this.isResponseEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_SIGN)) != null && !values.isEmpty()) {
            this.isRequestSign = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_ENCRYPT)) != null && !values.isEmpty()) {
            this.isRequestEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(REQUEST_HEADER_ENCRYPT)) != null && !values.isEmpty()) {
            this.isRequestHeaderEncrypt = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(PRIVATE_KEY_TYPE)) != null && !values.isEmpty()) {
            this.privateKeyType = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(PRIVATE_KEY_ALIAS)) != null && !values.isEmpty()) {
            this.privateKeyAlias = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(PUBLIC_KEY_ALIAS)) != null && !values.isEmpty()) {
            this.publicKeyAlias = (String)values.iterator().next();
        }
        String value = null;
        values = (Set)attrMap.get(USER_CREDENTIAL);
        if (values != null && !values.isEmpty()) {
            value = (String)values.iterator().next();
        }
        if (value != null && value.length() != 0) {
            if (this.usercredentials == null) {
                this.usercredentials = new ArrayList();
            }
            StringTokenizer stVal = new StringTokenizer(value, ",");
            while (stVal.hasMoreTokens()) {
                StringTokenizer st1;
                String tmpVal = stVal.nextToken();
                int index = tmpVal.indexOf("|");
                if (index == -1) {
                    return;
                }
                String usertmp = tmpVal.substring(0, index);
                String passwordtmp = tmpVal.substring(index + 1, tmpVal.length());
                String user = null;
                String password = null;
                StringTokenizer st = new StringTokenizer(usertmp, ":");
                if (USER_NAME.equals(st.nextToken()) && st.hasMoreTokens()) {
                    user = st.nextToken();
                }
                if (USER_PASSWORD.equals((st1 = new StringTokenizer(passwordtmp, ":")).nextToken()) && st1.hasMoreTokens()) {
                    password = st1.nextToken();
                }
                if (user == null || password == null) continue;
                PasswordCredential credential = new PasswordCredential(user, password);
                this.usercredentials.add(credential);
            }
        }
        if ((values = (Set)attrMap.get(KERBEROS_DOMAIN_SERVER)) != null && !values.isEmpty()) {
            this.kerberosDomainServer = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(KERBEROS_DOMAIN)) != null && !values.isEmpty()) {
            this.kerberosDomain = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(KERBEROS_SERVICE_PRINCIPAL)) != null && !values.isEmpty()) {
            this.kerberosServicePrincipal = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(KERBEROS_KEYTAB_FILE)) != null && !values.isEmpty()) {
            this.kerberosKeyTabFile = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(KERBEROS_VERIFY_SIGNATURE)) != null && !values.isEmpty()) {
            this.isVerifyKrbSignature = Boolean.valueOf((String)values.iterator().next());
        }
        if ((values = (Set)attrMap.get(ENCRYPTION_ALGORITHM)) != null && !values.isEmpty()) {
            this.encryptionAlgorithm = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(ENCRYPTION_STRENGTH)) != null && !values.isEmpty()) {
            tmp = (String)values.iterator().next();
            this.encryptionStrength = Integer.parseInt(tmp);
        }
        if ((values = (Set)attrMap.get(SIGNING_REF_TYPE)) != null && !values.isEmpty()) {
            this.signingRefType = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(AUTHENTICATION_CHAIN)) != null && !values.isEmpty() && !(tmp = (String)values.iterator().next()).equals("[Empty]")) {
            this.authChain = (String)values.iterator().next();
        }
        if ((values = (Set)attrMap.get(USER_TOKEN_DETECT_REPLAY)) != null && !values.isEmpty()) {
            this.detectUserTokenReplay = Boolean.valueOf((String)values.iterator().next());
        }
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public List getSecurityMechanisms() {
        return this.secMech;
    }

    public void setSecurityMechanisms(List authMech) {
        this.secMech = authMech;
    }

    public boolean isResponseSignEnabled() {
        return this.isResponseSign;
    }

    public void setResponseSignEnabled(boolean enable) {
        this.isResponseSign = enable;
    }

    public boolean isResponseEncryptEnabled() {
        return this.isResponseEncrypt;
    }

    public void setResponseEncryptEnabled(boolean enable) {
        this.isResponseEncrypt = enable;
    }

    public boolean isRequestSignEnabled() {
        return this.isRequestSign;
    }

    public void setRequestSignEnabled(boolean enable) {
        this.isRequestSign = enable;
    }

    public boolean isRequestEncryptEnabled() {
        return this.isRequestEncrypt;
    }

    public void setRequestEncryptEnabled(boolean enable) {
        this.isRequestEncrypt = enable;
    }

    public boolean isRequestHeaderEncryptEnabled() {
        return this.isRequestHeaderEncrypt;
    }

    public void setRequestHeaderEncryptEnabled(boolean enable) {
        this.isRequestHeaderEncrypt = enable;
    }

    public String getPrivateKeyType() {
        return this.privateKeyType;
    }

    public void setPrivateKeyType(String keyType) {
        this.privateKeyType = keyType;
    }

    public String getPrivateKeyAlias() {
        return this.privateKeyAlias;
    }

    public void setPrivateKeyAlias(String alias) {
        this.privateKeyAlias = alias;
    }

    public String getPublicKeyAlias() {
        return this.publicKeyAlias;
    }

    public void setPublicKeyAlias(String alias) {
        this.publicKeyAlias = alias;
    }

    public String getSTSEndpoint() {
        return this.stsEndpoint;
    }

    public String getKDCDomain() {
        return this.kerberosDomain;
    }

    public void setKDCDomain(String domain) {
        this.kerberosDomain = domain;
    }

    public String getKDCServer() {
        return this.kerberosDomainServer;
    }

    public void setKDCServer(String kdcServer) {
        this.kerberosDomainServer = kdcServer;
    }

    public String getKeyTabFile() {
        return this.kerberosKeyTabFile;
    }

    public void setKeyTabFile(String file) {
        this.kerberosKeyTabFile = file;
    }

    public String getKerberosServicePrincipal() {
        return this.kerberosServicePrincipal;
    }

    public void setKerberosServicePrincipal(String principal) {
        this.kerberosServicePrincipal = principal;
    }

    public boolean isValidateKerberosSignature() {
        return this.isVerifyKrbSignature;
    }

    public void setValidateKerberosSignature(boolean validate) {
        this.isVerifyKrbSignature = validate;
    }

    public void setUsers(List usercredentials) {
        this.usercredentials = usercredentials;
    }

    public List getUsers() {
        return this.usercredentials;
    }

    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    public void setEncryptionAlgorithm(String algorithm) {
        this.encryptionAlgorithm = algorithm;
    }

    public int getEncryptionStrength() {
        return this.encryptionStrength;
    }

    public void setEncryptionStrength(int encryptionStrength) {
        this.encryptionStrength = encryptionStrength;
    }

    public String getSigningRefType() {
        return this.signingRefType;
    }

    public void setSigningRefType(String refType) {
        this.signingRefType = refType;
    }

    public String getAuthenticationChain() {
        return this.authChain;
    }

    public void setAuthenticationChain(String authChain) {
        this.authChain = authChain;
    }

    public boolean isUserTokenDetectReplayEnabled() {
        return this.detectUserTokenReplay;
    }

    public void setDetectUserTokenReplay(boolean enable) {
        this.detectUserTokenReplay = enable;
    }

    public boolean isMessageReplayDetectionEnabled() {
        return detectMessageReplay;
    }

    public void setMessageReplayDetection(boolean enable) {
        detectMessageReplay = enable;
    }
}

