/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.comm.https;

import com.iplanet.services.comm.https.ReaderWriterClear;
import com.sun.identity.shared.debug.Debug;
import java.util.LinkedList;

public class JSSThreadPool {
    public static final int DEFAULT_THREAD_POOL_SIZE = 20;
    private static Debug debug;
    private ReaderWriterClear[] readerWriter;
    private int poolSize;
    private String poolName;
    private LinkedList taskList;
    private int busyThreadCount;
    private int currentThreadCount;
    private int busyReaderWriterCount;
    private int currentReaderWriterCount;
    private boolean shutdownThePool;
    private boolean daemon;
    private WorkerThread[] threads;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSSThreadPool(String name, int poolSize, boolean daemon, Debug debug) {
        JSSThreadPool.debug = debug;
        this.poolSize = poolSize;
        this.poolName = name;
        this.taskList = new LinkedList();
        this.busyThreadCount = 0;
        this.currentThreadCount = 0;
        this.busyReaderWriterCount = 0;
        this.currentReaderWriterCount = 0;
        this.daemon = daemon;
        this.shutdownThePool = false;
        this.threads = new WorkerThread[poolSize];
        this.readerWriter = new ReaderWriterClear[poolSize];
        JSSThreadPool jSSThreadPool = this;
        synchronized (jSSThreadPool) {
            this.createThreads(poolSize);
        }
    }

    protected void createThreads(int threadsToCreate) {
        if (threadsToCreate > this.poolSize) {
            threadsToCreate = this.poolSize;
        }
        for (int i = this.currentThreadCount; i < threadsToCreate; ++i) {
            this.threads[i - this.busyThreadCount] = new WorkerThread(this.poolName, this);
            this.threads[i - this.busyThreadCount].setDaemon(this.daemon);
            this.threads[i - this.busyThreadCount].start();
        }
        this.currentThreadCount = threadsToCreate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private WorkerThread getAvailableThread() {
        WorkerThread t = null;
        JSSThreadPool jSSThreadPool = this;
        synchronized (jSSThreadPool) {
            if (this.currentThreadCount == this.busyThreadCount) {
                this.createThreads(this.poolSize);
            }
            t = this.threads[this.currentThreadCount - this.busyThreadCount - 1];
            this.threads[this.currentThreadCount - this.busyThreadCount - 1] = null;
            ++this.busyThreadCount;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Runnable task) {
        WorkerThread t = null;
        JSSThreadPool jSSThreadPool = this;
        synchronized (jSSThreadPool) {
            if (this.busyThreadCount == this.poolSize) {
                this.taskList.addLast(task);
            } else {
                t = this.getAvailableThread();
            }
        }
        if (t != null && task != null) {
            t.runTask(task);
        }
    }

    protected synchronized void deductCurrentThreadCount() {
        --this.currentThreadCount;
        --this.busyThreadCount;
        if (!this.taskList.isEmpty()) {
            WorkerThread t = this.getAvailableThread();
            t.runTask((Runnable)this.taskList.removeFirst());
        }
    }

    protected synchronized void returnThread(WorkerThread t) {
        if (this.shutdownThePool) {
            t.terminate();
            t.setNeedReturn(false);
            --this.busyThreadCount;
            if (this.busyThreadCount == 0) {
                this.notify();
            }
            return;
        }
        if (!this.taskList.isEmpty()) {
            t.runTask((Runnable)this.taskList.remove(0));
        } else {
            --this.busyThreadCount;
            this.threads[this.currentThreadCount - this.busyThreadCount - 1] = t;
        }
    }

    public synchronized void shutdown() {
        if (!this.shutdownThePool) {
            this.shutdownThePool = true;
            for (int i = 0; i < this.currentThreadCount - this.busyThreadCount; ++i) {
                this.threads[i].terminate();
            }
            while (this.busyThreadCount != 0) {
                try {
                    this.wait();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.busyThreadCount = 0;
            this.currentThreadCount = 0;
            this.threads = null;
        }
    }

    public synchronized int getCurrentThreadCount() {
        return this.currentThreadCount;
    }

    public int getCurrentSize() {
        return this.taskList.size();
    }

    private class WorkerThread
    extends Thread {
        private Runnable task = null;
        private JSSThreadPool pool;
        private boolean needReturn;
        private boolean shouldTerminate;

        public WorkerThread(String name, JSSThreadPool pool) {
            this.setName(name);
            this.pool = pool;
            this.shouldTerminate = false;
            this.needReturn = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean localShouldTerminate = false;
            Runnable localTask = null;
            WorkerThread t = this;
            do {
                try {
                    WorkerThread workerThread = this;
                    synchronized (workerThread) {
                        if (this.task == null && !this.shouldTerminate) {
                            this.wait();
                        }
                        localShouldTerminate = this.shouldTerminate;
                        localTask = this.task;
                        this.task = null;
                    }
                    if (!localShouldTerminate) {
                        if (localTask == null) continue;
                        localTask.run();
                        continue;
                    }
                    break;
                }
                catch (RuntimeException ex) {
                    debug.error("Running task " + this.task, (Throwable)ex);
                    this.pool.deductCurrentThreadCount();
                    localShouldTerminate = true;
                    this.needReturn = false;
                }
                catch (Exception ex) {
                    debug.error("Running task " + this.task, (Throwable)ex);
                }
                catch (Throwable e) {
                    debug.error("Running task " + this.task, e);
                    this.pool.deductCurrentThreadCount();
                    localShouldTerminate = true;
                    this.needReturn = false;
                    throw new Error(e);
                }
                finally {
                    if (this.needReturn) {
                        this.pool.returnThread(t);
                    }
                }
            } while (!localShouldTerminate);
        }

        public synchronized void runTask(Runnable toRun) {
            this.task = toRun;
            this.notify();
        }

        public synchronized void terminate() {
            this.shouldTerminate = true;
            this.notify();
        }

        public synchronized void setNeedReturn(boolean value) {
            this.needReturn = value;
        }
    }
}

