/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.console.policy;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.identity.console.base.model.AMConsoleException;
import com.sun.identity.console.policy.ConditionOpViewBeanBase;
import com.sun.identity.console.policy.model.CachedPolicy;
import com.sun.identity.console.policy.model.PolicyModel;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameAlreadyExistsException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.interfaces.Condition;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPageTitleModelInterface;
import com.sun.web.ui.view.pagetitle.CCPageTitle;
import java.text.MessageFormat;
import java.util.Map;

public class ConditionEditViewBean
extends ConditionOpViewBeanBase {
    public static final String DEFAULT_DISPLAY_URL = "/console/policy/ConditionEdit.jsp";
    public static final String EDIT_CONDITION_NAME = "editConditionName";
    private static final String PGTITLE_TWO_BTNS = "pgtitleTwoBtns";

    ConditionEditViewBean(String name, String defaultDisplayURL) {
        super(name, defaultDisplayURL);
    }

    public ConditionEditViewBean() {
        super("ConditionEdit", DEFAULT_DISPLAY_URL);
    }

    protected void registerChildren() {
        super.registerChildren();
        this.registerChild(PGTITLE_TWO_BTNS, CCPageTitle.class);
    }

    protected View createChild(String name) {
        Object view = null;
        view = name.equals(PGTITLE_TWO_BTNS) ? new CCPageTitle((ContainerView)this, (CCPageTitleModelInterface)this.ptModel, name) : super.createChild(name);
        return view;
    }

    protected void createPageTitleModel() {
        this.ptModel = new CCPageTitleModel(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("com/sun/identity/console/threeBtnsPageTitle.xml"));
        this.ptModel.setValue("button1", (Object)"button.save");
        this.ptModel.setValue("button2", (Object)"button.reset");
        this.ptModel.setValue("button3", (Object)this.getBackButtonLabel());
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        super.beginDisplay(event);
        PolicyModel model = (PolicyModel)this.getModel();
        String i18nName = (String)this.propertySheetModel.getValue("tfConditionTypeName");
        String title = model.getLocalizedString("page.title.policy.condition.edit");
        String[] param = new String[]{i18nName};
        this.ptModel.setPageTitleText(MessageFormat.format(title, param));
        if (!this.canModify) {
            this.disableButton("button1", true);
            this.disableButton("button2", true);
        }
    }

    public void handleButton2Request(RequestInvocationEvent event) throws ModelControlException {
        this.forwardTo();
    }

    public void handleButton1Request(RequestInvocationEvent event) throws ModelControlException {
        try {
            this.handleButton1Request(this.getCachedPolicy());
        }
        catch (AMConsoleException e) {
            debug.warning("ConditionEditViewBean.handleButton1Request", (Throwable)e);
            this.redirectToStartURL();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleButton1Request(CachedPolicy cachedPolicy) throws ModelControlException {
        this.submitCycle = true;
        boolean forwarded = false;
        Condition deleted = null;
        String origName = (String)this.getPageSessionAttribute(EDIT_CONDITION_NAME);
        Policy policy = cachedPolicy.getPolicy();
        try {
            Condition condition = this.createCondition();
            if (condition != null) {
                String name = (String)this.propertySheetModel.getValue("tfConditionName");
                if (origName.equals(name)) {
                    policy.replaceCondition(name, condition);
                } else {
                    deleted = policy.removeCondition(origName);
                    policy.addCondition(name, condition);
                }
                deleted = null;
                this.setInlineAlertMessage("info", "message.information", "policy.condition.updated");
                cachedPolicy.setPolicyModified(true);
            }
        }
        catch (NameAlreadyExistsException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (InvalidNameException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (NameNotFoundException e) {
            this.setInlineAlertMessage("error", "message.error", this.getModel().getErrorString(e));
        }
        catch (AMConsoleException e) {
            this.setInlineAlertMessage("error", "message.error", e.getMessage());
        }
        finally {
            if (deleted != null) {
                try {
                    policy.addCondition(origName, deleted);
                }
                catch (NameAlreadyExistsException e) {
                    debug.warning("ConditionEditViewBean.handleButton1Request", (Throwable)e);
                }
                catch (InvalidNameException e) {
                    debug.warning("ConditionEditViewBean.handleButton1Request", (Throwable)e);
                }
            }
        }
        this.forwardTo();
    }

    protected Map getDefaultValues() {
        Map values = null;
        try {
            CachedPolicy cachedPolicy = this.getCachedPolicy();
            Policy policy = cachedPolicy.getPolicy();
            String conditionName = (String)this.getPageSessionAttribute("conditionName");
            Condition condition = policy.getCondition(conditionName);
            values = condition.getProperties();
        }
        catch (NameNotFoundException e) {
            debug.warning("ConditionEditViewBean.getDefaultValues", (Throwable)e);
        }
        catch (AMConsoleException e) {
            debug.warning("ConditionEditViewBean.getDefaultValues", (Throwable)e);
        }
        return values;
    }

    protected boolean hasValues() {
        return true;
    }

    protected String getBreadCrumbDisplayName() {
        PolicyModel model = (PolicyModel)this.getModel();
        String origName = (String)this.getPageSessionAttribute(EDIT_CONDITION_NAME);
        String[] arg = new String[]{origName};
        return MessageFormat.format(model.getLocalizedString("breadcrumbs.editCondition"), arg);
    }

    protected boolean startPageTrail() {
        return false;
    }
}

