/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wss.trust;

import com.sun.identity.wss.trust.RequestSecurityToken;
import com.sun.identity.wss.trust.RequestSecurityTokenResponse;
import com.sun.identity.wss.trust.RequestSecurityTokenResponseCollection;
import com.sun.identity.wss.trust.WSTException;
import com.sun.identity.wss.trust.wst13.RequestSecurityTokenResponseCollection_Impl;
import com.sun.identity.wss.trust.wst13.RequestSecurityTokenResponse_Impl;
import com.sun.identity.wss.trust.wst13.RequestSecurityToken_Impl;
import org.w3c.dom.Element;

public class WSTrustFactory {
    private String protocolVersion = null;

    private WSTrustFactory(String version) throws WSTException {
        if (!"1.3".equals(version) && !"1.0".equals(version)) {
            throw new WSTException("Unsupported version");
        }
        this.protocolVersion = version;
    }

    public static WSTrustFactory newInstance() throws WSTException {
        return new WSTrustFactory("1.0");
    }

    public static WSTrustFactory newInstance(String protocolVersion) throws WSTException {
        return new WSTrustFactory(protocolVersion);
    }

    public RequestSecurityToken createRequestSecurityToken() {
        if ("1.3".equals(this.protocolVersion)) {
            return new RequestSecurityToken_Impl();
        }
        return new com.sun.identity.wss.trust.wst10.RequestSecurityToken_Impl();
    }

    public RequestSecurityToken createRequestSecurityToken(Element element) throws WSTException {
        if ("1.3".equals(this.protocolVersion)) {
            return new RequestSecurityToken_Impl(element);
        }
        return new com.sun.identity.wss.trust.wst10.RequestSecurityToken_Impl(element);
    }

    public RequestSecurityTokenResponse createRequestSecurityTokenResponse() {
        if ("1.3".equals(this.protocolVersion)) {
            return new RequestSecurityTokenResponse_Impl();
        }
        return new com.sun.identity.wss.trust.wst10.RequestSecurityTokenResponse_Impl();
    }

    public RequestSecurityTokenResponse createRequestSecurityTokenResponse(Element element) throws WSTException {
        if ("1.3".equals(this.protocolVersion)) {
            return new RequestSecurityTokenResponse_Impl(element);
        }
        return new com.sun.identity.wss.trust.wst10.RequestSecurityTokenResponse_Impl(element);
    }

    public RequestSecurityTokenResponseCollection createRequestSecurityTokenResponseCollection() {
        if ("1.3".equals(this.protocolVersion)) {
            return new RequestSecurityTokenResponseCollection_Impl();
        }
        return new com.sun.identity.wss.trust.wst10.RequestSecurityTokenResponseCollection_Impl();
    }

    public RequestSecurityTokenResponseCollection createRequestSecurityTokenResponseCollection(Element element) throws WSTException {
        if ("1.3".equals(this.protocolVersion)) {
            return new RequestSecurityTokenResponseCollection_Impl(element);
        }
        return new com.sun.identity.wss.trust.wst10.RequestSecurityTokenResponseCollection_Impl(element);
    }
}

