/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.sdk;

import com.iplanet.am.sdk.AMCommonUtils;
import com.iplanet.am.sdk.AMDirectoryAccessFactory;
import com.iplanet.am.sdk.AMEntity;
import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMGroupContainer;
import com.iplanet.am.sdk.AMHashMap;
import com.iplanet.am.sdk.AMNamingAttrManager;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMOrganizationalUnit;
import com.iplanet.am.sdk.AMPeopleContainer;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMSearchControl;
import com.iplanet.am.sdk.AMSearchResults;
import com.iplanet.am.sdk.AMStaticGroup;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.am.sdk.common.IDirectoryServices;
import com.iplanet.am.util.AdminUtils;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.Server;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.idm.IdOperation;
import com.sun.identity.idm.IdRepo;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdRepoFatalException;
import com.sun.identity.idm.IdRepoListener;
import com.sun.identity.idm.IdRepoUnsupportedOpException;
import com.sun.identity.idm.IdType;
import com.sun.identity.idm.IdUtils;
import com.sun.identity.idm.RepoSearchResults;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.ldap.LDAPDN;
import com.sun.identity.shared.ldap.util.DN;
import com.sun.identity.shared.locale.AMResourceBundleCache;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class AMSDKRepo
extends IdRepo {
    protected static Set listeners = new HashSet();
    private Map supportedOps = new HashMap();
    private IdRepoListener myListener = null;
    private String orgDN = "";
    private boolean dataStoreRecursive = false;
    private String pcDN = null;
    private String agentDN = null;
    private static Debug debug = Debug.getInstance((String)"amsdkRepo");
    private static final String PC_ATTR = "iplanet-am-admin-console-default-pc";
    private static final String AC_ATTR = "iplanet-am-admin-console-default-ac";
    private static final String GC_ATTR = "iplanet-am-admin-console-default-gc";
    private static final String ADMIN_SERVICE = "iPlanetAMAdminConsoleService";
    private static final String CLASS_NAME = "com.iplanet.am.sdk.AMSDKRepo";
    private static SSOToken adminToken = null;
    private static AMStoreConnection sc = null;
    protected String amAuthLDAP = "amAuthLDAP";

    public AMSDKRepo() {
        this.loadSupportedOps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addListener(SSOToken token, IdRepoListener listnr) throws IdRepoException, SSOException {
        Set set = listeners;
        synchronized (set) {
            listeners.add(listnr);
        }
        this.myListener = listnr;
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener() {
        Set set = listeners;
        synchronized (set) {
            listeners.remove(this.myListener);
        }
    }

    public String create(SSOToken token, IdType type, String name, Map attrMap) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKIdRepo: Create called on " + type + ": " + name);
        }
        String dn = null;
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        try {
            int orgType = amsc.getAMObjectType(this.orgDN);
            if (orgType != 2) {
                debug.error("AMSDKRepo.create(): Incorrectly configured  plugin: Org DN is wrong = " + this.orgDN);
                throw new IdRepoException("amIdRepo", "303", null);
            }
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.create(): An exception occured while  initializing AM SDK ", (Throwable)ame);
            Object[] args = new Object[]{CLASS_NAME, IdOperation.CREATE.getName()};
            IdRepoException ide = new IdRepoException("amIdRepo", "304", args);
            ide.setLDAPErrorCode(ame.getLDAPErrorCode());
            throw ide;
        }
        AMOrganization amOrg = amsc.getOrganization(this.orgDN);
        HashMap<String, Map> entityNamesAndAttrs = new HashMap<String, Map>();
        entityNamesAndAttrs.put(name, attrMap);
        try {
            if (type.equals(IdType.USER)) {
                Set res = amOrg.createEntities(1, entityNamesAndAttrs);
                AMEntity entity = (AMEntity)res.iterator().next();
                dn = entity.getDN();
            } else if (type.equals(IdType.AGENT)) {
                Set res = amOrg.createEntities(100, entityNamesAndAttrs);
                AMEntity entity = (AMEntity)res.iterator().next();
                dn = entity.getDN();
            } else if (type.equals(IdType.GROUP)) {
                String gcDN = AMNamingAttrManager.getNamingAttr(4) + "=" + this.getDefaultGroupContainerName() + "," + this.orgDN;
                AMGroupContainer amgc = amsc.getGroupContainer(gcDN);
                Set groups = amgc.createStaticGroups(entityNamesAndAttrs);
                AMStaticGroup group = (AMStaticGroup)groups.iterator().next();
                dn = group.getDN();
            } else if (type.equals(IdType.ROLE)) {
                Set roles = amOrg.createRoles(entityNamesAndAttrs);
                AMRole role = (AMRole)roles.iterator().next();
                dn = role.getDN();
            } else if (type.equals(IdType.FILTEREDROLE)) {
                Set roles = amOrg.createFilteredRoles(entityNamesAndAttrs);
                AMFilteredRole role = (AMFilteredRole)roles.iterator().next();
                dn = role.getDN();
            }
        }
        catch (AMException ame) {
            debug.warning("AMSDKRepo.create(): Caught AMException..", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
        return dn;
    }

    public void delete(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKIdRepo: Delete called on " + type + ": " + name);
        }
        AMOrganization amOrg = this.checkAndGetOrg(token);
        HashSet<String> entitySet = new HashSet<String>();
        try {
            String eDN = this.getDN(type, name);
            entitySet.add(eDN);
            if (type.equals(IdType.USER)) {
                amOrg.deleteUsers(entitySet);
            } else if (type.equals(IdType.AGENT)) {
                amOrg.deleteEntities(100, entitySet);
            } else if (type.equals(IdType.GROUP)) {
                amOrg.deleteStaticGroups(entitySet);
            } else if (type.equals(IdType.ROLE)) {
                amOrg.deleteRoles(entitySet);
            } else if (type.equals(IdType.FILTEREDROLE)) {
                amOrg.deleteFilteredRoles(entitySet);
            }
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.delete(): Caught AMException...", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        String dn = this.getDN(type, name);
        int profileType = this.getProfileType(type);
        if (debug.messageEnabled()) {
            debug.message("AMSDKIdRepo: getAttributes called: " + type + ": " + name + " DN: '" + dn + "'");
        }
        if (adminToken != null) {
            token = adminToken;
        }
        try {
            if (amsc.isValidEntry(dn)) {
                IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
                return dsServices.getAttributes(token, dn, attrNames, false, false, profileType);
            }
            Object[] args = new Object[]{name};
            throw new IdRepoException("amIdRepo", "202", args);
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.getAttributes(): AMException ", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
    }

    public Map getAttributes(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        String dn = this.getDN(type, name);
        int profileType = this.getProfileType(type);
        if (debug.messageEnabled()) {
            debug.message("AMSDKIdRepo: getAttributes called: " + type + ": " + name + " DN: '" + dn + "'");
        }
        if (adminToken != null) {
            token = adminToken;
        }
        try {
            if (amsc.isValidEntry(dn)) {
                IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
                return dsServices.getAttributes(token, dn, false, false, profileType);
            }
            Object[] args = new Object[]{name};
            throw new IdRepoException("amIdRepo", "202", args);
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.getAttributes(): AMException ", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
    }

    public Map getBinaryAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKIdRepo: getBinaryAttributes called: " + type + ": " + name);
        }
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        String dn = this.getDN(type, name);
        int profileType = this.getProfileType(type);
        if (adminToken != null) {
            token = adminToken;
        }
        try {
            if (amsc.isValidEntry(dn)) {
                IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
                return dsServices.getAttributesByteValues(token, dn, attrNames, profileType);
            }
            Object[] args = new Object[]{name};
            throw new IdRepoException("amIdRepo", "202", args);
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.getBinaryAttributes(): AMException ", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
    }

    public Map getConfiguration() {
        return super.getConfiguration();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Set getMembers(SSOToken token, IdType type, String name, IdType membersType) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: getMembers called" + type + ": " + name + ": " + membersType);
        }
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        String dn = null;
        if (type.equals(IdType.USER) || type.equals(IdType.AGENT)) {
            debug.error("AMSDKRepo: Membership operation is not supported  for Users or Agents");
            throw new IdRepoException("amIdRepo", "203", null);
        }
        if (type.equals(IdType.GROUP)) {
            dn = this.getDN(type, name);
            AMStaticGroup group = amsc.getStaticGroup(dn);
            if (membersType.equals(IdType.USER)) {
                try {
                    return group.getUserDNs();
                }
                catch (AMException ame) {
                    debug.error("AMSDKRepo: Unable to get user memberships for group" + dn, (Throwable)ame);
                    Object[] args = new Object[]{CLASS_NAME, membersType.getName(), type.getName(), name};
                    IdRepoException ide = new IdRepoException("amIdRepo", "205", args);
                    ide.setLDAPErrorCode(ame.getLDAPErrorCode());
                    throw ide;
                }
            }
            debug.error("AMSDKRepo: Groups do not supported membership for " + membersType.getName());
            Object[] args = new Object[]{CLASS_NAME, membersType.getName(), type.getName()};
            throw new IdRepoException("amIdRepo", "204", args);
        }
        if (type.equals(IdType.ROLE)) {
            dn = this.getDN(type, name);
            AMRole role = amsc.getRole(dn);
            if (membersType.equals(IdType.USER)) {
                try {
                    return role.getUserDNs();
                }
                catch (AMException ame) {
                    debug.error("AMSDKRepo: Unable to get user memberships for role " + dn, (Throwable)ame);
                    throw IdUtils.convertAMException(ame);
                }
            }
            Object[] args = new Object[]{CLASS_NAME, membersType.getName(), type.getName()};
            throw new IdRepoException("amIdRepo", "204", args);
        }
        if (type.equals(IdType.FILTEREDROLE)) {
            dn = this.getDN(type, name);
            AMFilteredRole role = amsc.getFilteredRole(dn);
            if (membersType.equals(IdType.USER)) {
                try {
                    return role.getUserDNs();
                }
                catch (AMException ame) {
                    debug.error("AMSDKRepo: Unable to get user memberships for role " + dn, (Throwable)ame);
                    throw IdUtils.convertAMException(ame);
                }
            }
            Object[] args = new Object[]{CLASS_NAME, membersType.getName(), type.getName()};
            throw new IdRepoException("amIdRepo", "204", args);
        }
        Object[] args = new Object[]{CLASS_NAME, IdOperation.READ.getName(), type.getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
    }

    public Set getMemberships(SSOToken token, IdType type, String name, IdType membershipType) throws IdRepoException, SSOException {
        Set results;
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: getMemberships called" + type + ": " + name + ": " + membershipType);
        }
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        String dn = null;
        if (!type.equals(IdType.USER)) {
            debug.error("AMSDKRepo: Membership for identities other than  Users is not allowed ");
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        dn = this.getDN(type, name);
        AMUser user = amsc.getUser(dn);
        if (membershipType.equals(IdType.GROUP)) {
            try {
                results = user.getStaticGroupDNs();
            }
            catch (AMException ame) {
                debug.error("AMSDKRepo: Unable to get user's group memberships " + dn, (Throwable)ame);
                Object[] args = new Object[]{CLASS_NAME, membershipType.getName(), type.getName(), name};
                IdRepoException ide = new IdRepoException("amIdRepo", "207", args);
                ide.setLDAPErrorCode(ame.getLDAPErrorCode());
                throw ide;
            }
        } else if (membershipType.equals(IdType.ROLE)) {
            try {
                results = user.getRoleDNs();
            }
            catch (AMException ame) {
                debug.error("AMSDKRepo: Unable to get roles of a user " + dn, (Throwable)ame);
                throw IdUtils.convertAMException(ame);
            }
        } else if (membershipType.equals(IdType.FILTEREDROLE)) {
            try {
                results = user.getFilteredRoleDNs();
            }
            catch (AMException ame) {
                debug.error("AMSDKRepo: Unable to get user memberships for role " + dn, (Throwable)ame);
                throw IdUtils.convertAMException(ame);
            }
        } else {
            debug.error("AMSDKRepo: Membership for other types of entities  not supported for Users");
            Object[] args = new Object[]{CLASS_NAME, type.getName(), membershipType.getName()};
            throw new IdRepoException("amIdRepo", "204", args);
        }
        return results;
    }

    public Set getSupportedOperations(IdType type) {
        return (Set)this.supportedOps.get(type);
    }

    public Set getSupportedTypes() {
        return this.supportedOps.keySet();
    }

    public void initialize(Map configParams) {
        Set agentNameSet;
        Set pcNameSet;
        Set consoleRecursiveFlg;
        Set orgs;
        super.initialize(configParams);
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: Initializing configuration: " + this.configMap.toString());
        }
        this.orgDN = (orgs = (Set)this.configMap.get("amSDKOrgName")) != null && !orgs.isEmpty() ? (String)orgs.iterator().next() : AMStoreConnection.getAMSdkBaseDN();
        if (adminToken == null) {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                sc = new AMStoreConnection(adminToken);
            }
            catch (SSOException ssoe) {
                debug.error("AMSDKRepo:Initialize..Failed to initialize  AMStoreConnection...", (Throwable)((Object)ssoe));
            }
        }
        if ((consoleRecursiveFlg = (Set)this.configMap.get("sun-idrepo-amSDK-config-recursive-enabled")) != null && !consoleRecursiveFlg.isEmpty() && consoleRecursiveFlg.contains("true")) {
            this.dataStoreRecursive = true;
        }
        if ((pcNameSet = (Set)this.configMap.get("sun-idrepo-amSDK-config-people-container-name")) != null && !pcNameSet.isEmpty()) {
            String pcName = (String)pcNameSet.iterator().next();
            Set pcValueSet = (Set)this.configMap.get("sun-idrepo-amSDK-config-people-container-value");
            if (pcName != null && pcValueSet != null && !pcValueSet.isEmpty()) {
                String pcValue = (String)pcValueSet.iterator().next();
                this.pcDN = pcName + "=" + pcValue + "," + this.orgDN;
            }
        }
        if ((agentNameSet = (Set)this.configMap.get("sun-idrepo-amSDK-config-agent-container-name")) != null && !agentNameSet.isEmpty()) {
            String agentName = (String)agentNameSet.iterator().next();
            Set agentValueSet = (Set)this.configMap.get("sun-idrepo-amSDK-config-agent-container-value");
            if (agentName != null && agentValueSet != null && !agentValueSet.isEmpty()) {
                String agentValue = (String)agentValueSet.iterator().next();
                this.agentDN = agentName + "=" + agentValue + "," + this.orgDN;
            }
        }
    }

    public boolean isExists(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: isExists called " + type + ": " + name);
        }
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        try {
            String dn = this.getDN(type, name);
            return amsc.isValidEntry(dn);
        }
        catch (IdRepoException ide) {
            return false;
        }
    }

    public boolean isActive(SSOToken token, IdType type, String name) throws SSOException {
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        try {
            String dn = this.getDN(type, name);
            AMEntity entity = amsc.getEntity(dn);
            return entity.isActivated();
        }
        catch (AMException ame) {
            return false;
        }
        catch (IdRepoException ide) {
            return false;
        }
    }

    public void setActiveStatus(SSOToken token, IdType type, String name, boolean active) throws IdRepoException, SSOException {
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        try {
            String dn = this.getDN(type, name);
            AMEntity entity = amsc.getEntity(dn);
            if (active) {
                entity.activate();
            } else {
                entity.deactivate();
            }
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.setActiveStatus: Caught AMException", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
    }

    public void modifyMemberShip(SSOToken token, IdType type, String name, Set members, IdType membersType, int operation) throws IdRepoException, SSOException {
        String gdn;
        AMStoreConnection amsc;
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: modifyMemberShip called " + type + ": " + name + ": " + members + ": " + membersType);
        }
        if (members == null || members.isEmpty()) {
            debug.error("AMSDKRepo.modifyMemberShip: Members set is empty");
            throw new IdRepoException("amIdRepo", "201", null);
        }
        if (type.equals(IdType.USER) || type.equals(IdType.AGENT)) {
            debug.error("AMSDKRepo.modifyMembership: Memberhsip to users and agents is not supported");
            throw new IdRepoException("amIdRepo", "203", null);
        }
        if (!membersType.equals(IdType.USER)) {
            debug.error("AMSDKRepo.modifyMembership: A non-user type cannot  be made a member of any identity" + membersType.getName());
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "206", args);
        }
        HashSet<String> usersSet = new HashSet<String>();
        for (String curr : members) {
            String dn = this.getDN(membersType, curr);
            usersSet.add(dn);
        }
        AMStoreConnection aMStoreConnection = amsc = sc == null ? new AMStoreConnection(token) : sc;
        if (type.equals(IdType.GROUP)) {
            gdn = this.getDN(type, name);
            AMStaticGroup group = amsc.getStaticGroup(gdn);
            try {
                switch (operation) {
                    case 1: {
                        group.addUsers(usersSet);
                        break;
                    }
                    case 2: {
                        group.removeUsers(usersSet);
                    }
                }
            }
            catch (AMException ame) {
                debug.error("AMSDKRepo.modifyMembership: Caught exception while adding users to groups", (Throwable)ame);
                throw IdUtils.convertAMException(ame);
            }
        } else if (type.equals(IdType.ROLE)) {
            gdn = this.getDN(type, name);
            AMRole role = amsc.getRole(gdn);
            try {
                switch (operation) {
                    case 1: {
                        role.addUsers(usersSet);
                        break;
                    }
                    case 2: {
                        role.removeUsers(usersSet);
                    }
                }
            }
            catch (AMException ame) {
                debug.error("AMSDKRepo.modifyMembership: Caught exception while  adding/removing users to roles", (Throwable)ame);
                throw IdUtils.convertAMException(ame);
            }
        } else {
            debug.error("AMSDKRepo.modifyMembership: Memberships cannot bemodified for type= " + type.getName());
            Object[] args = new Object[]{CLASS_NAME, type.getName()};
            throw new IdRepoException("amIdRepo", "209", args);
        }
    }

    public void removeAttributes(SSOToken token, IdType type, String name, Set attrNames) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: removeAttributes called " + type + ": " + name + attrNames);
        }
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, Map avPairs, boolean recursive, int maxResults, int maxTime, Set returnAttrs) throws IdRepoException, SSOException {
        AMSearchResults results;
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: search called" + type + ": " + pattern + ": " + avPairs);
        }
        String searchDN = this.orgDN;
        int profileType = this.getProfileType(type);
        if (type.equals(IdType.USER)) {
            searchDN = "ou=" + this.getDefaultPeopleContainerName() + "," + this.orgDN;
        } else if (type.equals(IdType.AGENT)) {
            searchDN = "ou=" + this.getDefaultAgentContainerName() + "," + this.orgDN;
        } else if (type.equals(IdType.GROUP)) {
            searchDN = "ou=" + this.getDefaultGroupContainerName() + "," + this.orgDN;
        }
        AMSearchControl ctrl = new AMSearchControl();
        ctrl.setMaxResults(maxResults);
        ctrl.setTimeOut(maxTime);
        ctrl.setSearchScope(1);
        if (returnAttrs == null || returnAttrs.isEmpty()) {
            ctrl.setAllReturnAttributes(true);
        } else {
            ctrl.setReturnAttributes(returnAttrs);
        }
        try {
            AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
            switch (profileType) {
                case 1: {
                    Set usersFound;
                    AMPeopleContainer pc = amsc.getPeopleContainer(searchDN);
                    if (avPairs == null || avPairs.isEmpty()) {
                        results = pc.searchUsers(pattern, avPairs, ctrl);
                    } else {
                        String avFilter = AMSDKRepo.constructFilter(0, avPairs);
                        results = pc.searchUsers(pattern, ctrl, avFilter);
                    }
                    if (recursive && ((usersFound = results.getSearchResults()) == null || usersFound.isEmpty())) {
                        if (avPairs == null || avPairs.isEmpty()) {
                            AMOrganization org = amsc.getOrganization(this.orgDN);
                            ctrl.setSearchScope(2);
                            results = org.searchUsers(pattern, ctrl);
                            break;
                        }
                        String avFilter = AMSDKRepo.constructFilter(0, avPairs);
                        AMOrganization org = amsc.getOrganization(this.orgDN);
                        ctrl.setSearchScope(2);
                        results = org.searchUsers("*", ctrl, avFilter);
                    }
                    break;
                }
                case 100: {
                    AMOrganizationalUnit ou = amsc.getOrganizationalUnit(searchDN);
                    results = ou.searchEntities(pattern, avPairs, null, ctrl);
                    break;
                }
                case 9: 
                case 10: {
                    AMGroupContainer gc = amsc.getGroupContainer(searchDN);
                    results = gc.searchGroups(pattern, avPairs, ctrl);
                    break;
                }
                case 6: {
                    AMOrganization org = amsc.getOrganization(searchDN);
                    results = org.searchRoles(pattern, ctrl);
                    break;
                }
                case 8: {
                    AMOrganization org = amsc.getOrganization(searchDN);
                    results = org.searchFilteredRoles(pattern, ctrl);
                    break;
                }
                default: {
                    Object[] args = new Object[]{CLASS_NAME, type.getName()};
                    throw new IdRepoException("amIdRepo", "210", args);
                }
            }
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.search: Unable to perform search operation", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
        return new RepoSearchResults(results.getSearchResults(), results.getErrorCode(), results.getResultAttributes(), type);
    }

    public RepoSearchResults search(SSOToken token, IdType type, String pattern, int maxTime, int maxResults, Set returnAttrs, boolean returnAllAttrs, int filterOp, Map avPairs, boolean recursive) throws IdRepoException, SSOException {
        AMSearchResults results;
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: search called" + type + ": " + pattern + ": " + avPairs);
        }
        String searchDN = this.orgDN;
        int profileType = this.getProfileType(type);
        if (type.equals(IdType.GROUP)) {
            searchDN = "ou=" + this.getDefaultGroupContainerName() + "," + this.orgDN;
        }
        AMSearchControl ctrl = new AMSearchControl();
        ctrl.setMaxResults(maxResults);
        ctrl.setTimeOut(maxTime);
        ctrl.setSearchScope(1);
        if (returnAllAttrs) {
            ctrl.setAllReturnAttributes(true);
        } else if (returnAttrs != null && !returnAttrs.isEmpty()) {
            ctrl.setReturnAttributes(returnAttrs);
        }
        try {
            AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
            switch (profileType) {
                case 1: {
                    if (this.pcDN != null) {
                        if (!this.dataStoreRecursive) {
                            searchDN = this.pcDN;
                        } else {
                            ctrl.setSearchScope(2);
                        }
                    } else if (!this.dataStoreRecursive) {
                        searchDN = "ou=" + this.getDefaultPeopleContainerName() + "," + this.orgDN;
                    } else {
                        ctrl.setSearchScope(2);
                    }
                    AMPeopleContainer pc = amsc.getPeopleContainer(searchDN);
                    if (avPairs == null || avPairs.isEmpty()) {
                        results = pc.searchUsers(pattern, avPairs, ctrl);
                        break;
                    }
                    String avFilter = AMSDKRepo.constructFilter(filterOp, avPairs);
                    results = pc.searchUsers(pattern, ctrl, avFilter);
                    break;
                }
                case 100: {
                    if (this.agentDN != null) {
                        if (!this.dataStoreRecursive) {
                            searchDN = this.agentDN;
                        } else {
                            ctrl.setSearchScope(2);
                        }
                    } else if (!this.dataStoreRecursive) {
                        searchDN = "ou=" + this.getDefaultAgentContainerName() + "," + this.orgDN;
                    } else {
                        ctrl.setSearchScope(2);
                    }
                    AMOrganizationalUnit ou = amsc.getOrganizationalUnit(searchDN);
                    if (avPairs == null || avPairs.isEmpty()) {
                        results = ou.searchEntities(pattern, avPairs, null, ctrl);
                        break;
                    }
                    String avFilter = AMSDKRepo.constructFilter(filterOp, avPairs);
                    results = ou.searchEntities(pattern, ctrl, avFilter, null);
                    break;
                }
                case 9: 
                case 10: {
                    AMGroupContainer gc = amsc.getGroupContainer(searchDN);
                    results = gc.searchStaticGroups(pattern, avPairs, ctrl);
                    break;
                }
                case 6: {
                    AMOrganization org = amsc.getOrganization(searchDN);
                    results = org.searchRoles(pattern, ctrl);
                    break;
                }
                case 8: {
                    AMOrganization org = amsc.getOrganization(searchDN);
                    results = org.searchFilteredRoles(pattern, ctrl);
                    break;
                }
                default: {
                    Object[] args = new Object[]{CLASS_NAME, type.getName()};
                    throw new IdRepoException("amIdRepo", "210", args);
                }
            }
        }
        catch (AMException ame) {
            String amErrorCode = ame.getErrorCode();
            if (!amErrorCode.equals("341")) {
                debug.error("AMSDKRepo.search: Unable to perform search operation", (Throwable)ame);
            }
            if (profileType == 100 && amErrorCode.equals("341")) {
                return new RepoSearchResults(new HashSet(), 0, Collections.EMPTY_MAP, type);
            }
            throw IdUtils.convertAMException(ame);
        }
        return new RepoSearchResults(results.getSearchResults(), results.getErrorCode(), results.getResultAttributes(), type);
    }

    public void setAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            if (attributes.containsKey("userpassword")) {
                AMHashMap removedPasswd = new AMHashMap();
                removedPasswd.copy(attributes);
                removedPasswd.remove("userpassword");
                removedPasswd.put("userpassword", "xxx...");
                debug.message("AMSDKRepo: setAttributes called" + type + ": " + name + ": " + removedPasswd);
            } else {
                debug.message("AMSDKRepo: setAttributes called" + type + ": " + name + ": " + attributes);
            }
        }
        if (attributes == null || attributes.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        String dn = this.getDN(type, name);
        int profileType = this.getProfileType(type);
        try {
            if (adminToken != null) {
                token = adminToken;
            }
            IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
            dsServices.setAttributes(token, dn, profileType, attributes, null, false);
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.setAttributes: Unable to set attributes", (Throwable)ame);
            String ldapError = ame.getLDAPErrorCode();
            String errorMessage = ame.getMessage();
            int errCode = Integer.parseInt(ldapError);
            if (errCode == 19) {
                Object[] args = new Object[]{this.getClass().getName(), ldapError, errorMessage};
                IdRepoFatalException ide = new IdRepoFatalException("amIdRepo", "313", args);
                ide.setLDAPErrorCode(ldapError);
                throw ide;
            }
            throw IdUtils.convertAMException(ame);
        }
    }

    public void setBinaryAttributes(SSOToken token, IdType type, String name, Map attributes, boolean isAdd) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: setBinaryAttributes called" + type + ": " + name + ": " + attributes);
        }
        if (attributes == null || attributes.isEmpty()) {
            throw new IdRepoException("amIdRepo", "201", null);
        }
        String dn = this.getDN(type, name);
        int profileType = this.getProfileType(type);
        try {
            if (adminToken != null) {
                token = adminToken;
            }
            IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
            dsServices.setAttributes(token, dn, profileType, new AMHashMap(false), attributes, false);
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.setBinaryAttributes: Unable to set attributes", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
    }

    public void changePassword(SSOToken token, IdType type, String name, String attrName, String oldPassword, String newPassword) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo.changePassword: name = " + name);
        }
        if (!type.equals(IdType.USER)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "229", args);
        }
        String dn = this.getDN(type, name);
        int profileType = this.getProfileType(type);
        try {
            IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
            dsServices.changePassword(token, dn, attrName, oldPassword, newPassword);
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.changePassword:", (Throwable)ame);
            throw IdUtils.convertAMException(ame);
        }
    }

    private void setMixAttributes(SSOToken token, IdType type, String name, Map attrMap, boolean isAdd) throws IdRepoException, SSOException {
        HashMap binAttrMap = null;
        HashMap strAttrMap = null;
        boolean foundBin = false;
        for (String tmpAttrName : attrMap.keySet()) {
            if (!(attrMap.get(tmpAttrName) instanceof byte[][])) continue;
            if (!foundBin) {
                strAttrMap = new HashMap(attrMap);
                binAttrMap = new HashMap();
            }
            foundBin = true;
            binAttrMap.put(tmpAttrName, attrMap.get(tmpAttrName));
            strAttrMap.remove(tmpAttrName);
        }
        if (foundBin) {
            this.setAttributes(token, type, name, strAttrMap, false);
            this.setBinaryAttributes(token, type, name, binAttrMap, false);
        } else {
            this.setAttributes(token, type, name, attrMap, false);
        }
    }

    private void setTempMixAttributes(AMTemplate templ, Map attrMap) throws IdRepoException, SSOException {
        HashMap binAttrMap = null;
        HashMap strAttrMap = null;
        boolean foundBin = false;
        for (String tmpAttrName : attrMap.keySet()) {
            if (attrMap.get(tmpAttrName) instanceof byte[][]) {
                if (!foundBin) {
                    strAttrMap = new HashMap(attrMap);
                    binAttrMap = new HashMap();
                }
                foundBin = true;
                binAttrMap.put(tmpAttrName, attrMap.get(tmpAttrName));
                strAttrMap.remove(tmpAttrName);
                continue;
            }
            strAttrMap = new HashMap(attrMap);
            binAttrMap = new HashMap();
        }
        try {
            if (foundBin) {
                templ.setAttributes(strAttrMap);
                templ.setAttributesByteArray(binAttrMap);
            } else {
                templ.setAttributes(strAttrMap);
            }
        }
        catch (AMException ame) {
            throw IdUtils.convertAMException(ame);
        }
    }

    public void assignService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (adminToken != null) {
            token = adminToken;
        }
        if (type.equals(IdType.USER)) {
            Set OCs = (Set)attrMap.get("objectclass");
            HashSet<String> attrName = new HashSet<String>(1);
            attrName.add("objectclass");
            Map tmpMap = this.getAttributes(token, type, name, attrName);
            Set oldOCs = (Set)tmpMap.get("objectclass");
            OCs = AMCommonUtils.combineOCs(OCs, oldOCs);
            attrMap.put("objectclass", OCs);
            if (sType.equals(SchemaType.USER)) {
                this.setMixAttributes(token, type, name, attrMap, false);
            } else if (sType.equals(SchemaType.DYNAMIC)) {
                this.setMixAttributes(token, type, name, attrMap, false);
            }
        } else if (type.equals(IdType.ROLE) || type.equals(IdType.FILTEREDROLE) || type.equals(IdType.REALM)) {
            IDirectoryServices dsServices;
            block13: {
                dsServices = AMDirectoryAccessFactory.getDirectoryServices();
                try {
                    AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                    AMOrganization amOrg = amsc.getOrganization(this.orgDN);
                    Set assndSvcs = amOrg.getRegisteredServiceNames();
                    if (!assndSvcs.contains(serviceName)) {
                        amOrg.registerService(serviceName, false, false);
                    }
                }
                catch (AMException ame) {
                    if (ame.getErrorCode().equals("464")) break block13;
                    throw IdUtils.convertAMException(ame);
                }
            }
            String dn = this.getDN(type, name);
            try {
                attrMap.remove("objectclass");
                int priority = type.equals(IdType.REALM) ? 3 : 0;
                dsServices.createAMTemplate(token, dn, this.getProfileType(type), serviceName, attrMap, priority);
            }
            catch (AMException ame) {
                debug.error("AMSDKRepo.assignService: Caught AMException", (Throwable)ame);
                throw IdUtils.convertAMException(ame);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unassignService(SSOToken token, IdType type, String name, String serviceName, Map attrMap) throws IdRepoException, SSOException {
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (adminToken != null) {
            token = adminToken;
        }
        if (type.equals(IdType.USER)) {
            Set removeOCs = (Set)attrMap.get("objectclass");
            HashSet<String> attrNameSet = new HashSet<String>();
            attrNameSet.add("objectclass");
            Map objectClassesMap = this.getAttributes(token, type, name, attrNameSet);
            Set OCValues = (Set)objectClassesMap.get("objectclass");
            removeOCs = AMCommonUtils.updateAndGetRemovableOCs(OCValues, removeOCs);
            HashSet<String> removeAttrs = new HashSet<String>();
            for (String oc : removeOCs) {
                IDirectoryServices dsServices = AMDirectoryAccessFactory.getDirectoryServices();
                Set attrs = dsServices.getAttributesForSchema(oc);
                for (String attrName : attrs) {
                    removeAttrs.add(attrName.toLowerCase());
                }
            }
            Map avPair = this.getAttributes(token, type, name);
            for (String attrName : avPair.keySet()) {
                if (!removeAttrs.contains(attrName)) continue;
                try {
                    AMHashMap tmpMap = new AMHashMap();
                    tmpMap.put(attrName, Collections.EMPTY_SET);
                    this.setAttributes(token, type, name, tmpMap, false);
                }
                catch (Exception ex) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("AMUserImpl.unassignServices()Error occured while removing attribute: " + attrName);
                }
            }
            AMHashMap tmpMap = new AMHashMap();
            tmpMap.put("objectclass", OCValues);
            this.setAttributes(token, type, name, tmpMap, false);
            return;
        } else if (type.equals(IdType.ROLE)) {
            try {
                AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                String roleDN = this.getDN(type, name);
                AMRole role = amsc.getRole(roleDN);
                AMTemplate templ = role.getTemplate(serviceName, 301);
                if (templ == null || !templ.isExists()) return;
                templ.delete();
                return;
            }
            catch (AMException ame) {
                debug.error("AMSDKRepo.unassignService: Caught AMException", (Throwable)ame);
                throw IdUtils.convertAMException(ame);
            }
        } else if (type.equals(IdType.FILTEREDROLE) || type.equals(IdType.REALM)) {
            try {
                AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                String roleDN = this.getDN(type, name);
                AMFilteredRole role = amsc.getFilteredRole(roleDN);
                AMTemplate templ = role.getTemplate(serviceName, 301);
                if (templ == null || !templ.isExists()) return;
                templ.delete();
                return;
            }
            catch (AMException ame) {
                debug.error("AMSDKRepo.unassignService: Caught AMException", (Throwable)ame);
                throw IdUtils.convertAMException(ame);
            }
        } else {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
    }

    public Set getAssignedServices(SSOToken token, IdType type, String name, Map mapOfServiceNamesandOCs) throws IdRepoException, SSOException {
        HashSet<String> resultsSet = new HashSet<String>();
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (mapOfServiceNamesandOCs == null || mapOfServiceNamesandOCs.isEmpty()) {
            return resultsSet;
        }
        if (type.equals(IdType.USER)) {
            Set OCs = this.readObjectClass(token, type, name);
            OCs = this.convertToLowerCase(OCs);
            for (String sname : mapOfServiceNamesandOCs.keySet()) {
                Set ocSet = (Set)mapOfServiceNamesandOCs.get(sname);
                if (!OCs.containsAll(ocSet = this.convertToLowerCase(ocSet))) continue;
                resultsSet.add(sname);
            }
        } else if (type.equals(IdType.ROLE)) {
            for (String serviceName : mapOfServiceNamesandOCs.keySet()) {
                try {
                    String roleDN;
                    AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                    AMRole role = amsc.getRole(roleDN = this.getDN(type, name));
                    AMTemplate templ = role.getTemplate(serviceName, 301);
                    if (templ == null || !templ.isExists()) continue;
                    resultsSet.add(serviceName);
                }
                catch (AMException ame) {}
            }
        } else if (type.equals(IdType.FILTEREDROLE) || type.equals(IdType.REALM)) {
            for (String serviceName : mapOfServiceNamesandOCs.keySet()) {
                try {
                    String roleDN;
                    AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                    AMFilteredRole role = amsc.getFilteredRole(roleDN = this.getDN(type, name));
                    AMTemplate templ = role.getTemplate(serviceName, 301);
                    if (templ == null || !templ.isExists()) continue;
                    resultsSet.add(serviceName);
                }
                catch (AMException ame) {}
            }
        } else {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        return resultsSet;
    }

    public Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, true);
    }

    public Map getBinaryServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames) throws IdRepoException, SSOException {
        return this.getServiceAttributes(token, type, name, serviceName, attrNames, false);
    }

    private Map getServiceAttributes(SSOToken token, IdType type, String name, String serviceName, Set attrNames, boolean isString) throws IdRepoException, SSOException {
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (type.equals(IdType.USER)) {
            return isString ? this.getAttributes(token, type, name, attrNames) : this.getBinaryAttributes(token, type, name, attrNames);
        }
        if (type.equals(IdType.ROLE)) {
            try {
                AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                String roleDN = this.getDN(type, name);
                AMRole role = amsc.getRole(roleDN);
                AMTemplate templ = role.getTemplate(serviceName, 301);
                if (templ != null && templ.isExists()) {
                    return isString ? templ.getAttributes(attrNames) : templ.getAttributesByteArray(attrNames);
                }
                if (debug.messageEnabled()) {
                    debug.message("AMSDKRepo::getServiceAttributes Service: " + serviceName + " is not assigned to DN: " + roleDN);
                }
                return Collections.EMPTY_MAP;
            }
            catch (AMException ame) {
                throw IdUtils.convertAMException(ame);
            }
        }
        if (type.equals(IdType.FILTEREDROLE) || type.equals(IdType.REALM)) {
            try {
                AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                String roleDN = this.getDN(type, name);
                AMFilteredRole role = amsc.getFilteredRole(roleDN);
                AMTemplate templ = role.getTemplate(serviceName, 301);
                if (templ != null && templ.isExists()) {
                    return isString ? templ.getAttributes(attrNames) : templ.getAttributesByteArray(attrNames);
                }
                Object[] args = new Object[]{serviceName};
                throw new IdRepoException("amIdRepo", "101", args);
            }
            catch (AMException ame) {
                throw IdUtils.convertAMException(ame);
            }
        }
        Object[] args = new Object[]{this.getClass().getName()};
        throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
    }

    public void modifyService(SSOToken token, IdType type, String name, String serviceName, SchemaType sType, Map attrMap) throws IdRepoException, SSOException {
        if (type.equals(IdType.AGENT) || type.equals(IdType.GROUP)) {
            Object[] args = new Object[]{this.getClass().getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "213", args);
        }
        if (type.equals(IdType.USER)) {
            if (sType.equals(SchemaType.DYNAMIC)) {
                Object[] args = new Object[]{this.getClass().getName(), sType.toString(), type.getName()};
                throw new IdRepoException("amIdRepo", "214", args);
            }
            this.setMixAttributes(token, type, name, attrMap, false);
        } else {
            if (type.equals(IdType.ROLE)) {
                if (sType.equals(SchemaType.USER)) {
                    Object[] args = new Object[]{this.getClass().getName(), sType.toString(), type.getName()};
                    throw new IdRepoException("amIdRepo", "214", args);
                }
                try {
                    AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                    String roleDN = this.getDN(type, name);
                    AMRole role = amsc.getRole(roleDN);
                    AMTemplate templ = role.getTemplate(serviceName, 301);
                    if (templ == null || !templ.isExists()) {
                        Object[] args = new Object[]{serviceName};
                        throw new IdRepoException("amIdRepo", "101", args);
                    }
                    this.setTempMixAttributes(templ, attrMap);
                    templ.store();
                }
                catch (AMException ame) {
                    throw IdUtils.convertAMException(ame);
                }
            }
            if (type.equals(IdType.FILTEREDROLE) || type.equals(IdType.REALM)) {
                if (sType.equals(SchemaType.USER)) {
                    Object[] args = new Object[]{this.getClass().getName(), sType.toString(), type.getName()};
                    throw new IdRepoException("amIdRepo", "214", args);
                }
                try {
                    AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
                    String roleDN = this.getDN(type, name);
                    AMFilteredRole role = amsc.getFilteredRole(roleDN);
                    AMTemplate templ = role.getTemplate(serviceName, 301);
                    if (templ == null || !templ.isExists()) {
                        Object[] args = new Object[]{serviceName};
                        throw new IdRepoException("amIdRepo", "101", args);
                    }
                    this.setTempMixAttributes(templ, attrMap);
                    templ.store();
                }
                catch (AMException ame) {
                    throw IdUtils.convertAMException(ame);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyObjectChangedEvent(String normalizedDN, int eventType) {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo.notifyObjectChangedEvent - Sending event to listeners.");
        }
        if (adminToken == null) {
            adminToken = (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
            try {
                sc = new AMStoreConnection(adminToken);
            }
            catch (SSOException ssoe) {
                debug.error("AMSDKRepo:notifyObjectChangedEvent. Failed to initialize AMStoreConnection...", (Throwable)((Object)ssoe));
            }
        }
        int type = 0;
        try {
            if (eventType != 2) {
                type = sc.getAMObjectType(normalizedDN);
            }
        }
        catch (AMException amse) {
            debug.error("AMSDKRepo:notifyObjectChangedEvent Unable to convert name to getAMObjectType.");
        }
        catch (SSOException amsso) {
            debug.error("AMSDKRepo:notifyObjectChangedEvent Unable to detemine permission.");
        }
        IdType idType = null;
        switch (type) {
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                idType = IdType.GROUP;
                break;
            }
            case 1: {
                idType = IdType.USER;
                break;
            }
            case 2: 
            case 3: {
                idType = IdType.REALM;
                break;
            }
            case 6: 
            case 7: {
                idType = IdType.ROLE;
                break;
            }
            case 8: {
                idType = IdType.FILTEREDROLE;
                break;
            }
            default: {
                if (!debug.messageEnabled()) break;
                debug.message("AMSDKRepo:notifyObjectChangedEvent. unknown matching type: type=" + type + " Entity: " + normalizedDN + " Eventtype: " + eventType);
            }
        }
        Set set = listeners;
        synchronized (set) {
            for (IdRepoListener l : listeners) {
                Map configMap = l.getConfigMap();
                if (idType != null) {
                    l.objectChanged(normalizedDN, idType, eventType, configMap);
                    if (idType != IdType.USER) continue;
                    l.objectChanged(normalizedDN, IdType.AGENT, eventType, configMap);
                    continue;
                }
                l.objectChanged(normalizedDN, eventType, configMap);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyAllObjectsChangedEvent() {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo.notifyAllObjectsChangedEvent -  Sending event to listeners.");
        }
        Set set = listeners;
        synchronized (set) {
            for (IdRepoListener l : listeners) {
                l.allObjectsChanged();
            }
        }
    }

    private void loadSupportedOps() {
        HashSet<IdOperation> opSet = new HashSet<IdOperation>();
        opSet.add(IdOperation.CREATE);
        opSet.add(IdOperation.DELETE);
        opSet.add(IdOperation.EDIT);
        opSet.add(IdOperation.READ);
        opSet.add(IdOperation.SERVICE);
        this.supportedOps.put(IdType.USER, Collections.unmodifiableSet(opSet));
        this.supportedOps.put(IdType.ROLE, Collections.unmodifiableSet(opSet));
        this.supportedOps.put(IdType.FILTEREDROLE, Collections.unmodifiableSet(opSet));
        HashSet op2Set = new HashSet(opSet);
        op2Set.remove(IdOperation.SERVICE);
        this.supportedOps.put(IdType.GROUP, Collections.unmodifiableSet(op2Set));
        this.supportedOps.put(IdType.AGENT, Collections.unmodifiableSet(op2Set));
        HashSet op3Set = new HashSet(opSet);
        op3Set.remove(IdOperation.CREATE);
        op3Set.remove(IdOperation.DELETE);
        op3Set.remove(IdOperation.EDIT);
        this.supportedOps.put(IdType.REALM, Collections.unmodifiableSet(op3Set));
    }

    private String getDefaultPeopleContainerName() {
        String gcName = "People";
        try {
            Map attrs;
            Set vals;
            ServiceSchema ss;
            ServiceSchemaManager ssm = new ServiceSchemaManager(ADMIN_SERVICE, adminToken);
            if (ssm != null && (ss = ssm.getGlobalSchema()) != null && (vals = (Set)(attrs = ss.getAttributeDefaults()).get(PC_ATTR)) != null && !vals.isEmpty()) {
                gcName = (String)vals.iterator().next();
            }
        }
        catch (SMSException smse) {
            debug.error("AMSDKRepo.getDefaultGC: SMSException: ", (Throwable)smse);
        }
        catch (SSOException ssoe) {
            debug.error("AMSDKRepo.getDefaultGC: SSOException", (Throwable)((Object)ssoe));
        }
        return gcName;
    }

    private String getDefaultGroupContainerName() {
        String gcName = "Groups";
        try {
            Map attrs;
            Set vals;
            ServiceSchema ss;
            ServiceSchemaManager ssm = new ServiceSchemaManager(ADMIN_SERVICE, adminToken);
            if (ssm != null && (ss = ssm.getGlobalSchema()) != null && (vals = (Set)(attrs = ss.getAttributeDefaults()).get(GC_ATTR)) != null && !vals.isEmpty()) {
                gcName = (String)vals.iterator().next();
            }
        }
        catch (SMSException smse) {
            debug.error("AMSDKRepo.getDefaultAC: SMSException: ", (Throwable)smse);
        }
        catch (SSOException ssoe) {
            debug.error("AMSDKRepo.getDefaultAC: SSOException", (Throwable)((Object)ssoe));
        }
        return gcName;
    }

    private String getDefaultAgentContainerName() {
        String gcName = "Agent";
        try {
            Map attrs;
            Set vals;
            ServiceSchema ss;
            ServiceSchemaManager ssm = new ServiceSchemaManager(ADMIN_SERVICE, adminToken);
            if (ssm != null && (ss = ssm.getGlobalSchema()) != null && (vals = (Set)(attrs = ss.getAttributeDefaults()).get(AC_ATTR)) != null && !vals.isEmpty()) {
                gcName = (String)vals.iterator().next();
            }
        }
        catch (SMSException smse) {
            debug.error("AMSDKRepo.getDefaultAC: SMSException: ", (Throwable)smse);
        }
        catch (SSOException ssoe) {
            debug.error("AMSDKRepo.getDefaultAC: SSOException", (Throwable)((Object)ssoe));
        }
        return gcName;
    }

    private AMOrganization checkAndGetOrg(SSOToken token) throws IdRepoException, SSOException {
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        try {
            int orgType = amsc.getAMObjectType(this.orgDN);
            if (orgType != 2) {
                debug.error("AMSDKRepo.create(): Incorrectly configured  plugin: Org DN is wrong = " + this.orgDN);
                throw new IdRepoException("amIdRepo", "303", null);
            }
        }
        catch (AMException ame) {
            debug.error("AMSDKRepo.create(): An exception occured while  initializing AM SDK ", (Throwable)ame);
            Object[] args = new Object[]{CLASS_NAME, IdOperation.CREATE.getName()};
            IdRepoException ide = new IdRepoException("amIdRepo", "304", args);
            ide.setLDAPErrorCode(ame.getLDAPErrorCode());
            throw ide;
        }
        return amsc.getOrganization(this.orgDN);
    }

    private String getDN(IdType type, String name) throws IdRepoException, SSOException {
        String dn;
        block24: {
            if (!type.equals(IdType.REALM) && DN.isDN((String)name) && name.indexOf(",") > -1) {
                return name;
            }
            if (sc == null) {
                throw new IdRepoException("amProfile", "301", null);
            }
            if (type.equals(IdType.USER)) {
                dn = this.pcDN != null ? AMNamingAttrManager.getNamingAttr(1) + "=" + name + "," + this.pcDN : AMNamingAttrManager.getNamingAttr(1) + "=" + name + ",ou=" + this.getDefaultPeopleContainerName() + "," + this.orgDN;
                try {
                    int sdkType = sc.getAMObjectType(dn);
                    if (sdkType != 1) {
                        Object[] args = new Object[]{sc.getAMObjectName(sdkType)};
                        throw new IdRepoException("amIdRepo", "217", args);
                    }
                    break block24;
                }
                catch (AMException ame) {
                    throw IdUtils.convertAMException(ame);
                }
            }
            if (type.equals(IdType.AGENT)) {
                dn = this.agentDN != null ? AMNamingAttrManager.getNamingAttr(100) + "=" + name + "," + this.agentDN : AMNamingAttrManager.getNamingAttr(100) + "=" + name + ",ou=" + this.getDefaultAgentContainerName() + "," + this.orgDN;
                try {
                    int sdkType = sc.getAMObjectType(dn);
                    if (sdkType != 100) {
                        Object[] args = new Object[]{sc.getAMObjectName(sdkType)};
                        throw new IdRepoException("amIdRepo", "217", args);
                    }
                    break block24;
                }
                catch (AMException ame) {
                    throw IdUtils.convertAMException(ame);
                }
            }
            if (type.equals(IdType.GROUP)) {
                dn = AMNamingAttrManager.getNamingAttr(9) + "=" + name + ",ou=" + this.getDefaultGroupContainerName() + "," + this.orgDN;
                try {
                    int sdkType = sc.getAMObjectType(dn);
                    if (sdkType != 9 && sdkType != 10) {
                        Object[] args = new Object[]{sc.getAMObjectName(sdkType)};
                        throw new IdRepoException("amIdRepo", "217", args);
                    }
                    break block24;
                }
                catch (AMException ame) {
                    throw IdUtils.convertAMException(ame);
                }
            }
            if (type.equals(IdType.ROLE)) {
                dn = AMNamingAttrManager.getNamingAttr(6) + "=" + name + "," + this.orgDN;
                try {
                    int sdkType = sc.getAMObjectType(dn);
                    if (sdkType != 6) {
                        Object[] args = new Object[]{sc.getAMObjectName(sdkType)};
                        throw new IdRepoException("amIdRepo", "217", args);
                    }
                    break block24;
                }
                catch (AMException ame) {
                    throw IdUtils.convertAMException(ame);
                }
            }
            if (type.equals(IdType.FILTEREDROLE)) {
                dn = AMNamingAttrManager.getNamingAttr(8) + "=" + name + "," + this.orgDN;
                try {
                    int sdkType = sc.getAMObjectType(dn);
                    if (sdkType != 8) {
                        Object[] args = new Object[]{sc.getAMObjectName(sdkType)};
                        throw new IdRepoException("amIdRepo", "217", args);
                    }
                    break block24;
                }
                catch (AMException ame) {
                    throw IdUtils.convertAMException(ame);
                }
            }
            if (type.equals(IdType.REALM)) {
                dn = AMNamingAttrManager.getNamingAttr(8) + "=" + "ContainerDefaultTemplateRole" + "," + this.orgDN;
            } else {
                Object[] args = new Object[]{CLASS_NAME, IdOperation.READ.getName(), type.getName()};
                throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
            }
        }
        return dn;
    }

    private int getProfileType(IdType type) throws IdRepoException {
        int profileType;
        if (type.equals(IdType.USER)) {
            profileType = 1;
        } else if (type.equals(IdType.AGENT)) {
            profileType = 100;
        } else if (type.equals(IdType.GROUP)) {
            profileType = 9;
        } else if (type.equals(IdType.ROLE)) {
            profileType = 6;
        } else if (type.equals(IdType.FILTEREDROLE)) {
            profileType = 8;
        } else if (type.equals(IdType.REALM) || type.equals(IdType.REALM)) {
            profileType = 8;
        } else {
            Object[] args = new Object[]{CLASS_NAME, IdOperation.READ.getName(), type.getName()};
            throw new IdRepoUnsupportedOpException("amIdRepo", "305", args);
        }
        return profileType;
    }

    private Set readObjectClass(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        HashSet<String> attrNameSet = new HashSet<String>();
        attrNameSet.add("objectclass");
        Map objectClassesMap = this.getAttributes(token, type, name, attrNameSet);
        Set OCValues = (Set)objectClassesMap.get("objectclass");
        return OCValues;
    }

    private Set convertToLowerCase(Set vals) {
        if (vals == null || vals.isEmpty()) {
            return vals;
        }
        HashSet<String> tSet = new HashSet<String>();
        Iterator it = vals.iterator();
        while (it.hasNext()) {
            tSet.add(((String)it.next()).toLowerCase());
        }
        return tSet;
    }

    protected static String constructFilter(int filterModifier, Map avPairs) {
        StringBuffer filterSB = new StringBuffer();
        if (avPairs == null || filterModifier == -1) {
            return null;
        }
        if (filterModifier == 0) {
            filterSB.append("(|");
        } else if (filterModifier == 1) {
            filterSB.append("(&");
        }
        for (String attributeName : avPairs.keySet()) {
            for (String attributeValue : (Set)avPairs.get(attributeName)) {
                filterSB.append("(").append(attributeName).append("=").append(attributeValue).append(")");
            }
        }
        filterSB.append(")");
        return filterSB.toString();
    }

    private ServerInstance getDsSvrCfg(LDAPUser.Type authType) throws IdRepoException {
        ServerInstance svrCfg = null;
        try {
            DSConfigMgr dsCfg = DSConfigMgr.getDSConfigMgr();
            svrCfg = dsCfg.getServerInstance(authType);
        }
        catch (LDAPServiceException ldex) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKRepo: getFullyQualifiedName LDAPServiceException: " + ldex.getMessage());
            }
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "219", args);
        }
        return svrCfg;
    }

    public String getFullyQualifiedName(SSOToken token, IdType type, String name) throws IdRepoException, SSOException {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: getFullyQualifiedName. type=" + type + "; name=" + name);
        }
        if (name == null || name.length() == 0) {
            Object[] args = new Object[]{CLASS_NAME, ""};
            throw new IdRepoException("amIdRepo", "220", args);
        }
        AMStoreConnection amsc = sc == null ? new AMStoreConnection(token) : sc;
        String dn = this.getDN(type, name);
        boolean exists = amsc.isValidEntry(dn);
        ServerInstance svrCfg = this.getDsSvrCfg(LDAPUser.Type.AUTH_ADMIN);
        return "amsdk://" + svrCfg.getServerName() + ":" + svrCfg.getPort() + "/" + dn;
    }

    public boolean supportsAuthentication() {
        if (debug.messageEnabled()) {
            debug.message("AMSDKRepo: supportsAuthentication. authenticationEnabled=true");
        }
        return true;
    }

    public boolean authenticate(Callback[] credentials) throws IdRepoException, AuthLoginException {
        debug.message("AMSDKRepo: authenticate. ");
        String username = null;
        String password = null;
        for (int i = 0; i < credentials.length; ++i) {
            char[] passwd;
            if (credentials[i] instanceof NameCallback) {
                username = ((NameCallback)credentials[i]).getName();
                if (!debug.messageEnabled()) continue;
                debug.message("LDPv3Repo:authenticate username: " + username);
                continue;
            }
            if (!(credentials[i] instanceof PasswordCallback) || (passwd = ((PasswordCallback)credentials[i]).getPassword()) == null) continue;
            password = new String(passwd);
            debug.message("AMSDKRepo: authenticate passwd XXX.");
        }
        if (username == null || username.length() == 0 || password == null) {
            Object[] args = new Object[]{CLASS_NAME};
            throw new IdRepoException("amIdRepo", "221", args);
        }
        ServerInstance svrCfg = this.getDsSvrCfg(LDAPUser.Type.AUTH_ADMIN);
        ResourceBundle bundle = AMResourceBundleCache.getInstance().getResBundle("amAuth", Locale.getDefaultLocale());
        boolean ssl = svrCfg.getConnectionType() == Server.Type.CONN_SSL;
        LDAPAuthUtils ldapAuthUtil = null;
        try {
            ldapAuthUtil = new LDAPAuthUtils(svrCfg.getServerName(), svrCfg.getPort(), ssl, bundle, debug);
        }
        catch (LDAPUtilException ldapUtilEx) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKRepo: authenticate LDAPUtilException: " + ldapUtilEx.getMessage());
            }
            Object[] args = new Object[]{CLASS_NAME, username};
            throw new IdRepoException("amIdRepo", "211", args);
        }
        ldapAuthUtil.setAuthDN(AdminUtils.getAdminDN());
        ldapAuthUtil.setAuthPassword(new String(AdminUtils.getAdminPassword()));
        ldapAuthUtil.setScope(1);
        if (this.authenticateIt(ldapAuthUtil, IdType.USER, username, password)) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKRepo: IdType.USER authenticateIt=true");
            }
            return true;
        }
        if (this.authenticateIt(ldapAuthUtil, IdType.AGENT, username, password)) {
            if (debug.messageEnabled()) {
                debug.message("AMSDKRepo: IdType.AGENT authenticateIt=true");
            }
            return true;
        }
        return false;
    }

    private boolean authenticateIt(LDAPAuthUtils ldapAuthUtil, IdType type, String username, String password) throws IdRepoException, AuthLoginException {
        String userid;
        String namingAttr;
        String baseDN;
        block21: {
            baseDN = null;
            namingAttr = null;
            userid = username;
            try {
                if (type.equals(IdType.USER)) {
                    String pcNamingAttr = AMStoreConnection.getNamingAttribute(5);
                    baseDN = pcNamingAttr + "=" + this.getDefaultPeopleContainerName() + "," + this.orgDN;
                    namingAttr = AMStoreConnection.getNamingAttribute(1);
                    break block21;
                }
                if (type.equals(IdType.AGENT)) {
                    baseDN = "ou=" + this.getDefaultAgentContainerName() + "," + this.orgDN;
                    namingAttr = AMStoreConnection.getNamingAttribute(100);
                    break block21;
                }
                return false;
            }
            catch (AMException ame) {
                if (debug.messageEnabled()) {
                    debug.message("AMSDKRepo: authenticateItAMException : " + ame.getMessage());
                    debug.message("   type=" + type + "; username=" + username);
                }
                return false;
            }
        }
        try {
            ldapAuthUtil.setUserNamingAttribute(namingAttr);
            HashSet<String> userSearchAttr = new HashSet<String>();
            userSearchAttr.add(namingAttr);
            ldapAuthUtil.setUserSearchAttribute(userSearchAttr);
            ldapAuthUtil.setBase(baseDN);
            ldapAuthUtil.setFilter("");
            String[] attrs = new String[]{"dn", namingAttr};
            ldapAuthUtil.setUserAttrs(attrs);
            if (DN.isDN((String)username)) {
                userid = LDAPDN.explodeDN((String)username, (boolean)true)[0];
            }
            ldapAuthUtil.authenticateUser(userid, password);
        }
        catch (LDAPUtilException ldapUtilEx) {
            switch (ldapUtilEx.getLDAPResultCode()) {
                case 32: {
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKRepo:authenticateIt. The specified user does not exist. username=" + username);
                    }
                    throw new AuthLoginException(this.amAuthLDAP, "NoUser", null);
                }
                case 49: {
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKRepo:authenticateIt. Invalid password. username=" + username);
                    }
                    String failureUserID = ldapAuthUtil.getUserId();
                    throw new InvalidPasswordException(this.amAuthLDAP, "InvalidUP", null, failureUserID, null);
                }
                case 53: {
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKRepo:authenticateIt. Unwilling to perform. Account inactivated. username" + username);
                    }
                    throw new AuthLoginException(this.amAuthLDAP, "AcctInactive", null);
                }
                case 48: {
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKRepo:authenticateIt. Inappropriate authentication. username=" + username);
                    }
                    throw new AuthLoginException(this.amAuthLDAP, "InappAuth", null);
                }
                case 19: {
                    if (debug.messageEnabled()) {
                        debug.message("AMSDKRepo:authenticateIt. Exceed password retry limit. username" + username);
                    }
                    throw new AuthLoginException(this.amAuthLDAP, "ExceedRetryLimit", null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("AMSDKRepo:authenticateIt. default exception. username=" + username);
            }
            throw new AuthLoginException(this.amAuthLDAP, "LDAPex", null);
        }
        return ldapAuthUtil.getState() == 26;
    }
}

