/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.am.util;

import com.iplanet.am.util.Debug;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class AMResourceBundleCache {
    private static AMResourceBundleCache instance;
    private HashMap mapBundles = new HashMap(30);
    private Debug debug = Debug.getInstance("amSDK");

    private AMResourceBundleCache() {
    }

    public static AMResourceBundleCache getInstance() {
        if (instance == null) {
            instance = new AMResourceBundleCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getResBundle(String name, Locale locale) {
        ResourceBundle resBundle = null;
        HashMap<Locale, ResourceBundle> map = (HashMap<Locale, ResourceBundle>)this.mapBundles.get(name);
        if (map != null) {
            resBundle = (ResourceBundle)map.get(locale);
        }
        if (resBundle == null) {
            try {
                resBundle = ResourceBundle.getBundle(name, locale);
            }
            catch (MissingResourceException mre) {
                this.debug.error("AMResourceBundleCache.getResBundle", mre);
            }
            HashMap hashMap = this.mapBundles;
            synchronized (hashMap) {
                if (map == null) {
                    map = new HashMap<Locale, ResourceBundle>(5);
                    this.mapBundles.put(name, map);
                }
                map.put(locale, resBundle);
            }
        }
        return resBundle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        HashMap hashMap = this.mapBundles;
        synchronized (hashMap) {
            this.mapBundles.clear();
        }
    }
}

