/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.membership;

import com.iplanet.sso.SSOException;
import com.sun.identity.authentication.modules.membership.MembershipPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class Membership
extends AMLoginModule {
    private static Debug debug;
    private ResourceBundle bundle;
    private Map sharedState;
    private static final int PASSWORD_CHANGE = 2;
    private static final int WRONG_PASSWORD_ERROR = 3;
    private static final int NO_USER_PROFILE_ERROR = 4;
    private static final int NO_USER_NAME_ERROR = 5;
    private static final int NO_PASSWORD_ERROR = 6;
    private static final int NO_CONFIRMATION_ERROR = 7;
    private static final int PASSWORD_MISMATCH_ERROR = 8;
    private static final int CONFIGURATION_ERROR = 9;
    private static final int USER_EXISTS_ERROR = 10;
    private static final int PROFILE_ERROR = 11;
    private static final int MISSING_REQ_FIELD_ERROR = 12;
    private static final int USER_PASSWORD_SAME_ERROR = 13;
    private static final int INVALID_PASSWORD = 14;
    private static final int PASSWORD_EXPIRED = 15;
    private static final int REGISTRATION = 16;
    private static final int CHOOSE_USERNAMES = 17;
    private static final int DISCLAIMER = 18;
    private int previousScreen;
    private String validatedUserID;
    private MembershipPrincipal userPrincipal;
    private Map options;
    private String serviceStatus;
    private boolean isDisclaimerExist = true;
    private Set defaultRoles;
    private int requiredPasswordLength;
    private PasswordCallback pwdCallback;
    private String createMyOwn;
    private String userID;
    private String userName;
    private Map userAttrs;
    private static final String amAuthMembership = "amAuthMembership";
    private String regEx;
    private static final String INVALID_CHARS = "iplanet-am-auth-membership-invalid-chars";
    private boolean isReset;
    private boolean getCredentialsFromSharedState;
    private Callback[] callbacks;

    public void init(Subject subject, Map sharedState, Map options) {
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthMembership, locale);
        if (debug.messageEnabled()) {
            debug.message("Membership getting resource bundle for locale: " + locale);
        }
        this.options = options;
        this.sharedState = sharedState;
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("in process(), login state is " + state);
        }
        this.callbacks = callbacks;
        switch (state) {
            case 1: {
                this.previousScreen = 1;
                int action = 0;
                if (callbacks != null && callbacks.length != 0) {
                    action = ((ConfirmationCallback)callbacks[2]).getSelectedIndex();
                    if (debug.messageEnabled()) {
                        debug.message("LOGIN page button index: " + action);
                    }
                }
                if (action == 0) {
                    return this.loginUser(callbacks);
                }
                this.initAuthConfig();
                return 16;
            }
            case 2: {
                int pwdAction = ((ConfirmationCallback)callbacks[3]).getSelectedIndex();
                if (pwdAction == 0) {
                    return this.changeToNewPassword(callbacks);
                }
                if (this.isReset) {
                    this.isReset = false;
                    return 1;
                }
                return -1;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return this.previousScreen;
            }
            case 17: {
                return this.chooseUserID(callbacks);
            }
            case 18: {
                int agree = ((ConfirmationCallback)callbacks[0]).getSelectedIndex();
                if (debug.messageEnabled()) {
                    debug.message("DISCLAIMER page button index: " + agree);
                }
                if (agree == 0) {
                    return this.registerNewUser();
                }
                if (agree == 1) {
                    return 1;
                }
                throw new AuthLoginException(amAuthMembership, "loginException", null);
            }
        }
        this.previousScreen = 16;
        int next = ((ConfirmationCallback)callbacks[callbacks.length - 1]).getSelectedIndex();
        if (debug.messageEnabled()) {
            debug.message("REGISTRATION page button index: " + next);
        }
        if (next == 0) {
            int tempState = this.getAndCheckRegistrationFields(callbacks);
            if (tempState == 16) {
                if (this.isDisclaimerExist) {
                    return 18;
                }
                return this.registerNewUser();
            }
            return tempState;
        }
        if (next == 1) {
            this.clearCallbacks(callbacks);
            return 1;
        }
        return 0;
    }

    private void clearCallbacks(Callback[] callbacks) {
        for (int i = 0; i < callbacks.length; ++i) {
            if (!(callbacks[i] instanceof NameCallback)) continue;
            NameCallback nc = (NameCallback)callbacks[i];
            nc.setName("");
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new MembershipPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.validatedUserID = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.sharedState = null;
        this.options = null;
        this.serviceStatus = null;
        this.defaultRoles = null;
        this.pwdCallback = null;
        this.createMyOwn = null;
        this.userID = null;
        this.userName = null;
        this.userAttrs = null;
        this.regEx = null;
        this.callbacks = null;
    }

    private void initAuthConfig() throws AuthLoginException {
        if (this.options == null || this.options.isEmpty()) {
            debug.error("options is null or empty");
            throw new AuthLoginException(amAuthMembership, "unable-to-initialize-options", null);
        }
        try {
            String tmp;
            String authLevel = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-auth-level");
            if (authLevel != null) {
                try {
                    int tmp2 = Integer.parseInt(authLevel);
                    this.setAuthLevel(tmp2);
                }
                catch (NumberFormatException e) {
                    debug.error("invalid auth level " + authLevel, (Throwable)e);
                }
            }
            this.regEx = CollectionHelper.getMapAttr((Map)this.options, (String)INVALID_CHARS);
            this.serviceStatus = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-default-user-status", (String)"Active");
            this.isDisclaimerExist = this.getNumberOfStates() >= 18;
            this.defaultRoles = (Set)this.options.get("iplanet-am-auth-membership-default-roles");
            if (debug.messageEnabled()) {
                debug.message("defaultRoles is : " + this.defaultRoles);
            }
            if ((tmp = CollectionHelper.getMapAttr((Map)this.options, (String)"iplanet-am-auth-membership-min-password-length")) != null) {
                this.requiredPasswordLength = Integer.parseInt(tmp);
            }
            if (this.callbacks != null && this.callbacks.length != 0) {
                Callback[] callbacks = this.getCallback(2);
                this.pwdCallback = (PasswordCallback)callbacks[0];
            }
        }
        catch (Exception e) {
            debug.error("unable to initialize in initAuthConfig(): ", (Throwable)e);
            throw new AuthLoginException(amAuthMembership, "Membershipex", null, e);
        }
    }

    private int loginUser(Callback[] callbacks) throws AuthLoginException {
        String password = null;
        Callback[] idCallbacks = new Callback[2];
        try {
            if (callbacks != null && callbacks.length == 0) {
                this.userName = (String)this.sharedState.get(this.getUserKey());
                password = (String)this.sharedState.get(this.getPwdKey());
                if (this.userName == null || password == null) {
                    return 1;
                }
                this.getCredentialsFromSharedState = true;
                NameCallback nameCallback = new NameCallback("dummy");
                nameCallback.setName(this.userName);
                idCallbacks[0] = nameCallback;
                PasswordCallback passwordCallback = new PasswordCallback("dummy", false);
                passwordCallback.setPassword(password.toCharArray());
                idCallbacks[1] = passwordCallback;
            } else {
                idCallbacks = callbacks;
                this.userName = ((NameCallback)callbacks[0]).getName();
                password = String.valueOf(((PasswordCallback)callbacks[1]).getPassword());
            }
            if (password == null || password.length() == 0) {
                if (debug.messageEnabled()) {
                    debug.message("Membership.loginUser: Password is null/empty");
                }
                throw new InvalidPasswordException("amAuth", "invalidPasswd", null);
            }
            this.storeUsernamePasswd(this.userName, password);
            this.initAuthConfig();
            AMIdentityRepository idrepo = this.getAMIdentityRepository(this.getRequestOrg());
            boolean success = idrepo.authenticate(idCallbacks);
            if (success) {
                this.validatedUserID = this.userName;
                return -1;
            }
            throw new AuthLoginException(amAuthMembership, "authFailed", null);
        }
        catch (IdRepoException ex) {
            if (this.getCredentialsFromSharedState && !this.isUseFirstPassEnabled()) {
                this.getCredentialsFromSharedState = false;
                return 1;
            }
            debug.message("idRepo Exception");
            this.setFailureID(this.userName);
            throw new AuthLoginException(amAuthMembership, "authFailed", null, ex);
        }
    }

    private int changeToNewPassword(Callback[] callbacks) throws AuthLoginException {
        debug.message("trying to change user password");
        String oldPassword = this.getPassword((PasswordCallback)callbacks[0]);
        String newPassword = this.getPassword((PasswordCallback)callbacks[1]);
        String confirmPassword = this.getPassword((PasswordCallback)callbacks[2]);
        this.validatePassword(newPassword);
        return -1;
    }

    private int registerNewUser() throws AuthLoginException {
        if (debug.messageEnabled()) {
            debug.message("trying to register(create) a new user: " + this.userID);
        }
        try {
            if (this.userExists(this.userID)) {
                if (debug.messageEnabled()) {
                    debug.message("unable to register, user " + this.userID + " already exists");
                }
                return 10;
            }
            HashSet<String> vals = new HashSet<String>();
            vals.add(this.serviceStatus);
            this.userAttrs.put("inetuserstatus", vals);
            this.createIdentity(this.userID, this.userAttrs, this.defaultRoles);
        }
        catch (SSOException pe) {
            debug.error("profile exception occured: ", (Throwable)((Object)pe));
            return 11;
        }
        catch (IdRepoException pe) {
            debug.error("profile exception occured: ", (Throwable)pe);
            return 11;
        }
        this.validatedUserID = this.userID;
        if (debug.messageEnabled()) {
            debug.message("registration is completed, created user: " + this.validatedUserID);
        }
        return -1;
    }

    private int getAndCheckRegistrationFields(Callback[] callbacks) throws AuthLoginException {
        HashMap<String, Set> attrs = new HashMap<String, Set>();
        this.userID = this.getCallbackFieldValue(callbacks[0]);
        if (this.userID == null || this.userID.length() == 0) {
            return 5;
        }
        this.validateUserName(this.userID, this.regEx);
        String password = this.getPassword((PasswordCallback)callbacks[1]);
        String confirmPassword = this.getPassword((PasswordCallback)callbacks[2]);
        int tempState = this.checkPassword(password, confirmPassword);
        if (debug.messageEnabled()) {
            debug.message("state returned from checkPassword(): " + tempState);
        }
        if (tempState != -1) {
            return tempState;
        }
        this.validatePassword(confirmPassword);
        if (password.equals(this.userID)) {
            return 13;
        }
        for (int i = 0; i < callbacks.length; ++i) {
            String attrName = this.getAttribute(16, i);
            Set values = this.getCallbackFieldValues(callbacks[i]);
            if (this.isRequired(16, i) && values.isEmpty()) {
                if (debug.messageEnabled()) {
                    debug.message("Empty value for required field :" + attrName);
                }
                return 12;
            }
            if (attrName == null || attrName.length() == 0) continue;
            attrs.put(attrName, values);
        }
        this.userAttrs = attrs;
        try {
            if (this.userExists(this.userID)) {
                Set generatedUserIDs;
                if (debug.messageEnabled()) {
                    debug.message("user ID " + this.userID + " already exists");
                }
                if ((generatedUserIDs = this.getNewUserIDs(attrs, 0)) == null) {
                    return 10;
                }
                ArrayList nonExistingUserIDs = this.getNonExistingUserIDs(generatedUserIDs);
                this.resetCallback(17, 0);
                Callback[] origCallbacks = this.getCallback(17);
                ChoiceCallback origCallback = (ChoiceCallback)origCallbacks[0];
                String prompt = origCallback.getPrompt();
                this.createMyOwn = origCallback.getChoices()[0];
                nonExistingUserIDs.add(this.createMyOwn);
                String[] choices = nonExistingUserIDs.toArray(new String[0]);
                ChoiceCallback callback = new ChoiceCallback(prompt, choices, 0, false);
                callback.setSelectedIndex(0);
                this.replaceCallback(17, 0, callback);
                return 17;
            }
        }
        catch (SSOException pe) {
            debug.error("profile exception occured: ", (Throwable)((Object)pe));
            return 11;
        }
        catch (IdRepoException pe) {
            debug.error("profile exception occured: ", (Throwable)pe);
            return 11;
        }
        return 16;
    }

    private int checkPassword(String password, String confirmPassword) {
        if (password == null || password.length() == 0) {
            debug.message("password was missing from the form");
            return 6;
        }
        if (password.length() < this.requiredPasswordLength) {
            debug.message("password was not long enough");
            return 14;
        }
        if (confirmPassword == null || confirmPassword.length() == 0) {
            debug.message("no confirmation password");
            return 7;
        }
        if (!password.equals(confirmPassword)) {
            return 8;
        }
        return -1;
    }

    private int chooseUserID(Callback[] callbacks) throws AuthLoginException {
        String userChoiceID = this.getCallbackFieldValue(callbacks[0]);
        if (userChoiceID.equals(this.createMyOwn)) {
            return 16;
        }
        String attrName = this.getAttribute(16, 0);
        this.userID = userChoiceID;
        HashSet<String> values = new HashSet<String>();
        values.add(this.userID);
        this.userAttrs.put(attrName, values);
        if (this.isDisclaimerExist) {
            return 18;
        }
        return this.registerNewUser();
    }

    private String getPassword(PasswordCallback callback) {
        char[] tmpPassword = callback.getPassword();
        if (tmpPassword == null) {
            tmpPassword = new char[]{};
        }
        char[] pwd = new char[tmpPassword.length];
        System.arraycopy(tmpPassword, 0, pwd, 0, tmpPassword.length);
        return new String(pwd);
    }

    private Set getCallbackFieldValues(Callback callback) {
        HashSet<String> values = new HashSet<String>();
        if (callback instanceof NameCallback) {
            String value = ((NameCallback)callback).getName();
            if (value != null && value.length() != 0) {
                values.add(value);
            }
        } else if (callback instanceof PasswordCallback) {
            String value = this.getPassword((PasswordCallback)callback);
            if (value != null && value.length() != 0) {
                values.add(value);
            }
        } else if (callback instanceof ChoiceCallback) {
            String[] vals = ((ChoiceCallback)callback).getChoices();
            int[] selectedIndexes = ((ChoiceCallback)callback).getSelectedIndexes();
            for (int i = 0; i < selectedIndexes.length; ++i) {
                values.add(vals[selectedIndexes[i]]);
            }
        }
        return values;
    }

    private String getCallbackFieldValue(Callback callback) {
        Set values = this.getCallbackFieldValues(callback);
        Iterator it = values.iterator();
        if (it.hasNext()) {
            return (String)it.next();
        }
        return null;
    }

    private ArrayList getNonExistingUserIDs(Set userIDs) throws IdRepoException, SSOException {
        ArrayList<String> validUserIDs = new ArrayList<String>();
        for (String userID : userIDs) {
            if (this.userExists(userID)) continue;
            validUserIDs.add(userID);
        }
        return validUserIDs;
    }

    private boolean userExists(String userID) throws IdRepoException, SSOException {
        Set results;
        block3: {
            AMIdentityRepository amIdRepo = this.getAMIdentityRepository(this.getRequestOrg());
            IdSearchControl idsc = new IdSearchControl();
            idsc.setRecursive(true);
            idsc.setTimeOut(0);
            idsc.setAllReturnAttributes(true);
            results = Collections.EMPTY_SET;
            try {
                idsc.setMaxResults(0);
                IdSearchResults searchResults = amIdRepo.searchIdentities(IdType.USER, userID, idsc);
                if (searchResults != null) {
                    results = searchResults.getSearchResults();
                }
            }
            catch (IdRepoException e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("IdRepoException : Error searching  Identities with username : " + e.getMessage());
            }
        }
        return !results.isEmpty();
    }

    static {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthMembership);
        }
    }
}

